/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.betwixt.strategy;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.betwixt.strategy.ClassNormalizer;

public class ListedClassNormalizer
extends ClassNormalizer {
    private ArrayList normalizations = new ArrayList();
    private boolean strickCheck = false;

    public boolean isStrickCheck() {
        return this.strickCheck;
    }

    public void setStrickCheck(boolean strickCheck) {
        this.strickCheck = strickCheck;
    }

    public void addSubstitution(Class match, Class substitute) {
        this.normalizations.add(new ListEntry(match, substitute));
    }

    public void addSubstitution(Class substitute) {
        this.addSubstitution(substitute, substitute);
    }

    public Class normalize(Class clazz) {
        Iterator it = this.normalizations.iterator();
        while (it.hasNext()) {
            ListEntry entry = (ListEntry)it.next();
            if (!(this.strickCheck ? entry.match.equals(clazz) : entry.match.isAssignableFrom(clazz))) continue;
            return entry.substitute;
        }
        return clazz;
    }

    private class ListEntry {
        Class match;
        Class substitute;

        ListEntry(Class match, Class substitute) {
            this.match = match;
            this.substitute = substitute;
        }
    }
}

