/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util;

import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class DOMUtils {
    protected static Class[] getElementsByNSParameterTypes = new Class[]{class$java$lang$String == null ? (class$java$lang$String = DOMUtils.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = DOMUtils.class$("java.lang.String")) : class$java$lang$String};
    static /* synthetic */ Class class$java$lang$String;

    public static boolean isDocumentBuilderDOM2Compliant() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            String data = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><D:propfind xmlns:D=\"DAV:\"><D:prop><D:displayname/></D:prop></D:propfind>";
            Document document = builder.parse(new InputSource(new StringReader(data)));
            Element root = document.getDocumentElement();
            return DOMUtils.isDOM2Compliant(root);
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public static boolean isDOM2Compliant(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("The input node cannot be null");
        }
        Document document = node.getOwnerDocument();
        boolean isDOM2 = false;
        try {
            Class<?> documentClass = document.getClass();
            Method method = documentClass.getMethod("getElementsByTagNameNS", getElementsByNSParameterTypes);
            if (method != null) {
                isDOM2 = true;
            }
        }
        catch (NoSuchMethodException e) {}
        return isDOM2;
    }

    public static String findDavPrefix(Document document) {
        Element multistatus = document.getDocumentElement();
        NamedNodeMap list = multistatus.getAttributes();
        String prefix = "DAV:";
        int i = 0;
        while (i < list.getLength()) {
            try {
                Attr attr = (Attr)list.item(i);
                if (attr.getName() != null && attr.getName().startsWith("xmlns") && attr.getValue().equals("DAV:")) {
                    int indx = attr.getName().indexOf(":");
                    prefix = indx >= 0 && indx < attr.getName().length() - 1 ? attr.getName().substring(indx + 1) + ":" : "";
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            ++i;
        }
        return prefix;
    }

    public static String getTextValue(Node node) {
        String text = "";
        NodeList textList = node.getChildNodes();
        int i = 0;
        while (i < textList.getLength()) {
            try {
                text = text + ((Text)textList.item(i)).getData();
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            ++i;
        }
        return text;
    }

    public static int parseStatus(String statusString) {
        int status = -1;
        if (statusString != null) {
            StringTokenizer tokenizer = new StringTokenizer(statusString);
            if (tokenizer.countTokens() >= 2) {
                Object dummy = tokenizer.nextElement();
                String statusCode = tokenizer.nextElement().toString();
                try {
                    status = Integer.parseInt(statusCode);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Status code is not numeric");
                }
            } else {
                throw new IllegalArgumentException("There aren't enough words in the input argument");
            }
        }
        return status;
    }

    public static String getElementNamespaceURI(Element element) {
        String namespace = null;
        if (element == null) {
            throw new IllegalArgumentException("The element cannot be null");
        }
        if (DOMUtils.isDOM2Compliant(element)) {
            namespace = element.getNamespaceURI();
        } else {
            String tagName = element.getTagName();
            String attribute = "xmlns";
            int index = tagName.indexOf(":");
            if (index > 0 && index < tagName.length() - 1) {
                attribute = attribute + ":" + tagName.substring(0, index);
            }
            boolean found = false;
            Node node = element;
            while (!found && node != null) {
                try {
                    String tmp = node.getAttribute(attribute);
                    if (tmp != null && !tmp.equals("")) {
                        namespace = tmp;
                        found = true;
                    }
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
                node = node.getParentNode();
            }
        }
        return namespace;
    }

    public static String getElementLocalName(Element element) {
        String localName = null;
        if (element == null) {
            throw new IllegalArgumentException("The element cannot be null");
        }
        if (DOMUtils.isDOM2Compliant(element)) {
            localName = element.getLocalName();
        } else {
            localName = element.getTagName();
            int index = localName.indexOf(":");
            if (index > 0 && index < localName.length() - 1) {
                localName = localName.substring(index + 1);
            }
        }
        return localName;
    }

    public static NodeList getElementsByTagNameNS(Node node, String tagName, String namespace) {
        NodeList list = null;
        if (node != null) {
            if (!(node instanceof Document) && !(node instanceof Element)) {
                throw new IllegalArgumentException("The node parameter must be an Element or a Document node");
            }
            if (DOMUtils.isDOM2Compliant(node)) {
                list = ((Element)node).getElementsByTagNameNS(namespace, tagName);
            } else {
                Vector vector = new Vector();
                DOMUtils.getChildElementsByTagNameNS(vector, node, tagName, namespace);
                list = new NodeListImpl(vector);
            }
        }
        return list;
    }

    protected static void getChildElementsByTagNameNS(Vector vector, Node node, String tagName, String namespace) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (list != null && i < list.getLength()) {
            try {
                Element element = (Element)list.item(i);
                if (tagName.equals(DOMUtils.getElementLocalName(element)) && namespace.equals(DOMUtils.getElementNamespaceURI(element))) {
                    vector.addElement(element);
                } else {
                    DOMUtils.getChildElementsByTagNameNS(vector, element, tagName, namespace);
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            ++i;
        }
    }

    public static Element getFirstElement(Node node, String namespace, String name) {
        NodeList children = node.getChildNodes();
        if (children == null) {
            return null;
        }
        int i = 0;
        while (i < children.getLength()) {
            try {
                Element child = (Element)children.item(i);
                if (name.equals(DOMUtils.getElementLocalName(child)) && namespace.equals(DOMUtils.getElementNamespaceURI(child))) {
                    return child;
                }
            }
            catch (ClassCastException e) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class NodeListImpl
    implements NodeList {
        private Vector vector = null;

        NodeListImpl(Vector vector) {
            this.vector = vector;
        }

        public int getLength() {
            return this.vector.size();
        }

        public Node item(int i) {
            return (Node)this.vector.elementAt(i);
        }
    }
}

