/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.xml.util;

import java.util.HashMap;
import org.jfree.xml.util.GenericObjectFactory;
import org.jfree.xml.util.ManualMappingDefinition;
import org.jfree.xml.util.MultiplexMappingDefinition;
import org.jfree.xml.util.ObjectFactory;

public class SimpleObjectFactory
implements ObjectFactory {
    private HashMap objectMappings = new HashMap();
    private HashMap manualMappings = new HashMap();
    private HashMap multiplexMappings = new HashMap();

    public void addManualMapping(ManualMappingDefinition manualMappingDefinition) {
        this.manualMappings.put(manualMappingDefinition.getBaseClass(), manualMappingDefinition);
    }

    public void addGenericHandler(GenericObjectFactory genericObjectFactory) {
        this.objectMappings.put(genericObjectFactory.getBaseClass(), genericObjectFactory);
    }

    public void addMultiplexMapping(MultiplexMappingDefinition multiplexMappingDefinition) {
        this.multiplexMappings.put(multiplexMappingDefinition.getBaseClass(), multiplexMappingDefinition);
    }

    public void clear() {
        this.objectMappings.clear();
        this.manualMappings.clear();
        this.multiplexMappings.clear();
    }

    public GenericObjectFactory getFactoryForClass(Class clazz) {
        GenericObjectFactory genericObjectFactory = (GenericObjectFactory)this.objectMappings.get(clazz);
        if (genericObjectFactory == null) {
            return null;
        }
        return genericObjectFactory.getInstance();
    }

    public ManualMappingDefinition getManualMappingDefinition(Class clazz) {
        return (ManualMappingDefinition)this.manualMappings.get(clazz);
    }

    public MultiplexMappingDefinition getMultiplexDefinition(Class clazz) {
        MultiplexMappingDefinition multiplexMappingDefinition = (MultiplexMappingDefinition)this.multiplexMappings.get(clazz);
        return multiplexMappingDefinition;
    }

    public boolean isGenericHandler(Class clazz) {
        return this.objectMappings.containsKey(clazz);
    }
}

