/*
 * Decompiled with CFR 0.152.
 */
package sqlj.runtime.profile.ref;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import sqlj.runtime.AsciiStream;
import sqlj.runtime.BinaryStream;
import sqlj.runtime.CharacterStream;
import sqlj.runtime.ForUpdate;
import sqlj.runtime.UnicodeStream;
import sqlj.runtime.error.ProfileRefErrors;
import sqlj.runtime.profile.BatchContext;
import sqlj.runtime.profile.EntryInfo;
import sqlj.runtime.profile.RTStatement;
import sqlj.runtime.profile.ref.DynamicProfile;
import sqlj.runtime.profile.ref.DynamicProfileWrapper;
import sqlj.runtime.profile.ref.LocalStatement;
import sqlj.runtime.profile.ref.RTStatementWrapper;

public class PositionedProfile
extends DynamicProfileWrapper {
    static final int EMPTY = 0;
    static final int BOOLEAN = 1;
    static final int BYTE = 2;
    static final int SHORT = 3;
    static final int INT = 4;
    static final int LONG = 5;
    static final int FLOAT = 6;
    static final int DOUBLE = 7;
    static final int BIGDECIMAL = 8;
    static final int STRING = 9;
    static final int BYTES = 10;
    static final int DATE = 11;
    static final int TIME = 12;
    static final int TIMESTAMP = 13;
    static final int OBJECT = 14;
    static final int ASCII = 16;
    static final int BINARY = 17;
    static final int UNICODE = 18;
    static final int CHARACTER = 19;
    static final int BOOLEAN_WRAP = 21;
    static final int BYTE_WRAP = 22;
    static final int SHORT_WRAP = 23;
    static final int INT_WRAP = 24;
    static final int LONG_WRAP = 25;
    static final int FLOAT_WRAP = 26;
    static final int DOUBLE_WRAP = 27;
    static final int BLOB = 31;
    static final int CLOB = 32;
    static final int REF = 33;

    public PositionedProfile(DynamicProfile dynamicProfile) {
        super(dynamicProfile);
    }

    public RTStatement getStatement(int n2, BatchContext batchContext, Map map) throws SQLException {
        EntryInfo entryInfo = this.getProfileData().getEntryInfo(n2);
        switch (entryInfo.getRole()) {
            case 6: {
                if (entryInfo.getStatementType() != 2) {
                    ProfileRefErrors.raise_EXPECTED_PREPARED_STATEMENT(entryInfo.getSQLString());
                }
                if (entryInfo.getExecuteType() != 8) {
                    ProfileRefErrors.raise_EXPECTED_EXECUTE_UPDATE(entryInfo.getSQLString());
                }
                int n3 = (Integer)entryInfo.getDescriptor();
                int n4 = entryInfo.getParamInfo(n3).getMarkerIndex();
                return new PositionedStatement(entryInfo.getSQLString(), n4, n3, entryInfo.getParamCount());
            }
        }
        return this.baseProfile.getStatement(n2, batchContext, map);
    }

    public class PositionedStatement
    extends RTStatementWrapper {
        private int m_cursorMarkerNdx;
        private int m_cursorParamNum;
        private String m_origSqlText;
        private ForUpdate m_cursor = null;
        private Object[] m_params;
        private int[] m_paramTypes;
        private int m_numParams;
        private RTStatement m_dummyStmt = this.stmt;

        public PositionedStatement(String string, int n2, int n3, int n4) {
            super(new LocalStatement());
            this.m_origSqlText = string;
            this.m_cursorMarkerNdx = n2;
            this.m_cursorParamNum = n3;
            this.m_numParams = n4;
            this.m_params = new Object[this.m_numParams];
            this.m_paramTypes = new int[this.m_numParams];
            for (int i2 = 0; i2 < this.m_numParams; ++i2) {
                this.m_params[i2] = null;
                this.m_paramTypes[i2] = 0;
            }
        }

        public void executeComplete() throws SQLException {
            super.executeComplete();
            this.stmt = this.m_dummyStmt;
        }

        public void setBoolean(int n2, boolean bl) throws SQLException {
            this.m_paramTypes[n2 - 1] = 1;
            this.m_params[n2 - 1] = new Boolean(bl);
        }

        public void setBooleanWrapper(int n2, Boolean bl) throws SQLException {
            this.m_paramTypes[n2 - 1] = 21;
            this.m_params[n2 - 1] = bl;
        }

        public void setByte(int n2, byte by) throws SQLException {
            this.m_paramTypes[n2 - 1] = 2;
            this.m_params[n2 - 1] = new Byte(by);
        }

        public void setByteWrapper(int n2, Byte by) throws SQLException {
            this.m_paramTypes[n2 - 1] = 22;
            this.m_params[n2 - 1] = by;
        }

        public void setShort(int n2, short s2) throws SQLException {
            this.m_paramTypes[n2 - 1] = 3;
            this.m_params[n2 - 1] = new Short(s2);
        }

        public void setShortWrapper(int n2, Short s2) throws SQLException {
            this.m_paramTypes[n2 - 1] = 23;
            this.m_params[n2 - 1] = s2;
        }

        public void setInt(int n2, int n3) throws SQLException {
            this.m_paramTypes[n2 - 1] = 4;
            this.m_params[n2 - 1] = new Integer(n3);
        }

        public void setIntWrapper(int n2, Integer n3) throws SQLException {
            this.m_paramTypes[n2 - 1] = 24;
            this.m_params[n2 - 1] = n3;
        }

        public void setLong(int n2, long l2) throws SQLException {
            this.m_paramTypes[n2 - 1] = 5;
            this.m_params[n2 - 1] = new Long(l2);
        }

        public void setLongWrapper(int n2, Long l2) throws SQLException {
            this.m_paramTypes[n2 - 1] = 25;
            this.m_params[n2 - 1] = l2;
        }

        public void setFloat(int n2, float f2) throws SQLException {
            this.m_paramTypes[n2 - 1] = 6;
            this.m_params[n2 - 1] = new Float(f2);
        }

        public void setFloatWrapper(int n2, Float f2) throws SQLException {
            this.m_paramTypes[n2 - 1] = 26;
            this.m_params[n2 - 1] = f2;
        }

        public void setDouble(int n2, double d2) throws SQLException {
            this.m_paramTypes[n2 - 1] = 7;
            this.m_params[n2 - 1] = new Double(d2);
        }

        public void setDoubleWrapper(int n2, Double d2) throws SQLException {
            this.m_paramTypes[n2 - 1] = 27;
            this.m_params[n2 - 1] = d2;
        }

        public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
            this.m_paramTypes[n2 - 1] = 8;
            this.m_params[n2 - 1] = bigDecimal;
        }

        public void setString(int n2, String string) throws SQLException {
            this.m_paramTypes[n2 - 1] = 9;
            this.m_params[n2 - 1] = string;
        }

        public void setBytes(int n2, byte[] byArray) throws SQLException {
            this.m_paramTypes[n2 - 1] = 10;
            this.m_params[n2 - 1] = byArray;
        }

        public void setDate(int n2, Date date) throws SQLException {
            this.m_paramTypes[n2 - 1] = 11;
            this.m_params[n2 - 1] = date;
        }

        public void setTime(int n2, Time time) throws SQLException {
            this.m_paramTypes[n2 - 1] = 12;
            this.m_params[n2 - 1] = time;
        }

        public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
            this.m_paramTypes[n2 - 1] = 13;
            this.m_params[n2 - 1] = timestamp;
        }

        public void setAsciiStreamWrapper(int n2, AsciiStream asciiStream) throws SQLException {
            this.m_paramTypes[n2 - 1] = 16;
            this.m_params[n2 - 1] = asciiStream;
        }

        public void setCharacterStreamWrapper(int n2, CharacterStream characterStream) throws SQLException {
            this.m_paramTypes[n2 - 1] = 19;
            this.m_params[n2 - 1] = characterStream;
        }

        public void setBinaryStreamWrapper(int n2, BinaryStream binaryStream) throws SQLException {
            this.m_paramTypes[n2 - 1] = 17;
            this.m_params[n2 - 1] = binaryStream;
        }

        public void setUnicodeStreamWrapper(int n2, UnicodeStream unicodeStream) throws SQLException {
            this.m_paramTypes[n2 - 1] = 18;
            this.m_params[n2 - 1] = unicodeStream;
        }

        public void setBlob(int n2, Blob blob) throws SQLException {
            this.m_paramTypes[n2 - 1] = 31;
            this.m_params[n2 - 1] = blob;
        }

        public void setClob(int n2, Clob clob) throws SQLException {
            this.m_paramTypes[n2 - 1] = 32;
            this.m_params[n2 - 1] = clob;
        }

        public void setRef(int n2, Ref ref) throws SQLException {
            this.m_paramTypes[n2 - 1] = 33;
            this.m_params[n2 - 1] = ref;
        }

        public void setObject(int n2, Object object) throws SQLException {
            if (n2 == this.m_cursorParamNum) {
                if (object instanceof ForUpdate) {
                    this.m_cursor = (ForUpdate)object;
                } else {
                    ProfileRefErrors.raise_EXPECTED_FOR_UPDATE(n2, object.getClass().getName());
                }
            } else {
                this.m_paramTypes[n2 - 1] = 14;
                this.m_params[n2 - 1] = object;
            }
        }

        public int executeUpdate() throws SQLException {
            this.createStatement();
            return this.stmt.executeUpdate();
        }

        private void createStatement() throws SQLException {
            this.stmt.executeComplete();
            String string = this.m_origSqlText.substring(0, this.m_cursorMarkerNdx) + " " + this.m_cursor.getCursorName() + " " + this.m_origSqlText.substring(this.m_cursorMarkerNdx + 1);
            this.stmt = PositionedProfile.this.baseDynamicProfile.prepareStatement(string);
            if (this.m_dummyStmt.getMaxFieldSize() != 0) {
                this.stmt.setMaxFieldSize(this.m_dummyStmt.getMaxFieldSize());
            }
            if (this.m_dummyStmt.getMaxRows() != 0) {
                this.stmt.setMaxRows(this.m_dummyStmt.getMaxRows());
            }
            if (this.m_dummyStmt.getQueryTimeout() != 0) {
                this.stmt.setQueryTimeout(this.m_dummyStmt.getQueryTimeout());
            }
            if (this.m_dummyStmt.getFetchSize() != 0) {
                this.stmt.setFetchSize(this.m_dummyStmt.getFetchSize());
            }
            block31: for (int i2 = 0; i2 < this.m_numParams; ++i2) {
                switch (this.m_paramTypes[i2]) {
                    case 0: {
                        continue block31;
                    }
                    case 1: {
                        this.stmt.setBoolean(i2 + 1, (Boolean)this.m_params[i2]);
                        continue block31;
                    }
                    case 21: {
                        this.stmt.setBooleanWrapper(i2 + 1, (Boolean)this.m_params[i2]);
                        continue block31;
                    }
                    case 2: {
                        this.stmt.setByte(i2 + 1, (Byte)this.m_params[i2]);
                        continue block31;
                    }
                    case 3: {
                        this.stmt.setShort(i2 + 1, (Short)this.m_params[i2]);
                        continue block31;
                    }
                    case 4: {
                        this.stmt.setInt(i2 + 1, (Integer)this.m_params[i2]);
                        continue block31;
                    }
                    case 5: {
                        this.stmt.setLong(i2 + 1, (Long)this.m_params[i2]);
                        continue block31;
                    }
                    case 6: {
                        this.stmt.setFloat(i2 + 1, ((Float)this.m_params[i2]).floatValue());
                        continue block31;
                    }
                    case 7: {
                        this.stmt.setDouble(i2 + 1, (Double)this.m_params[i2]);
                        continue block31;
                    }
                    case 22: {
                        this.stmt.setByteWrapper(i2 + 1, (Byte)this.m_params[i2]);
                        continue block31;
                    }
                    case 23: {
                        this.stmt.setShortWrapper(i2 + 1, (Short)this.m_params[i2]);
                        continue block31;
                    }
                    case 24: {
                        this.stmt.setIntWrapper(i2 + 1, (Integer)this.m_params[i2]);
                        continue block31;
                    }
                    case 25: {
                        this.stmt.setLongWrapper(i2 + 1, (Long)this.m_params[i2]);
                        continue block31;
                    }
                    case 26: {
                        this.stmt.setFloatWrapper(i2 + 1, (Float)this.m_params[i2]);
                        continue block31;
                    }
                    case 27: {
                        this.stmt.setDoubleWrapper(i2 + 1, (Double)this.m_params[i2]);
                        continue block31;
                    }
                    case 8: {
                        this.stmt.setBigDecimal(i2 + 1, (BigDecimal)this.m_params[i2]);
                        continue block31;
                    }
                    case 9: {
                        this.stmt.setString(i2 + 1, (String)this.m_params[i2]);
                        continue block31;
                    }
                    case 10: {
                        this.stmt.setBytes(i2 + 1, (byte[])this.m_params[i2]);
                        continue block31;
                    }
                    case 11: {
                        this.stmt.setDate(i2 + 1, (Date)this.m_params[i2]);
                        continue block31;
                    }
                    case 12: {
                        this.stmt.setTime(i2 + 1, (Time)this.m_params[i2]);
                        continue block31;
                    }
                    case 13: {
                        this.stmt.setTimestamp(i2 + 1, (Timestamp)this.m_params[i2]);
                        continue block31;
                    }
                    case 14: {
                        this.stmt.setObject(i2 + 1, this.m_params[i2]);
                        continue block31;
                    }
                    case 16: {
                        this.stmt.setAsciiStreamWrapper(i2 + 1, (AsciiStream)this.m_params[i2]);
                        continue block31;
                    }
                    case 17: {
                        this.stmt.setBinaryStreamWrapper(i2 + 1, (BinaryStream)this.m_params[i2]);
                        continue block31;
                    }
                    case 18: {
                        this.stmt.setUnicodeStreamWrapper(i2 + 1, (UnicodeStream)this.m_params[i2]);
                        continue block31;
                    }
                    case 19: {
                        this.stmt.setCharacterStreamWrapper(i2 + 1, (CharacterStream)this.m_params[i2]);
                        continue block31;
                    }
                    case 31: {
                        this.stmt.setBlob(i2 + 1, (Blob)this.m_params[i2]);
                        continue block31;
                    }
                    case 32: {
                        this.stmt.setClob(i2 + 1, (Clob)this.m_params[i2]);
                        continue block31;
                    }
                    case 33: {
                        this.stmt.setRef(i2 + 1, (Ref)this.m_params[i2]);
                    }
                }
            }
        }
    }
}

