/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.axisChart.BarChart;
import org.jCharts.chartData.interfaces.IAxisChartDataSet;
import org.jCharts.imageMap.RectMapArea;
import org.jCharts.properties.BarChartProperties;

abstract class ClusteredBarChart {
    ClusteredBarChart() {
    }

    static void render(AxisChart axisChart, IAxisChartDataSet iAxisChartDataSet) {
        Graphics2D graphics2D = axisChart.getGraphics2D();
        BarChartProperties barChartProperties = (BarChartProperties)iAxisChartDataSet.getChartTypeProperties();
        float f = axisChart.getYAxis().getZeroLineCoordinate();
        float f2 = axisChart.getXAxis().getScalePixelWidth() * barChartProperties.getPercentage();
        float f3 = f2 / (float)iAxisChartDataSet.getNumberOfDataSets();
        if (axisChart.getAxisProperties().hasUserDefinedScale()) {
            Rectangle2D.Float float_ = new Rectangle2D.Float(axisChart.getXAxis().getOrigin(), axisChart.getYAxis().getOrigin() - axisChart.getYAxis().getPixelLength() + 1.0f, axisChart.getXAxis().getPixelLength(), axisChart.getYAxis().getPixelLength() - 2.0f);
            graphics2D.setClip(float_);
        }
        float f4 = axisChart.getXAxis().getTickStartX() - f2 / 2.0f;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f4, f, f3, 0.0f);
        graphics2D.setStroke(barChartProperties.getOutlineStroke());
        int n = 0;
        while (n < iAxisChartDataSet.getNumberOfDataItems()) {
            int n2 = 0;
            while (n2 < iAxisChartDataSet.getNumberOfDataSets()) {
                graphics2D.setPaint(iAxisChartDataSet.getPaint(n2));
                if (iAxisChartDataSet.getValue(n2, n) != 0.0) {
                    if (iAxisChartDataSet.getValue(n2, n) < 0.0) {
                        float_.y = f;
                        float_.height = BarChart.computeScaleHeightOfValue(iAxisChartDataSet.getValue(n2, n), axisChart.getYAxis());
                    } else {
                        float_.y = axisChart.getYAxis().computeAxisCoordinate(iAxisChartDataSet.getValue(n2, n));
                        float_.height = f - float_.y;
                    }
                    if (float_.height != 0.0f) {
                        graphics2D.fill(float_);
                        if (barChartProperties.getShowOutlinesFlag()) {
                            graphics2D.setPaint(barChartProperties.getOutlinePaint());
                            graphics2D.draw(float_);
                            if (axisChart.getGenerateImageMapFlag()) {
                                axisChart.getImageMap().addImageMapArea(new RectMapArea(float_, iAxisChartDataSet.getValue(n2, n), axisChart.getIDataSeries().getXAxisLabel(n), iAxisChartDataSet.getLegendLabel(n2)));
                            }
                        }
                    }
                }
                float_.x += f3;
                ++n2;
            }
            float_.x = f4 += axisChart.getXAxis().getScalePixelWidth();
            ++n;
        }
    }
}

