/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

public class PropertiesConfiguration
extends BaseConfiguration {
    protected String fileSeparator = System.getProperty("file.separator");
    protected String basePath;
    protected static String include = "include";

    public PropertiesConfiguration() {
    }

    public PropertiesConfiguration(String file) throws IOException {
        this.basePath = new File(file).getAbsolutePath();
        this.basePath = this.basePath.substring(0, this.basePath.lastIndexOf(this.fileSeparator) + 1);
        this.load(new FileInputStream(file));
    }

    public PropertiesConfiguration(String file, Configuration defaultConfig) throws IOException {
        this(file);
        this.defaults = defaultConfig;
    }

    public PropertiesConfiguration(Configuration defaultConfig) throws IOException {
        this.defaults = defaultConfig;
    }

    public PropertiesConfiguration(String file, String defaultFile) throws IOException {
        this(file);
        if (defaultFile != null) {
            this.defaults = new PropertiesConfiguration(defaultFile);
        }
    }

    public void load(InputStream input) throws IOException {
        this.load(input, null);
    }

    public synchronized void load(InputStream input, String enc) throws IOException {
        PropertiesReader reader = null;
        if (enc != null) {
            try {
                reader = new PropertiesReader(new InputStreamReader(input, enc));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        if (reader == null) {
            reader = new PropertiesReader(new InputStreamReader(input));
        }
        try {
            while (true) {
                String line;
                int equalSign;
                if ((equalSign = (line = reader.readProperty()).indexOf(61)) <= 0) {
                    continue;
                }
                String key = line.substring(0, equalSign).trim();
                String value = line.substring(equalSign + 1).trim();
                if ("".equals(value)) continue;
                if (this.getInclude() != null && key.equalsIgnoreCase(this.getInclude())) {
                    File file = null;
                    if (value.startsWith(this.fileSeparator)) {
                        file = new File(value);
                    } else {
                        if (value.startsWith("." + this.fileSeparator)) {
                            value = value.substring(2);
                        }
                        file = new File(this.basePath + value);
                    }
                    if (file == null || !file.exists() || !file.canRead()) continue;
                    this.load(new FileInputStream(file));
                    continue;
                }
                this.addProperty(key, value);
            }
        }
        catch (NullPointerException e) {
            return;
        }
    }

    public void save(String filename) throws IOException {
        File file = new File(filename);
        PropertiesWriter out = new PropertiesWriter(file);
        out.writeComment("written by PropertiesConfiguration");
        out.writeComment(new Date().toString());
        Iterator i = this.getKeys();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = StringUtils.join((Object[])this.getStringArray(key), (String)", ");
            out.writeProperty(key, value);
        }
        out.flush();
        out.close();
    }

    public String getInclude() {
        return include;
    }

    public void setInclude(String inc) {
        include = inc;
    }

    class PropertiesWriter
    extends FileWriter {
        public PropertiesWriter(File file) throws IOException {
            super(file);
        }

        public void writeProperty(String key, String value) throws IOException {
            this.write(key + " = " + value + "\n");
        }

        public void writeComment(String comment) throws IOException {
            this.write("# " + comment + "\n");
        }
    }

    class PropertiesReader
    extends LineNumberReader {
        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public String readProperty() throws IOException {
            StringBuffer buffer = new StringBuffer();
            try {
                String line;
                while (true) {
                    if ((line = this.readLine().trim()).length() == 0 || line.charAt(0) == '#') {
                        continue;
                    }
                    if (!line.endsWith("\\")) break;
                    line = line.substring(0, line.length() - 1);
                    buffer.append(line);
                }
                buffer.append(line);
            }
            catch (NullPointerException e) {
                return null;
            }
            return buffer.toString();
        }
    }
}

