/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.wstore;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.compiere.model.MAdvertisement;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUser;
import org.compiere.util.WebUtil;
import org.compiere.wstore.JSPEnv;

public class AdvertisementServlet
extends HttpServlet {
    private static CLogger log = CLogger.getCLogger(AdvertisementServlet.class);
    public static final String NAME = "AdvertisementServlet";
    public static final String P_ADVERTISEMENT_ID = "W_Advertisement_ID";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("AdvertisementServlet.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Avertisement Servlet";
    }

    public void destroy() {
        log.fine("");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("Get from " + request.getRemoteHost() + " - " + request.getRemoteAddr() + " - forward to request.jsp");
        if (!response.isCommitted()) {
            response.sendRedirect("advertisements.jsp");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String ClickTargetURL;
        String Description;
        log.info("Post from " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession(true);
        session.removeAttribute("hdrMessage");
        Ctx ctx = JSPEnv.getCtx(request);
        WebUser wu = (WebUser)session.getAttribute("webUser");
        if (wu == null) {
            log.warning("No web user");
            if (!response.isCommitted()) {
                response.sendRedirect("loginServlet?ForwardTo=advertisement.jsp");
            }
            return;
        }
        int W_Advertisement_ID = WebUtil.getParameterAsInt(request, P_ADVERTISEMENT_ID);
        MAdvertisement ad = new MAdvertisement(ctx, W_Advertisement_ID, null);
        if (ad.get_ID() == 0) {
            WebUtil.createForwardPage(response, "Web Advertisement Not Found", "advertisements.jsp", 0);
            return;
        }
        StringBuffer info = new StringBuffer();
        String Name = WebUtil.getParameter(request, "Name");
        if (Name != null && Name.length() > 0 && !Name.equals(ad.getName())) {
            ad.setName(Name);
            info.append("Name - ");
        }
        if ((Description = WebUtil.getParameter(request, "Description")) != null && Description.length() > 0 && !Description.equals(ad.getDescription())) {
            ad.setDescription(Description);
            info.append("Description - ");
        }
        Object ImageURL = null;
        String AdText = WebUtil.getParameter(request, "AdText");
        if (AdText != null && AdText.length() > 0 && !AdText.equals(ad.getAdText())) {
            ad.setAdText(AdText);
            info.append("AdText - ");
        }
        if ((ClickTargetURL = WebUtil.getParameter(request, "ClickTargetURL")) != null && ClickTargetURL.length() > 0 && !ClickTargetURL.equals(ad.getClickTargetURL())) {
            ad.setClickTargetURL(ClickTargetURL);
            info.append("ClickTargetURL - ");
        }
        if (info.length() > 0) {
            if (ad.save()) {
                WebUtil.createForwardPage(response, "Web Advertisement Updated: " + info.toString(), "advertisements.jsp", 0);
            } else {
                WebUtil.createForwardPage(response, "Web Advertisement Update Error", "advertisements.jsp", 0);
            }
        } else {
            WebUtil.createForwardPage(response, "Web Advertisement not changed", "advertisements.jsp", 0);
        }
    }
}

