/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarcommonscli;

import groovyjarjarcommonscli.Option;
import groovyjarjarcommonscli.Options;
import groovyjarjarcommonscli.Parser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class PosixParser
extends Parser {
    private ArrayList tokens = new ArrayList();
    private boolean eatTheRest;
    private Option currentOption;
    private Options options;

    private void init() {
        this.eatTheRest = false;
        this.tokens.clear();
        this.currentOption = null;
    }

    protected String[] flatten(Options options, String[] arguments, boolean stopAtNonOption) {
        this.init();
        this.options = options;
        Iterator<String> iter = Arrays.asList(arguments).iterator();
        String token = null;
        while (iter.hasNext()) {
            token = iter.next();
            if (token.startsWith("--")) {
                if (token.indexOf(61) != -1) {
                    this.tokens.add(token.substring(0, token.indexOf(61)));
                    this.tokens.add(token.substring(token.indexOf(61) + 1, token.length()));
                } else {
                    this.tokens.add(token);
                }
            } else if ("-".equals(token)) {
                this.processSingleHyphen(token);
            } else if (token.startsWith("-")) {
                int tokenLength = token.length();
                if (tokenLength == 2) {
                    this.processOptionToken(token, stopAtNonOption);
                } else {
                    this.burstToken(token, stopAtNonOption);
                }
            } else if (stopAtNonOption) {
                this.process(token);
            } else {
                this.tokens.add(token);
            }
            this.gobble(iter);
        }
        return this.tokens.toArray(new String[0]);
    }

    private void gobble(Iterator iter) {
        if (this.eatTheRest) {
            while (iter.hasNext()) {
                this.tokens.add(iter.next());
            }
        }
    }

    private void process(String value) {
        if (this.currentOption != null && this.currentOption.hasArg()) {
            if (this.currentOption.hasArg()) {
                this.tokens.add(value);
                this.currentOption = null;
            } else if (this.currentOption.hasArgs()) {
                this.tokens.add(value);
            }
        } else {
            this.eatTheRest = true;
            this.tokens.add("--");
            this.tokens.add(value);
        }
    }

    private void processSingleHyphen(String hyphen) {
        this.tokens.add(hyphen);
    }

    private void processOptionToken(String token, boolean stopAtNonOption) {
        if (this.options.hasOption(token)) {
            this.currentOption = this.options.getOption(token);
            this.tokens.add(token);
        } else if (stopAtNonOption) {
            this.eatTheRest = true;
        }
    }

    protected void burstToken(String token, boolean stopAtNonOption) {
        int tokenLength = token.length();
        int i2 = 1;
        while (i2 < tokenLength) {
            String ch = String.valueOf(token.charAt(i2));
            boolean hasOption = this.options.hasOption(ch);
            if (hasOption) {
                this.tokens.add("-" + ch);
                this.currentOption = this.options.getOption(ch);
                if (this.currentOption.hasArg() && token.length() != i2 + 1) {
                    this.tokens.add(token.substring(i2 + 1));
                    break;
                }
            } else if (stopAtNonOption) {
                this.process(token.substring(i2));
            } else {
                this.tokens.add("-" + ch);
            }
            ++i2;
        }
    }
}

