/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.base.JRBasePrintFrame;
import net.sf.jasperreports.engine.export.CutsInfo;
import net.sf.jasperreports.engine.export.ElementGridCell;
import net.sf.jasperreports.engine.export.ElementWrapper;
import net.sf.jasperreports.engine.export.EmptyGridCell;
import net.sf.jasperreports.engine.export.ExporterNature;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.OccupiedGridCell;
import net.sf.jasperreports.engine.util.JRBoxUtil;

public class JRGridLayout {
    private final ExporterNature nature;
    private int width;
    private int height;
    private int offsetX;
    private int offsetY;
    private final String address;
    private CutsInfo xCuts;
    private CutsInfo yCuts;
    private JRExporterGridCell[][] grid;
    private Map boxesCache;
    private int virtualFrameIndex = 0;
    private boolean hasTopMargin = true;
    private boolean hasBottomMargin = true;
    private boolean hasLeftMargin = true;
    private boolean hasRightMargin = true;
    private boolean isNested;

    public JRGridLayout(ExporterNature nature, List elements, int width, int height, int offsetX, int offsetY) {
        this(nature, elements, width, height, offsetX, offsetY, null);
    }

    public JRGridLayout(ExporterNature nature, List elements, int width, int height, int offsetX, int offsetY, CutsInfo xCuts) {
        this.nature = nature;
        this.height = height;
        this.width = width;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.address = null;
        this.xCuts = xCuts;
        this.boxesCache = new HashMap();
        this.virtualFrameIndex = elements.size();
        this.layoutGrid(JRGridLayout.createWrappers(elements, this.address));
        if (nature.isSplitSharedRowSpan()) {
            this.splitSharedRowSpanIntoNestedGrids();
        }
    }

    protected JRGridLayout(ExporterNature nature, ElementWrapper[] wrappers, int width, int height, int offsetX, int offsetY, String address2) {
        this.nature = nature;
        this.height = height;
        this.width = width;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.address = address2;
        this.isNested = true;
        this.boxesCache = new HashMap();
        this.layoutGrid(wrappers);
        if (nature.isSplitSharedRowSpan()) {
            this.splitSharedRowSpanIntoNestedGrids();
        }
    }

    private void createNestedGrid(int row1, int col1, int row2, int col2) {
        JRBasePrintFrame frame2 = new JRBasePrintFrame(null);
        ArrayList<ElementWrapper> wrappers = new ArrayList<ElementWrapper>();
        OccupiedGridCell occupiedGridCell = new OccupiedGridCell(row1, col1);
        for (int row = row1; row < row2; ++row) {
            for (int col3 = col1; col3 < col2; ++col3) {
                JRExporterGridCell gridCell = this.grid[row][col3];
                this.grid[row][col3] = occupiedGridCell;
                ElementWrapper wrapper = gridCell.getWrapper();
                if (gridCell.getType() != JRExporterGridCell.TYPE_ELEMENT_CELL) continue;
                wrappers.add(wrapper);
                frame2.addElement(wrapper.getElement());
            }
        }
        frame2.setWidth(this.xCuts.getCut(col2) - this.xCuts.getCut(col1));
        frame2.setHeight(this.yCuts.getCut(row2) - this.yCuts.getCut(row1));
        String virtualAddress = (this.address == null ? "" : this.address + "_") + this.getNextVirtualFrameIndex();
        ElementGridCell gridCell = new ElementGridCell(new ElementWrapper(frame2, virtualAddress, null), frame2.getWidth(), frame2.getHeight(), col2 - col1, row2 - row1);
        gridCell.setLayout(new JRGridLayout(this.nature, wrappers.toArray(new ElementWrapper[wrappers.size()]), frame2.getWidth(), frame2.getHeight(), this.offsetX - this.xCuts.getCut(col1), this.offsetY - this.yCuts.getCut(row1), virtualAddress));
        this.grid[row1][col1] = gridCell;
    }

    protected void layoutGrid(ElementWrapper[] wrappers) {
        boolean createXCuts = this.xCuts == null;
        this.xCuts = createXCuts ? new CutsInfo() : this.xCuts;
        CutsInfo cutsInfo = this.yCuts = this.nature.isIgnoreLastRow() ? new CutsInfo(0) : new CutsInfo(this.height);
        if (!this.isNested && this.nature.isIgnorePageMargins()) {
            this.setMargins(wrappers);
            if (createXCuts) {
                List xCutsList = this.xCuts.getCuts();
                if (this.hasLeftMargin) {
                    xCutsList.remove(new Integer(0));
                }
            }
            List yCutsList = this.yCuts.getCuts();
            if (this.hasTopMargin) {
                yCutsList.remove(new Integer(0));
            }
            if (this.hasBottomMargin) {
                yCutsList.remove(new Integer(this.height));
            }
        }
        this.createCuts(wrappers, this.offsetX, this.offsetY, createXCuts);
        if (!(!createXCuts || !this.isNested && (this.nature.isIgnorePageMargins() && this.hasRightMargin || this.xCuts.hasCuts() && this.xCuts.getLastCut() >= this.width))) {
            this.xCuts.addCut(this.width);
        }
        this.xCuts.use();
        this.yCuts.use();
        int colCount = Math.max(this.xCuts.size() - 1, 0);
        int rowCount = Math.max(this.yCuts.size() - 1, 0);
        this.grid = new JRExporterGridCell[rowCount][colCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int col2 = 0; col2 < colCount; ++col2) {
                this.grid[row][col2] = new EmptyGridCell(this.xCuts.getCut(col2 + 1) - this.xCuts.getCut(col2), this.yCuts.getCut(row + 1) - this.yCuts.getCut(row), 1, 1);
            }
        }
        this.setGridElements(wrappers, this.offsetX, this.offsetY, 0, 0, rowCount, colCount);
        this.width = this.xCuts.getTotalLength();
        this.height = this.yCuts.getTotalLength();
    }

    protected void createCuts(ElementWrapper[] wrappers, int elementOffsetX, int elementOffsetY, boolean createXCuts) {
        for (int elementIndex = 0; elementIndex < wrappers.length; ++elementIndex) {
            ElementWrapper wrapper = wrappers[elementIndex];
            JRPrintElement element = wrapper.getElement();
            if (!this.nature.isToExport(element)) continue;
            if (createXCuts) {
                this.xCuts.addXCuts(element, elementOffsetX);
            }
            this.yCuts.addYCuts(element, elementOffsetY);
            if (!this.nature.isDeep() || !(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame2 = (JRPrintFrame)element;
            this.createCuts(wrapper.getWrappers(), element.getX() + elementOffsetX + frame2.getLineBox().getLeftPadding(), element.getY() + elementOffsetY + frame2.getLineBox().getTopPadding(), createXCuts);
        }
    }

    protected void setMargins(ElementWrapper[] wrappers) {
        for (int elementIndex = 0; elementIndex < wrappers.length; ++elementIndex) {
            ElementWrapper wrapper = wrappers[elementIndex];
            JRPrintElement element = wrapper.getElement();
            if (!this.nature.isToExport(element)) continue;
            if (this.hasLeftMargin && element.getX() <= 0) {
                this.hasLeftMargin = false;
            }
            if (this.hasRightMargin && element.getX() >= this.width - element.getWidth()) {
                this.hasRightMargin = false;
            }
            if (this.hasTopMargin && element.getY() <= 0) {
                this.hasTopMargin = false;
            }
            if (!this.hasBottomMargin || element.getY() < this.height - element.getHeight()) continue;
            this.hasBottomMargin = false;
        }
    }

    protected void setGridElements(ElementWrapper[] wrappers, int elementOffsetX, int elementOffsetY, int startRow, int startCol, int endRow, int endCol) {
        for (int elementIndex = wrappers.length - 1; elementIndex >= 0; --elementIndex) {
            ElementWrapper wrapper = wrappers[elementIndex];
            JRPrintElement element = wrapper.getElement();
            if (!this.nature.isToExport(element)) continue;
            int x = element.getX() + elementOffsetX;
            int y = element.getY() + elementOffsetY;
            int col1 = this.xCuts.indexOfCut(x);
            int row1 = this.yCuts.indexOfCut(y);
            int col2 = this.xCuts.indexOfCut(x + element.getWidth());
            int row2 = this.yCuts.indexOfCut(y + element.getHeight());
            if (this.isOverlap(row1, col1, row2, col2)) continue;
            if (this.nature.isDeep() && element instanceof JRPrintFrame) {
                JRPrintFrame frame2 = (JRPrintFrame)element;
                this.setGridElements(wrapper.getWrappers(), x + frame2.getLineBox().getLeftPadding(), y + frame2.getLineBox().getTopPadding(), row1, col1, row2, col2);
                this.setFrameCellsStyle(frame2, row1, col1, row2, col2);
                continue;
            }
            this.setGridElement(wrapper, row1, col1, row2, col2);
        }
        if (this.nature.isHorizontallyMergeEmptyCells()) {
            this.horizontallyMergeEmptyCells(startRow, startCol, endRow, endCol);
        }
    }

    protected void horizontallyMergeEmptyCells(int startRow, int startCol, int endRow, int endCol) {
        for (int row = startRow; row < endRow; ++row) {
            int col2;
            int startSpan = -1;
            int spanWidth = 0;
            for (col2 = startCol; col2 < endCol; ++col2) {
                JRExporterGridCell cell = this.grid[row][col2];
                if (cell.isEmpty()) {
                    if (startSpan == -1) {
                        startSpan = col2;
                    }
                    spanWidth += cell.getWidth();
                    continue;
                }
                if (startSpan != -1 && col2 - startSpan > 1) {
                    JRExporterGridCell spanCell = this.grid[row][startSpan];
                    spanCell.setColSpan(col2 - startSpan);
                    spanCell.setWidth(spanWidth);
                }
                startSpan = -1;
                spanWidth = 0;
            }
            if (startSpan == -1 || col2 - startSpan <= 1) continue;
            JRExporterGridCell spanCell = this.grid[row][startSpan];
            spanCell.setColSpan(col2 - startSpan);
            spanCell.setWidth(spanWidth);
        }
    }

    protected boolean isOverlap(int row1, int col1, int row2, int col2) {
        boolean isOverlap;
        block4: {
            isOverlap = false;
            if (this.nature.isSpanCells()) {
                for (int row = row1; row < row2; ++row) {
                    for (int col3 = col1; col3 < col2; ++col3) {
                        if (this.grid[row][col3].isEmpty()) continue;
                        isOverlap = true;
                        break block4;
                    }
                }
            } else {
                isOverlap = this.grid[row1][col1].getWrapper() != null;
            }
        }
        return isOverlap;
    }

    protected void setGridElement(ElementWrapper wrapper, int row1, int col1, int row2, int col2) {
        this.yCuts.addUsage(row1, 1);
        this.xCuts.addUsage(col1, 1);
        if (this.nature.isSpanCells()) {
            OccupiedGridCell occupiedGridCell = new OccupiedGridCell(row1, col1);
            for (int row = row1; row < row2; ++row) {
                for (int col3 = col1; col3 < col2; ++col3) {
                    this.grid[row][col3] = occupiedGridCell;
                }
                this.yCuts.addUsage(row, 2);
            }
            for (int col4 = col1; col4 < col2; ++col4) {
                this.xCuts.addUsage(col4, 2);
            }
        }
        if (col2 - col1 != 0 && row2 - row1 != 0) {
            JRPrintElement element = wrapper.getElement();
            JRPrintFrame frame2 = element instanceof JRPrintFrame ? (JRPrintFrame)element : null;
            int rowSpan = this.nature.isSpanCells() ? row2 - row1 : 1;
            int colSpan = this.nature.isSpanCells() ? col2 - col1 : 1;
            ElementGridCell gridCell = new ElementGridCell(wrapper, element.getWidth(), element.getHeight(), colSpan, rowSpan);
            if (frame2 != null) {
                gridCell.setLayout(new JRGridLayout(this.nature, wrapper.getWrappers(), frame2.getWidth(), frame2.getHeight(), 0, 0, wrapper.getAddress()));
            }
            gridCell.setBox(element instanceof JRBoxContainer ? ((JRBoxContainer)((Object)element)).getLineBox() : null);
            if (this.nature.isBreakBeforeRow(element)) {
                this.yCuts.addUsage(row1, 4);
            }
            if (this.nature.isBreakAfterRow(element)) {
                this.yCuts.addUsage(row1 + rowSpan, 4);
            }
            this.grid[row1][col1] = gridCell;
        }
    }

    protected void setFrameCellsStyle(JRPrintFrame frame2, int row1, int col1, int row2, int col2) {
        Color backcolor = frame2.getMode() == 1 ? frame2.getBackcolor() : null;
        for (int row = row1; row < row2; ++row) {
            for (int col3 = col1; col3 < col2; ++col3) {
                boolean keepBottom;
                JRExporterGridCell cell = this.grid[row][col3];
                if (cell.getBackcolor() == null && frame2.getMode() == 1) {
                    cell.setBackcolor(backcolor);
                }
                if (cell.getForecolor() == null) {
                    cell.setForecolor(frame2.getForecolor());
                }
                boolean keepLeft = col3 == col1;
                boolean keepRight = col3 == col2 - cell.getColSpan();
                boolean keepTop = row == row1;
                boolean bl = keepBottom = row == row2 - cell.getRowSpan();
                if (!keepLeft && !keepRight && !keepTop && !keepBottom) continue;
                JRLineBox cellBox = cell.getBox();
                BoxKey key = new BoxKey(frame2.getLineBox(), cellBox, keepLeft, keepRight, keepTop, keepBottom);
                JRLineBox modBox = (JRLineBox)this.boxesCache.get(key);
                if (modBox == null) {
                    modBox = JRBoxUtil.clone(frame2.getLineBox(), keepLeft, keepRight, keepTop, keepBottom, cellBox);
                    this.boxesCache.put(key, modBox);
                }
                cell.setBox(modBox);
            }
        }
    }

    private void splitSharedRowSpanIntoNestedGrids() {
        int rowSpan;
        for (int row = 0; row < this.grid.length; row += Math.abs(rowSpan)) {
            rowSpan = this.getSharedRowSpan(row);
            if (rowSpan <= 0) continue;
            this.splitSharedColSpanIntoNestedGrids(row, row + rowSpan);
        }
    }

    private void splitSharedColSpanIntoNestedGrids(int row1, int row2) {
        int colSpan;
        for (int col2 = 0; col2 < this.grid[row1].length; col2 += Math.abs(colSpan)) {
            colSpan = this.getSharedColSpan(row1, row2, col2);
            if (colSpan <= 0 || row1 == 0 && row2 == this.grid.length && col2 == 0 && colSpan == this.grid[0].length) continue;
            this.createNestedGrid(row1, col2, row2, col2 + colSpan);
        }
    }

    private int getSharedRowSpan(int row1) {
        int rowSpan = 1;
        int sharedSpanCount = 0;
        for (int row = 0; row < rowSpan; ++row) {
            for (int col2 = 0; col2 < this.grid[0].length; ++col2) {
                JRExporterGridCell gridCell = this.grid[row1 + row][col2];
                if (row + gridCell.getRowSpan() <= rowSpan) continue;
                ++sharedSpanCount;
                rowSpan = row + gridCell.getRowSpan();
            }
        }
        return sharedSpanCount > 1 ? rowSpan : -rowSpan;
    }

    private int getSharedColSpan(int row1, int row2, int col1) {
        int colSpan = 1;
        boolean isSharedSpan = false;
        for (int col2 = 0; col2 < colSpan; ++col2) {
            for (int row = row1; row < row2; ++row) {
                JRExporterGridCell gridCell = this.grid[row][col1 + col2];
                if (col2 + gridCell.getColSpan() > colSpan) {
                    isSharedSpan = true;
                    colSpan = col2 + gridCell.getColSpan();
                    continue;
                }
                if (gridCell.getRowSpan() <= 1) continue;
                isSharedSpan = true;
            }
        }
        return isSharedSpan ? colSpan : -colSpan;
    }

    public JRExporterGridCell[][] getGrid() {
        return this.grid;
    }

    public CutsInfo getXCuts() {
        return this.xCuts;
    }

    public CutsInfo getYCuts() {
        return this.yCuts;
    }

    public int getWidth() {
        return this.width;
    }

    public int getRowHeight(int row) {
        return this.yCuts.getCut(row + 1) - this.yCuts.getCut(row);
    }

    public static int getMaxRowHeight(JRExporterGridCell[] row) {
        int maxRowHeight = row[0].getHeight();
        for (int col2 = 0; col2 < row.length; ++col2) {
            JRExporterGridCell cell = row[col2];
            if (cell.getType() == JRExporterGridCell.TYPE_OCCUPIED_CELL || maxRowHeight >= cell.getHeight()) continue;
            maxRowHeight = cell.getHeight();
        }
        return maxRowHeight;
    }

    public static int getRowHeight(JRExporterGridCell[] row) {
        int col2;
        if (row[0].getRowSpan() == 1 && row[0].getType() != JRExporterGridCell.TYPE_OCCUPIED_CELL) {
            return row[0].getHeight();
        }
        int rowHeight = 0;
        int minSpanIdx = 0;
        int colCount = row.length;
        for (col2 = 0; col2 < colCount; ++col2) {
            JRExporterGridCell cell = row[col2];
            if (cell.getType() == JRExporterGridCell.TYPE_OCCUPIED_CELL) continue;
            if (cell.getRowSpan() == 1) {
                rowHeight = cell.getHeight();
                break;
            }
            if (cell.getRowSpan() >= row[minSpanIdx].getRowSpan()) continue;
            minSpanIdx = col2;
        }
        if (col2 >= colCount) {
            rowHeight = row[minSpanIdx].getHeight();
        }
        return rowHeight;
    }

    public static CutsInfo calculateXCuts(ExporterNature nature, List pages, int startPageIndex, int endPageIndex, int width, int offsetX) {
        CutsInfo xCuts = new CutsInfo();
        for (int pageIndex = startPageIndex; pageIndex <= endPageIndex; ++pageIndex) {
            JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
            JRGridLayout.addXCuts(nature, page.getElements(), offsetX, xCuts);
        }
        int lastCut = xCuts.getLastCut();
        if (lastCut < width) {
            xCuts.addCut(width);
        }
        return xCuts;
    }

    protected static void addXCuts(ExporterNature nature, List elementsList, int elementOffsetX, CutsInfo xCuts) {
        Iterator it = elementsList.iterator();
        while (it.hasNext()) {
            JRPrintElement element = (JRPrintElement)it.next();
            if (!nature.isToExport(element)) continue;
            xCuts.addXCuts(element, elementOffsetX);
            if (!(element instanceof JRPrintFrame)) continue;
            JRPrintFrame frame2 = (JRPrintFrame)element;
            JRGridLayout.addXCuts(nature, frame2.getElements(), element.getX() + elementOffsetX + frame2.getLineBox().getLeftPadding(), xCuts);
        }
    }

    protected int getNextVirtualFrameIndex() {
        return this.virtualFrameIndex++;
    }

    private static ElementWrapper[] createWrappers(List elementsList, String parentAddress) {
        ElementWrapper[] wrappers = new ElementWrapper[elementsList.size()];
        for (int elementIndex = 0; elementIndex < elementsList.size(); ++elementIndex) {
            JRPrintElement element = (JRPrintElement)elementsList.get(elementIndex);
            String address2 = (parentAddress == null ? "" : parentAddress + "_") + elementIndex;
            wrappers[elementIndex] = new ElementWrapper(element, address2, element instanceof JRPrintFrame ? JRGridLayout.createWrappers(((JRPrintFrame)element).getElements(), address2) : null);
        }
        return wrappers;
    }

    protected static class BoxKey {
        final JRLineBox box;
        final JRLineBox cellBox;
        final boolean left;
        final boolean right;
        final boolean top;
        final boolean bottom;
        final int hashCode;

        BoxKey(JRLineBox box, JRLineBox cellBox, boolean left, boolean right, boolean top, boolean bottom) {
            this.box = box;
            this.cellBox = cellBox;
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
            int hash = box.hashCode();
            if (cellBox != null) {
                hash = 31 * hash + cellBox.hashCode();
            }
            hash = 31 * hash + (left ? 1231 : 1237);
            hash = 31 * hash + (right ? 1231 : 1237);
            hash = 31 * hash + (top ? 1231 : 1237);
            this.hashCode = hash = 31 * hash + (bottom ? 1231 : 1237);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            BoxKey b2 = (BoxKey)obj;
            return b2.box.equals(this.box) && (b2.cellBox == null ? this.cellBox == null : this.cellBox != null && b2.cellBox.equals(this.cellBox)) && b2.left == this.left && b2.right == this.right && b2.top == this.top && b2.bottom == this.bottom;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

