/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.barbecue;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.StringWriter;
import java.io.Writer;
import java.text.StringCharacterIterator;
import javax.swing.JComponent;
import net.sourceforge.barbecue.BarcodeException;
import net.sourceforge.barbecue.Module;
import net.sourceforge.barbecue.env.EnvironmentFactory;
import net.sourceforge.barbecue.output.AbstractOutput;
import net.sourceforge.barbecue.output.GraphicsOutput;
import net.sourceforge.barbecue.output.SVGOutput;

public abstract class Barcode
extends JComponent {
    private static final String[] UNITS = new String[]{"in", "px", "cm", "mm"};
    private static final double DEFAULT_BAR_HEIGHT = 50.0;
    protected String data;
    protected boolean drawingText;
    protected double barWidth = 2.0;
    protected double barHeight;
    private Font font;
    private Dimension size;
    private int x;
    private int y;
    private int resolution = -1;
    private String mSVGUnits;
    private double mSVGScalar;

    protected Barcode(String string) throws BarcodeException {
        if (string == null || string.length() == 0) {
            throw new BarcodeException("Data to encode cannot be empty");
        }
        this.data = string;
        double d2 = this.calculateMinimumBarHeight(this.getResolution());
        this.barHeight = d2 > 0.0 ? d2 : 50.0;
        this.font = EnvironmentFactory.getEnvironment().getDefaultFont();
        this.drawingText = true;
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setOpaque(true);
        this.setSVGScalar(0.0078125, "in");
        this.invalidateSize();
    }

    public String getData() {
        return this.data;
    }

    public void setFont(Font font2) {
        this.font = font2;
        this.invalidateSize();
    }

    public void setDrawingText(boolean bl) {
        this.drawingText = bl;
        this.invalidateSize();
    }

    public boolean isDrawingText() {
        return this.drawingText;
    }

    public void setBarWidth(double d2) {
        this.barWidth = d2 >= 1.0 ? d2 : 1.0;
        this.invalidateSize();
    }

    public void setBarHeight(double d2) {
        if (d2 > this.calculateMinimumBarHeight(this.getResolution())) {
            this.barHeight = d2;
            this.invalidateSize();
        }
    }

    public void setResolution(int n) {
        if (n > 0) {
            this.resolution = n;
            double d2 = this.calculateMinimumBarHeight(this.getResolution());
            if (d2 > this.barHeight) {
                this.barHeight = d2;
            }
            this.invalidateSize();
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return (int)this.getActualSize().getWidth();
    }

    public int getHeight() {
        return (int)this.getActualSize().getHeight();
    }

    public Rectangle getBounds() {
        return this.getBounds(new Rectangle());
    }

    public Rectangle getBounds(Rectangle rectangle) {
        rectangle.setBounds(this.getX(), this.getY(), (int)this.getActualSize().getWidth() + this.getX(), (int)this.getActualSize().getHeight() + this.getY());
        return rectangle;
    }

    public Dimension getPreferredSize() {
        return this.getActualSize();
    }

    public Dimension getMinimumSize() {
        return this.getActualSize();
    }

    public Dimension getMaximumSize() {
        return this.getActualSize();
    }

    public Dimension getSize() {
        return this.getActualSize();
    }

    public void draw(Graphics2D graphics2D, int n, int n2) {
        this.x = n;
        this.y = n2;
        this.size = this.internalDraw(graphics2D, n, n2, true);
    }

    protected abstract double getBarcodeWidth(int var1);

    protected abstract Module[] encodeData();

    protected abstract Module calculateChecksum();

    protected abstract Module getPreAmble();

    protected abstract Module getPostAmble();

    protected String getLabel() {
        return this.data;
    }

    protected double calculateMinimumBarHeight(int n) {
        return 0.0;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Insets insets = this.getInsets();
        this.draw((Graphics2D)graphics, insets.left, insets.top);
    }

    protected int getResolution() {
        if (this.resolution > 0) {
            return this.resolution;
        }
        return EnvironmentFactory.getEnvironment().getResolution();
    }

    private Dimension internalDraw(Graphics2D graphics2D, int n, int n2, boolean bl) {
        Module[] moduleArray;
        Color color = graphics2D.getColor();
        double d2 = n;
        GraphicsOutput graphicsOutput = new GraphicsOutput(graphics2D, this.font, this.barWidth, this.barHeight, bl, this.getForeground(), this.getBackground());
        if (bl) {
            moduleArray = this.getActualSize();
            ((AbstractOutput)graphicsOutput).beginDraw(moduleArray.width, moduleArray.height);
        }
        d2 += this.drawModule(this.getPreAmble(), graphicsOutput, d2, n2);
        moduleArray = this.encodeData();
        for (int j = 0; j < moduleArray.length; ++j) {
            Module module = moduleArray[j];
            d2 += this.drawModule(module, graphicsOutput, d2, n2);
        }
        d2 += this.drawModule(this.calculateChecksum(), graphicsOutput, d2, n2);
        d2 += this.drawModule(this.getPostAmble(), graphicsOutput, d2, n2);
        double d3 = this.barHeight + (double)n2;
        if (this.drawingText) {
            d3 += this.drawTextLabel(graphicsOutput, n, (int)d3, d2);
        }
        if (bl) {
            ((AbstractOutput)graphicsOutput).endDraw();
        }
        graphics2D.setColor(color);
        return new Dimension((int)(d2 - (double)n), (int)d3 - n2);
    }

    private void invalidateSize() {
        this.size = null;
    }

    private Dimension getActualSize() {
        if (this.size == null) {
            this.size = this.calculateSize();
        }
        return this.size;
    }

    private Dimension calculateSize() {
        return this.internalDraw((Graphics2D)new BufferedImage(1000, 1000, 10).getGraphics(), 0, 0, false);
    }

    protected double drawModule(Module module, AbstractOutput abstractOutput, double d2, double d3) {
        if (module == null) {
            return 0.0;
        }
        return module.draw(abstractOutput, d2, d3);
    }

    protected String beautify(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c2 = stringCharacterIterator.first();
        while (c2 != '\uffff') {
            if (Character.isDefined(c2) && !Character.isISOControl(c2)) {
                stringBuffer.append(c2);
            }
            c2 = stringCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    public String getSVG() {
        StringWriter stringWriter = new StringWriter();
        this.outputSVG(stringWriter);
        return stringWriter.toString();
    }

    public void outputSVG(Writer writer) {
        this.internalOutputSVG(writer, 0, 0);
    }

    public void setSVGScalar(double d2, String string) {
        String string2 = "";
        boolean bl = false;
        for (int j = 0; !bl && j < UNITS.length; ++j) {
            if (string.equals(UNITS[j])) {
                bl = true;
            }
            if (j != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + UNITS[j];
        }
        if (!bl) {
            throw new IllegalArgumentException("SVG Units must be one of " + string2);
        }
        this.mSVGScalar = d2;
        this.mSVGUnits = string;
    }

    private Dimension internalOutputSVG(Writer writer, int n, int n2) {
        double d2 = n;
        double d3 = this.barWidth;
        boolean bl = this.drawingText;
        this.drawingText = false;
        this.setBarWidth(1.0);
        SVGOutput sVGOutput = new SVGOutput(writer, this.font, this.barHeight, this.getForeground(), this.getBackground(), this.mSVGScalar, this.mSVGUnits);
        Dimension dimension = this.getActualSize();
        ((AbstractOutput)sVGOutput).beginDraw(dimension.width, dimension.height);
        d2 += this.drawModule(this.getPreAmble(), sVGOutput, d2, n2);
        Module[] moduleArray = this.encodeData();
        for (int j = 0; j < moduleArray.length; ++j) {
            Module module = moduleArray[j];
            d2 += this.drawModule(module, sVGOutput, d2, n2);
        }
        d2 += this.drawModule(this.calculateChecksum(), sVGOutput, d2, n2);
        d2 += this.drawModule(this.getPostAmble(), sVGOutput, d2, n2);
        double d4 = this.barHeight + (double)n2;
        if (this.drawingText) {
            d4 += this.drawTextLabel(sVGOutput, n, (int)d4, d2);
        }
        ((AbstractOutput)sVGOutput).endDraw();
        this.setBarWidth(d3);
        this.drawingText = bl;
        return new Dimension((int)(d2 - (double)n), (int)d4 - n2);
    }

    private double drawTextLabel(AbstractOutput abstractOutput, double d2, double d3, double d4) {
        String string = this.beautify(this.getLabel());
        return abstractOutput.drawText(string, d2, d3, d4);
    }
}

