/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.bytecode;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.javaflow.bytecode.EmptyStackException;
import org.apache.commons.javaflow.utils.ReflectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Stack
implements Serializable {
    private static final Log log = LogFactory.getLog(class$org$apache$commons$javaflow$bytecode$Stack == null ? (class$org$apache$commons$javaflow$bytecode$Stack = Stack.class$("org.apache.commons.javaflow.bytecode.Stack")) : class$org$apache$commons$javaflow$bytecode$Stack);
    private static final long serialVersionUID = 2L;
    private int[] istack;
    private float[] fstack;
    private double[] dstack;
    private long[] lstack;
    private Object[] ostack;
    private Object[] rstack;
    private int iTop;
    private int fTop;
    private int dTop;
    private int lTop;
    private int oTop;
    private int rTop;
    protected Runnable runnable;
    static /* synthetic */ Class class$org$apache$commons$javaflow$bytecode$Stack;

    public Stack(Runnable pRunnable) {
        this.istack = new int[10];
        this.lstack = new long[5];
        this.dstack = new double[5];
        this.fstack = new float[5];
        this.ostack = new Object[10];
        this.rstack = new Object[5];
        this.runnable = pRunnable;
    }

    public Stack(Stack pParent) {
        this.istack = new int[pParent.istack.length];
        this.lstack = new long[pParent.lstack.length];
        this.dstack = new double[pParent.dstack.length];
        this.fstack = new float[pParent.fstack.length];
        this.ostack = new Object[pParent.ostack.length];
        this.rstack = new Object[pParent.rstack.length];
        this.iTop = pParent.iTop;
        this.fTop = pParent.fTop;
        this.dTop = pParent.dTop;
        this.lTop = pParent.lTop;
        this.oTop = pParent.oTop;
        this.rTop = pParent.rTop;
        System.arraycopy(pParent.istack, 0, this.istack, 0, this.iTop);
        System.arraycopy(pParent.fstack, 0, this.fstack, 0, this.fTop);
        System.arraycopy(pParent.dstack, 0, this.dstack, 0, this.dTop);
        System.arraycopy(pParent.lstack, 0, this.lstack, 0, this.lTop);
        System.arraycopy(pParent.ostack, 0, this.ostack, 0, this.oTop);
        System.arraycopy(pParent.rstack, 0, this.rstack, 0, this.rTop);
        this.runnable = pParent.runnable;
    }

    public boolean hasDouble() {
        return this.dTop > 0;
    }

    public double popDouble() {
        if (this.dTop == 0) {
            throw new EmptyStackException("pop double");
        }
        double d2 = this.dstack[--this.dTop];
        log.debug("pop double " + d2 + " " + this.getStats());
        return d2;
    }

    public boolean hasFloat() {
        return this.fTop > 0;
    }

    public float popFloat() {
        if (this.fTop == 0) {
            throw new EmptyStackException("pop float");
        }
        float f2 = this.fstack[--this.fTop];
        log.debug("pop float " + f2 + " " + this.getStats());
        return f2;
    }

    public boolean hasInt() {
        return this.iTop > 0;
    }

    public int popInt() {
        if (this.iTop == 0) {
            throw new EmptyStackException("pop int");
        }
        int i2 = this.istack[--this.iTop];
        log.debug("pop int " + i2 + " " + this.getStats());
        return i2;
    }

    public boolean hasLong() {
        return this.lTop > 0;
    }

    public long popLong() {
        if (this.lTop == 0) {
            throw new EmptyStackException("pop long");
        }
        long l = this.lstack[--this.lTop];
        log.debug("pop long " + l + " " + this.getStats());
        return l;
    }

    public boolean hasObject() {
        return this.oTop > 0;
    }

    public Object popObject() {
        if (this.oTop == 0) {
            throw new EmptyStackException("pop object");
        }
        Object o = this.ostack[--this.oTop];
        this.ostack[this.oTop] = null;
        if (log.isDebugEnabled()) {
            String clazz = ReflectionUtils.getClassName(o);
            String clazzLoader = ReflectionUtils.getClassLoaderName(o);
            log.debug("pop object " + clazz + "/" + clazzLoader + " [" + o + "] ");
        }
        return o;
    }

    public boolean hasReference() {
        return this.rTop > 0;
    }

    public Object popReference() {
        if (this.rTop == 0) {
            throw new EmptyStackException("pop reference");
        }
        Object o = this.rstack[--this.rTop];
        this.rstack[this.rTop] = null;
        if (log.isDebugEnabled()) {
            String clazz = ReflectionUtils.getClassName(o);
            String clazzLoader = ReflectionUtils.getClassLoaderName(o);
            log.debug("pop reference " + clazz + "/" + clazzLoader + " [" + o + "] " + this.getStats());
        }
        return o;
    }

    public void pushDouble(double d2) {
        log.debug("push double " + d2 + " " + this.getStats());
        if (this.dTop == this.dstack.length) {
            double[] hlp = new double[Math.max(8, this.dstack.length * 2)];
            System.arraycopy(this.dstack, 0, hlp, 0, this.dstack.length);
            this.dstack = hlp;
        }
        this.dstack[this.dTop++] = d2;
    }

    public void pushFloat(float f2) {
        log.debug("push float " + f2 + " " + this.getStats());
        if (this.fTop == this.fstack.length) {
            float[] hlp = new float[Math.max(8, this.fstack.length * 2)];
            System.arraycopy(this.fstack, 0, hlp, 0, this.fstack.length);
            this.fstack = hlp;
        }
        this.fstack[this.fTop++] = f2;
    }

    public void pushInt(int i2) {
        log.debug("push int " + i2 + " " + this.getStats());
        if (this.iTop == this.istack.length) {
            int[] hlp = new int[Math.max(8, this.istack.length * 2)];
            System.arraycopy(this.istack, 0, hlp, 0, this.istack.length);
            this.istack = hlp;
        }
        this.istack[this.iTop++] = i2;
    }

    public void pushLong(long l) {
        log.debug("push long " + l + " " + this.getStats());
        if (this.lTop == this.lstack.length) {
            long[] hlp = new long[Math.max(8, this.lstack.length * 2)];
            System.arraycopy(this.lstack, 0, hlp, 0, this.lstack.length);
            this.lstack = hlp;
        }
        this.lstack[this.lTop++] = l;
    }

    public void pushObject(Object o) {
        if (log.isDebugEnabled()) {
            String clazz = ReflectionUtils.getClassName(o);
            String clazzLoader = ReflectionUtils.getClassLoaderName(o);
            log.debug("push object " + clazz + "/" + clazzLoader + " [" + o + "] " + this.getStats());
        }
        if (this.oTop == this.ostack.length) {
            Object[] hlp = new Object[Math.max(8, this.ostack.length * 2)];
            System.arraycopy(this.ostack, 0, hlp, 0, this.ostack.length);
            this.ostack = hlp;
        }
        this.ostack[this.oTop++] = o;
    }

    public void pushReference(Object o) {
        if (log.isDebugEnabled()) {
            String clazz = ReflectionUtils.getClassName(o);
            String clazzLoader = ReflectionUtils.getClassLoaderName(o);
            log.debug("push reference " + clazz + "/" + clazzLoader + " [" + o + "] " + this.getStats());
        }
        if (this.rTop == this.rstack.length) {
            Object[] hlp = new Object[Math.max(8, this.rstack.length * 2)];
            System.arraycopy(this.rstack, 0, hlp, 0, this.rstack.length);
            this.rstack = hlp;
        }
        this.rstack[this.rTop++] = o;
    }

    public boolean isSerializable() {
        int i2;
        for (i2 = 0; i2 < this.rTop; ++i2) {
            Object r = this.rstack[i2];
            if (r instanceof Serializable) continue;
            return false;
        }
        for (i2 = 0; i2 < this.oTop; ++i2) {
            Object o = this.ostack[i2];
            if (o instanceof Serializable) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.iTop == 0 && this.lTop == 0 && this.dTop == 0 && this.fTop == 0 && this.oTop == 0 && this.rTop == 0;
    }

    private String getStats() {
        StringBuffer sb = new StringBuffer();
        sb.append("i[").append(this.iTop).append("],");
        sb.append("l[").append(this.lTop).append("],");
        sb.append("d[").append(this.dTop).append("],");
        sb.append("f[").append(this.fTop).append("],");
        sb.append("o[").append(this.oTop).append("],");
        sb.append("r[").append(this.rTop).append("]");
        return sb.toString();
    }

    private String getContent() {
        int i2;
        StringBuffer sb = new StringBuffer();
        sb.append("i[").append(this.iTop).append("]\n");
        sb.append("l[").append(this.lTop).append("]\n");
        sb.append("d[").append(this.dTop).append("]\n");
        sb.append("f[").append(this.fTop).append("]\n");
        sb.append("o[").append(this.oTop).append("]\n");
        for (i2 = 0; i2 < this.oTop; ++i2) {
            sb.append(' ').append(i2).append(": ");
            sb.append(ReflectionUtils.getClassName(this.ostack[i2])).append('/').append(ReflectionUtils.getClassLoaderName(this.ostack[i2]));
            sb.append('\n');
        }
        sb.append("r[").append(this.rTop).append("]\n");
        for (i2 = 0; i2 < this.rTop; ++i2) {
            sb.append(' ').append(i2).append(": ");
            sb.append(ReflectionUtils.getClassName(this.rstack[i2])).append('/').append(ReflectionUtils.getClassLoaderName(this.rstack[i2]));
            sb.append('\n');
        }
        return sb.toString();
    }

    public String toString() {
        return this.getContent();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        int i2;
        s2.writeInt(this.iTop);
        for (i2 = 0; i2 < this.iTop; ++i2) {
            s2.writeInt(this.istack[i2]);
        }
        s2.writeInt(this.lTop);
        for (i2 = 0; i2 < this.lTop; ++i2) {
            s2.writeLong(this.lstack[i2]);
        }
        s2.writeInt(this.dTop);
        for (i2 = 0; i2 < this.dTop; ++i2) {
            s2.writeDouble(this.dstack[i2]);
        }
        s2.writeInt(this.fTop);
        for (i2 = 0; i2 < this.fTop; ++i2) {
            s2.writeDouble(this.fstack[i2]);
        }
        s2.writeInt(this.oTop);
        for (i2 = 0; i2 < this.oTop; ++i2) {
            s2.writeObject(this.ostack[i2]);
        }
        s2.writeInt(this.rTop);
        for (i2 = 0; i2 < this.rTop; ++i2) {
            s2.writeObject(this.rstack[i2]);
        }
        s2.writeObject(this.runnable);
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        int i2;
        this.iTop = s2.readInt();
        this.istack = new int[this.iTop];
        for (i2 = 0; i2 < this.iTop; ++i2) {
            this.istack[i2] = s2.readInt();
        }
        this.lTop = s2.readInt();
        this.lstack = new long[this.lTop];
        for (i2 = 0; i2 < this.lTop; ++i2) {
            this.lstack[i2] = s2.readLong();
        }
        this.dTop = s2.readInt();
        this.dstack = new double[this.dTop];
        for (i2 = 0; i2 < this.dTop; ++i2) {
            this.dstack[i2] = s2.readDouble();
        }
        this.fTop = s2.readInt();
        this.fstack = new float[this.fTop];
        for (i2 = 0; i2 < this.fTop; ++i2) {
            this.fstack[i2] = s2.readFloat();
        }
        this.oTop = s2.readInt();
        this.ostack = new Object[this.oTop];
        for (i2 = 0; i2 < this.oTop; ++i2) {
            this.ostack[i2] = s2.readObject();
        }
        this.rTop = s2.readInt();
        this.rstack = new Object[this.rTop];
        for (i2 = 0; i2 < this.rTop; ++i2) {
            this.rstack[i2] = s2.readObject();
        }
        this.runnable = (Runnable)s2.readObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

