/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.util.Date;
import org.apache.poi.hpsf.MutableSection;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SpecialPropertySet;
import org.apache.poi.hpsf.UnexpectedPropertySetTypeException;
import org.apache.poi.hpsf.Util;
import org.apache.poi.hpsf.wellknown.PropertyIDMap;

public class SummaryInformation
extends SpecialPropertySet {
    public static final String DEFAULT_STREAM_NAME = "\u0005SummaryInformation";

    public PropertyIDMap getPropertySetIDMap() {
        return PropertyIDMap.getSummaryInformationProperties();
    }

    public SummaryInformation(PropertySet ps) throws UnexpectedPropertySetTypeException {
        super(ps);
        if (!this.isSummaryInformation()) {
            throw new UnexpectedPropertySetTypeException("Not a " + this.getClass().getName());
        }
    }

    public String getTitle() {
        return (String)this.getProperty(2);
    }

    public void setTitle(String title2) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(2, title2);
    }

    public void removeTitle() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(2L);
    }

    public String getSubject() {
        return (String)this.getProperty(3);
    }

    public void setSubject(String subject) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(3, subject);
    }

    public void removeSubject() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(3L);
    }

    public String getAuthor() {
        return (String)this.getProperty(4);
    }

    public void setAuthor(String author) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(4, author);
    }

    public void removeAuthor() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(4L);
    }

    public String getKeywords() {
        return (String)this.getProperty(5);
    }

    public void setKeywords(String keywords) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(5, keywords);
    }

    public void removeKeywords() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(5L);
    }

    public String getComments() {
        return (String)this.getProperty(6);
    }

    public void setComments(String comments) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(6, comments);
    }

    public void removeComments() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(6L);
    }

    public String getTemplate() {
        return (String)this.getProperty(7);
    }

    public void setTemplate(String template) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(7, template);
    }

    public void removeTemplate() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(7L);
    }

    public String getLastAuthor() {
        return (String)this.getProperty(8);
    }

    public void setLastAuthor(String lastAuthor) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(8, lastAuthor);
    }

    public void removeLastAuthor() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(8L);
    }

    public String getRevNumber() {
        return (String)this.getProperty(9);
    }

    public void setRevNumber(String revNumber) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(9, revNumber);
    }

    public void removeRevNumber() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(9L);
    }

    public long getEditTime() {
        Date d2 = (Date)this.getProperty(10);
        if (d2 == null) {
            return 0L;
        }
        return Util.dateToFileTime(d2);
    }

    public void setEditTime(long time) {
        Date d2 = Util.filetimeToDate(time);
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(10, 64L, d2);
    }

    public void removeEditTime() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(10L);
    }

    public Date getLastPrinted() {
        return (Date)this.getProperty(11);
    }

    public void setLastPrinted(Date lastPrinted) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(11, 64L, lastPrinted);
    }

    public void removeLastPrinted() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(11L);
    }

    public Date getCreateDateTime() {
        return (Date)this.getProperty(12);
    }

    public void setCreateDateTime(Date createDateTime) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(12, 64L, createDateTime);
    }

    public void removeCreateDateTime() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(12L);
    }

    public Date getLastSaveDateTime() {
        return (Date)this.getProperty(13);
    }

    public void setLastSaveDateTime(Date time) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(13, 64L, time);
    }

    public void removeLastSaveDateTime() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(13L);
    }

    public int getPageCount() {
        return this.getPropertyIntValue(14);
    }

    public void setPageCount(int pageCount) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(14, pageCount);
    }

    public void removePageCount() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(14L);
    }

    public int getWordCount() {
        return this.getPropertyIntValue(15);
    }

    public void setWordCount(int wordCount) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(15, wordCount);
    }

    public void removeWordCount() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(15L);
    }

    public int getCharCount() {
        return this.getPropertyIntValue(16);
    }

    public void setCharCount(int charCount) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(16, charCount);
    }

    public void removeCharCount() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(16L);
    }

    public byte[] getThumbnail() {
        return (byte[])this.getProperty(17);
    }

    public void setThumbnail(byte[] thumbnail) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(17, 30L, thumbnail);
    }

    public void removeThumbnail() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(17L);
    }

    public String getApplicationName() {
        return (String)this.getProperty(18);
    }

    public void setApplicationName(String applicationName) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(18, applicationName);
    }

    public void removeApplicationName() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(18L);
    }

    public int getSecurity() {
        return this.getPropertyIntValue(19);
    }

    public void setSecurity(int security) {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.setProperty(19, security);
    }

    public void removeSecurity() {
        MutableSection s2 = (MutableSection)this.getFirstSection();
        s2.removeProperty(19L);
    }
}

