/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.aggregates.CFRecordsAggregate;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.formula.FormulaShifter;

public final class ConditionalFormattingTable
extends RecordAggregate {
    private final List _cfHeaders;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CFHeaderRecord;

    public ConditionalFormattingTable() {
        this._cfHeaders = new ArrayList();
    }

    public ConditionalFormattingTable(RecordStream rs) {
        ArrayList<CFRecordsAggregate> temp = new ArrayList<CFRecordsAggregate>();
        while (rs.peekNextClass() == (class$org$apache$poi$hssf$record$CFHeaderRecord == null ? ConditionalFormattingTable.class$("org.apache.poi.hssf.record.CFHeaderRecord") : class$org$apache$poi$hssf$record$CFHeaderRecord)) {
            temp.add(CFRecordsAggregate.createCFAggregate(rs));
        }
        this._cfHeaders = temp;
    }

    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        for (int i2 = 0; i2 < this._cfHeaders.size(); ++i2) {
            CFRecordsAggregate subAgg = (CFRecordsAggregate)this._cfHeaders.get(i2);
            subAgg.visitContainedRecords(rv);
        }
    }

    public int add(CFRecordsAggregate cfAggregate) {
        this._cfHeaders.add(cfAggregate);
        return this._cfHeaders.size() - 1;
    }

    public int size() {
        return this._cfHeaders.size();
    }

    public CFRecordsAggregate get(int index) {
        this.checkIndex(index);
        return (CFRecordsAggregate)this._cfHeaders.get(index);
    }

    public void remove(int index) {
        this.checkIndex(index);
        this._cfHeaders.remove(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this._cfHeaders.size()) {
            throw new IllegalArgumentException("Specified CF index " + index + " is outside the allowable range (0.." + (this._cfHeaders.size() - 1) + ")");
        }
    }

    public void updateFormulasAfterCellShift(FormulaShifter shifter, int externSheetIndex) {
        for (int i2 = 0; i2 < this._cfHeaders.size(); ++i2) {
            CFRecordsAggregate subAgg = (CFRecordsAggregate)this._cfHeaders.get(i2);
            boolean shouldKeep = subAgg.updateFormulasAfterCellShift(shifter, externSheetIndex);
            if (shouldKeep) continue;
            this._cfHeaders.remove(i2);
            --i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

