/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;
import org.apache.poi.hssf.record.aggregates.SharedValueManager;
import org.apache.poi.hssf.record.formula.FormulaShifter;
import org.apache.poi.hssf.record.formula.Ptg;

public final class ValueRecordsAggregate {
    private int firstcell = -1;
    private int lastcell = -1;
    private CellValueRecordInterface[][] records = new CellValueRecordInterface[30][];
    static /* synthetic */ Class class$org$apache$poi$hssf$record$StringRecord;

    public void insertCell(CellValueRecordInterface cell) {
        CellValueRecordInterface[] rowCells;
        int newSize;
        short column = cell.getColumn();
        int row = cell.getRow();
        if (row >= this.records.length) {
            CellValueRecordInterface[][] oldRecords = this.records;
            newSize = oldRecords.length * 2;
            if (newSize < row + 1) {
                newSize = row + 1;
            }
            this.records = new CellValueRecordInterface[newSize][];
            System.arraycopy(oldRecords, 0, this.records, 0, oldRecords.length);
        }
        if ((rowCells = this.records[row]) == null) {
            newSize = column + 1;
            if (newSize < 10) {
                newSize = 10;
            }
            rowCells = new CellValueRecordInterface[newSize];
            this.records[row] = rowCells;
        }
        if (column >= rowCells.length) {
            CellValueRecordInterface[] oldRowCells = rowCells;
            int newSize2 = oldRowCells.length * 2;
            if (newSize2 < column + 1) {
                newSize2 = column + 1;
            }
            rowCells = new CellValueRecordInterface[newSize2];
            System.arraycopy(oldRowCells, 0, rowCells, 0, oldRowCells.length);
            this.records[row] = rowCells;
        }
        rowCells[column] = cell;
        if (column < this.firstcell || this.firstcell == -1) {
            this.firstcell = column;
        }
        if (column > this.lastcell || this.lastcell == -1) {
            this.lastcell = column;
        }
    }

    public void removeCell(CellValueRecordInterface cell) {
        if (cell == null) {
            throw new IllegalArgumentException("cell must not be null");
        }
        int row = cell.getRow();
        if (row >= this.records.length) {
            throw new RuntimeException("cell row is out of range");
        }
        CellValueRecordInterface[] rowCells = this.records[row];
        if (rowCells == null) {
            throw new RuntimeException("cell row is already empty");
        }
        short column = cell.getColumn();
        if (column >= rowCells.length) {
            throw new RuntimeException("cell column is out of range");
        }
        rowCells[column] = null;
    }

    public void removeAllCellsValuesForRow(int rowIndex) {
        if (rowIndex >= this.records.length) {
            throw new IllegalArgumentException("Specified rowIndex " + rowIndex + " is outside the allowable range (0.." + this.records.length + ")");
        }
        this.records[rowIndex] = null;
    }

    public int getPhysicalNumberOfCells() {
        int count = 0;
        for (int r = 0; r < this.records.length; ++r) {
            CellValueRecordInterface[] rowCells = this.records[r];
            if (rowCells == null) continue;
            for (int c2 = 0; c2 < rowCells.length; c2 = (int)((short)(c2 + 1))) {
                if (rowCells[c2] == null) continue;
                ++count;
            }
        }
        return count;
    }

    public int getFirstCellNum() {
        return this.firstcell;
    }

    public int getLastCellNum() {
        return this.lastcell;
    }

    public void construct(CellValueRecordInterface rec, RecordStream rs, SharedValueManager sfh) {
        if (rec instanceof FormulaRecord) {
            FormulaRecord formulaRec = (FormulaRecord)rec;
            if (formulaRec.isSharedFormula()) {
                sfh.convertSharedFormulaRecord(formulaRec);
            }
            Class nextClass = rs.peekNextClass();
            StringRecord cachedText = nextClass == (class$org$apache$poi$hssf$record$StringRecord == null ? (class$org$apache$poi$hssf$record$StringRecord = ValueRecordsAggregate.class$("org.apache.poi.hssf.record.StringRecord")) : class$org$apache$poi$hssf$record$StringRecord) ? (StringRecord)rs.getNext() : null;
            this.insertCell(new FormulaRecordAggregate(formulaRec, cachedText, sfh));
        } else {
            this.insertCell(rec);
        }
    }

    public int getRowCellBlockSize(int startRow, int endRow) {
        CellValueRecordInterface cell;
        int row;
        MyIterator itr = new MyIterator(startRow, endRow);
        int size = 0;
        while (itr.hasNext() && (row = (cell = (CellValueRecordInterface)itr.next()).getRow()) <= endRow) {
            if (row < startRow || row > endRow) continue;
            size += ((RecordBase)((Object)cell)).getRecordSize();
        }
        return size;
    }

    public boolean rowHasCells(int row) {
        if (row > this.records.length - 1) {
            return false;
        }
        CellValueRecordInterface[] rowCells = this.records[row];
        if (rowCells == null) {
            return false;
        }
        for (int col2 = 0; col2 < rowCells.length; ++col2) {
            if (rowCells[col2] == null) continue;
            return true;
        }
        return false;
    }

    public int serializeCellRow(int row, int offset, byte[] data) {
        CellValueRecordInterface cell;
        MyIterator itr = new MyIterator(row, row);
        int pos = offset;
        while (itr.hasNext() && (cell = (CellValueRecordInterface)itr.next()).getRow() == row) {
            pos += ((RecordBase)((Object)cell)).serialize(pos, data);
        }
        return pos - offset;
    }

    public void visitCellsForRow(int rowIndex, RecordAggregate.RecordVisitor rv) {
        CellValueRecordInterface[] cellRecs = this.records[rowIndex];
        if (cellRecs != null) {
            for (int i2 = 0; i2 < cellRecs.length; ++i2) {
                CellValueRecordInterface cvr = cellRecs[i2];
                if (cvr == null) continue;
                if (cvr instanceof RecordAggregate) {
                    RecordAggregate agg = (RecordAggregate)((Object)cvr);
                    agg.visitContainedRecords(rv);
                    continue;
                }
                Record rec = (Record)((Object)cvr);
                rv.visitRecord(rec);
            }
        }
    }

    public void updateFormulasAfterRowShift(FormulaShifter shifter, int currentExternSheetIndex) {
        for (int i2 = 0; i2 < this.records.length; ++i2) {
            CellValueRecordInterface[] rowCells = this.records[i2];
            if (rowCells == null) continue;
            for (int j = 0; j < rowCells.length; ++j) {
                FormulaRecord fr;
                Ptg[] ptgs;
                CellValueRecordInterface cell = rowCells[j];
                if (!(cell instanceof FormulaRecordAggregate) || !shifter.adjustFormula(ptgs = (fr = ((FormulaRecordAggregate)cell).getFormulaRecord()).getParsedExpression(), currentExternSheetIndex)) continue;
                fr.setParsedExpression(ptgs);
            }
        }
    }

    public CellValueRecordInterface[] getValueRecords() {
        ArrayList<CellValueRecordInterface> temp = new ArrayList<CellValueRecordInterface>();
        for (int i2 = 0; i2 < this.records.length; ++i2) {
            CellValueRecordInterface[] rowCells = this.records[i2];
            if (rowCells == null) continue;
            for (int j = 0; j < rowCells.length; ++j) {
                CellValueRecordInterface cell = rowCells[j];
                if (cell == null) continue;
                temp.add(cell);
            }
        }
        CellValueRecordInterface[] result = new CellValueRecordInterface[temp.size()];
        temp.toArray(result);
        return result;
    }

    public Iterator getIterator() {
        return new MyIterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class MyIterator
    implements Iterator {
        short nextColumn = (short)-1;
        int nextRow;
        int lastRow;

        public MyIterator() {
            this.nextRow = 0;
            this.lastRow = ValueRecordsAggregate.this.records.length - 1;
            this.findNext();
        }

        public MyIterator(int firstRow, int lastRow) {
            this.nextRow = firstRow;
            this.lastRow = lastRow;
            this.findNext();
        }

        public boolean hasNext() {
            return this.nextRow <= this.lastRow;
        }

        public Object next() {
            CellValueRecordInterface o = ValueRecordsAggregate.this.records[this.nextRow][this.nextColumn];
            this.findNext();
            return o;
        }

        public void remove() {
            throw new UnsupportedOperationException("gibt's noch nicht");
        }

        private void findNext() {
            this.nextColumn = (short)(this.nextColumn + 1);
            while (this.nextRow <= this.lastRow) {
                CellValueRecordInterface[] rowCells;
                CellValueRecordInterface[] cellValueRecordInterfaceArray = rowCells = this.nextRow < ValueRecordsAggregate.this.records.length ? ValueRecordsAggregate.this.records[this.nextRow] : null;
                if (rowCells == null) {
                    this.nextColumn = 0;
                } else {
                    while (this.nextColumn < rowCells.length) {
                        if (rowCells[this.nextColumn] != null) {
                            return;
                        }
                        this.nextColumn = (short)(this.nextColumn + 1);
                    }
                    this.nextColumn = 0;
                }
                ++this.nextRow;
            }
        }
    }
}

