/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.EvaluationException;
import org.apache.poi.hssf.record.formula.eval.NumberEval;
import org.apache.poi.hssf.record.formula.eval.OperandResolver;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Function;
import org.apache.poi.hssf.record.formula.functions.MathX;

public abstract class NumericFunction
implements Function {
    static final double ZERO = 0.0;
    static final double TEN = 10.0;
    static final double LOG_10_TO_BASE_e = Math.log(10.0);
    public static final Function ABS = new OneArg(){

        protected double evaluate(double d2) {
            return Math.abs(d2);
        }
    };
    public static final Function ACOS = new OneArg(){

        protected double evaluate(double d2) {
            return Math.acos(d2);
        }
    };
    public static final Function ACOSH = new OneArg(){

        protected double evaluate(double d2) {
            return MathX.acosh(d2);
        }
    };
    public static final Function ASIN = new OneArg(){

        protected double evaluate(double d2) {
            return Math.asin(d2);
        }
    };
    public static final Function ASINH = new OneArg(){

        protected double evaluate(double d2) {
            return MathX.asinh(d2);
        }
    };
    public static final Function ATAN = new OneArg(){

        protected double evaluate(double d2) {
            return Math.atan(d2);
        }
    };
    public static final Function ATANH = new OneArg(){

        protected double evaluate(double d2) {
            return MathX.atanh(d2);
        }
    };
    public static final Function COS = new OneArg(){

        protected double evaluate(double d2) {
            return Math.cos(d2);
        }
    };
    public static final Function COSH = new OneArg(){

        protected double evaluate(double d2) {
            return MathX.cosh(d2);
        }
    };
    public static final Function DEGREES = new OneArg(){

        protected double evaluate(double d2) {
            return Math.toDegrees(d2);
        }
    };
    public static final Function DOLLAR = new OneArg(){

        protected double evaluate(double d2) {
            return d2;
        }
    };
    public static final Function EXP = new OneArg(){

        protected double evaluate(double d2) {
            return Math.pow(Math.E, d2);
        }
    };
    public static final Function FACT = new OneArg(){

        protected double evaluate(double d2) {
            return MathX.factorial((int)d2);
        }
    };
    public static final Function INT = new OneArg(){

        protected double evaluate(double d2) {
            return Math.round(d2 - 0.5);
        }
    };
    public static final Function LN = new OneArg(){

        protected double evaluate(double d2) {
            return Math.log(d2);
        }
    };
    public static final Function LOG10 = new OneArg(){

        protected double evaluate(double d2) {
            return Math.log(d2) / LOG_10_TO_BASE_e;
        }
    };
    public static final Function RADIANS = new OneArg(){

        protected double evaluate(double d2) {
            return Math.toRadians(d2);
        }
    };
    public static final Function SIGN = new OneArg(){

        protected double evaluate(double d2) {
            return MathX.sign(d2);
        }
    };
    public static final Function SIN = new OneArg(){

        protected double evaluate(double d2) {
            return Math.sin(d2);
        }
    };
    public static final Function SINH = new OneArg(){

        protected double evaluate(double d2) {
            return MathX.sinh(d2);
        }
    };
    public static final Function SQRT = new OneArg(){

        protected double evaluate(double d2) {
            return Math.sqrt(d2);
        }
    };
    public static final Function TAN = new OneArg(){

        protected double evaluate(double d2) {
            return Math.tan(d2);
        }
    };
    public static final Function TANH = new OneArg(){

        protected double evaluate(double d2) {
            return MathX.tanh(d2);
        }
    };
    public static final Function ATAN2 = new TwoArg(){

        protected double evaluate(double d0, double d1) throws EvaluationException {
            if (d0 == 0.0 && d1 == 0.0) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return Math.atan2(d1, d0);
        }
    };
    public static final Function CEILING = new TwoArg(){

        protected double evaluate(double d0, double d1) {
            return MathX.ceiling(d0, d1);
        }
    };
    public static final Function COMBIN = new TwoArg(){

        protected double evaluate(double d0, double d1) throws EvaluationException {
            if (d0 > 2.147483647E9 || d1 > 2.147483647E9) {
                throw new EvaluationException(ErrorEval.NUM_ERROR);
            }
            return MathX.nChooseK((int)d0, (int)d1);
        }
    };
    public static final Function FLOOR = new TwoArg(){

        protected double evaluate(double d0, double d1) throws EvaluationException {
            if (d1 == 0.0) {
                if (d0 == 0.0) {
                    return 0.0;
                }
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return MathX.floor(d0, d1);
        }
    };
    public static final Function MOD = new TwoArg(){

        protected double evaluate(double d0, double d1) throws EvaluationException {
            if (d1 == 0.0) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return MathX.mod(d0, d1);
        }
    };
    public static final Function POWER = new TwoArg(){

        protected double evaluate(double d0, double d1) {
            return Math.pow(d0, d1);
        }
    };
    public static final Function ROUND = new TwoArg(){

        protected double evaluate(double d0, double d1) {
            return MathX.round(d0, (int)d1);
        }
    };
    public static final Function ROUNDDOWN = new TwoArg(){

        protected double evaluate(double d0, double d1) {
            return MathX.roundDown(d0, (int)d1);
        }
    };
    public static final Function ROUNDUP = new TwoArg(){

        protected double evaluate(double d0, double d1) {
            return MathX.roundUp(d0, (int)d1);
        }
    };
    public static final Function LOG = new MultiArg(1, 2){

        protected double evaluate(double[] ds) {
            double logE = Math.log(ds[0]);
            if (ds.length == 1) {
                return logE / LOG_10_TO_BASE_e;
            }
            double base2 = ds[1];
            if (base2 == Math.E) {
                return logE;
            }
            return logE / Math.log(base2);
        }
    };

    protected static final double singleOperandEvaluate(Eval arg, int srcCellRow, short srcCellCol) throws EvaluationException {
        ValueEval ve = OperandResolver.getSingleValue(arg, srcCellRow, srcCellCol);
        double result = OperandResolver.coerceValueToDouble(ve);
        NumericFunction.checkValue(result);
        return result;
    }

    private static final void checkValue(double result) throws EvaluationException {
        if (Double.isNaN(result) || Double.isInfinite(result)) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
    }

    public final Eval evaluate(Eval[] args, int srcCellRow, short srcCellCol) {
        double result;
        try {
            result = this.eval(args, srcCellRow, srcCellCol);
            NumericFunction.checkValue(result);
        }
        catch (EvaluationException e2) {
            return e2.getErrorEval();
        }
        return new NumberEval(result);
    }

    protected abstract double eval(Eval[] var1, int var2, short var3) throws EvaluationException;

    public static abstract class MultiArg
    extends NumericFunction {
        private final int _minArgs;
        private final int _maxArgs;

        protected MultiArg(int minArgs, int maxArgs) {
            this._minArgs = minArgs;
            this._maxArgs = maxArgs;
        }

        protected final double eval(Eval[] args, int srcCellRow, short srcCellCol) throws EvaluationException {
            int nArgs = args.length;
            if (nArgs < this._minArgs || nArgs > this._maxArgs) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            double[] ds = new double[nArgs];
            for (int i2 = 0; i2 < nArgs; ++i2) {
                ds[i2] = MultiArg.singleOperandEvaluate(args[i2], srcCellRow, srcCellCol);
            }
            return this.evaluate(ds);
        }

        protected abstract double evaluate(double[] var1) throws EvaluationException;
    }

    public static abstract class TwoArg
    extends NumericFunction {
        protected TwoArg() {
        }

        protected final double eval(Eval[] args, int srcCellRow, short srcCellCol) throws EvaluationException {
            if (args.length != 2) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            double d0 = TwoArg.singleOperandEvaluate(args[0], srcCellRow, srcCellCol);
            double d1 = TwoArg.singleOperandEvaluate(args[1], srcCellRow, srcCellCol);
            return this.evaluate(d0, d1);
        }

        protected abstract double evaluate(double var1, double var3) throws EvaluationException;
    }

    public static abstract class OneArg
    extends NumericFunction {
        protected OneArg() {
        }

        protected final double eval(Eval[] args, int srcCellRow, short srcCellCol) throws EvaluationException {
            if (args.length != 1) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            double d2 = OneArg.singleOperandEvaluate(args[0], srcCellRow, srcCellCol);
            return this.evaluate(d2);
        }

        protected abstract double evaluate(double var1) throws EvaluationException;
    }
}

