/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.RangeAddress;

public final class HSSFName {
    private HSSFWorkbook _book;
    private NameRecord _definedNameRec;

    HSSFName(HSSFWorkbook book, NameRecord name) {
        this._book = book;
        this._definedNameRec = name;
    }

    public String getSheetName() {
        int indexToExternSheet = this._definedNameRec.getExternSheetNumber();
        return this._book.getWorkbook().findSheetNameFromExternSheet(indexToExternSheet);
    }

    public String getNameName() {
        return this._definedNameRec.getNameText();
    }

    public void setNameName(String nameName) {
        this._definedNameRec.setNameText(nameName);
        Workbook wb = this._book.getWorkbook();
        for (int i2 = wb.getNumNames() - 1; i2 >= 0; --i2) {
            NameRecord rec = wb.getNameRecord(i2);
            if (rec == this._definedNameRec || !rec.getNameText().equalsIgnoreCase(this.getNameName())) continue;
            throw new IllegalArgumentException("The workbook already contains this name (case-insensitive)");
        }
    }

    public String getReference() {
        if (this._definedNameRec.isFunctionName()) {
            throw new IllegalStateException("Only applicable to named ranges");
        }
        return this._definedNameRec.getAreaReference(this._book);
    }

    private void setSheetName(String sheetName) {
        int sheetNumber = this._book.getSheetIndex(sheetName);
        short externSheetNumber = this._book.getWorkbook().checkExternSheet(sheetNumber);
        this._definedNameRec.setExternSheetNumber(externSheetNumber);
    }

    public void setReference(String ref) {
        RangeAddress ra = new RangeAddress(ref);
        String sheetName = ra.getSheetName();
        if (ra.hasSheetName()) {
            this.setSheetName(sheetName);
        }
        this._definedNameRec.setAreaReference(ref);
    }

    public boolean isDeleted() {
        String formulaText = this.getReference();
        if (formulaText.startsWith("#REF!")) {
            return true;
        }
        return formulaText.endsWith("#REF!");
    }

    public boolean isFunctionName() {
        return this._definedNameRec.isFunctionName();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this._definedNameRec.getNameText());
        sb.append("]");
        return sb.toString();
    }
}

