/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.lang.support;

import java.util.HashMap;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;
import org.apache.taglibs.standard.lang.jstl.Coercions;
import org.apache.taglibs.standard.lang.jstl.ELException;
import org.apache.taglibs.standard.lang.jstl.Logger;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluator;

public class ExpressionEvaluatorManager {
    public static final String EVALUATOR_CLASS = "org.apache.taglibs.standard.lang.jstl.Evaluator";
    private static HashMap nameMap = new HashMap();
    private static Logger logger = new Logger(System.out);

    public static Object evaluate(String attributeName, String expression, Class expectedType, Tag tag, PageContext pageContext) throws JspException {
        ExpressionEvaluator target = ExpressionEvaluatorManager.getEvaluatorByName(EVALUATOR_CLASS);
        return target.evaluate(attributeName, expression, expectedType, tag, pageContext);
    }

    public static Object evaluate(String attributeName, String expression, Class expectedType, PageContext pageContext) throws JspException {
        ExpressionEvaluator target = ExpressionEvaluatorManager.getEvaluatorByName(EVALUATOR_CLASS);
        return target.evaluate(attributeName, expression, expectedType, null, pageContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExpressionEvaluator getEvaluatorByName(String name) throws JspException {
        Object oEvaluator = nameMap.get(name);
        if (oEvaluator != null) {
            return (ExpressionEvaluator)oEvaluator;
        }
        try {
            HashMap hashMap = nameMap;
            synchronized (hashMap) {
                oEvaluator = nameMap.get(name);
                if (oEvaluator != null) {
                    return (ExpressionEvaluator)oEvaluator;
                }
                ExpressionEvaluator e2 = (ExpressionEvaluator)Class.forName(name).newInstance();
                nameMap.put(name, e2);
                return e2;
            }
        }
        catch (ClassCastException ex) {
            throw new JspException("invalid ExpressionEvaluator: " + ex.toString(), (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new JspException("couldn't find ExpressionEvaluator: " + ex.toString(), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new JspException("couldn't access ExpressionEvaluator: " + ex.toString(), (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new JspException("couldn't instantiate ExpressionEvaluator: " + ex.toString(), (Throwable)ex);
        }
    }

    public static Object coerce(Object value, Class classe) throws JspException {
        try {
            return Coercions.coerce(value, classe, logger);
        }
        catch (ELException ex) {
            throw new JspException((Throwable)ex);
        }
    }
}

