/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyInterceptable;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.lang.Range;
import groovy.lang.Script;
import groovy.lang.SpreadMap;
import groovy.lang.SpreadMapEvaluatingException;
import groovy.lang.Tuple;
import groovy.lang.Writable;
import groovy.xml.dom.DOMUtil;
import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.Invoker;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.NullObject;
import org.codehaus.groovy.runtime.RegexSupport;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.IntegerCache;
import org.codehaus.groovy.runtime.wrappers.PojoWrapper;
import org.w3c.dom.Element;

public class InvokerHelper {
    private static final Object[] EMPTY_MAIN_ARGS = new Object[]{new String[0]};
    public static final Object[] EMPTY_ARGS = new Object[0];
    protected static final Object[] EMPTY_ARGUMENTS = EMPTY_ARGS;
    protected static final Class[] EMPTY_TYPES = new Class[0];
    static final MetaClassRegistry metaRegistry = GroovySystem.getMetaClassRegistry();
    private static final Invoker SINGLETON = new Invoker();

    public static Invoker getInstance() {
        return SINGLETON;
    }

    public static Object invokeNoArgumentsMethod(Object object2, String methodName) {
        return InvokerHelper.getInstance().invokeMethod(object2, methodName, EMPTY_ARGS);
    }

    public static void removeClass(Class clazz) {
        metaRegistry.removeMetaClass(clazz);
        Introspector.flushFromCaches(clazz);
    }

    public static Object invokeMethodSafe(Object object2, String methodName, Object arguments) {
        if (object2 != null) {
            return InvokerHelper.invokeMethod(object2, methodName, arguments);
        }
        return null;
    }

    public static Object invokeStaticMethod(String klass, String methodName, Object arguments) throws ClassNotFoundException {
        Class<?> type = Class.forName(klass);
        return InvokerHelper.invokeStaticMethod(type, methodName, arguments);
    }

    public static Object invokeStaticNoArgumentsMethod(Class type, String methodName) {
        return InvokerHelper.invokeStaticMethod(type, methodName, (Object)EMPTY_ARGS);
    }

    public static Object invokeConstructorOf(String klass, Object arguments) throws ClassNotFoundException {
        Class<?> type = Class.forName(klass);
        return InvokerHelper.invokeConstructorOf(type, arguments);
    }

    public static Object invokeNoArgumentsConstructorOf(Class type) {
        return InvokerHelper.invokeConstructorOf(type, (Object)EMPTY_ARGS);
    }

    public static Object invokeClosure(Object closure, Object arguments) {
        return InvokerHelper.invokeMethod(closure, "doCall", arguments);
    }

    public static List asList(Object value) {
        if (value == null) {
            return Collections.EMPTY_LIST;
        }
        if (value instanceof List) {
            return (List)value;
        }
        if (value.getClass().isArray()) {
            return Arrays.asList((Object[])value);
        }
        if (value instanceof Enumeration) {
            ArrayList answer = new ArrayList();
            Enumeration e2 = (Enumeration)value;
            while (e2.hasMoreElements()) {
                answer.add(e2.nextElement());
            }
            return answer;
        }
        return Collections.singletonList(value);
    }

    public static String toString(Object arguments) {
        if (arguments instanceof Object[]) {
            return InvokerHelper.toArrayString((Object[])arguments);
        }
        if (arguments instanceof Collection) {
            return InvokerHelper.toListString((Collection)arguments);
        }
        if (arguments instanceof Map) {
            return InvokerHelper.toMapString((Map)arguments);
        }
        return InvokerHelper.format(arguments, false);
    }

    public static String inspect(Object self) {
        return InvokerHelper.format(self, true);
    }

    public static Object getAttribute(Object object2, String attribute) {
        if (object2 instanceof Class) {
            return metaRegistry.getMetaClass((Class)object2).getAttribute(object2, attribute);
        }
        if (object2 instanceof GroovyObject) {
            return ((GroovyObject)object2).getMetaClass().getAttribute(object2, attribute);
        }
        return metaRegistry.getMetaClass(object2.getClass()).getAttribute(object2, attribute);
    }

    public static void setAttribute(Object object2, String attribute, Object newValue) {
        if (object2 instanceof Class) {
            metaRegistry.getMetaClass((Class)object2).setAttribute(object2, attribute, newValue);
        } else if (object2 instanceof GroovyObject) {
            ((GroovyObject)object2).getMetaClass().setAttribute(object2, attribute, newValue);
        } else {
            metaRegistry.getMetaClass(object2.getClass()).setAttribute(object2, attribute, newValue);
        }
    }

    public static Object getProperty(Object object2, String property) {
        if (object2 instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object2;
            return pogo.getProperty(property);
        }
        if (object2 instanceof Class) {
            Class c2 = (Class)object2;
            return metaRegistry.getMetaClass(c2).getProperty(object2, property);
        }
        return metaRegistry.getMetaClass(object2.getClass()).getProperty(object2, property);
    }

    public static Object getPropertySafe(Object object2, String property) {
        if (object2 != null) {
            return InvokerHelper.getProperty(object2, property);
        }
        return null;
    }

    public static void setProperty(Object object2, String property, Object newValue) {
        if (object2 instanceof GroovyObject) {
            GroovyObject pogo = (GroovyObject)object2;
            pogo.setProperty(property, newValue);
        } else if (object2 instanceof Class) {
            metaRegistry.getMetaClass((Class)object2).setProperty((Class)object2, property, newValue);
        } else {
            metaRegistry.getMetaClass(object2.getClass()).setProperty(object2, property, newValue);
        }
    }

    public static void setProperty2(Object newValue, Object object2, String property) {
        InvokerHelper.setProperty(object2, property, newValue);
    }

    public static void setGroovyObjectProperty(Object newValue, GroovyObject object2, String property) {
        object2.setProperty(property, newValue);
    }

    public static Object getGroovyObjectProperty(GroovyObject object2, String property) {
        return object2.getProperty(property);
    }

    public static void setPropertySafe2(Object newValue, Object object2, String property) {
        if (object2 != null) {
            InvokerHelper.setProperty2(newValue, object2, property);
        }
    }

    public static Closure getMethodPointer(Object object2, String methodName) {
        if (object2 == null) {
            throw new NullPointerException("Cannot access method pointer for '" + methodName + "' on null object");
        }
        return new MethodClosure(object2, methodName);
    }

    public static Object unaryMinus(Object value) {
        if (value instanceof Integer) {
            Integer number = (Integer)value;
            return IntegerCache.integerValue(-number.intValue());
        }
        if (value instanceof Long) {
            Long number = (Long)value;
            return new Long(-number.longValue());
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).negate();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).negate();
        }
        if (value instanceof Double) {
            Double number = (Double)value;
            return new Double(-number.doubleValue());
        }
        if (value instanceof Float) {
            Float number = (Float)value;
            return new Float(-number.floatValue());
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            Iterator it = ((ArrayList)value).iterator();
            while (it.hasNext()) {
                newlist.add(InvokerHelper.unaryMinus(it.next()));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value, "negative", EMPTY_ARGS);
    }

    public static Object unaryPlus(Object value) {
        if (value instanceof Integer || value instanceof Long || value instanceof BigInteger || value instanceof BigDecimal || value instanceof Double || value instanceof Float) {
            return value;
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            Iterator it = ((ArrayList)value).iterator();
            while (it.hasNext()) {
                newlist.add(InvokerHelper.unaryPlus(it.next()));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value, "positive", EMPTY_ARGS);
    }

    public static Matcher findRegex(Object left, Object right) {
        String regexToCompareTo;
        String stringToCompare = left instanceof String ? (String)left : InvokerHelper.toString(left);
        if (right instanceof String) {
            regexToCompareTo = (String)right;
        } else {
            if (right instanceof Pattern) {
                Pattern pattern = (Pattern)right;
                return pattern.matcher(stringToCompare);
            }
            regexToCompareTo = InvokerHelper.toString(right);
        }
        Matcher matcher = Pattern.compile(regexToCompareTo).matcher(stringToCompare);
        return matcher;
    }

    public static boolean matchRegex(Object left, Object right) {
        Pattern pattern = right instanceof Pattern ? (Pattern)right : Pattern.compile(InvokerHelper.toString(right));
        String stringToCompare = InvokerHelper.toString(left);
        Matcher matcher = pattern.matcher(stringToCompare);
        RegexSupport.setLastMatcher(matcher);
        return matcher.matches();
    }

    public static Tuple createTuple(Object[] array) {
        return new Tuple(array);
    }

    public static SpreadMap spreadMap(Object value) {
        if (value instanceof Map) {
            Object[] values = new Object[((Map)value).keySet().size() * 2];
            int index = 0;
            Iterator it = ((Map)value).keySet().iterator();
            while (it.hasNext()) {
                Object key = it.next();
                values[index++] = key;
                values[index++] = ((Map)value).get(key);
            }
            return new SpreadMap(values);
        }
        throw new SpreadMapEvaluatingException("Cannot spread the map " + value.getClass().getName() + ", value " + value);
    }

    public static List createList(Object[] values) {
        ArrayList<Object> answer = new ArrayList<Object>(values.length);
        answer.addAll(Arrays.asList(values));
        return answer;
    }

    public static Map createMap(Object[] values) {
        LinkedHashMap<Object, Object> answer = new LinkedHashMap<Object, Object>(values.length / 2);
        int i2 = 0;
        while (i2 < values.length - 1) {
            if (values[i2] instanceof SpreadMap && values[i2 + 1] instanceof Map) {
                Map smap = (Map)values[i2 + 1];
                Iterator iter = smap.keySet().iterator();
                while (iter.hasNext()) {
                    Object key = iter.next();
                    answer.put(key, smap.get(key));
                }
                i2 += 2;
                continue;
            }
            answer.put(values[i2++], values[i2++]);
        }
        return answer;
    }

    public static void assertFailed(Object expression, Object message) {
        if (message == null || "".equals(message)) {
            throw new AssertionError((Object)("Expression: " + expression));
        }
        throw new AssertionError((Object)(String.valueOf(message) + ". Expression: " + expression));
    }

    public static Object runScript(Class scriptClass, String[] args) {
        Binding context = new Binding(args);
        Script script2 = InvokerHelper.createScript(scriptClass, context);
        return InvokerHelper.invokeMethod(script2, "run", EMPTY_ARGS);
    }

    public static Script createScript(Class scriptClass, Binding context) {
        Script script2 = null;
        if (scriptClass == null) {
            script2 = new Script(){

                public Object run() {
                    return null;
                }
            };
        } else {
            try {
                final GroovyObject object2 = (GroovyObject)scriptClass.newInstance();
                if (object2 instanceof Script) {
                    script2 = (Script)object2;
                } else {
                    script2 = new Script(){

                        public Object run() {
                            object2.invokeMethod("main", EMPTY_MAIN_ARGS);
                            return null;
                        }
                    };
                    InvokerHelper.setProperties(object2, context.getVariables());
                }
            }
            catch (Exception e2) {
                throw new GroovyRuntimeException("Failed to create Script instance for class: " + scriptClass + ". Reason: " + e2, e2);
            }
        }
        script2.setBinding(context);
        return script2;
    }

    public static void setProperties(Object object2, Map map2) {
        MetaClass mc = InvokerHelper.getMetaClass(object2);
        Iterator iter = map2.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            try {
                mc.setProperty(object2, key, value);
            }
            catch (MissingPropertyException mpe) {}
        }
    }

    public static String getVersion() {
        String version = null;
        Package p2 = Package.getPackage("groovy.lang");
        if (p2 != null) {
            version = p2.getImplementationVersion();
        }
        if (version == null) {
            version = "";
        }
        return version;
    }

    public static void write(Writer out, Object object2) throws IOException {
        if (object2 instanceof String) {
            out.write((String)object2);
        } else if (object2 instanceof Object[]) {
            out.write(InvokerHelper.toArrayString((Object[])object2));
        } else if (object2 instanceof Map) {
            out.write(InvokerHelper.toMapString((Map)object2));
        } else if (object2 instanceof Collection) {
            out.write(InvokerHelper.toListString((Collection)object2));
        } else if (object2 instanceof Writable) {
            Writable writable = (Writable)object2;
            writable.writeTo(out);
        } else if (object2 instanceof InputStream || object2 instanceof Reader) {
            int i2;
            Reader reader = object2 instanceof InputStream ? new InputStreamReader((InputStream)object2) : (Reader)object2;
            char[] chars = new char[8192];
            while ((i2 = reader.read(chars)) != -1) {
                out.write(chars, 0, i2);
            }
            reader.close();
        } else {
            out.write(InvokerHelper.toString(object2));
        }
    }

    public static Iterator asIterator(Object o) {
        return (Iterator)InvokerHelper.invokeMethod(o, "iterator", EMPTY_ARGS);
    }

    protected static String format(Object arguments, boolean verbose) {
        if (arguments == null) {
            NullObject nullObject = NullObject.getNullObject();
            return (String)nullObject.getMetaClass().invokeMethod((Object)nullObject, "toString", EMPTY_ARGS);
        }
        if (arguments.getClass().isArray()) {
            return InvokerHelper.format(DefaultTypeTransformation.asCollection(arguments), verbose);
        }
        if (arguments instanceof Range) {
            Range range = (Range)arguments;
            if (verbose) {
                return range.inspect();
            }
            return range.toString();
        }
        if (arguments instanceof List) {
            List list = (List)arguments;
            StringBuffer buffer = new StringBuffer("[");
            boolean first = true;
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(InvokerHelper.format(iter.next(), verbose));
            }
            buffer.append("]");
            return buffer.toString();
        }
        if (arguments instanceof Map) {
            Map map2 = (Map)arguments;
            if (map2.isEmpty()) {
                return "[:]";
            }
            StringBuffer buffer = new StringBuffer("[");
            boolean first = true;
            Iterator iter = map2.entrySet().iterator();
            while (iter.hasNext()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                Map.Entry entry = iter.next();
                buffer.append(InvokerHelper.format(entry.getKey(), verbose));
                buffer.append(":");
                if (entry.getValue() == map2) {
                    buffer.append("this Map_");
                    continue;
                }
                buffer.append(InvokerHelper.format(entry.getValue(), verbose));
            }
            buffer.append("]");
            return buffer.toString();
        }
        if (arguments instanceof Element) {
            return DOMUtil.serialize((Element)arguments);
        }
        if (arguments instanceof String) {
            if (verbose) {
                String arg = ((String)arguments).replaceAll("\\n", "\\\\n");
                arg = arg.replaceAll("\\r", "\\\\r");
                arg = arg.replaceAll("\\t", "\\\\t");
                arg = arg.replaceAll("\\f", "\\\\f");
                arg = arg.replaceAll("\\\"", "\\\\\"");
                arg = arg.replaceAll("\\\\", "\\\\");
                return "\"" + arg + "\"";
            }
            return (String)arguments;
        }
        return arguments.toString();
    }

    public static String toTypeString(Object[] arguments) {
        if (arguments == null) {
            return "null";
        }
        StringBuffer argBuf = new StringBuffer();
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            if (i2 > 0) {
                argBuf.append(", ");
            }
            argBuf.append(arguments[i2] != null ? arguments[i2].getClass().getName() : "null");
        }
        return argBuf.toString();
    }

    public static String toMapString(Map arg) {
        return InvokerHelper.format(arg, true);
    }

    public static String toListString(Collection arg) {
        if (arg == null) {
            return "null";
        }
        if (arg.isEmpty()) {
            return "[]";
        }
        String sbdry = "[";
        String ebdry = "]";
        StringBuffer buffer = new StringBuffer(sbdry);
        boolean first = true;
        Iterator iter = arg.iterator();
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            Object elem = iter.next();
            buffer.append(InvokerHelper.format(elem, true));
        }
        buffer.append(ebdry);
        return buffer.toString();
    }

    public static String toArrayString(Object[] arguments) {
        if (arguments == null) {
            return "null";
        }
        String sbdry = "{";
        String ebdry = "}";
        StringBuffer argBuf = new StringBuffer(sbdry);
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            if (i2 > 0) {
                argBuf.append(", ");
            }
            argBuf.append(InvokerHelper.format(arguments[i2], true));
        }
        argBuf.append(ebdry);
        return argBuf.toString();
    }

    public static List createRange(Object from, Object to, boolean inclusive) {
        try {
            return ScriptBytecodeAdapter.createRange(from, to, inclusive);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Error e2) {
            throw e2;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static Object bitwiseNegate(Object value) {
        if (value instanceof Integer) {
            Integer number = (Integer)value;
            return new Integer(~number.intValue());
        }
        if (value instanceof Long) {
            Long number = (Long)value;
            return new Long((long)(number ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).not();
        }
        if (value instanceof String) {
            return DefaultGroovyMethods.bitwiseNegate(value.toString());
        }
        if (value instanceof GString) {
            return DefaultGroovyMethods.bitwiseNegate(value.toString());
        }
        if (value instanceof ArrayList) {
            ArrayList<Object> newlist = new ArrayList<Object>();
            Iterator it = ((ArrayList)value).iterator();
            while (it.hasNext()) {
                newlist.add(InvokerHelper.bitwiseNegate(it.next()));
            }
            return newlist;
        }
        return InvokerHelper.invokeMethod(value, "bitwiseNegate", EMPTY_ARGS);
    }

    public static MetaClassRegistry getMetaRegistry() {
        return metaRegistry;
    }

    public static MetaClass getMetaClass(Object object2) {
        return metaRegistry.getMetaClass(object2.getClass());
    }

    public static MetaClass getMetaClass(Class cls) {
        return metaRegistry.getMetaClass(cls);
    }

    public static Object invokeMethod(Object object2, String methodName, Object arguments) {
        if (object2 == null) {
            object2 = NullObject.getNullObject();
        }
        if (object2 instanceof Class) {
            Class theClass = (Class)object2;
            MetaClass metaClass = metaRegistry.getMetaClass(theClass);
            return metaClass.invokeStaticMethod(object2, methodName, InvokerHelper.asArray(arguments));
        }
        if (!(object2 instanceof GroovyObject)) {
            return InvokerHelper.invokePojoMethod(object2, methodName, arguments);
        }
        return InvokerHelper.invokePogoMethod(object2, methodName, arguments);
    }

    private static Object invokePojoMethod(Object object2, String methodName, Object arguments) {
        Class<?> theClass = object2.getClass();
        MetaClass metaClass = metaRegistry.getMetaClass(theClass);
        return metaClass.invokeMethod(object2, methodName, InvokerHelper.asArray(arguments));
    }

    private static Object invokePogoMethod(Object object2, String methodName, Object arguments) {
        GroovyObject groovy = (GroovyObject)object2;
        boolean intercepting = groovy instanceof GroovyInterceptable;
        try {
            if (intercepting) {
                return groovy.invokeMethod(methodName, InvokerHelper.asUnwrappedArray(arguments));
            }
            return groovy.getMetaClass().invokeMethod(object2, methodName, InvokerHelper.asArray(arguments));
        }
        catch (MissingMethodException e2) {
            if (!intercepting && e2.getMethod().equals(methodName) && object2.getClass() == e2.getType()) {
                return groovy.invokeMethod(methodName, InvokerHelper.asUnwrappedArray(arguments));
            }
            throw e2;
        }
    }

    public static Object invokeSuperMethod(Object object2, String methodName, Object arguments) {
        if (object2 == null) {
            throw new NullPointerException("Cannot invoke method " + methodName + "() on null object");
        }
        Class<?> theClass = object2.getClass();
        MetaClass metaClass = metaRegistry.getMetaClass(theClass.getSuperclass());
        return metaClass.invokeMethod(object2, methodName, InvokerHelper.asArray(arguments));
    }

    public static Object invokeStaticMethod(Class type, String method, Object arguments) {
        MetaClass metaClass = metaRegistry.getMetaClass(type);
        return metaClass.invokeStaticMethod(type, method, InvokerHelper.asArray(arguments));
    }

    public static Object invokeConstructorOf(Class type, Object arguments) {
        MetaClass metaClass = metaRegistry.getMetaClass(type);
        return metaClass.invokeConstructor(InvokerHelper.asArray(arguments));
    }

    public static Object[] asArray(Object arguments) {
        if (arguments == null) {
            return EMPTY_ARGUMENTS;
        }
        if (arguments instanceof Object[]) {
            return (Object[])arguments;
        }
        return new Object[]{arguments};
    }

    public static Object[] asUnwrappedArray(Object arguments) {
        Object[] args = InvokerHelper.asArray(arguments);
        for (int i2 = 0; i2 < args.length; ++i2) {
            if (!(args[i2] instanceof PojoWrapper)) continue;
            args[i2] = ((PojoWrapper)args[i2]).unwrap();
        }
        return args;
    }
}

