/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime;

import groovy.lang.Closure;
import groovy.lang.GString;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaMethod;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedConstructor;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.FastArray;
import org.codehaus.groovy.reflection.ParameterTypes;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.wrappers.Wrapper;

public class MetaClassHelper {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Class[] EMPTY_TYPE_ARRAY = new Class[0];
    public static final Object[] ARRAY_WITH_NULL = new Object[]{null};
    protected static final Logger LOG = Logger.getLogger(MetaClassHelper.class.getName());
    private static final int MAX_ARG_LEN = 12;
    private static final int VARGS_SHIFT = 28;
    private static final Class[] PRIMITIVES = new Class[]{Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, BigInteger.class, Float.TYPE, Float.class, Double.TYPE, Double.class, BigDecimal.class, Number.class, Object.class};
    private static final int[][] PRIMITIVE_DISTANCE_TABLE = new int[][]{{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {14, 15, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, {14, 15, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, {14, 15, 12, 13, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {14, 15, 12, 13, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, {14, 15, 12, 13, 10, 11, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9}, {14, 15, 12, 13, 10, 11, 1, 0, 2, 3, 4, 5, 6, 7, 8, 9}, {14, 15, 12, 13, 10, 11, 8, 9, 0, 1, 2, 3, 4, 5, 6, 7}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 0, 1, 2, 3, 4, 5, 6}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 1, 0, 2, 3, 4, 5, 6}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 5, 6, 0, 1, 2, 3, 4}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 5, 6, 1, 0, 2, 3, 4}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 5, 6, 3, 4, 0, 1, 2}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 5, 6, 3, 4, 2, 0, 1}, {14, 15, 12, 13, 10, 11, 8, 9, 7, 5, 6, 3, 4, 2, 1, 0}};

    public static boolean accessibleToConstructor(Class at, Constructor constructor) {
        boolean accessible = false;
        int modifiers = constructor.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            accessible = true;
        } else if (Modifier.isPrivate(modifiers)) {
            accessible = at.getName().equals(constructor.getName());
        } else if (Modifier.isProtected(modifiers)) {
            Boolean isAccessible = MetaClassHelper.checkCompatiblePackages(at, constructor);
            if (isAccessible != null) {
                accessible = isAccessible;
            } else {
                boolean flag = false;
                for (Class clazz = at; !flag && clazz != null; clazz = clazz.getSuperclass()) {
                    if (clazz.equals(constructor.getDeclaringClass())) {
                        flag = true;
                        break;
                    }
                    if (clazz.equals(class$java$lang$Object == null ? MetaClassHelper.class$("java.lang.Object") : class$java$lang$Object)) break;
                }
                accessible = flag;
            }
        } else {
            Boolean isAccessible = MetaClassHelper.checkCompatiblePackages(at, constructor);
            if (isAccessible != null) {
                accessible = isAccessible;
            }
        }
        return accessible;
    }

    private static Boolean checkCompatiblePackages(Class at, Constructor constructor) {
        if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() == null) {
            return Boolean.TRUE;
        }
        if (at.getPackage() == null && constructor.getDeclaringClass().getPackage() != null) {
            return Boolean.FALSE;
        }
        if (at.getPackage() != null && constructor.getDeclaringClass().getPackage() == null) {
            return Boolean.FALSE;
        }
        if (at.getPackage().equals(constructor.getDeclaringClass().getPackage())) {
            return Boolean.TRUE;
        }
        return null;
    }

    public static Object[] asWrapperArray(Object parameters, Class componentType) {
        Object[] ret;
        block9: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        ret = null;
                                        if (componentType != Boolean.TYPE) break block8;
                                        boolean[] array = (boolean[])parameters;
                                        ret = new Object[array.length];
                                        for (int i2 = 0; i2 < array.length; ++i2) {
                                            ret[i2] = new Boolean(array[i2]);
                                        }
                                        break block9;
                                    }
                                    if (componentType != Character.TYPE) break block10;
                                    char[] array = (char[])parameters;
                                    ret = new Object[array.length];
                                    for (int i3 = 0; i3 < array.length; ++i3) {
                                        ret[i3] = new Character(array[i3]);
                                    }
                                    break block9;
                                }
                                if (componentType != Byte.TYPE) break block11;
                                byte[] array = (byte[])parameters;
                                ret = new Object[array.length];
                                for (int i4 = 0; i4 < array.length; ++i4) {
                                    ret[i4] = new Byte(array[i4]);
                                }
                                break block9;
                            }
                            if (componentType != Integer.TYPE) break block12;
                            int[] array = (int[])parameters;
                            ret = new Object[array.length];
                            for (int i5 = 0; i5 < array.length; ++i5) {
                                ret[i5] = new Integer(array[i5]);
                            }
                            break block9;
                        }
                        if (componentType != Short.TYPE) break block13;
                        short[] array = (short[])parameters;
                        ret = new Object[array.length];
                        for (int i6 = 0; i6 < array.length; ++i6) {
                            ret[i6] = new Short(array[i6]);
                        }
                        break block9;
                    }
                    if (componentType != Long.TYPE) break block14;
                    long[] array = (long[])parameters;
                    ret = new Object[array.length];
                    for (int i7 = 0; i7 < array.length; ++i7) {
                        ret[i7] = new Long(array[i7]);
                    }
                    break block9;
                }
                if (componentType != Double.TYPE) break block15;
                double[] array = (double[])parameters;
                ret = new Object[array.length];
                for (int i8 = 0; i8 < array.length; ++i8) {
                    ret[i8] = new Double(array[i8]);
                }
                break block9;
            }
            if (componentType != Float.TYPE) break block9;
            float[] array = (float[])parameters;
            ret = new Object[array.length];
            for (int i9 = 0; i9 < array.length; ++i9) {
                ret[i9] = new Float(array[i9]);
            }
        }
        return ret;
    }

    public static Object asPrimitiveArray(List list, Class parameterType) {
        Class<?> arrayType = parameterType.getComponentType();
        Object objArray = Array.newInstance(arrayType, list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object obj = list.get(i2);
            if (arrayType.isPrimitive()) {
                if (obj instanceof Integer) {
                    Array.setInt(objArray, i2, (Integer)obj);
                    continue;
                }
                if (obj instanceof Double) {
                    Array.setDouble(objArray, i2, (Double)obj);
                    continue;
                }
                if (obj instanceof Boolean) {
                    Array.setBoolean(objArray, i2, (Boolean)obj);
                    continue;
                }
                if (obj instanceof Long) {
                    Array.setLong(objArray, i2, (Long)obj);
                    continue;
                }
                if (obj instanceof Float) {
                    Array.setFloat(objArray, i2, ((Float)obj).floatValue());
                    continue;
                }
                if (obj instanceof Character) {
                    Array.setChar(objArray, i2, ((Character)obj).charValue());
                    continue;
                }
                if (obj instanceof Byte) {
                    Array.setByte(objArray, i2, (Byte)obj);
                    continue;
                }
                if (!(obj instanceof Short)) continue;
                Array.setShort(objArray, i2, (Short)obj);
                continue;
            }
            Array.set(objArray, i2, obj);
        }
        return objArray;
    }

    private static int getPrimitiveIndex(Class c2) {
        for (int i2 = 0; i2 < PRIMITIVES.length; i2 = (int)((byte)(i2 + 1))) {
            if (PRIMITIVES[i2] != c2) continue;
            return i2;
        }
        return -1;
    }

    private static int getPrimitiveDistance(Class from, Class to) {
        int fromIndex = MetaClassHelper.getPrimitiveIndex(from);
        int toIndex = MetaClassHelper.getPrimitiveIndex(to);
        if (fromIndex == -1 || toIndex == -1) {
            return -1;
        }
        return PRIMITIVE_DISTANCE_TABLE[toIndex][fromIndex];
    }

    private static int getMaximumInterfaceDistance(Class c2, Class interfaceClass) {
        if (c2 == null) {
            return -1;
        }
        if (c2 == interfaceClass) {
            return 0;
        }
        Class<?>[] interfaces = c2.getInterfaces();
        int max = -1;
        for (int i2 = 0; i2 < interfaces.length; ++i2) {
            int sub2 = MetaClassHelper.getMaximumInterfaceDistance(interfaces[i2], interfaceClass);
            if (sub2 != -1) {
                ++sub2;
            }
            max = Math.max(max, sub2);
        }
        int superClassMax = MetaClassHelper.getMaximumInterfaceDistance(c2.getSuperclass(), interfaceClass);
        return Math.max(max, superClassMax);
    }

    private static long calculateParameterDistance(Class argument, CachedClass parameter) {
        if (parameter.getCachedClass() == argument) {
            return 0L;
        }
        if (parameter.isInterface()) {
            return MetaClassHelper.getMaximumInterfaceDistance(argument, parameter.getCachedClass()) << 1;
        }
        long objectDistance = 0L;
        if (argument != null) {
            long pd = MetaClassHelper.getPrimitiveDistance(parameter.getCachedClass(), argument);
            if (pd != -1L) {
                return pd << 32;
            }
            objectDistance += (long)(PRIMITIVES.length + 1);
            Class clazz = ReflectionCache.autoboxType(argument);
            while (clazz != null && clazz != parameter.getCachedClass()) {
                if (clazz == (class$groovy$lang$GString == null ? MetaClassHelper.class$("groovy.lang.GString") : class$groovy$lang$GString) && parameter.getCachedClass() == (class$java$lang$String == null ? MetaClassHelper.class$("java.lang.String") : class$java$lang$String)) {
                    objectDistance += 2L;
                    break;
                }
                clazz = clazz.getSuperclass();
                objectDistance += 3L;
            }
        } else {
            --objectDistance;
            Class clazz = parameter.getCachedClass();
            if (clazz.isPrimitive()) {
                objectDistance += 2L;
            } else {
                while (clazz != (class$java$lang$Object == null ? MetaClassHelper.class$("java.lang.Object") : class$java$lang$Object)) {
                    clazz = clazz.getSuperclass();
                    objectDistance += 2L;
                }
            }
        }
        return objectDistance << 32;
    }

    public static long calculateParameterDistance(Class[] arguments, ParameterTypes pt) {
        CachedClass[] parameters = pt.getParameterTypes();
        if (parameters.length == 0) {
            return 0L;
        }
        long ret = 0L;
        int noVargsLength = parameters.length - 1;
        for (int i2 = 0; i2 < noVargsLength; ++i2) {
            ret += MetaClassHelper.calculateParameterDistance(arguments[i2], parameters[i2]);
        }
        if (arguments.length == parameters.length) {
            CachedClass baseType = parameters[noVargsLength];
            if (!parameters[noVargsLength].isAssignableFrom(arguments[noVargsLength])) {
                baseType = ReflectionCache.getCachedClass(baseType.getCachedClass().getComponentType());
                ret += 0x20000000L;
            }
            ret += MetaClassHelper.calculateParameterDistance(arguments[noVargsLength], baseType);
        } else if (arguments.length > parameters.length) {
            ret += (long)(2 + arguments.length - parameters.length << 28);
            CachedClass vargsType = ReflectionCache.getCachedClass(parameters[noVargsLength].getCachedClass().getComponentType());
            for (int i3 = noVargsLength; i3 < arguments.length; ++i3) {
                ret += MetaClassHelper.calculateParameterDistance(arguments[i3], vargsType);
            }
        } else {
            ret += 0x10000000L;
        }
        return ret;
    }

    public static String capitalize(String property) {
        return property.substring(0, 1).toUpperCase() + property.substring(1, property.length());
    }

    public static Object chooseEmptyMethodParams(FastArray methods) {
        Object vargsMethod = null;
        int len = methods.size();
        Object[] data = methods.getArray();
        for (int i2 = 0; i2 != len; ++i2) {
            Object method = data[i2];
            ParameterTypes pt = MetaClassHelper.getParameterTypes(method);
            CachedClass[] paramTypes = pt.getParameterTypes();
            int paramLength = paramTypes.length;
            if (paramLength == 0) {
                return method;
            }
            if (paramLength != 1 || !pt.isVargsMethod(EMPTY_ARRAY)) continue;
            vargsMethod = method;
        }
        return vargsMethod;
    }

    public static Object chooseMostGeneralMethodWith1NullParam(FastArray methods) {
        CachedClass closestClass = null;
        CachedClass closestVargsClass = null;
        Object answer = null;
        int closestDist = -1;
        int len = methods.size();
        for (int i2 = 0; i2 != len; ++i2) {
            int newDist;
            Object[] data = methods.getArray();
            Object method = data[i2];
            ParameterTypes pt = MetaClassHelper.getParameterTypes(method);
            CachedClass[] paramTypes = pt.getParameterTypes();
            int paramLength = paramTypes.length;
            if (paramLength == 0 || paramLength > 2) continue;
            CachedClass theType = paramTypes[0];
            if (theType.isPrimitive) continue;
            if (paramLength == 2) {
                if (!pt.isVargsMethod(ARRAY_WITH_NULL)) continue;
                if (closestClass == null) {
                    closestVargsClass = paramTypes[1];
                    closestClass = theType;
                    answer = method;
                    continue;
                }
                if (closestClass.getCachedClass() == theType.getCachedClass()) {
                    if (closestVargsClass == null) continue;
                    CachedClass newVargsClass = paramTypes[1];
                    if (closestVargsClass != null && !MetaClassHelper.isAssignableFrom(newVargsClass.getCachedClass(), closestVargsClass.getCachedClass())) continue;
                    closestVargsClass = newVargsClass;
                    answer = method;
                    continue;
                }
                if (!MetaClassHelper.isAssignableFrom(theType.getCachedClass(), closestClass.getCachedClass())) continue;
                closestVargsClass = paramTypes[1];
                closestClass = theType;
                answer = method;
                continue;
            }
            if (closestClass == null || MetaClassHelper.isAssignableFrom(theType.getCachedClass(), closestClass.getCachedClass())) {
                closestVargsClass = null;
                closestClass = theType;
                answer = method;
                closestDist = -1;
                continue;
            }
            if (closestDist == -1) {
                closestDist = closestClass.getSuperClassDistance();
            }
            if ((newDist = theType.getSuperClassDistance()) >= closestDist) continue;
            closestDist = newDist;
            closestVargsClass = null;
            closestClass = theType;
            answer = method;
        }
        return answer;
    }

    private static int calculateSimplifiedClassDistanceToObject(Class clazz) {
        int objectDistance = 0;
        while (clazz != null) {
            clazz = clazz.getSuperclass();
            ++objectDistance;
        }
        return objectDistance;
    }

    public static boolean containsMatchingMethod(List list, MetaMethod method) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            CachedClass[] params2;
            MetaMethod aMethod = (MetaMethod)iter.next();
            CachedClass[] params1 = aMethod.getParameterTypes();
            if (params1.length != (params2 = method.getParameterTypes()).length) continue;
            boolean matches = true;
            for (int i2 = 0; i2 < params1.length; ++i2) {
                if (params1[i2] == params2[i2]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    public static Class[] convertToTypeArray(Object[] args) {
        if (args == null) {
            return null;
        }
        int s2 = args.length;
        Class[] ans = new Class[s2];
        for (int i2 = 0; i2 < s2; ++i2) {
            Object o = args[i2];
            ans[i2] = o == null ? null : (o instanceof Wrapper ? ((Wrapper)o).getType() : o.getClass());
        }
        return ans;
    }

    public static Object doConstructorInvoke(CachedConstructor constructor, Object[] argumentArray) {
        Constructor constr = constructor.cachedConstructor;
        argumentArray = constructor.coerceArgumentsToClasses(argumentArray);
        try {
            return constr.newInstance(argumentArray);
        }
        catch (InvocationTargetException e2) {
            throw new InvokerInvocationException(e2);
        }
        catch (IllegalArgumentException e3) {
            throw MetaClassHelper.createExceptionText("failed to invoke constructor: ", constr, argumentArray, e3, false);
        }
        catch (IllegalAccessException e4) {
            throw MetaClassHelper.createExceptionText("could not access constructor: ", constr, argumentArray, e4, false);
        }
        catch (Exception e5) {
            throw MetaClassHelper.createExceptionText("failed to invoke constructor: ", constr, argumentArray, e5, true);
        }
    }

    private static GroovyRuntimeException createExceptionText(String init, Constructor constructor, Object[] argumentArray, Throwable e2, boolean setReason) {
        throw new GroovyRuntimeException(init + constructor + " with arguments: " + InvokerHelper.toString(argumentArray) + " reason: " + e2, setReason ? e2 : null);
    }

    public static Object doMethodInvoke(Object object2, MetaMethod method, Object[] argumentArray) {
        return method.doMethodInvoke(object2, argumentArray);
    }

    public static Object makeCommonArray(Object[] arguments, int offset, Class fallback) {
        Class<?> baseClass = null;
        for (int i2 = offset; i2 < arguments.length; ++i2) {
            if (arguments[i2] == null) continue;
            Class<?> argClass = arguments[i2].getClass();
            if (baseClass == null) {
                baseClass = argClass;
                continue;
            }
            while (baseClass != (class$java$lang$Object == null ? MetaClassHelper.class$("java.lang.Object") : class$java$lang$Object) && !baseClass.isAssignableFrom(argClass)) {
                baseClass = baseClass.getSuperclass();
            }
        }
        if (baseClass == null) {
            baseClass = fallback;
        }
        Object result = MetaClassHelper.makeArray(null, baseClass, arguments.length - offset);
        System.arraycopy(arguments, offset, result, 0, arguments.length - offset);
        return result;
    }

    public static Object makeArray(Object obj, Class secondary, int length) {
        Class<?> baseClass = secondary;
        if (obj != null) {
            baseClass = obj.getClass();
        }
        return Array.newInstance(baseClass, length);
    }

    public static GroovyRuntimeException createExceptionText(String init, MetaMethod method, Object object2, Object[] args, Throwable reason, boolean setReason) {
        return new GroovyRuntimeException(init + method + " on: " + object2 + " with arguments: " + InvokerHelper.toString(args) + " reason: " + reason, setReason ? reason : null);
    }

    protected static String getClassName(Object object2) {
        if (object2 == null) {
            return null;
        }
        return object2 instanceof Class ? ((Class)object2).getName() : object2.getClass().getName();
    }

    public static Closure getMethodPointer(Object object2, String methodName) {
        return new MethodClosure(object2, methodName);
    }

    public static ParameterTypes getParameterTypes(Object methodOrConstructor) {
        if (methodOrConstructor instanceof ParameterTypes) {
            return (ParameterTypes)methodOrConstructor;
        }
        if (methodOrConstructor instanceof Method) {
            Method method = (Method)methodOrConstructor;
            return CachedMethod.find(method);
        }
        if (methodOrConstructor instanceof Constructor) {
            Constructor constructor = (Constructor)methodOrConstructor;
            return CachedConstructor.find(constructor);
        }
        throw new IllegalArgumentException("Must be a Method or Constructor");
    }

    public static boolean isAssignableFrom(Class classToTransformTo, Class classToTransformFrom) {
        if (classToTransformTo == classToTransformFrom) {
            return true;
        }
        if (classToTransformFrom == null) {
            return true;
        }
        if (classToTransformTo == Object.class) {
            return true;
        }
        if ((classToTransformTo = ReflectionCache.autoboxType(classToTransformTo)) == (classToTransformFrom = ReflectionCache.autoboxType(classToTransformFrom))) {
            return true;
        }
        if (classToTransformTo == Integer.class ? classToTransformFrom == Integer.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == BigInteger.class : (classToTransformTo == Double.class ? classToTransformFrom == Double.class || classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == Float.class || classToTransformFrom == BigDecimal.class || classToTransformFrom == BigInteger.class : (classToTransformTo == BigDecimal.class ? classToTransformFrom == Double.class || classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == Float.class || classToTransformFrom == BigDecimal.class || classToTransformFrom == BigInteger.class : (classToTransformTo == BigInteger.class ? classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class || classToTransformFrom == BigInteger.class : (classToTransformTo == Long.class ? classToTransformFrom == Long.class || classToTransformFrom == Integer.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class : (classToTransformTo == Float.class ? classToTransformFrom == Float.class || classToTransformFrom == Integer.class || classToTransformFrom == Long.class || classToTransformFrom == Short.class || classToTransformFrom == Byte.class : (classToTransformTo == Short.class ? classToTransformFrom == Short.class || classToTransformFrom == Byte.class : classToTransformTo == String.class && (classToTransformFrom == String.class || GString.class.isAssignableFrom(classToTransformFrom))))))))) {
            return true;
        }
        return ReflectionCache.isAssignableFrom(classToTransformTo, classToTransformFrom);
    }

    public static boolean isGenericSetMethod(MetaMethod method) {
        return method.getName().equals("set") && method.getParameterTypes().length == 2;
    }

    protected static boolean isSuperclass(Class claszz, Class superclass) {
        while (claszz != null) {
            if (claszz == superclass) {
                return true;
            }
            claszz = claszz.getSuperclass();
        }
        return false;
    }

    public static boolean parametersAreCompatible(Class[] arguments, Class[] parameters) {
        if (arguments.length != parameters.length) {
            return false;
        }
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            if (MetaClassHelper.isAssignableFrom(parameters[i2], arguments[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidMethod(Object method, Class[] arguments) {
        return MetaClassHelper.getParameterTypes(method).isValidMethod(arguments);
    }

    public static void logMethodCall(Object object2, String methodName, Object[] arguments) {
        String className = MetaClassHelper.getClassName(object2);
        String logname = "methodCalls." + className + "." + methodName;
        Logger objLog = Logger.getLogger(logname);
        if (!objLog.isLoggable(Level.FINER)) {
            return;
        }
        StringBuffer msg = new StringBuffer(methodName);
        msg.append("(");
        if (arguments != null) {
            int i2 = 0;
            while (i2 < arguments.length) {
                msg.append(MetaClassHelper.normalizedValue(arguments[i2]));
                if (++i2 >= arguments.length) continue;
                msg.append(",");
            }
        }
        msg.append(")");
        objLog.logp(Level.FINER, className, msg.toString(), "called from MetaClass.invokeMethod");
    }

    protected static String normalizedValue(Object argument) {
        String value;
        try {
            value = argument.toString();
            if (value.length() > 12) {
                value = value.substring(0, 10) + "..";
            }
            if (argument instanceof String) {
                value = "'" + value + "'";
            }
        }
        catch (Exception e2) {
            value = MetaClassHelper.shortName(argument);
        }
        return value;
    }

    protected static String shortName(Object object2) {
        if (object2 == null || object2.getClass() == null) {
            return "unknownClass";
        }
        String name = MetaClassHelper.getClassName(object2);
        if (name == null) {
            return "unknownClassName";
        }
        int lastDotPos = name.lastIndexOf(46);
        if (lastDotPos < 0 || lastDotPos >= name.length() - 1) {
            return name;
        }
        return name.substring(lastDotPos + 1);
    }

    public static Class[] wrap(Class[] classes) {
        Class[] wrappedArguments = new Class[classes.length];
        for (int i2 = 0; i2 < wrappedArguments.length; ++i2) {
            Class c2 = classes[i2];
            if (c2 == null) continue;
            if (c2.isPrimitive()) {
                if (c2 == Integer.TYPE) {
                    c2 = class$java$lang$Integer == null ? MetaClassHelper.class$("java.lang.Integer") : class$java$lang$Integer;
                } else if (c2 == Byte.TYPE) {
                    c2 = class$java$lang$Byte == null ? MetaClassHelper.class$("java.lang.Byte") : class$java$lang$Byte;
                } else if (c2 == Long.TYPE) {
                    c2 = class$java$lang$Long == null ? MetaClassHelper.class$("java.lang.Long") : class$java$lang$Long;
                } else if (c2 == Double.TYPE) {
                    c2 = class$java$lang$Double == null ? MetaClassHelper.class$("java.lang.Double") : class$java$lang$Double;
                } else if (c2 == Float.TYPE) {
                    c2 = class$java$lang$Float == null ? MetaClassHelper.class$("java.lang.Float") : class$java$lang$Float;
                }
            } else if (MetaClassHelper.isSuperclass(c2, class$groovy$lang$GString == null ? MetaClassHelper.class$("groovy.lang.GString") : class$groovy$lang$GString)) {
                c2 = class$java$lang$String == null ? MetaClassHelper.class$("java.lang.String") : class$java$lang$String;
            }
            wrappedArguments[i2] = c2;
        }
        return wrappedArguments;
    }
}

