/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.startup;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.Properties;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;

public class Environment
extends Properties {
    public static final String COMPIERE_APPS_SERVER = "COMPIERE_APPS_SERVER";
    public static final String COMPIERE_APPS_TYPE = "COMPIERE_APPS_TYPE";
    public static final String APPSTYPE_JBOSS = "jboss";
    public static final String APPSTYPE_TOMCAT = "tomcatOnly";
    public static final String APPSTYPE_IBM = "ibmWAS";
    public static final String APPSTYPE_ORACLE = "<oracleAS>";
    public static final String COMPIERE_WAS_CLIENT = "COMPIERE_WAS_CLIENT";
    public static final String COMPIERE_WEB_PORT = "COMPIERE_WEB_PORT";
    public static final String COMPIERE_SSL_PORT = "COMPIERE_SSL_PORT";
    public static final String COMPIERE_JNP_PORT = "COMPIERE_JNP_PORT";
    public static final String COMPIERE_APPS_DEPLOY = "COMPIERE_APPS_DEPLOY";
    public static final String COMPIERE_WEB_ALIAS = "COMPIERE_WEB_ALIAS";
    public static final String COMPIERE_DB_SERVER = "COMPIERE_DB_SERVER";
    public static final String COMPIERE_DB_TYPE = "COMPIERE_DB_TYPE";
    public static final String COMPIERE_DB_PATH = "COMPIERE_DB_PATH";
    public static final String DBTYPE_PG = "postgreSQL";
    public static final String DBTYPE_ORACLE = "oracle";
    public static final String DBTYPE_ORACLEXE = "oracleXE";
    public static final String DBTYPE_DB2 = "db2";
    public static final String DBTYPE_MS = "sqlServer";
    public static final String COMPIERE_DB_NAME = "COMPIERE_DB_NAME";
    public static final String COMPIERE_DB_PORT = "COMPIERE_DB_PORT";
    public static final String COMPIERE_DB_USER = "COMPIERE_DB_USER";
    public static final String COMPIERE_DB_USER_EXISTS = "COMPIERE_DB_USER_EXISTS";
    public static final String COMPIERE_DB_PASSWORD = "COMPIERE_DB_PASSWORD";
    public static final String COMPIERE_DB_URL = "COMPIERE_DB_URL";
    public static final String COMPIERE_DB_SYSTEM = "COMPIERE_DB_SYSTEM";
    private static final String FILENAME = "Environment.properties";
    private static Environment s_env = null;

    public static synchronized Environment get() {
        if (s_env == null) {
            s_env = new Environment();
        }
        return s_env;
    }

    public static URL getCodeBase() {
        try {
            BasicService bs = (BasicService)ServiceManager.lookup("javax.jnlp.BasicService");
            URL url = bs.getCodeBase();
            return url;
        }
        catch (UnavailableServiceException ue) {
            return null;
        }
    }

    public static String getCodeBaseHost() {
        URL url = Environment.getCodeBase();
        if (url == null) {
            return null;
        }
        return url.getHost();
    }

    private Environment() {
        this.load();
    }

    public boolean load() {
        boolean loadOK = true;
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(FILENAME);
            this.load(in);
            in.close();
        }
        catch (Exception e2) {
            System.err.println("Environment.load(1) - " + e2);
            loadOK = false;
        }
        catch (Throwable t) {
            System.err.println("Environment.load(2) - " + t);
            loadOK = false;
        }
        return loadOK;
    }

    public void setHost(String hostName) {
        if (hostName == null || hostName.length() == 0) {
            try {
                InetAddress localhost = InetAddress.getLocalHost();
                hostName = localhost.getHostName();
            }
            catch (Exception e2) {
                hostName = "localhost";
            }
        }
        this.setProperty(COMPIERE_APPS_SERVER, hostName);
        this.setProperty(COMPIERE_DB_SERVER, hostName);
    }

    public boolean save(Properties pp, String compiereHome) {
        this.clear();
        this.setProperty(COMPIERE_APPS_SERVER, pp.getProperty(COMPIERE_APPS_SERVER));
        this.setProperty(COMPIERE_JNP_PORT, pp.getProperty(COMPIERE_JNP_PORT));
        this.setProperty(COMPIERE_APPS_TYPE, pp.getProperty(COMPIERE_APPS_TYPE));
        this.setProperty(COMPIERE_WAS_CLIENT, pp.getProperty(COMPIERE_WAS_CLIENT) == null ? "" : pp.getProperty(COMPIERE_WAS_CLIENT));
        this.setProperty(COMPIERE_WEB_PORT, pp.getProperty(COMPIERE_WEB_PORT));
        this.setProperty(COMPIERE_DB_SERVER, pp.getProperty(COMPIERE_DB_SERVER));
        this.setProperty(COMPIERE_DB_NAME, pp.getProperty(COMPIERE_DB_NAME));
        this.setProperty(COMPIERE_DB_PATH, pp.getProperty(COMPIERE_DB_PATH));
        this.setProperty(COMPIERE_DB_TYPE, pp.getProperty(COMPIERE_DB_TYPE));
        this.setProperty(COMPIERE_DB_PORT, pp.getProperty(COMPIERE_DB_PORT));
        this.setProperty(COMPIERE_DB_USER, pp.getProperty(COMPIERE_DB_USER));
        this.setProperty(COMPIERE_DB_PASSWORD, pp.getProperty(COMPIERE_DB_PASSWORD));
        boolean saveOK = true;
        String fileName = compiereHome + File.separator + FILENAME;
        File file = new File(fileName);
        try {
            FileOutputStream out = new FileOutputStream(file, false);
            this.store(out, "(C) ComPiere, Inc.");
            out.flush();
            out.close();
        }
        catch (Exception e2) {
            System.err.println("Environment.save - " + e2);
            saveOK = false;
        }
        return saveOK;
    }

    public boolean isEmpty() {
        return this.size() < 2;
    }
}

