/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ForStatement
extends Statement {
    public Statement[] initializations;
    public Expression condition;
    public Statement[] increments;
    public Statement action;
    public boolean neededScope;
    public BlockScope scope;
    private Label breakLabel;
    private Label continueLabel;
    int preCondInitStateIndex = -1;
    int condIfTrueInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public ForStatement(Statement[] initializations, Expression condition, Statement[] increments, Statement action, boolean neededScope, int s2, int e2) {
        this.sourceStart = s2;
        this.sourceEnd = e2;
        this.initializations = initializations;
        this.condition = condition;
        this.increments = increments;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
        this.neededScope = neededScope;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        LoopingFlowContext loopingContext;
        FlowInfo actionInfo;
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        if (this.initializations != null) {
            int i2 = 0;
            int count = this.initializations.length;
            while (i2 < count) {
                flowInfo = this.initializations[i2].analyseCode(this.scope, flowContext, flowInfo);
                ++i2;
            }
        }
        this.preCondInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        Constant cst = this.condition == null ? null : this.condition.constant;
        boolean isConditionTrue = cst == null || cst != NotAConstant && cst.booleanValue();
        boolean isConditionFalse = cst != null && cst != NotAConstant && !cst.booleanValue();
        cst = this.condition == null ? null : this.condition.optimizedBooleanConstant();
        boolean isConditionOptimizedTrue = cst == null || cst != NotAConstant && cst.booleanValue();
        boolean isConditionOptimizedFalse = cst != null && cst != NotAConstant && !cst.booleanValue();
        LoopingFlowContext condLoopContext = null;
        FlowInfo condInfo = flowInfo.copy().unconditionalInits().discardNullRelatedInitializations();
        if (this.condition != null && !isConditionTrue) {
            condLoopContext = new LoopingFlowContext(flowContext, this, null, null, this.scope);
            condInfo = this.condition.analyseCode(this.scope, condLoopContext, condInfo);
        }
        if (this.action == null || this.action.isEmptyBlock() && currentScope.compilerOptions().complianceLevel <= 0x2F0000L) {
            if (condLoopContext != null) {
                condLoopContext.complainOnDeferredChecks(this.scope, condInfo);
            }
            if (isConditionTrue) {
                return FlowInfo.DEAD_END;
            }
            if (isConditionFalse) {
                this.continueLabel = null;
            }
            actionInfo = condInfo.initsWhenTrue().copy().unconditionalInits().discardNullRelatedInitializations();
            loopingContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, this.scope);
        } else {
            loopingContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, this.scope);
            FlowInfo initsWhenTrue = condInfo.initsWhenTrue();
            this.condIfTrueInitStateIndex = currentScope.methodScope().recordInitializationStates(initsWhenTrue);
            if (isConditionFalse) {
                actionInfo = FlowInfo.DEAD_END;
            } else {
                actionInfo = initsWhenTrue.copy().unconditionalInits().discardNullRelatedInitializations();
                if (isConditionOptimizedFalse) {
                    ((FlowInfo)actionInfo).setReachMode(1);
                }
            }
            if (!this.action.complainIfUnreachable(actionInfo, this.scope, false)) {
                actionInfo = this.action.analyseCode(this.scope, loopingContext, actionInfo);
            }
            if (!((FlowInfo)actionInfo).isReachable() && !loopingContext.initsOnContinue.isReachable()) {
                this.continueLabel = null;
            } else {
                if (condLoopContext != null) {
                    condLoopContext.complainOnDeferredChecks(this.scope, condInfo);
                }
                actionInfo = ((FlowInfo)actionInfo).mergedWith(loopingContext.initsOnContinue.unconditionalInits());
                loopingContext.complainOnDeferredChecks(this.scope, actionInfo);
            }
        }
        FlowInfo exitBranch = condInfo.initsWhenFalse();
        exitBranch.addInitializationsFrom(flowInfo);
        if (this.continueLabel != null) {
            if (this.increments != null) {
                LoopingFlowContext loopContext = new LoopingFlowContext(flowContext, this, null, null, this.scope);
                int i3 = 0;
                int count = this.increments.length;
                while (i3 < count) {
                    actionInfo = this.increments[i3].analyseCode(this.scope, loopContext, actionInfo);
                    ++i3;
                }
                loopContext.complainOnDeferredChecks(this.scope, actionInfo);
            }
            exitBranch.addPotentialInitializationsFrom(((FlowInfo)actionInfo).unconditionalInits());
        }
        FlowInfo mergedInfo = FlowInfo.mergedOptimizedBranches(loopingContext.initsOnBreak, isConditionOptimizedTrue, exitBranch, isConditionOptimizedFalse, !isConditionTrue);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.initializations != null) {
            int i2 = 0;
            int max = this.initializations.length;
            while (i2 < max) {
                this.initializations[i2].generateCode(this.scope, codeStream);
                ++i2;
            }
        }
        Label actionLabel = new Label(codeStream);
        Label conditionLabel = new Label(codeStream);
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel != null) {
            this.continueLabel.initialize(codeStream);
        }
        if (this.condition != null && this.condition.constant == NotAConstant && (this.action != null && !this.action.isEmptyBlock() || this.increments != null)) {
            int jumpPC = codeStream.position;
            codeStream.goto_(conditionLabel);
            codeStream.recordPositionsFrom(jumpPC, this.condition.sourceStart);
        }
        actionLabel.place();
        if (this.action != null) {
            if (this.condIfTrueInitStateIndex != -1) {
                codeStream.addDefinitelyAssignedVariables(currentScope, this.condIfTrueInitStateIndex);
            }
            this.action.generateCode(this.scope, codeStream);
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            if (this.increments != null) {
                int i3 = 0;
                int max = this.increments.length;
                while (i3 < max) {
                    this.increments[i3].generateCode(this.scope, codeStream);
                    ++i3;
                }
            }
        }
        if (this.preCondInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.preCondInitStateIndex);
        }
        conditionLabel.place();
        if (this.condition != null && this.condition.constant == NotAConstant) {
            this.condition.generateOptimizedBoolean(this.scope, codeStream, actionLabel, null, true);
        } else if (this.continueLabel != null) {
            codeStream.goto_(actionLabel);
        }
        this.breakLabel.place();
        if (this.neededScope) {
            codeStream.exitUserScope(this.scope);
        }
        if (this.mergedInitStateIndex != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
            codeStream.addDefinitelyAssignedVariables(currentScope, this.mergedInitStateIndex);
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        int i2;
        ForStatement.printIndent(tab, output).append("for (");
        if (this.initializations != null) {
            i2 = 0;
            while (i2 < this.initializations.length) {
                if (i2 > 0) {
                    output.append(", ");
                }
                this.initializations[i2].print(0, output);
                ++i2;
            }
        }
        output.append("; ");
        if (this.condition != null) {
            this.condition.printExpression(0, output);
        }
        output.append("; ");
        if (this.increments != null) {
            i2 = 0;
            while (i2 < this.increments.length) {
                if (i2 > 0) {
                    output.append(", ");
                }
                this.increments[i2].print(0, output);
                ++i2;
            }
        }
        output.append(") ");
        if (this.action == null) {
            output.append(';');
        } else {
            output.append('\n');
            this.action.printStatement(tab + 1, output);
        }
        return output.append(';');
    }

    public void resolve(BlockScope upperScope) {
        int length;
        BlockScope blockScope = this.scope = this.neededScope ? new BlockScope(upperScope) : upperScope;
        if (this.initializations != null) {
            int i2 = 0;
            length = this.initializations.length;
            while (i2 < length) {
                this.initializations[i2].resolve(this.scope);
                ++i2;
            }
        }
        if (this.condition != null) {
            TypeBinding type = this.condition.resolveTypeExpecting(this.scope, BooleanBinding);
            this.condition.computeConversion(this.scope, type, type);
        }
        if (this.increments != null) {
            int i3 = 0;
            length = this.increments.length;
            while (i3 < length) {
                this.increments[i3].resolve(this.scope);
                ++i3;
            }
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            int i2;
            if (this.initializations != null) {
                int initializationsLength = this.initializations.length;
                i2 = 0;
                while (i2 < initializationsLength) {
                    this.initializations[i2].traverse(visitor, this.scope);
                    ++i2;
                }
            }
            if (this.condition != null) {
                this.condition.traverse(visitor, this.scope);
            }
            if (this.increments != null) {
                int incrementsLength = this.increments.length;
                i2 = 0;
                while (i2 < incrementsLength) {
                    this.increments[i2].traverse(visitor, this.scope);
                    ++i2;
                }
            }
            if (this.action != null) {
                this.action.traverse(visitor, this.scope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

