/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.env.IDependent;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public abstract class ReferenceBinding
extends TypeBinding
implements IDependent {
    public static ReferenceBinding LUB_GENERIC = new ReferenceBinding(){};
    public char[][] compoundName;
    public char[] sourceName;
    public int modifiers;
    public PackageBinding fPackage;
    char[] fileName;
    char[] constantPoolName;
    char[] signature;

    public FieldBinding[] availableFields() {
        return this.fields();
    }

    public MethodBinding[] availableMethods() {
        return this.methods();
    }

    public boolean canBeInstantiated() {
        return (this.modifiers & 0x6600) == 0;
    }

    public final boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.fPackage;
    }

    public final boolean canBeSeenBy(ReferenceBinding receiverType, SourceTypeBinding invocationType) {
        ReferenceBinding declaringClass;
        if (this.isPublic()) {
            return true;
        }
        if (invocationType == this && invocationType == receiverType) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType == this) {
                return true;
            }
            if (invocationType.fPackage == this.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            ReferenceBinding declaringClass2 = this.enclosingType();
            if (declaringClass2 == invocationType) {
                return true;
            }
            ReferenceBinding declaringErasure = (ReferenceBinding)declaringClass2.erasure();
            if (declaringClass2 == null) {
                return false;
            }
            do {
                if (currentType.findSuperTypeWithSameErasure(declaringErasure) == null) continue;
                return true;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            TypeVariableBinding typeVariable;
            if (!(receiverType == this || receiverType == this.enclosingType() || receiverType.isTypeVariable() && ((typeVariable = (TypeVariableBinding)receiverType).isErasureBoundTo(this.erasure()) || typeVariable.isErasureBoundTo(this.enclosingType().erasure())))) {
                return false;
            }
            if (invocationType != this) {
                ReferenceBinding outerInvocationType = invocationType;
                ReferenceBinding temp = outerInvocationType.enclosingType();
                while (temp != null) {
                    outerInvocationType = temp;
                    temp = temp.enclosingType();
                }
                ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.erasure();
                temp = outerDeclaringClass.enclosingType();
                while (temp != null) {
                    outerDeclaringClass = temp;
                    temp = temp.enclosingType();
                }
                if (outerInvocationType != outerDeclaringClass) {
                    return false;
                }
            }
            return true;
        }
        if (invocationType.fPackage != this.fPackage) {
            return false;
        }
        ReferenceBinding type = receiverType;
        ReferenceBinding referenceBinding = declaringClass = this.enclosingType() == null ? this : this.enclosingType();
        do {
            if (declaringClass == type) {
                return true;
            }
            if (this.fPackage == type.fPackage) continue;
            return false;
        } while ((type = type.superclass()) != null);
        return false;
    }

    public final boolean canBeSeenBy(Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        if (scope.kind == 4) {
            return this.canBeSeenBy(((CompilationUnitScope)scope).fPackage);
        }
        SourceTypeBinding invocationType = scope.enclosingSourceType();
        if (invocationType == this) {
            return true;
        }
        if (this.isProtected()) {
            if (invocationType.fPackage == this.fPackage) {
                return true;
            }
            ReferenceBinding currentType = invocationType;
            ReferenceBinding declaringClass = this.enclosingType();
            if (declaringClass == null) {
                return false;
            }
            do {
                if (declaringClass == invocationType) {
                    return true;
                }
                if (!declaringClass.isSuperclassOf(currentType)) continue;
                return true;
            } while ((currentType = currentType.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            ReferenceBinding outerInvocationType = invocationType;
            ReferenceBinding temp = outerInvocationType.enclosingType();
            while (temp != null) {
                outerInvocationType = temp;
                temp = temp.enclosingType();
            }
            ReferenceBinding outerDeclaringClass = (ReferenceBinding)this.erasure();
            temp = outerDeclaringClass.enclosingType();
            while (temp != null) {
                outerDeclaringClass = temp;
                temp = temp.enclosingType();
            }
            return outerInvocationType == outerDeclaringClass;
        }
        return invocationType.fPackage == this.fPackage;
    }

    public char[] computeGenericTypeSignature(TypeVariableBinding[] typeVariables) {
        int i2;
        char[] typeSig;
        boolean isMemberOfGeneric;
        boolean bl = isMemberOfGeneric = this.isMemberType() && (this.enclosingType().modifiers & 0x40000000) != 0;
        if (typeVariables == NoTypeVariables && !isMemberOfGeneric) {
            return this.signature();
        }
        StringBuffer sig = new StringBuffer(10);
        if (isMemberOfGeneric) {
            typeSig = this.enclosingType().genericTypeSignature();
            i2 = 0;
            while (i2 < typeSig.length - 1) {
                sig.append(typeSig[i2]);
                ++i2;
            }
            sig.append('.');
            sig.append(this.sourceName);
        } else {
            typeSig = this.signature();
            i2 = 0;
            while (i2 < typeSig.length - 1) {
                sig.append(typeSig[i2]);
                ++i2;
            }
        }
        if (typeVariables == NoTypeVariables) {
            sig.append(';');
        } else {
            sig.append('<');
            int i3 = 0;
            int length = typeVariables.length;
            while (i3 < length) {
                sig.append(typeVariables[i3].genericTypeSignature());
                ++i3;
            }
            sig.append(">;");
        }
        int sigLength = sig.length();
        char[] result = new char[sigLength];
        sig.getChars(0, sigLength, result, 0);
        return result;
    }

    public void computeId() {
        switch (this.compoundName.length) {
            case 3: {
                if (!CharOperation.equals(JAVA, this.compoundName[0])) {
                    return;
                }
                if (!CharOperation.equals(LANG, this.compoundName[1])) {
                    if (CharOperation.equals(JAVA_IO_PRINTSTREAM, this.compoundName)) {
                        this.id = 53;
                    } else if (CharOperation.equals(JAVA_UTIL_ITERATOR, this.compoundName)) {
                        this.id = 39;
                    } else if (CharOperation.equals(JAVA_IO_SERIALIZABLE, this.compoundName)) {
                        this.id = 37;
                    }
                    return;
                }
                char[] typeName = this.compoundName[2];
                if (typeName.length == 0) {
                    return;
                }
                switch (typeName[0]) {
                    case 'A': {
                        if (CharOperation.equals(typeName, JAVA_LANG_ASSERTIONERROR[2])) {
                            this.id = 35;
                        }
                        return;
                    }
                    case 'B': {
                        if (CharOperation.equals(typeName, JAVA_LANG_BOOLEAN[2])) {
                            this.id = 33;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_BYTE[2])) {
                            this.id = 26;
                        }
                        return;
                    }
                    case 'C': {
                        if (CharOperation.equals(typeName, JAVA_LANG_CHARACTER[2])) {
                            this.id = 28;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_CLASS[2])) {
                            this.id = 16;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_CLASSNOTFOUNDEXCEPTION[2])) {
                            this.id = 23;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_CLONEABLE[2])) {
                            this.id = 36;
                        }
                        return;
                    }
                    case 'D': {
                        if (CharOperation.equals(typeName, JAVA_LANG_DOUBLE[2])) {
                            this.id = 32;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_DEPRECATED[2])) {
                            this.id = 44;
                        }
                        return;
                    }
                    case 'E': {
                        if (CharOperation.equals(typeName, JAVA_LANG_ERROR[2])) {
                            this.id = 19;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_EXCEPTION[2])) {
                            this.id = 25;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_ENUM[2])) {
                            this.id = 41;
                        }
                        return;
                    }
                    case 'F': {
                        if (CharOperation.equals(typeName, JAVA_LANG_FLOAT[2])) {
                            this.id = 31;
                        }
                        return;
                    }
                    case 'I': {
                        if (CharOperation.equals(typeName, JAVA_LANG_INTEGER[2])) {
                            this.id = 29;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_ITERABLE[2])) {
                            this.id = 38;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_ILLEGALARGUMENTEXCEPTION[2])) {
                            this.id = 42;
                        }
                        return;
                    }
                    case 'L': {
                        if (CharOperation.equals(typeName, JAVA_LANG_LONG[2])) {
                            this.id = 30;
                        }
                        return;
                    }
                    case 'N': {
                        if (CharOperation.equals(typeName, JAVA_LANG_NOCLASSDEFERROR[2])) {
                            this.id = 22;
                        }
                        return;
                    }
                    case 'O': {
                        if (CharOperation.equals(typeName, JAVA_LANG_OBJECT[2])) {
                            this.id = 1;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_OVERRIDE[2])) {
                            this.id = 47;
                        }
                        return;
                    }
                    case 'R': {
                        if (!CharOperation.equals(typeName, JAVA_LANG_RUNTIMEEXCEPTION[2])) break;
                        this.id = 24;
                        break;
                    }
                    case 'S': {
                        if (CharOperation.equals(typeName, JAVA_LANG_STRING[2])) {
                            this.id = 11;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_STRINGBUFFER[2])) {
                            this.id = 17;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_STRINGBUILDER[2])) {
                            this.id = 40;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_SYSTEM[2])) {
                            this.id = 18;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_SHORT[2])) {
                            this.id = 27;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_SUPPRESSWARNINGS[2])) {
                            this.id = 49;
                        }
                        return;
                    }
                    case 'T': {
                        if (CharOperation.equals(typeName, JAVA_LANG_THROWABLE[2])) {
                            this.id = 21;
                        }
                        return;
                    }
                    case 'V': {
                        if (CharOperation.equals(typeName, JAVA_LANG_VOID[2])) {
                            this.id = 34;
                        }
                        return;
                    }
                }
                break;
            }
            case 4: {
                if (!CharOperation.equals(JAVA, this.compoundName[0])) {
                    return;
                }
                if (!CharOperation.equals(LANG, this.compoundName[1])) {
                    return;
                }
                char[] packageName = this.compoundName[2];
                if (packageName.length == 0) {
                    return;
                }
                char[] typeName = this.compoundName[3];
                if (typeName.length == 0) {
                    return;
                }
                if (CharOperation.equals(packageName, REFLECT)) {
                    if (CharOperation.equals(typeName, JAVA_LANG_REFLECT_CONSTRUCTOR[3])) {
                        this.id = 20;
                    }
                    return;
                }
                if (!CharOperation.equals(packageName, ANNOTATION)) break;
                switch (typeName[0]) {
                    case 'A': {
                        if (CharOperation.equals(typeName, JAVA_LANG_ANNOTATION_ANNOTATION[3])) {
                            this.id = 43;
                        }
                        return;
                    }
                    case 'D': {
                        if (CharOperation.equals(typeName, JAVA_LANG_ANNOTATION_DOCUMENTED[3])) {
                            this.id = 45;
                        }
                        return;
                    }
                    case 'E': {
                        if (CharOperation.equals(typeName, JAVA_LANG_ANNOTATION_ELEMENTTYPE[3])) {
                            this.id = 52;
                        }
                        return;
                    }
                    case 'I': {
                        if (CharOperation.equals(typeName, JAVA_LANG_ANNOTATION_INHERITED[3])) {
                            this.id = 46;
                        }
                        return;
                    }
                    case 'R': {
                        if (CharOperation.equals(typeName, JAVA_LANG_ANNOTATION_RETENTION[3])) {
                            this.id = 48;
                        } else if (CharOperation.equals(typeName, JAVA_LANG_ANNOTATION_RETENTIONPOLICY[3])) {
                            this.id = 51;
                        }
                        return;
                    }
                    case 'T': {
                        if (CharOperation.equals(typeName, JAVA_LANG_ANNOTATION_TARGET[3])) {
                            this.id = 50;
                        }
                        return;
                    }
                }
            }
        }
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        if (!isLeaf) {
            return this.signature();
        }
        return this.genericTypeSignature();
    }

    public char[] constantPoolName() {
        if (this.constantPoolName != null) {
            return this.constantPoolName;
        }
        this.constantPoolName = CharOperation.concatWith(this.compoundName, '/');
        return this.constantPoolName;
    }

    public String debugName() {
        return this.compoundName != null ? new String(this.readableName()) : "UNNAMED TYPE";
    }

    public final int depth() {
        int depth = 0;
        ReferenceBinding current = this;
        while ((current = current.enclosingType()) != null) {
            ++depth;
        }
        return depth;
    }

    public boolean detectAnnotationCycle() {
        if ((this.tagBits & 0x100000000L) != 0L) {
            return false;
        }
        if ((this.tagBits & 0x80000000L) != 0L) {
            return true;
        }
        this.tagBits |= 0x80000000L;
        MethodBinding[] currentMethods = this.methods();
        int i2 = 0;
        int l = currentMethods.length;
        while (i2 < l) {
            TypeBinding returnType = currentMethods[i2].returnType.leafComponentType();
            if (returnType.isAnnotationType() && ((ReferenceBinding)returnType).detectAnnotationCycle()) {
                if (this instanceof SourceTypeBinding) {
                    MethodDeclaration decl = (MethodDeclaration)currentMethods[i2].sourceMethod();
                    ((SourceTypeBinding)this).scope.problemReporter().annotationCircularity(this, returnType, decl != null ? decl.returnType : null);
                }
                return true;
            }
            ++i2;
        }
        this.tagBits |= 0x100000000L;
        return false;
    }

    public final ReferenceBinding enclosingTypeAt(int relativeDepth) {
        ReferenceBinding current = this;
        while (relativeDepth-- > 0 && current != null) {
            current = current.enclosingType();
        }
        return current;
    }

    public int enumConstantCount() {
        int count = 0;
        FieldBinding[] fields = this.fields();
        int i2 = 0;
        int length = fields.length;
        while (i2 < length) {
            if ((fields[i2].modifiers & 0x4000) != 0) {
                ++count;
            }
            ++i2;
        }
        return count;
    }

    public int fieldCount() {
        return this.fields().length;
    }

    public FieldBinding[] fields() {
        return NoFields;
    }

    public ReferenceBinding findSuperTypeErasingTo(int wellKnownErasureID, boolean erasureIsClass) {
        if (this.id == wellKnownErasureID || !this.isTypeVariable() && this.erasure().id == wellKnownErasureID) {
            return this;
        }
        ReferenceBinding currentType = this;
        if (erasureIsClass) {
            while ((currentType = currentType.superclass()) != null) {
                if (currentType.id != wellKnownErasureID && (currentType.isTypeVariable() || currentType.erasure().id != wellKnownErasureID)) continue;
                return currentType;
            }
            return null;
        }
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
        int lastPosition = -1;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) == NoSuperInterfaces) continue;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
        } while ((currentType = currentType.superclass()) != null);
        int i2 = 0;
        while (i2 <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i2];
            int j = 0;
            int length = interfaces.length;
            while (j < length) {
                currentType = interfaces[j];
                if (currentType.id == wellKnownErasureID || !currentType.isTypeVariable() && currentType.erasure().id == wellKnownErasureID) {
                    return currentType;
                }
                ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
                if (itsInterfaces != NoSuperInterfaces) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                ++j;
            }
            ++i2;
        }
        return null;
    }

    public ReferenceBinding findSuperTypeWithSameErasure(TypeBinding otherType) {
        if (!otherType.isTypeVariable()) {
            otherType = otherType.erasure();
        }
        if (this == otherType || !this.isTypeVariable() && this.erasure() == otherType) {
            return this;
        }
        ReferenceBinding currentType = this;
        if (!otherType.isInterface()) {
            while ((currentType = currentType.superclass()) != null) {
                if (currentType != otherType && (currentType.isTypeVariable() || currentType.erasure() != otherType)) continue;
                return currentType;
            }
            return null;
        }
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
        int lastPosition = -1;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) == NoSuperInterfaces) continue;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
        } while ((currentType = currentType.superclass()) != null);
        int i2 = 0;
        while (i2 <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i2];
            int j = 0;
            int length = interfaces.length;
            while (j < length) {
                currentType = interfaces[j];
                if (currentType == otherType || !currentType.isTypeVariable() && currentType.erasure() == otherType) {
                    return currentType;
                }
                ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
                if (itsInterfaces != NoSuperInterfaces) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                ++j;
            }
            ++i2;
        }
        return null;
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    public long getAnnotationTagBits() {
        return this.tagBits;
    }

    public MethodBinding getExactConstructor(TypeBinding[] argumentTypes) {
        return null;
    }

    public MethodBinding getExactMethod(char[] selector, TypeBinding[] argumentTypes, CompilationUnitScope refScope) {
        return null;
    }

    public FieldBinding getField(char[] fieldName, boolean needResolve) {
        return null;
    }

    public char[] getFileName() {
        return this.fileName;
    }

    public ReferenceBinding getMemberType(char[] typeName) {
        ReferenceBinding[] memberTypes = this.memberTypes();
        int i2 = memberTypes.length;
        while (--i2 >= 0) {
            if (!CharOperation.equals(memberTypes[i2].sourceName, typeName)) continue;
            return memberTypes[i2];
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] selector) {
        return NoMethods;
    }

    public PackageBinding getPackage() {
        return this.fPackage;
    }

    public boolean hasMemberTypes() {
        return false;
    }

    public TypeVariableBinding getTypeVariable(char[] variableName) {
        TypeVariableBinding[] typeVariables = this.typeVariables();
        int i2 = typeVariables.length;
        while (--i2 >= 0) {
            if (!CharOperation.equals(typeVariables[i2].sourceName, variableName)) continue;
            return typeVariables[i2];
        }
        return null;
    }

    public int hashCode() {
        return this.compoundName == null || this.compoundName.length == 0 ? super.hashCode() : CharOperation.hashCode(this.compoundName[this.compoundName.length - 1]);
    }

    public final boolean hasRestrictedAccess() {
        return (this.modifiers & 0x40000) != 0;
    }

    public boolean hasIncompatibleSuperType(ReferenceBinding otherType) {
        ReferenceBinding match;
        if (this == otherType) {
            return false;
        }
        ReferenceBinding currentType = this;
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
        int lastPosition = -1;
        do {
            if ((match = otherType.findSuperTypeWithSameErasure(currentType)) != null && !match.isIntersectingWith(currentType)) {
                return true;
            }
            ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
            if (itsInterfaces == NoSuperInterfaces) continue;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
        } while ((currentType = currentType.superclass()) != null);
        int i2 = 0;
        while (i2 <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i2];
            int j = 0;
            int length = interfaces.length;
            while (j < length) {
                currentType = interfaces[j];
                if (currentType == otherType) {
                    return false;
                }
                match = otherType.findSuperTypeWithSameErasure(currentType);
                if (match != null && !match.isIntersectingWith(currentType)) {
                    return true;
                }
                ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
                if (itsInterfaces != NoSuperInterfaces) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                ++j;
            }
            ++i2;
        }
        return false;
    }

    public boolean implementsInterface(ReferenceBinding anInterface, boolean searchHierarchy) {
        if (this == anInterface) {
            return true;
        }
        ReferenceBinding[][] interfacesToVisit = new ReferenceBinding[5][];
        int lastPosition = -1;
        ReferenceBinding currentType = this;
        do {
            ReferenceBinding[] itsInterfaces;
            if ((itsInterfaces = currentType.superInterfaces()) == NoSuperInterfaces || itsInterfaces == null) continue;
            if (++lastPosition == interfacesToVisit.length) {
                ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
            }
            interfacesToVisit[lastPosition] = itsInterfaces;
        } while (searchHierarchy && (currentType = currentType.superclass()) != null);
        int i2 = 0;
        while (i2 <= lastPosition) {
            ReferenceBinding[] interfaces = interfacesToVisit[i2];
            int j = 0;
            int length = interfaces.length;
            while (j < length) {
                currentType = interfaces[j];
                if (currentType.isEquivalentTo(anInterface)) {
                    return true;
                }
                ReferenceBinding[] itsInterfaces = currentType.superInterfaces();
                if (itsInterfaces != NoSuperInterfaces && itsInterfaces != null) {
                    if (++lastPosition == interfacesToVisit.length) {
                        ReferenceBinding[][] referenceBindingArray = interfacesToVisit;
                        interfacesToVisit = new ReferenceBinding[lastPosition * 2][];
                        System.arraycopy(referenceBindingArray, 0, interfacesToVisit, 0, lastPosition);
                    }
                    interfacesToVisit[lastPosition] = itsInterfaces;
                }
                ++j;
            }
            ++i2;
        }
        return false;
    }

    boolean implementsMethod(MethodBinding method) {
        ReferenceBinding type = this;
        while (type != null) {
            MethodBinding[] methods = type.getMethods(method.selector);
            int i2 = methods.length;
            while (--i2 >= 0) {
                if (!methods[i2].areParametersEqual(method)) continue;
                return true;
            }
            type = type.superclass();
        }
        return false;
    }

    public final boolean isAbstract() {
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotationType() {
        return (this.modifiers & 0x2000) != 0;
    }

    public final boolean isBinaryBinding() {
        return (this.tagBits & 0x40L) != 0L;
    }

    public boolean isClass() {
        return (this.modifiers & 0x6200) == 0;
    }

    public boolean isHierarchyBeingConnected() {
        return (this.tagBits & 0x200L) == 0L && (this.tagBits & 0x100L) != 0L;
    }

    public boolean isCompatibleWith(TypeBinding otherType) {
        if (otherType == this) {
            return true;
        }
        if (otherType.id == 1) {
            return true;
        }
        if (this.isEquivalentTo(otherType)) {
            return true;
        }
        switch (otherType.kind()) {
            case 516: {
                return false;
            }
            case 4100: {
                if (otherType.isCapture()) {
                    CaptureBinding otherCapture = (CaptureBinding)otherType;
                    TypeBinding otherLowerBound = otherCapture.lowerBound;
                    if (otherLowerBound != null) {
                        if (otherLowerBound.isArrayType()) {
                            return false;
                        }
                        return this.isCompatibleWith(otherLowerBound);
                    }
                }
            }
            case 4: 
            case 260: 
            case 1028: 
            case 2052: {
                switch (this.kind()) {
                    case 260: 
                    case 1028: 
                    case 2052: {
                        if (this.erasure() != otherType.erasure()) break;
                        return false;
                    }
                }
                ReferenceBinding otherReferenceType = (ReferenceBinding)otherType;
                if (otherReferenceType.isInterface()) {
                    return this.implementsInterface(otherReferenceType, true);
                }
                if (this.isInterface()) {
                    return false;
                }
                return otherReferenceType.isSuperclassOf(this);
            }
        }
        return false;
    }

    public final boolean isDefault() {
        return (this.modifiers & 7) == 0;
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public boolean isEnum() {
        return (this.modifiers & 0x4000) != 0;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.modifiers & 0x200) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 0x208) != 0 || (this.tagBits & 4L) == 0L;
    }

    public final boolean isStrictfp() {
        return (this.modifiers & 0x800) != 0;
    }

    public boolean isSuperclassOf(ReferenceBinding otherType) {
        while ((otherType = otherType.superclass()) != null) {
            if (!otherType.isEquivalentTo(this)) continue;
            return true;
        }
        return false;
    }

    public boolean isUncheckedException(boolean includeSupertype) {
        switch (this.id) {
            case 19: 
            case 24: {
                return true;
            }
            case 21: 
            case 25: {
                return includeSupertype;
            }
        }
        ReferenceBinding current = this;
        while ((current = current.superclass()) != null) {
            switch (current.id) {
                case 19: 
                case 24: {
                    return true;
                }
                case 21: 
                case 25: {
                    return false;
                }
            }
        }
        return false;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public ReferenceBinding[] memberTypes() {
        return NoMemberTypes;
    }

    public MethodBinding[] methods() {
        return NoMethods;
    }

    public final ReferenceBinding outermostEnclosingType() {
        ReferenceBinding last;
        ReferenceBinding current = this;
        do {
            last = current;
        } while ((current = current.enclosingType()) != null);
        return last;
    }

    public char[] qualifiedSourceName() {
        if (this.isMemberType()) {
            return CharOperation.concat(this.enclosingType().qualifiedSourceName(), this.sourceName(), '.');
        }
        return this.sourceName();
    }

    public char[] readableName() {
        char[] readableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().readableName(), this.sourceName, '.') : CharOperation.concatWith(this.compoundName, '.');
        TypeVariableBinding[] typeVars = this.typeVariables();
        if (typeVars != NoTypeVariables) {
            StringBuffer nameBuffer = new StringBuffer(10);
            nameBuffer.append(readableName).append('<');
            int i2 = 0;
            int length = typeVars.length;
            while (i2 < length) {
                if (i2 > 0) {
                    nameBuffer.append(',');
                }
                nameBuffer.append(typeVars[i2].readableName());
                ++i2;
            }
            nameBuffer.append('>');
            int nameLength = nameBuffer.length();
            readableName = new char[nameLength];
            nameBuffer.getChars(0, nameLength, readableName, 0);
        }
        return readableName;
    }

    public char[] shortReadableName() {
        char[] shortReadableName = this.isMemberType() ? CharOperation.concat(this.enclosingType().shortReadableName(), this.sourceName, '.') : this.sourceName;
        TypeVariableBinding[] typeVars = this.typeVariables();
        if (typeVars != NoTypeVariables) {
            StringBuffer nameBuffer = new StringBuffer(10);
            nameBuffer.append(shortReadableName).append('<');
            int i2 = 0;
            int length = typeVars.length;
            while (i2 < length) {
                if (i2 > 0) {
                    nameBuffer.append(',');
                }
                nameBuffer.append(typeVars[i2].shortReadableName());
                ++i2;
            }
            nameBuffer.append('>');
            int nameLength = nameBuffer.length();
            shortReadableName = new char[nameLength];
            nameBuffer.getChars(0, nameLength, shortReadableName, 0);
        }
        return shortReadableName;
    }

    public char[] signature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = CharOperation.concat('L', this.constantPoolName(), ';');
        return this.signature;
    }

    public char[] sourceName() {
        return this.sourceName;
    }

    public ReferenceBinding superclass() {
        return null;
    }

    public ReferenceBinding[] superInterfaces() {
        return NoSuperInterfaces;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.isStatic()) {
            return null;
        }
        ReferenceBinding enclosingType = this.enclosingType();
        if (enclosingType == null) {
            return null;
        }
        return new ReferenceBinding[]{enclosingType};
    }

    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return null;
    }

    MethodBinding[] unResolvedMethods() {
        return this.methods();
    }
}

