/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart;

import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Stroke;
import org.jfree.util.BooleanList;
import org.jfree.util.PaintList;
import org.jfree.util.StrokeList;

public class HashUtilities {
    public static int hashCodeForPaint(Paint p2) {
        if (p2 == null) {
            return 0;
        }
        int result = 0;
        if (p2 instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)p2;
            result = 193;
            result = 37 * result + gp.getColor1().hashCode();
            result = 37 * result + gp.getPoint1().hashCode();
            result = 37 * result + gp.getColor2().hashCode();
            result = 37 * result + gp.getPoint2().hashCode();
        } else {
            result = p2.hashCode();
        }
        return result;
    }

    public static int hashCodeForDoubleArray(double[] a2) {
        if (a2 == null) {
            return 0;
        }
        int result = 193;
        for (int i2 = 0; i2 < a2.length; ++i2) {
            long temp = Double.doubleToLongBits(a2[i2]);
            result = 29 * result + (int)(temp ^ temp >>> 32);
        }
        return result;
    }

    public static int hashCode(int pre2, boolean b2) {
        return 37 * pre2 + (b2 ? 0 : 1);
    }

    public static int hashCode(int pre2, int i2) {
        return 37 * pre2 + i2;
    }

    public static int hashCode(int pre2, double d2) {
        long l = Double.doubleToLongBits(d2);
        return 37 * pre2 + (int)(l ^ l >>> 32);
    }

    public static int hashCode(int pre2, Paint p2) {
        return 37 * pre2 + HashUtilities.hashCodeForPaint(p2);
    }

    public static int hashCode(int pre2, Stroke s2) {
        int h7 = s2 != null ? s2.hashCode() : 0;
        return 37 * pre2 + h7;
    }

    public static int hashCode(int pre2, String s2) {
        int h7 = s2 != null ? s2.hashCode() : 0;
        return 37 * pre2 + h7;
    }

    public static int hashCode(int pre2, Comparable c2) {
        int h7 = c2 != null ? c2.hashCode() : 0;
        return 37 * pre2 + h7;
    }

    public static int hashCode(int pre2, Object obj) {
        int h7 = obj != null ? obj.hashCode() : 0;
        return 37 * pre2 + h7;
    }

    public static int hashCode(int pre2, BooleanList list) {
        if (list == null) {
            return pre2;
        }
        int result = 127;
        int size = list.size();
        result = HashUtilities.hashCode(result, size);
        if (size > 0) {
            result = HashUtilities.hashCode(result, list.getBoolean(0));
            if (size > 1) {
                result = HashUtilities.hashCode(result, list.getBoolean(size - 1));
                if (size > 2) {
                    result = HashUtilities.hashCode(result, list.getBoolean(size / 2));
                }
            }
        }
        return 37 * pre2 + result;
    }

    public static int hashCode(int pre2, PaintList list) {
        if (list == null) {
            return pre2;
        }
        int result = 127;
        int size = list.size();
        result = HashUtilities.hashCode(result, size);
        if (size > 0) {
            result = HashUtilities.hashCode(result, list.getPaint(0));
            if (size > 1) {
                result = HashUtilities.hashCode(result, list.getPaint(size - 1));
                if (size > 2) {
                    result = HashUtilities.hashCode(result, list.getPaint(size / 2));
                }
            }
        }
        return 37 * pre2 + result;
    }

    public static int hashCode(int pre2, StrokeList list) {
        if (list == null) {
            return pre2;
        }
        int result = 127;
        int size = list.size();
        result = HashUtilities.hashCode(result, size);
        if (size > 0) {
            result = HashUtilities.hashCode(result, list.getStroke(0));
            if (size > 1) {
                result = HashUtilities.hashCode(result, list.getStroke(size - 1));
                if (size > 2) {
                    result = HashUtilities.hashCode(result, list.getStroke(size / 2));
                }
            }
        }
        return 37 * pre2 + result;
    }
}

