/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.util.Arrays;

public class ArrayUtilities {
    private ArrayUtilities() {
    }

    public static float[][] clone(float[][] array) {
        if (array == null) {
            return null;
        }
        float[][] result = new float[array.length][];
        System.arraycopy(array, 0, result, 0, array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            float[] child = array[i2];
            float[] copychild = new float[child.length];
            System.arraycopy(child, 0, copychild, 0, child.length);
            result[i2] = copychild;
        }
        return result;
    }

    public static boolean equalReferencesInArrays(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i2 = 0; i2 < array1.length; ++i2) {
            if (array1[i2] == null && array2[i2] != null) {
                return false;
            }
            if (array2[i2] == null && array1[i2] != null) {
                return false;
            }
            if (array1[i2] == array2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(float[][] array1, float[][] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i2 = 0; i2 < array1.length; ++i2) {
            if (Arrays.equals(array1[i2], array2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasDuplicateItems(Object[] array) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            for (int j = 0; j < i2; ++j) {
                Object o1 = array[i2];
                Object o2 = array[j];
                if (o1 == null || o2 == null || !o1.equals(o2)) continue;
                return true;
            }
        }
        return false;
    }

    public static int compareVersionArrays(Comparable[] a1, Comparable[] a2) {
        int length = Math.min(a1.length, a2.length);
        for (int i2 = 0; i2 < length; ++i2) {
            Comparable o1 = a1[i2];
            Comparable o2 = a2[i2];
            if (o1 == null && o2 == null) continue;
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            int retval = o1.compareTo(o2);
            if (retval == 0) continue;
            return retval;
        }
        return 0;
    }
}

