/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.search;

import com.ampiere.dto.CodeValue;
import com.ampiere.search.ComponentBean;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Msg;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoPAttribute {
    private static CLogger log = CLogger.getCLogger(InfoPAttribute.class);
    private ArrayList<Hashtable> m_productEditors = new ArrayList();
    private ArrayList<Hashtable> m_productEditorsTo = new ArrayList();
    private ArrayList<Hashtable> m_instanceEditors = new ArrayList();
    private ArrayList<Hashtable> m_instanceEditorsTo = new ArrayList();
    private ArrayList<ComponentBean> componentList = new ArrayList();
    private Hashtable<String, Integer> componentMapping = new Hashtable();

    public InfoPAttribute(Ctx ctx) {
        try {
            this.dynInit(ctx);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "InfoPAttribute", e);
        }
    }

    private void dynInit(Ctx ctx) {
        this.addAttributes(ctx);
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "SerNo"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("SerNo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 3, "", "left", "middle", "", 220));
        this.componentList.add(new ComponentBean(0));
        this.componentMapping.put("Lot", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "Lot"), 1, "", "right", "middle", "", 0));
        this.componentList.add(new ComponentBean("", 3, "", "left", "middle", "", 220));
        this.componentList.add(new ComponentBean(0));
        this.componentList.add(new ComponentBean(Msg.translate(ctx, "M_Lot_ID"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("M_Lot_ID", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 4, this.initLotSelection(ctx), "left", "middle", "", 220));
        this.componentList.add(new ComponentBean(0));
        String s = Msg.translate(ctx, "GuaranteeDate");
        ArrayList<CodeValue> lst = new ArrayList<CodeValue>();
        lst.add(new CodeValue("<", s + " <"));
        lst.add(new CodeValue("=", s + " ="));
        lst.add(new CodeValue(">", s + " >"));
        this.componentMapping.put("GuaranteeDateSelection", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 4, lst, "right", "middle", "", 220));
        this.componentMapping.put("GuaranteeDate", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 5, "", "left", "middle", "", 196));
        this.componentList.add(new ComponentBean(0));
    }

    private int addAttributes(Ctx ctx) {
        int row = 0;
        CPreparedStatement pstmt = null;
        String sql = MRole.getDefault(ctx, false).addAccessSQL("SELECT M_Attribute_ID, Name, Description, AttributeValueType, IsInstanceAttribute FROM M_Attribute WHERE IsActive='Y' ORDER BY IsInstanceAttribute, Name", "M_Attribute", false, false);
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            boolean instanceLine = false;
            while (rs.next()) {
                int attribute_ID = rs.getInt(1);
                String name = rs.getString(2);
                String description = rs.getString(3);
                String attributeValueType = rs.getString(4);
                boolean isInstanceAttribute = "Y".equals(rs.getString(5));
                if (!instanceLine && isInstanceAttribute) {
                    this.componentList.add(new ComponentBean(Msg.translate(ctx, "IsInstanceAttribute"), 1, "", "right", "right", "", 0));
                    this.componentList.add(new ComponentBean(0));
                    ++row;
                    instanceLine = true;
                }
                ComponentBean cb = new ComponentBean();
                if (description != null && description.length() > 0) {
                    cb.setToolTipText(description);
                }
                if ("L".equals(attributeValueType)) {
                    cb.setType(4);
                    cb.setContent(this.getAttributeList(ctx, attribute_ID));
                    cb.setWidth(220);
                } else if ("N".equals(attributeValueType)) {
                    cb.setType(2);
                    cb.setWidth(220);
                } else {
                    cb.setType(3);
                    cb.setWidth(220);
                }
                this.componentList.add(new ComponentBean(name, 1, "", "right", "middle", "", 0));
                int idx = this.componentList.size();
                this.componentList.add(cb);
                this.componentList.add(new ComponentBean(0));
                ++row;
                Hashtable<String, Integer> attr = new Hashtable<String, Integer>();
                attr.put("idx", idx);
                attr.put("attribute_ID", attribute_ID);
                if (isInstanceAttribute) {
                    this.m_instanceEditors.add(attr);
                } else {
                    this.m_productEditors.add(attr);
                }
                Hashtable<String, Integer> attrTo = new Hashtable<String, Integer>();
                attrTo.put("attribute_ID", attribute_ID);
                if ("N".equals(attributeValueType)) {
                    this.componentList.add(new ComponentBean("-" + name, 1, "", "right", "middle", "", 0));
                    idx = this.componentList.size();
                    this.componentList.add(new ComponentBean("", 3, "", "left", "middle", "", 220));
                    this.componentList.add(new ComponentBean(0));
                    attrTo.put("idx", idx);
                } else {
                    attrTo.put("idx", -1);
                }
                if (isInstanceAttribute) {
                    this.m_instanceEditorsTo.add(attrTo);
                    continue;
                }
                this.m_productEditorsTo.add(attrTo);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return row;
    }

    private ArrayList<CodeValue> getAttributeList(Ctx ctx, int M_Attribute_ID) {
        ArrayList<CodeValue> list = new ArrayList<CodeValue>();
        list.add(new CodeValue("", ""));
        CPreparedStatement pstmt = null;
        String sql = MRole.getDefault(ctx, false).addAccessSQL("SELECT M_AttributeValue_ID, Value, Name FROM M_AttributeValue WHERE M_Attribute_ID=? ORDER BY 2", "M_AttributeValue", false, false);
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Attribute_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new CodeValue(rs.getString(1), rs.getString(3)));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return list;
    }

    private ArrayList<CodeValue> initLotSelection(Ctx ctx) {
        ArrayList<CodeValue> list = new ArrayList<CodeValue>();
        list.add(new CodeValue("", ""));
        String sql = MRole.getDefault(ctx, false).addAccessSQL("SELECT M_Lot_ID, Name FROM M_Lot WHERE IsActive='Y' ORDER BY 2", "M_Lot", false, false);
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new CodeValue(rs.getString(1), rs.getString(2)));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return list;
    }

    private String getValue(Hashtable valueMapping, int idx) {
        String s = (String)valueMapping.get(idx);
        if (s != null && s.length() > 0) {
            return s;
        }
        return null;
    }

    private String getComponetValue(Hashtable valueMapping, String key) {
        Integer idx = this.componentMapping.get(key);
        if (idx != null && valueMapping.get(idx) != null) {
            return this.getValue(valueMapping, idx);
        }
        return null;
    }

    private String createQuery(Hashtable valueMapping, SimpleDateFormat dateFormat) {
        BigDecimal valueTo;
        Object value;
        int M_Attribute_ID;
        String valTo;
        String val;
        ComponentBean cb;
        int idxTo;
        int attribute_ID;
        int idx;
        Hashtable attrTo;
        Hashtable attr;
        int i;
        StringBuffer sb = new StringBuffer();
        String s = this.getComponetValue(valueMapping, "SerNo");
        if (s != null) {
            sb.append(" AND asi.SerNo");
            if (s.indexOf(37) == -1 && s.indexOf(95) == 1) {
                sb.append("=");
            } else {
                sb.append(" LIKE ");
            }
            sb.append(DB.TO_STRING(s));
        }
        if ((s = this.getComponetValue(valueMapping, "Lot")) != null) {
            sb.append(" AND asi.Lot");
            if (s.indexOf(37) == -1 && s.indexOf(95) == 1) {
                sb.append("=");
            } else {
                sb.append(" LIKE ");
            }
            sb.append(DB.TO_STRING(s));
        }
        if ((s = this.getComponetValue(valueMapping, "M_Lot_ID")) != null) {
            int ID = Integer.parseInt(s);
            sb.append(" AND asi.M_Lot_ID=").append(ID);
        }
        if ((s = this.getComponetValue(valueMapping, "GuaranteeDate")) != null) {
            try {
                Date d = dateFormat.parse(s);
                Timestamp ts = new Timestamp(d.getTime());
                sb.append(" AND TRUNC(asi.GuaranteeDate)");
                String ss = "<";
                s = this.getComponetValue(valueMapping, "GuaranteeDateSelection");
                if (s != null) {
                    if (s.indexOf("=") >= 0) {
                        ss = "=";
                    } else if (ss.indexOf(">") >= 0) {
                        ss = ">";
                    }
                }
                sb.append(ss);
                sb.append(DB.TO_DATE(ts, true));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "InfoPAttribute : createQuery : GuaranteeDate", e);
            }
        }
        for (i = 0; i < this.m_instanceEditors.size(); ++i) {
            StringBuffer iAttr = new StringBuffer();
            attr = this.m_instanceEditors.get(i);
            attrTo = this.m_instanceEditorsTo.get(i);
            idx = (Integer)attr.get("idx");
            attribute_ID = (Integer)attr.get("attribute_ID");
            idxTo = (Integer)attrTo.get("idx");
            cb = this.componentList.get(idx);
            if (cb == null) continue;
            val = this.getValue(valueMapping, idx);
            valTo = this.getValue(valueMapping, idxTo);
            M_Attribute_ID = attribute_ID;
            if (cb.getType() == 4) {
                if (val != null) {
                    iAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND M_AttributeValue_ID=").append(val);
                }
            } else if (cb.getType() == 2) {
                value = null;
                valueTo = null;
                try {
                    value = new BigDecimal(val);
                    valueTo = new BigDecimal(valTo);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "InfoPAttribute : createQuery : To BigDecimal", e);
                }
                if (value != null || valueTo != null) {
                    iAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND ValueNumber");
                    if (value != null && valueTo == null) {
                        iAttr.append("=").append(value);
                    } else if (value == null && valueTo != null) {
                        iAttr.append("<=").append(valueTo);
                    } else if (value != null && valueTo != null) {
                        iAttr.append(" BETWEEN ").append(value).append(" AND ").append(valueTo);
                    }
                }
            } else {
                value = val;
                if (value != null && ((String)value).length() > 0) {
                    iAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND Value");
                    if (((String)value).indexOf(37) == -1 && ((String)value).indexOf(95) == -1) {
                        iAttr.append("=");
                    } else {
                        iAttr.append(" LIKE ");
                    }
                    iAttr.append(DB.TO_STRING((String)value));
                }
            }
            if (iAttr.length() <= 0) continue;
            sb.append(" AND asi.M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE ").append(iAttr).append(")");
        }
        if (sb.length() > 0) {
            sb.insert(0, " AND EXISTS (SELECT * FROM M_Storage s INNER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID) WHERE s.M_Product_ID=p.M_Product_ID");
            sb.append(")");
        }
        for (i = 0; i < this.m_productEditors.size(); ++i) {
            StringBuffer pAttr = new StringBuffer();
            attr = this.m_productEditors.get(i);
            attrTo = this.m_productEditorsTo.get(i);
            idx = (Integer)attr.get("idx");
            attribute_ID = (Integer)attr.get("attribute_ID");
            idxTo = (Integer)attrTo.get("idx");
            cb = this.componentList.get(idx);
            if (cb == null) continue;
            val = this.getValue(valueMapping, idx);
            valTo = this.getValue(valueMapping, idxTo);
            M_Attribute_ID = attribute_ID;
            if (cb.getType() == 4) {
                if (val != null) {
                    pAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND M_AttributeValue_ID=").append(val);
                }
            } else if (cb.getType() == 2) {
                value = new BigDecimal(val);
                valueTo = new BigDecimal(valTo);
                try {
                    value = new BigDecimal(val);
                    valueTo = new BigDecimal(valTo);
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "InfoPAttribute : createQuery : To BigDecimal", e);
                }
                if (value != null || valueTo != null) {
                    pAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND ValueNumber");
                    if (value != null && valueTo == null) {
                        pAttr.append("=").append(value);
                    } else if (value == null && valueTo != null) {
                        pAttr.append("<=").append(valueTo);
                    } else if (value != null && valueTo != null) {
                        pAttr.append(" BETWEEN ").append(value).append(" AND ").append(valueTo);
                    }
                }
            } else {
                value = val;
                if (value != null && ((String)value).length() > 0) {
                    pAttr.append("M_Attribute_ID=").append(M_Attribute_ID).append(" AND Value");
                    if (((String)value).indexOf(37) == -1 && ((String)value).indexOf(95) == -1) {
                        pAttr.append("=");
                    } else {
                        pAttr.append(" LIKE ");
                    }
                    pAttr.append(DB.TO_STRING((String)value));
                }
            }
            if (pAttr.length() <= 0) continue;
            sb.append(" AND p.M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE ").append(pAttr).append(")");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return null;
    }

    public String getWhereClause(String where, SimpleDateFormat dateFormat) {
        if (where == null || where.length() == 0) {
            return null;
        }
        String[] p = where.split(";");
        if (p == null || p.length == 0) {
            return null;
        }
        Hashtable<Integer, String> valueMapping = new Hashtable<Integer, String>();
        for (int i = 0; i < p.length; ++i) {
            String[] pp = p[i].split(",");
            if (pp == null || pp.length != 2) continue;
            try {
                valueMapping.put(new Integer(Integer.parseInt(pp[0])), pp[1]);
                continue;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "InfoPAttribute : getWhereClause", e);
            }
        }
        String query = this.createQuery(valueMapping, dateFormat);
        log.config(query);
        return query;
    }

    public ArrayList<ComponentBean> getComponentList() {
        return this.componentList;
    }
}

