/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.search;

import com.ampiere.search.IDColumn;
import com.ampiere.search.PAttributeInstanceVO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;

public class PAttributeInstance {
    private List instanceList = null;
    private int m_M_Warehouse_ID;
    private int m_M_Product_ID;
    private int m_M_AttributeSetInstance_ID = -1;
    private String m_M_AttributeSetInstanceName = null;
    private String m_sql;
    private static CLogger log = CLogger.getCLogger(PAttributeInstance.class);
    private static String s_sqlFrom = "M_Storage s INNER JOIN M_Locator l ON (s.M_Locator_ID=l.M_Locator_ID) INNER JOIN M_Product p ON (s.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN M_AttributeSetInstance asi ON (s.M_AttributeSetInstance_ID=asi.M_AttributeSetInstance_ID)";
    private static String s_sqlWhere = "l.M_Warehouse_ID=? AND s.M_Product_ID=?";
    private String m_sqlMinLife = "";

    public List getInstanceList() {
        return this.instanceList;
    }

    public void setInstanceList(List instanceList) {
        this.instanceList = instanceList;
    }

    public PAttributeInstance(Ctx ctx, String title, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        this.instanceList = this.init(ctx, M_Warehouse_ID, M_Locator_ID, M_Product_ID, C_BPartner_ID);
    }

    private List init(Ctx ctx, int M_Warehouse_ID, int M_Locator_ID, int M_Product_ID, int C_BPartner_ID) {
        List ret_list = null;
        log.info("M_Warehouse_ID=" + M_Warehouse_ID + ", M_Locator_ID=" + M_Locator_ID + ", M_Product_ID=" + M_Product_ID);
        this.m_M_Warehouse_ID = M_Warehouse_ID;
        this.m_M_Product_ID = M_Product_ID;
        try {
            ret_list = this.dynInit(ctx, C_BPartner_ID);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        return ret_list;
    }

    private List dynInit(Ctx ctx, int C_BPartner_ID) {
        log.config("C_BPartner_ID=" + C_BPartner_ID);
        if (C_BPartner_ID != 0) {
            int ShelfLifeMinPct = 0;
            int ShelfLifeMinDays = 0;
            String sql = "SELECT bp.ShelfLifeMinPct, bpp.ShelfLifeMinPct, bpp.ShelfLifeMinDays FROM C_BPartner bp  LEFT OUTER JOIN C_BPartner_Product bpp ON (bp.C_BPartner_ID=bpp.C_BPartner_ID AND bpp.M_Product_ID=?) WHERE bp.C_BPartner_ID=?";
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, this.m_M_Product_ID);
                pstmt.setInt(2, C_BPartner_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    ShelfLifeMinPct = rs.getInt(1);
                    int pct = rs.getInt(2);
                    if (pct > 0) {
                        ShelfLifeMinDays = pct;
                    }
                    ShelfLifeMinDays = rs.getInt(3);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, sql, e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (ShelfLifeMinPct > 0) {
                this.m_sqlMinLife = " AND COALESCE(TRUNC(((TRUNC(asi.GuaranteeDate)-TRUNC(SysDate))/p.GuaranteeDays)*100),0)>=" + ShelfLifeMinPct;
                log.config("PAttributeInstance.dynInit - ShelfLifeMinPct=" + ShelfLifeMinPct);
            }
            if (ShelfLifeMinDays > 0) {
                this.m_sqlMinLife = this.m_sqlMinLife + " AND COALESCE((TRUNC(asi.GuaranteeDate)-TRUNC(SysDate)),0)>=" + ShelfLifeMinDays;
                log.config("PAttributeInstance.dynInit - ShelfLifeMinDays=" + ShelfLifeMinDays);
            }
        }
        String m_sql = this.prepareTable(ctx, s_sqlFrom, s_sqlWhere) + " ORDER BY asi.GuaranteeDate, s.QtyOnHand";
        return this.refresh(m_sql);
    }

    private List refresh(String m_sql) {
        String sql = m_sql;
        List ret_list = null;
        log.finest(sql);
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.m_M_Warehouse_ID);
            pstmt.setInt(2, this.m_M_Product_ID);
            ResultSet rs = pstmt.executeQuery();
            ret_list = this.loadTable(rs);
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return ret_list;
    }

    public int getM_AttributeSetInstance_ID() {
        return this.m_M_AttributeSetInstance_ID;
    }

    public String getM_AttributeSetInstanceName() {
        return this.m_M_AttributeSetInstanceName;
    }

    public String prepareTable(Ctx ctx, String from, String where) {
        StringBuffer sql = new StringBuffer("SELECT ");
        sql.append(" s.M_AttributeSetInstance_ID, ");
        sql.append(" s.asi.Description, ");
        sql.append(" asi.Lot, ");
        sql.append(" asi.SerNo,");
        sql.append(" asi.GuaranteeDate, ");
        sql.append(" l.Value, ");
        sql.append(" s.M_Locator_ID, ");
        sql.append(" s.QtyOnHand,");
        sql.append(" s.QtyReserved, ");
        sql.append(" s.QtyOrdered, ");
        sql.append(" daysBetween(TRUNC(asi.GuaranteeDate, 'DD'), TRUNC(SysDate, 'DD')) - p.GuaranteeDaysMin, ");
        sql.append(" daysBetween(TRUNC(asi.GuaranteeDate, 'DD'), TRUNC(SysDate, 'DD')),");
        sql.append(" CASE WHEN p.GuaranteeDays > 0 THEN daysBetween(TRUNC(asi.GuaranteeDate, ");
        sql.append(" 'DD'), TRUNC(SysDate, 'DD')) / p.GuaranteeDays * 100 ELSE 0 END ");
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ").append(where);
        if (from.length() == 0) {
            return sql.toString();
        }
        String finalSQL = MRole.getDefault(ctx, false).addAccessSQL(sql.toString(), "s", true, false);
        log.finest(finalSQL);
        return finalSQL;
    }

    public List loadTable(ResultSet rs) {
        ArrayList<PAttributeInstanceVO> instanceList = new ArrayList<PAttributeInstanceVO>();
        try {
            while (rs.next()) {
                PAttributeInstanceVO vo = new PAttributeInstanceVO();
                int colOffset = 1;
                for (int col = 0; col < 12; ++col) {
                    Object data = null;
                    int colIndex = col + colOffset;
                    if (col == 0) {
                        data = new IDColumn(rs.getInt(colIndex));
                    } else if (col == 4) {
                        data = rs.getTimestamp(colIndex);
                    } else if (col == 6 || col == 7 || col == 8) {
                        data = new Double(rs.getDouble(colIndex));
                    } else if (col == 9 || col == 10 || col == 11) {
                        data = new Integer(rs.getInt(colIndex));
                    } else if (col == 5) {
                        String display = rs.getString(colIndex);
                        int key = rs.getInt(colIndex + 1);
                        data = display;
                        ++colOffset;
                    } else {
                        String s = rs.getString(colIndex);
                        if (s != null) {
                            data = s.trim();
                        }
                    }
                    if (col == 0) {
                        IDColumn dataColumn = (IDColumn)data;
                        vo.setAttributeSetInstanceId(String.valueOf(dataColumn.getRecord_ID()));
                        continue;
                    }
                    if (col == 1) {
                        vo.setDescription(data.toString());
                        continue;
                    }
                    if (col == 2) {
                        vo.setLot(data.toString());
                        continue;
                    }
                    if (col == 3) {
                        vo.setSerNo(data.toString());
                        continue;
                    }
                    if (col == 4) {
                        vo.setGuaranteeDate(data.toString());
                        continue;
                    }
                    if (col == 5) {
                        vo.setMlocatorId(data.toString());
                        continue;
                    }
                    if (col == 6) {
                        vo.setQtyOnHand(data.toString());
                        continue;
                    }
                    if (col == 7) {
                        vo.setQtyReserved(data.toString());
                        continue;
                    }
                    if (col == 8) {
                        vo.setQtyOrdered(data.toString());
                        continue;
                    }
                    if (col == 9) {
                        vo.setGoodForDays(data.toString());
                        continue;
                    }
                    if (col == 10) {
                        vo.setShelfLifeDays(data.toString());
                        continue;
                    }
                    if (col != 11) continue;
                    vo.setShelfLifeRemainingPct(data.toString());
                }
                instanceList.add(vo);
            }
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, "", e);
        }
        return instanceList;
    }
}

