/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util;

import com.ampiere.util.GraphUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.compiere.model.MAchievement;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MProjectType;
import org.compiere.model.MRequestType;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;

public class BarGraphColumn
extends JComponent
implements MouseListener {
    private MAchievement m_achievement = null;
    private MMeasureCalc m_mc = null;
    private MGoal m_goal = null;
    private MRequestType m_rt = null;
    private MProjectType m_pt = null;
    private int m_id = 0;
    private String m_measureDisplay = null;
    private Timestamp m_date = null;
    private String m_label = null;
    private double m_value = 0.0;
    private String m_labelValue = "";
    private double m_targetValue = 0.0;
    private double m_width = 0.0;
    private double m_height = 0.0;
    private static CLogger log = CLogger.getCLogger(BarGraphColumn.class);
    private static DecimalFormat s_format = DisplayType.getNumberFormat(11);
    private static final AffineTransform s_affineTransform = new AffineTransform();

    public BarGraphColumn(String label2, double value) {
        this.m_label = label2;
        this.setValue(value);
        this.addMouseListener(this);
    }

    public BarGraphColumn(MAchievement achievement) {
        this(achievement.getName(), achievement.getManualActual().doubleValue());
        this.m_achievement = achievement;
    }

    public BarGraphColumn(MGoal goal, BigDecimal data) {
        this("", data == null ? 0.0 : data.doubleValue());
        this.m_goal = goal;
    }

    public BarGraphColumn(MMeasureCalc mc, BigDecimal data) {
        this("", data == null ? 0.0 : data.doubleValue());
        this.m_mc = mc;
    }

    public BarGraphColumn(MRequestType rt, BigDecimal data, int id) {
        this("", data == null ? 0.0 : data.doubleValue());
        this.m_rt = rt;
        this.m_id = id;
    }

    public BarGraphColumn(MProjectType pt, BigDecimal data, int id) {
        this("", data == null ? 0.0 : data.doubleValue());
        this.m_pt = pt;
        this.m_id = id;
    }

    public MGoal getGoal() {
        return this.m_goal;
    }

    public MAchievement getAchievement() {
        return this.m_achievement;
    }

    public MMeasureCalc getMeasureCalc() {
        return this.m_mc;
    }

    public MRequestType getRequestType() {
        return this.m_rt;
    }

    public MProjectType getProjectType() {
        return this.m_pt;
    }

    public String getMeasureDisplay() {
        return this.m_measureDisplay;
    }

    public Timestamp getDate() {
        return this.m_date;
    }

    public int getID() {
        return this.m_id;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.setForeground(GraphUtil.getForeground(bg));
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label2) {
        this.m_label = label2;
        this.m_labelValue = this.m_label != null ? s_format.format(this.m_value) + " - " + this.m_label : s_format.format(this.m_value);
        this.setToolTipText(this.m_labelValue);
        this.setName(this.m_labelValue);
    }

    public void setLabel(Timestamp date, String MeasureDisplay) {
        if (date == null) {
            return;
        }
        this.m_date = date;
        this.m_measureDisplay = MeasureDisplay;
        SimpleDateFormat format = DisplayType.getDateFormat(15);
        String text = format.format(date);
        if ("5".equals(MeasureDisplay) || "3".equals(MeasureDisplay)) {
            String pattern = format.toPattern();
            String mmText = text;
            int index = pattern.indexOf("dd");
            if (index == 0) {
                mmText = text.substring(3);
            } else if (index > 0) {
                mmText = text.substring(0, index - 1);
                if (text.length() > index + 2) {
                    mmText = mmText + text.substring(index + 2);
                }
            }
            this.setLabel(mmText);
        } else {
            this.setLabel(text);
        }
    }

    public double getTargetValue() {
        return this.m_targetValue;
    }

    public void setTargetValue(double targetValue) {
        this.m_targetValue = targetValue;
    }

    public double getValue() {
        return this.m_value;
    }

    public void setValue(double value) {
        this.m_value = value;
        this.m_labelValue = this.m_label != null ? s_format.format(this.m_value) + " - " + this.m_label : s_format.format(this.m_value);
        this.setToolTipText(this.m_labelValue);
        this.setName(this.m_labelValue);
    }

    public double getColWidth() {
        return this.m_width;
    }

    public void setColWidth(double width) {
        this.m_width = width;
        if (this.isPreferredSizeSet()) {
            this.setPreferredSize(null);
        }
    }

    public double getColHeight() {
        return this.m_height;
    }

    public void setColHeight(double height) {
        this.m_height = height;
        if (this.isPreferredSizeSet()) {
            this.setPreferredSize(null);
        }
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            Dimension size = new Dimension((int)this.m_width, (int)this.m_height);
            this.setPreferredSize(size);
        }
        return super.getPreferredSize();
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Rectangle bounds = this.getBounds();
        bounds.setLocation(0, 0);
        bounds.width /= 4;
        g2d.setColor(this.getBackground());
        g2d.fill3DRect(bounds.x, bounds.y, bounds.width * 3, bounds.height, false);
        g2d.setColor(this.getBackground().darker());
        s_affineTransform.setToShear(0.0, 0.9);
        Shape shape = s_affineTransform.createTransformedShape(bounds);
        s_affineTransform.setToTranslation(bounds.width * 3, 0.0);
        shape = s_affineTransform.createTransformedShape(shape);
        g2d.fill(shape);
        Color color = this.getForeground();
        g2d.setPaint(color);
        Font font = this.getFont();
        FontMetrics fm = g2d.getFontMetrics(font);
        int fontHeight = fm.getHeight();
        s_affineTransform.setToRotation(4.71238898038469);
        font = font.deriveFont(s_affineTransform);
        g2d.setFont(font);
        int x = bounds.width + (fontHeight - 2) / 2;
        if (x < fontHeight) {
            x = fontHeight - 2;
        }
        int y = bounds.height - 3;
        g2d.drawString(this.m_labelValue, x, y);
        log.finest("x=" + x + ",fontHeight=" + fontHeight + ", y=" + y + " - " + this.m_labelValue);
    }

    public void addActionListener(ActionListener l) {
        if (l != null) {
            this.listenerList.add(ActionListener.class, l);
        }
    }

    public void removeActionListener(ActionListener l) {
        if (l != null) {
            this.listenerList.remove(ActionListener.class, l);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    protected void fireActionPerformed(MouseEvent event) {
        ActionListener[] listeners = this.getActionListeners();
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, 1001, "column" + this.m_label, event.getWhen(), event.getModifiers());
            }
            listeners[i].actionPerformed(e);
        }
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
            this.fireActionPerformed(e);
        }
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

