/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util;

import com.ampiere.util.BarGraph;
import com.ampiere.util.BarGraphColumn;
import com.ampiere.util.GraphUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import org.compiere.util.CLogger;

public class BarGraphLayout
implements LayoutManager {
    private BarGraph m_parent;
    private ArrayList<BarGraphColumn> m_list = new ArrayList();
    private boolean m_layoutComplete = false;
    private static int XGAP = 2;
    private static int YGAP = 1;
    private static CLogger log = CLogger.getCLogger(BarGraphLayout.class);

    public BarGraphLayout(BarGraph parent) {
        this.m_parent = parent;
    }

    public void addLayoutComponent(String name, Component comp) {
        if (comp instanceof BarGraphColumn) {
            this.m_list.add((BarGraphColumn)comp);
        } else {
            log.severe("Invalid Class: " + comp);
        }
        this.m_layoutComplete = false;
    }

    public void removeLayoutComponent(Component comp) {
        this.m_list.remove(comp);
        this.m_layoutComplete = false;
    }

    public Dimension preferredLayoutSize(Container parent) {
        return parent.getPreferredSize();
    }

    public Dimension minimumLayoutSize(Container parent) {
        return parent.getMinimumSize();
    }

    public void layoutContainer(Container parent) {
        if (this.m_layoutComplete) {
            return;
        }
        double maxValue = 0.0;
        for (int i = 0; i < this.m_list.size(); ++i) {
            BarGraphColumn column = this.m_list.get(i);
            maxValue = Math.max(maxValue, column.getValue());
        }
        Dimension size = this.m_parent.getPreferredSize();
        Point point0_0 = this.m_parent.getPoint0_0();
        double graphHeight = size.height - (size.height - point0_0.y) - 2 * YGAP;
        double graphWidth = size.width - point0_0.x - XGAP;
        double columnWidth = (graphWidth - (double)(XGAP * this.m_list.size())) / (double)this.m_list.size();
        columnWidth = Math.min(30.0, columnWidth);
        FontMetrics fm = this.m_parent.getFontMetrics(this.m_parent.getFont());
        int fontHeight = fm.getHeight();
        columnWidth = Math.max((double)fontHeight, columnWidth);
        log.fine("Height=" + graphHeight + ", MaxValue=" + maxValue + ", Width=" + graphWidth + ", ColumnWidth=" + columnWidth);
        int x = point0_0.x + 2 * XGAP;
        for (int i = 0; i < this.m_list.size(); ++i) {
            BarGraphColumn column = this.m_list.get(i);
            double multiplier = column.getValue() / maxValue;
            double height = graphHeight * multiplier;
            column.setColHeight(height);
            column.setColWidth(columnWidth);
            Dimension ps = column.getPreferredSize();
            column.setBackground(GraphUtil.getBackground(i));
            int y = point0_0.y - ps.height - YGAP;
            column.setLocation(x, y);
            column.setBounds(x, y, ps.width, ps.height);
            x += ps.width + XGAP;
            log.finer(i + " - " + (int)(multiplier * 100.0) + "% - " + column.getBounds());
        }
        this.m_layoutComplete = true;
    }
}

