/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util;

import com.ampiere.util.GraphUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.text.DecimalFormat;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.compiere.model.MColorSchema;
import org.compiere.model.MGoal;
import org.compiere.swing.CMenuItem;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class PerformanceIndicator
extends JComponent
implements MouseListener,
ActionListener {
    private static final int s_gap = 3;
    private static final DecimalFormat s_format = DisplayType.getNumberFormat(11);
    private Composite m_composite = AlphaComposite.getInstance(3, 0.4f);
    private Area m_tempArea = new Area();
    private Rectangle m_paintRect = new Rectangle();
    private Rectangle m_tempRect = new Rectangle();
    private Point m_bottomRight = new Point();
    private GradientPaint m_gradientPaint;
    private GradientPaint m_gradientPaintInner;
    private GradientPaint m_gradientPaintInnerPercent;
    private GradientPaint m_gradientPaintPercentInner;
    private GradientPaint m_innerGradientPaintInnerDome;
    private GradientPaint m_innerGradientDelineator;
    private MGoal m_goal = null;
    private TreeMap<Integer, Color> m_colors = new TreeMap();
    private JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mRefresh = new CMenuItem(Msg.getMsg(Env.getCtx(), "Refresh"), Env.getImageIcon("Refresh16.gif"));

    public PerformanceIndicator(MGoal goal) {
        this.m_goal = goal;
        this.setName(this.m_goal.getName());
        this.getPreferredSize();
        Border border = BorderFactory.createLineBorder(Color.GRAY);
        Border emptyBorder = BorderFactory.createEmptyBorder(3, 3, 0, 3);
        border = BorderFactory.createCompoundBorder(border, emptyBorder);
        this.setBorder(border);
        this.setOpaque(false);
        this.setFont(UIManager.getFont("Label.font").deriveFont(1));
        this.setFont(this.getFont().deriveFont(this.getFont().getSize() + 1));
        this.updateDisplay();
        this.mRefresh.addActionListener(this);
        this.popupMenu.add(this.mRefresh);
        this.addMouseListener(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mRefresh) {
            this.m_goal.updateGoal(true);
            this.updateDisplay();
            Container parent = this.getParent();
            if (parent != null) {
                parent.invalidate();
            }
            this.invalidate();
            if (parent != null) {
                parent.repaint();
            } else {
                this.repaint();
            }
        }
    }

    public void addActionListener(ActionListener l) {
        if (l != null) {
            this.listenerList.add(ActionListener.class, l);
        }
    }

    private void calcPaintRect() {
        Insets insets = this.getInsets();
        this.getBounds(this.m_paintRect);
        int origWidth = this.m_paintRect.width;
        int origHeight = this.m_paintRect.height;
        this.m_paintRect.setLocation(0, 0);
        this.m_paintRect.x += insets.left;
        this.m_paintRect.width -= insets.left + insets.right;
        if (this.m_paintRect.width > this.m_paintRect.height * 2) {
            this.m_paintRect.width = this.m_paintRect.height * 2;
        }
        this.m_paintRect.height = this.m_paintRect.width - insets.bottom;
        this.m_paintRect.x = origWidth / 2 - this.m_paintRect.width / 2;
        this.m_paintRect.y = origHeight - this.m_paintRect.height / 2 + insets.top;
    }

    protected void fireActionPerformed(MouseEvent event) {
        ActionListener[] listeners = this.getActionListeners();
        ActionEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ActionEvent(this, 1001, "pi", event.getWhen(), event.getModifiers());
            }
            listeners[i].actionPerformed(e);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(ActionListener.class);
    }

    public MGoal getGoal() {
        return this.m_goal;
    }

    private GradientPaint getGradientPaint(Rectangle rect) {
        this.m_bottomRight.setLocation(rect.x + rect.width, rect.y + rect.height);
        if (this.m_gradientPaint == null || !this.m_gradientPaint.getPoint2().equals(this.m_bottomRight)) {
            this.m_gradientPaint = new GradientPaint(rect.x, rect.y, Color.LIGHT_GRAY, rect.x + rect.width, rect.y + rect.height, Color.DARK_GRAY);
        }
        return this.m_gradientPaint;
    }

    private GradientPaint getGradientPaintDelineator(Rectangle rect) {
        this.m_bottomRight.setLocation(rect.x + rect.width, rect.y + rect.height);
        if (this.m_innerGradientDelineator == null || !this.m_innerGradientDelineator.getPoint2().equals(this.m_bottomRight)) {
            this.m_innerGradientDelineator = new GradientPaint(rect.x, rect.y, Color.DARK_GRAY, rect.x + rect.width, rect.y + rect.height, Color.GRAY);
        }
        return this.m_innerGradientDelineator;
    }

    private GradientPaint getGradientPaintInner(Rectangle rect) {
        this.m_bottomRight.setLocation(rect.x + rect.width, rect.y + rect.height);
        if (this.m_gradientPaintInner == null || !this.m_gradientPaintInner.getPoint2().equals(this.m_bottomRight)) {
            this.m_gradientPaintInner = new GradientPaint(rect.x, rect.y, Color.DARK_GRAY, rect.x + rect.width, rect.y + rect.height, Color.WHITE);
        }
        return this.m_gradientPaintInner;
    }

    private GradientPaint getGradientPaintInnerDome(Rectangle rect) {
        this.m_bottomRight.setLocation(rect.x + rect.width, rect.y + rect.height);
        if (this.m_innerGradientPaintInnerDome == null || !this.m_innerGradientPaintInnerDome.getPoint2().equals(this.m_bottomRight)) {
            this.m_innerGradientPaintInnerDome = new GradientPaint(rect.x, rect.y, Color.DARK_GRAY, rect.x + rect.width, rect.y + rect.height, Color.LIGHT_GRAY);
        }
        return this.m_innerGradientPaintInnerDome;
    }

    private GradientPaint getGradientPaintPercent(Rectangle rect) {
        this.m_bottomRight.setLocation(rect.x + rect.width, rect.y + rect.height);
        if (this.m_gradientPaintInnerPercent == null || !this.m_gradientPaintInnerPercent.getPoint2().equals(this.m_bottomRight)) {
            this.m_gradientPaintInnerPercent = new GradientPaint(rect.x, rect.y, Color.DARK_GRAY, rect.x + rect.width, rect.y + rect.height, Color.LIGHT_GRAY);
        }
        return this.m_gradientPaintInnerPercent;
    }

    private GradientPaint getGradientPaintPercentInner(Rectangle rect) {
        this.m_bottomRight.setLocation(rect.x + rect.width, rect.y + rect.height);
        if (this.m_gradientPaintPercentInner == null || !this.m_gradientPaintPercentInner.getPoint2().equals(this.m_bottomRight)) {
            this.m_gradientPaintPercentInner = new GradientPaint(rect.x, rect.y, Color.GRAY, rect.x + rect.width, rect.y + rect.height, Color.WHITE);
        }
        return this.m_gradientPaintPercentInner;
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() > 1) {
            this.fireActionPerformed(e);
        }
        if (SwingUtilities.isRightMouseButton(e)) {
            this.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
        }
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    protected void paintComponent(Graphics g) {
        int percent;
        this.calcPaintRect();
        Graphics2D g2d = (Graphics2D)g;
        Paint paint = g2d.getPaint();
        Composite composite = g2d.getComposite();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setPaint(this.getGradientPaint(this.m_paintRect));
        g2d.fillArc(this.m_paintRect.x, this.m_paintRect.y, this.m_paintRect.width, this.m_paintRect.height + 6, 0, 180);
        this.m_paintRect.grow(-this.m_paintRect.width / 8 + 3, -this.m_paintRect.height / 12 + 3);
        this.m_paintRect.height -= this.m_paintRect.height / 4;
        g2d.setPaint(this.getGradientPaintInner(this.m_paintRect));
        g2d.fillArc(this.m_paintRect.x, this.m_paintRect.y, this.m_paintRect.width, this.m_paintRect.height, 0, 180);
        this.m_tempRect.setBounds(this.m_paintRect.x, this.m_paintRect.y + this.m_paintRect.height / 2, this.m_paintRect.width, 2);
        g2d.setPaint(this.getGradientPaintDelineator(this.m_tempRect));
        g2d.fill(this.m_tempRect);
        this.m_tempRect.setBounds(this.m_paintRect);
        this.m_paintRect.grow(-this.m_paintRect.height / 50, -this.m_paintRect.height / 50);
        int last = 0;
        for (Integer i : this.m_colors.keySet()) {
            g2d.setColor(this.m_colors.get(i));
            g2d.fillArc(this.m_paintRect.x, this.m_paintRect.y, this.m_paintRect.width, this.m_paintRect.height - 3, 180 * last / 100, 180 - 180 * i / 100);
            i = last;
        }
        this.m_paintRect.grow(-this.m_paintRect.height / 25, -this.m_paintRect.height / 25);
        g2d.setPaint(this.getGradientPaintInnerDome(this.m_paintRect));
        g2d.fillArc(this.m_paintRect.x, this.m_paintRect.y, this.m_paintRect.width, this.m_paintRect.height, 0, 180);
        int n = percent = this.m_goal.getPercent() > 100 ? 100 : this.m_goal.getPercent();
        if (percent > 0) {
            g2d.setComposite(this.m_composite);
            g2d.setPaint(this.getGradientPaintPercentInner(this.m_tempRect));
            g2d.setColor(this.m_goal.getColor());
            g2d.fillArc(this.m_paintRect.x, this.m_paintRect.y, this.m_paintRect.width, this.m_paintRect.height, 180, -180 * percent / 100);
        }
        this.m_tempRect.y += this.m_tempRect.height / 2 - this.m_tempRect.height / 35;
        this.m_tempRect.height /= 35;
        g2d.setPaint(this.getGradientPaintInner(this.m_tempRect));
        Point p2 = this.m_tempRect.getLocation();
        this.m_tempRect.setLocation(0, 0);
        this.m_tempArea.reset();
        this.m_tempRect.width /= 2;
        AffineTransform at = AffineTransform.getShearInstance(-0.5, 0.0);
        Shape shape = at.createTransformedShape(this.m_tempRect);
        at.setToTranslation(p2.x + this.m_tempRect.height / 2, p2.y + 1);
        shape = at.createTransformedShape(shape);
        this.m_tempArea.add(new Area(shape));
        at.setToShear(0.5, 0.0);
        shape = at.createTransformedShape(this.m_tempRect);
        at.setToTranslation(p2.x + this.m_tempRect.width - this.m_tempRect.height / 2, p2.y + 1);
        shape = at.createTransformedShape(shape);
        this.m_tempArea.add(new Area(shape));
        g2d.fill(this.m_tempArea);
        Font font = this.getFont().deriveFont((float)this.m_paintRect.height / 4.0f);
        font = font.deriveFont(0);
        g2d.setFont(font);
        FontMetrics fm = g2d.getFontMetrics(font);
        String str = this.m_goal.getPercent() + "%";
        str = this.m_goal.getPercent() < 10 ? " " + str : str;
        int width = SwingUtilities.computeStringWidth(fm, str);
        this.m_tempRect.setBounds(this.m_paintRect.x + this.m_paintRect.width / 2 - width / 2, this.m_paintRect.y + this.m_paintRect.height / 4 - fm.getAscent() / 2, width, fm.getHeight());
        g2d.setPaint(this.getGradientPaintPercent(this.m_tempRect));
        g2d.fillRoundRect(this.m_tempRect.x - 3, this.m_tempRect.y - 3, this.m_tempRect.width + 6, this.m_tempRect.height + 6, 10, 10);
        g2d.setComposite(this.m_composite);
        g2d.setPaint(this.getGradientPaintPercentInner(this.m_tempRect));
        g2d.setColor(this.m_goal.getColor());
        g2d.fillRoundRect(this.m_tempRect.x, this.m_tempRect.y, this.m_tempRect.width, this.m_tempRect.height, 10, 10);
        g2d.setPaint(paint);
        g2d.setComposite(composite);
        g2d.setColor(Color.BLACK);
        g2d.drawString(str, this.m_tempRect.x, this.m_tempRect.y + this.m_tempRect.height - fm.getDescent());
        g2d.setFont(this.getFont());
        font = this.getFont().deriveFont((float)this.m_paintRect.height / 10.0f);
        g2d.setFont(font);
        fm = g2d.getFontMetrics(font);
        str = this.m_goal.getName();
        this.m_tempRect.setFrame(fm.getStringBounds(str, g2d));
        this.m_tempRect.grow(12, 1);
        this.m_tempRect.setLocation(this.getWidth() / 2 - this.m_tempRect.width / 2, this.getHeight() - this.m_tempRect.height - this.m_tempRect.height / 6);
        g2d.setPaint(paint);
        g2d.setColor(Color.LIGHT_GRAY);
        g2d.drawString(str, this.m_tempRect.x + 12, this.m_tempRect.y + this.m_tempRect.height - fm.getDescent());
        g2d.setColor(Color.BLACK);
        g2d.drawString(str, this.m_tempRect.x + 12 + 1, this.m_tempRect.y + this.m_tempRect.height - fm.getDescent() + 2);
        g2d.setFont(this.getFont());
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void updateDisplay() {
        this.m_colors.clear();
        MColorSchema mcs = this.m_goal.getColorSchema();
        if (mcs != null) {
            Color lastColor = null;
            for (int i = 0; i < 100; ++i) {
                Color color = mcs.getColor(i);
                if (!color.equals(lastColor)) {
                    this.m_colors.put(i, color);
                }
                lastColor = color;
            }
        }
        StringBuilder text = new StringBuilder();
        if (this.m_goal.getDescription() != null) {
            text.append(this.m_goal.getDescription()).append(": ");
        }
        text.append(s_format.format(this.m_goal.getMeasureActual()));
        if (this.m_goal.isTarget()) {
            text.append(" ").append(Msg.getMsg(this.m_goal.getCtx(), "of")).append(" ").append(s_format.format(this.m_goal.getMeasureTarget()));
        }
        this.setToolTipText(text.toString());
        this.setBackground(this.m_goal.getColor());
        this.setForeground(GraphUtil.getForeground(this.getBackground()));
        this.invalidate();
    }
}

