/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util.ajax;

import com.ampiere.dto.Item;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

public class AjaxXmlItemBuilder {
    private String encoding = "UTF-8";
    private Map<String, String> targetInfo = new HashMap<String, String>();
    private List<Item> items = new ArrayList<Item>();

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public AjaxXmlItemBuilder putInfo(String name, String value) {
        this.targetInfo.put(name, value);
        return this;
    }

    public AjaxXmlItemBuilder addItem(String name, String value) {
        this.items.add(new Item(name, value, false));
        return this;
    }

    public AjaxXmlItemBuilder addItemAsCData(String name, String value) {
        this.items.add(new Item(name, value, true));
        return this;
    }

    public AjaxXmlItemBuilder addItems(Collection collection, String nameProperty, String valueProperty) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.addItems(collection, nameProperty, valueProperty, false);
    }

    public AjaxXmlItemBuilder addItems(Collection collection, String nameProperty, String valueProperty, boolean asCData) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        for (Object element : collection) {
            String name = BeanUtils.getProperty(element, (String)nameProperty);
            String value = BeanUtils.getProperty(element, (String)valueProperty);
            if (asCData) {
                this.items.add(new Item(name, value, false));
                continue;
            }
            this.items.add(new Item(name, value, true));
        }
        return this;
    }

    public AjaxXmlItemBuilder addItemsAsCData(Collection collection, String nameProperty, String valueProperty) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.addItems(collection, nameProperty, valueProperty, true);
    }

    public String toString() {
        StringBuffer xml = new StringBuffer().append("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            xml.append(" encoding=\"");
            xml.append(this.encoding);
            xml.append("\"");
        }
        xml.append(" ?>");
        xml.append("<ajax-response>");
        xml.append("<response>");
        xml.append(this.toStringItems(false));
        xml.append("</response>");
        xml.append("</ajax-response>");
        return xml.toString();
    }

    public String toStringItems(boolean hasTargetInfo) {
        StringBuffer xml = new StringBuffer();
        if (hasTargetInfo) {
            xml.append("<target ");
            for (Object object : this.targetInfo.keySet()) {
                xml.append(object + "=\"" + this.targetInfo.get(object) + "\" ");
            }
            xml.append(">");
        }
        for (Item item : this.items) {
            xml.append("<item>");
            xml.append("<name>");
            if (item.isAsCData()) {
                xml.append("<![CDATA[");
            }
            xml.append(item.getName());
            if (item.isAsCData()) {
                xml.append("]]>");
            }
            xml.append("</name>");
            xml.append("<value>");
            if (item.isAsCData()) {
                xml.append("<![CDATA[");
            }
            xml.append(item.getValue());
            if (item.isAsCData()) {
                xml.append("]]>");
            }
            xml.append("</value>");
            xml.append("</item>");
        }
        if (hasTargetInfo) {
            xml.append("</target>");
        }
        return xml.toString();
    }
}

