/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WWindowStatus;
import com.jware.util.StringToIntConverter;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.p;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.textarea;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MAttachment;
import org.compiere.model.MAttachmentEntry;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.FileUpload;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WAttachment
extends HttpServlet {
    private static final long serialVersionUID = 7585292696988042858L;
    private static CLogger log = CLogger.getCLogger(WAttachment.class);
    private static String UPLOAD_ACTION = "1";
    private static String SELECT_ACTION = "2";
    private static String DELETE_ACTION = "3";
    private static String EXPORT_ACTION = "4";
    private static String SAVE_ACTION = "5";
    private static String DELETE_ENTIRE_ACTION = "6";
    private static String ATTACHMENT = "attachment";
    public static final String P_Attachment_ID = "AD_Attachment_ID";
    public static final String P_ATTACHMENT_INDEX = "AttachmentIndex";
    public static final String P_TEXTMSG = "TextMsg";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WAttachment.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession(false);
        WWindowStatus ws = WWindowStatus.get(request);
        WebDoc doc = null;
        if (session == null || ws == null) {
            doc = WebDoc.createPopup("No Context");
            table bottomTable = new table("0", "0", "0", "100%", null);
            bottomTable.addElement((org.apache.ecs.Element)new tr().addElement((org.apache.ecs.Element)AmpiereUtil.createButtons(ws.ctx, false)));
            doc.getBody().addElement((org.apache.ecs.Element)bottomTable);
        } else {
            int attachmentIndex;
            String error = null;
            int AD_Attachment_ID = WebUtil.getParameterAsInt(request, P_Attachment_ID);
            if (AD_Attachment_ID != 0 && (attachmentIndex = WebUtil.getParameterAsInt(request, P_ATTACHMENT_INDEX)) != 0 && (error = this.streamAttachment(AD_Attachment_ID, attachmentIndex, response, ws)) == null) {
                return;
            }
            String actionType = WebUtil.getParameter(request, "actionType");
            if (EXPORT_ACTION.equals(actionType)) {
                AD_Attachment_ID = ws.curTab.getAD_AttachmentID();
                int attachmentIndex2 = WebUtil.getParameterAsInt(request, P_ATTACHMENT_INDEX);
                error = this.streamAttachment(AD_Attachment_ID, attachmentIndex2, response, ws);
                return;
            }
            doc = this.createPage(request, ws.ctx, ws.curTab.getAD_AttachmentID(), ws.curTab.getAD_Table_ID(), ws.curTab.getRecord_ID(), error);
        }
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        HttpSession session = request.getSession();
        WWindowStatus ws = WWindowStatus.get(request);
        WebDoc doc = null;
        if (ws == null) {
            doc = WebDoc.create("Help - No Context");
        } else {
            String actionType = WebUtil.getParameter(request, "actionType");
            int AD_Attachment_ID = ws.curTab.getAD_AttachmentID();
            int attachmentIndex = StringToIntConverter.StringToInt(WebUtil.getParameter(request, P_ATTACHMENT_INDEX));
            if (UPLOAD_ACTION.equals(actionType)) {
                String error = this.processPost(request, response, ws);
                Document xml_doc = this.getDoc(request, error);
                AWebUtil.createCalloutAjaxResponse(response, xml_doc);
                return;
            }
            if (SELECT_ACTION.equals(actionType)) {
                Document xml_doc = this.getDoc(request, null);
                AWebUtil.createCalloutAjaxResponse(response, xml_doc);
                return;
            }
            if (DELETE_ACTION.equals(actionType)) {
                String error = this.deleteAttachment(request);
                Document xml_doc = this.getDoc(request, error);
                AWebUtil.createCalloutAjaxResponse(response, xml_doc);
                return;
            }
            if (SAVE_ACTION.equals(actionType)) {
                String msg = WebUtil.getParameter(request, P_TEXTMSG);
                MAttachment attachment = (MAttachment)session.getAttribute(ATTACHMENT);
                attachment.setTextMsg(msg);
                attachment.save();
                Document xml_doc = this.getDoc(request, null);
                AWebUtil.createCalloutAjaxResponse(response, xml_doc);
                return;
            }
            if (DELETE_ENTIRE_ACTION.equals(actionType)) {
                this.deleteEntireAttachment(request);
                Document xml_doc = this.getCloseDoc(request);
                AWebUtil.createCalloutAjaxResponse(response, xml_doc);
                return;
            }
        }
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private WebDoc createPage(HttpServletRequest request, Ctx ctx, int AD_Attachment_ID, int AD_Table_ID, int Record_ID, String error) {
        HttpSession session = request.getSession();
        WebDoc doc = WebDoc.createWindow(Msg.translate(ctx, P_Attachment_ID));
        AmpiereUtil.addProcessMsg(request, doc);
        doc.getHead().addElement((org.apache.ecs.Element)new script((org.apache.ecs.Element)null, WebEnv.getBaseDirectory("js/attachment.js")));
        doc.getHead().addElement((org.apache.ecs.Element)new script((org.apache.ecs.Element)null, WebEnv.getBaseDirectory("js/search.js")));
        doc.getHead().addElement((org.apache.ecs.Element)new script((org.apache.ecs.Element)null, WebEnv.getBaseDirectory("js/protocalendar-js-1.1.0/javascripts/prototype.js")));
        doc.getHead().addElement((org.apache.ecs.Element)new script((org.apache.ecs.Element)null, WebEnv.getBaseDirectory("js/protocalendar-js-1.1.0/javascripts/effects.js")));
        table table2 = new table().setAlign("center");
        table2.setBorder(0);
        table2.setCellSpacing(5);
        doc.getBody().addElement((org.apache.ecs.Element)table2);
        form upload = new form("WAttachment", "post", "multipart/form-data");
        upload.setID("attachmentForm");
        table2.addElement((org.apache.ecs.Element)upload);
        if (error != null) {
            upload.addElement((org.apache.ecs.Element)new tr().addElement((org.apache.ecs.Element)new td("popupHeader", "right", "top", false, null)).addElement((org.apache.ecs.Element)new td("popupHeader", "left", "top", false, new p(error, "left").setClass("Cerror"))));
        }
        MAttachment attachment = null;
        attachment = AD_Attachment_ID != 0 ? new MAttachment(ctx, AD_Attachment_ID, null) : new MAttachment(ctx, AD_Table_ID, Record_ID, null);
        session.setAttribute("attachment", (Object)attachment);
        MAttachmentEntry[] entries = attachment.getEntries();
        MAttachmentEntry currentEntry = null;
        if (entries.length > 0) {
            currentEntry = entries[0];
        }
        tr tr2 = new tr();
        td left = new td();
        td right = new td("popupCenter", "left", "top", false);
        tr2.addElement((org.apache.ecs.Element)left);
        tr2.addElement((org.apache.ecs.Element)right);
        upload.addElement((org.apache.ecs.Element)tr2);
        table ltable = new table().setAlign("center");
        ltable.setBorder(0);
        ltable.setCellSpacing(0);
        left.addElement((org.apache.ecs.Element)ltable);
        td ltd1 = new td();
        ltable.addElement((org.apache.ecs.Element)new tr().addElement((org.apache.ecs.Element)ltd1));
        img deleteButton = new img(WebEnv.getImageDirectory("Delete32.png"), "Delete");
        deleteButton.setAlt("Delete");
        deleteButton.setTitle("Delete");
        deleteButton.setOnClick("deleteAttachment()");
        ltd1.addElement((org.apache.ecs.Element)deleteButton);
        img exportButton = new img(WebEnv.getImageDirectory("Export32.png"), "Export");
        exportButton.setAlt("Export");
        exportButton.setTitle("Export");
        exportButton.setOnClick("exportAttachment()");
        ltd1.addElement((org.apache.ecs.Element)exportButton);
        textarea info = new textarea("infoarea", 5, 40);
        if (currentEntry != null) {
            info.addElement(currentEntry.toStringX());
        } else {
            info.addElement("");
        }
        info.setID("infoarea");
        info.setReadOnly(true);
        td ltd2 = new td();
        ltd2.addElement((org.apache.ecs.Element)info);
        ltable.addElement((org.apache.ecs.Element)new tr().addElement((org.apache.ecs.Element)ltd2));
        table rtable = new table().setAlign("center");
        rtable.setBorder(0);
        rtable.setCellSpacing(5);
        right.addElement((org.apache.ecs.Element)rtable);
        upload.addElement((org.apache.ecs.Element)new input("hidden", P_Attachment_ID, AD_Attachment_ID));
        upload.addElement((org.apache.ecs.Element)new input("hidden", "AD_Table_ID", AD_Table_ID));
        upload.addElement((org.apache.ecs.Element)new input("hidden", "Record_ID", Record_ID));
        upload.addElement((org.apache.ecs.Element)new input("hidden", P_Attachment_ID, AD_Attachment_ID));
        upload.addElement((org.apache.ecs.Element)new input("hidden", "AD_Table_ID", AD_Table_ID));
        upload.addElement((org.apache.ecs.Element)new input("hidden", "Record_ID", Record_ID));
        p p2 = new p();
        option[] options = new option[entries.length];
        for (int i2 = 0; i2 < entries.length; ++i2) {
            MAttachmentEntry entry = entries[i2];
            options[i2] = new option(String.valueOf(i2 + 1)).addElement(entry.getName());
            if (i2 != 0) continue;
            options[i2].setSelected(true);
        }
        select entriesSelect = new select(P_ATTACHMENT_INDEX, options);
        entriesSelect.setID(P_ATTACHMENT_INDEX);
        entriesSelect.setOnChange("selectAttachment();");
        td rtd1 = new td();
        rtd1.addElement((org.apache.ecs.Element)entriesSelect);
        rtable.addElement((org.apache.ecs.Element)new tr().addElement((org.apache.ecs.Element)rtd1));
        rtable.addElement((org.apache.ecs.Element)new tr().addElement((org.apache.ecs.Element)new td().addElement("&nbsp;")));
        textarea msg = new textarea(P_TEXTMSG, 5, 40);
        msg.addElement(attachment.getTextMsg());
        msg.setID(P_TEXTMSG);
        td rtd2 = new td();
        rtd2.addElement((org.apache.ecs.Element)msg);
        rtable.addElement((org.apache.ecs.Element)new tr().addElement((org.apache.ecs.Element)rtd2));
        td uploadTd = new td();
        uploadTd.addElement(new label("File").setFor("file").setID("sourcefile"));
        uploadTd.addElement(new input("file", "file", "").setSize(40).setID("sourcefile"));
        input ok = new input("button", "upload", "Upload");
        ok.setOnClick("uploadAttachment();");
        uploadTd.addElement((org.apache.ecs.Element)ok);
        rtable.addElement((org.apache.ecs.Element)new tr().addElement((org.apache.ecs.Element)uploadTd));
        table bottomTable = new table().setAlign("center");
        bottomTable.setBorder(0);
        bottomTable.setCellSpacing(5);
        td delEntireTd = (td)new td().setClass("button-box");
        img delEntireButton = new img(WebEnv.getImageDirectory("Delete32.png"), "Delete");
        delEntireButton.setAlt("Delete Entire Attachment");
        delEntireButton.setTitle("Delete Entire Attachment");
        delEntireButton.setOnClick("deleteEntireAttachment()");
        delEntireTd.addElement((org.apache.ecs.Element)delEntireButton);
        td tdButton = (td)new td().setClass("button-box");
        input ok2 = AmpiereUtil.createImageButton(ctx, "Ok", "");
        ok2.setOnClick("saveAttachment();");
        tdButton.addElement((org.apache.ecs.Element)ok2);
        tdButton.addElement((org.apache.ecs.Element)new span("OK"));
        input cancel = AmpiereUtil.createImageButton(ctx, "Cancel", "window.opener.top.WWindow.document.WForm.PCommand.value='Refresh';window.opener.top.WWindow.document.WForm.submit();window.close();");
        tdButton.addElement((org.apache.ecs.Element)cancel);
        tdButton.addElement((org.apache.ecs.Element)new span("\u30ad\u30e3\u30f3\u30bb\u30eb"));
        tr lastTr = new tr();
        lastTr.addElement((org.apache.ecs.Element)delEntireTd);
        lastTr.addElement((org.apache.ecs.Element)tdButton);
        bottomTable.addElement((org.apache.ecs.Element)lastTr);
        doc.getBody().addElement((org.apache.ecs.Element)bottomTable);
        return doc;
    }

    private String streamAttachment(int AD_Attachment_ID, int attachmentIndex, HttpServletResponse response, WWindowStatus ws) {
        log.info("AD_Attachment_ID=" + AD_Attachment_ID + ", AttachmentIndex=" + attachmentIndex);
        MAttachment attachment = new MAttachment(ws.ctx, AD_Attachment_ID, null);
        if (attachment.get_ID() == 0) {
            log.fine("No Attachment AD_Attachment_ID=" + AD_Attachment_ID);
            return "Attachment not found";
        }
        if (ws.curTab.getAD_AttachmentID() != AD_Attachment_ID) {
            log.warning("Tab AD_Attachment_ID=" + ws.curTab.getAD_AttachmentID() + " <> " + AD_Attachment_ID);
            return "Your Attachment not found";
        }
        return WebUtil.streamAttachment(response, attachment, attachmentIndex);
    }

    private String processPost(HttpServletRequest request, HttpServletResponse response, WWindowStatus ws) {
        HttpSession session = request.getSession();
        int AD_Attachment_ID = 0;
        int AD_Table_ID = 0;
        int Record_ID = 0;
        String textMsg = null;
        FileUpload upload = null;
        if (request.getContentType().equals("application/x-www-form-urlencoded")) {
            AD_Attachment_ID = WebUtil.getParameterAsInt(request, P_Attachment_ID);
            AD_Table_ID = WebUtil.getParameterAsInt(request, "AD_Table_ID");
            Record_ID = WebUtil.getParameterAsInt(request, "Record_ID");
            textMsg = WebUtil.getParameter(request, P_TEXTMSG);
        } else {
            upload = new FileUpload(request);
            String error = upload.getError();
            if (error != null) {
                log.warning("pocessPost - " + error);
                return error;
            }
            AD_Attachment_ID = ws.curTab.getAD_AttachmentID();
            AD_Table_ID = upload.getParameterAsInt("AD_Table_ID");
            Record_ID = upload.getParameterAsInt("Record_ID");
        }
        log.info("processPost - AD_Attachment_ID=" + AD_Attachment_ID + ", AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID + " - Upload=" + upload);
        if (AD_Attachment_ID != 0 && Record_ID == 0) {
            return "Need to save record first";
        }
        MAttachment attachment = null;
        attachment = AD_Attachment_ID == 0 ? new MAttachment(ws.ctx, AD_Table_ID, Record_ID, null) : new MAttachment(ws.ctx, AD_Attachment_ID, null);
        if (textMsg != null) {
            attachment.setTextMsg(textMsg);
        }
        if (upload != null) {
            attachment.addEntry(upload.getFileName(), upload.getData());
        }
        if (attachment.getEntryCount() == 0) {
            // empty if block
        }
        if (!attachment.save()) {
            return "Attachment not saved";
        }
        ws.curTab.loadAttachments();
        session.setAttribute(ATTACHMENT, (Object)attachment);
        return null;
    }

    private String deleteAttachment(HttpServletRequest request) {
        HttpSession session = request.getSession();
        MAttachment attachment = (MAttachment)session.getAttribute(ATTACHMENT);
        attachment.deleteEntry(StringToIntConverter.StringToInt(request.getParameter(P_ATTACHMENT_INDEX)) - 1);
        attachment.save();
        session.setAttribute(ATTACHMENT, (Object)attachment);
        return null;
    }

    Document getDoc(HttpServletRequest request, String error) {
        HttpSession session = request.getSession();
        WWindowStatus ws = WWindowStatus.get(request);
        int AD_Attachment_ID = ws.curTab.getAD_AttachmentID();
        MAttachment attachment = (MAttachment)session.getAttribute(ATTACHMENT);
        MAttachmentEntry[] entries = attachment.getEntries();
        int attachmentIndex = WebUtil.getParameterAsInt(request, P_ATTACHMENT_INDEX);
        if (attachmentIndex > entries.length) {
            attachmentIndex = entries.length;
        }
        if (attachmentIndex > 0) {
            --attachmentIndex;
        }
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
            Element element = document.createElement("element");
            elements.appendChild(element);
            Element elm_id = document.createElement("id");
            elm_id.appendChild(document.createTextNode(P_ATTACHMENT_INDEX));
            element.appendChild(elm_id);
            Element elm_lookup = document.createElement("lookup");
            element.appendChild(elm_lookup);
            elm_lookup.appendChild(document.createTextNode("1"));
            Element elm_newValue = document.createElement("newValue");
            element.appendChild(elm_newValue);
            for (int i2 = 0; i2 < entries.length; ++i2) {
                Element elm_item = document.createElement("item");
                elm_newValue.appendChild(elm_item);
                MAttachmentEntry entry = entries[i2];
                String key = String.valueOf(i2 + 1);
                String value = entry.getName();
                Element elm_key = document.createElement("key");
                elm_item.appendChild(elm_key);
                elm_key.appendChild(document.createTextNode(String.valueOf(key)));
                Element elm_value = document.createElement("value");
                elm_item.appendChild(elm_value);
                elm_value.appendChild(document.createTextNode(value));
            }
            Element element2 = document.createElement("element");
            elements.appendChild(element2);
            Element elm_id2 = document.createElement("id");
            elm_id2.appendChild(document.createTextNode("infoarea"));
            element2.appendChild(elm_id2);
            Element elm_lookup2 = document.createElement("lookup");
            element2.appendChild(elm_lookup2);
            elm_lookup2.appendChild(document.createTextNode("0"));
            Element elm_newValue2 = document.createElement("newValue");
            element2.appendChild(elm_newValue2);
            String newValue_str2 = "";
            try {
                newValue_str2 = entries[attachmentIndex].toStringX();
            }
            catch (Exception e) {
                // empty catch block
            }
            elm_newValue2.appendChild(document.createTextNode(newValue_str2));
            Element element3 = document.createElement("element");
            elements.appendChild(element3);
            Element elm_id3 = document.createElement("id");
            elm_id3.appendChild(document.createTextNode(P_TEXTMSG));
            element3.appendChild(elm_id3);
            Element elm_lookup3 = document.createElement("lookup");
            element3.appendChild(elm_lookup3);
            elm_lookup3.appendChild(document.createTextNode("0"));
            Element elm_newValue3 = document.createElement("newValue");
            element3.appendChild(elm_newValue3);
            String newValue_str3 = "";
            if (!StringUtils.isEmpty(attachment.getTextMsg())) {
                newValue_str3 = attachment.getTextMsg();
            }
            elm_newValue3.appendChild(document.createTextNode(newValue_str3));
            Element element4 = document.createElement("element");
            elements.appendChild(element4);
            Element elm_id4 = document.createElement("id");
            elm_id4.appendChild(document.createTextNode("AttachmentSelectedIndex"));
            element4.appendChild(elm_id4);
            Element elm_lookup4 = document.createElement("lookup");
            element4.appendChild(elm_lookup4);
            elm_lookup4.appendChild(document.createTextNode("0"));
            Element elm_newValue4 = document.createElement("newValue");
            element4.appendChild(elm_newValue4);
            int selectedIndex = WebUtil.getParameterAsInt(request, P_ATTACHMENT_INDEX);
            if (selectedIndex <= 0) {
                selectedIndex = 1;
            } else if (selectedIndex > entries.length) {
                selectedIndex = entries.length;
            }
            String newValue_str4 = String.valueOf(selectedIndex);
            elm_newValue4.appendChild(document.createTextNode(newValue_str4));
            if (!StringUtils.isEmpty(error)) {
                Element element5 = document.createElement("element");
                elements.appendChild(element5);
                Element elementScript = document.createElement("script");
                element5.appendChild(elementScript);
                elementScript.appendChild(document.createTextNode(error));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    private void deleteEntireAttachment(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WWindowStatus ws = WWindowStatus.get(request);
        MAttachment m_attachment = (MAttachment)session.getAttribute(ATTACHMENT);
        m_attachment.delete(true);
        session.setAttribute(ATTACHMENT, null);
        ws.curTab.loadAttachments();
    }

    Document getCloseDoc(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WWindowStatus ws = WWindowStatus.get(request);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
            Element element = document.createElement("element");
            elements.appendChild(element);
            Element elm_id = document.createElement("closeWindow");
            elm_id.appendChild(document.createTextNode("closeWindow"));
            element.appendChild(elm_id);
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }
}

