/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WWindowStatus;
import com.jware.util.StringToIntConverter;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WBPartner
extends HttpServlet {
    private static final long serialVersionUID = 6617424544044122702L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String NAME = "BPartner";

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WProcess.init");
        }
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = this.createBPartnerPage(request);
        if (doc == null) {
            doc = WebDoc.createWindow("Error");
        }
        doc.getBody().setOnUnload("closeMyChildren();");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        MBPartner m_partner = null;
        int C_BPartner_ID = StringToIntConverter.StringToInt(WebUtil.getParameter(request, "C_BPartner_ID"));
        if (C_BPartner_ID != 0) {
            m_partner = new MBPartner(ws.ctx, C_BPartner_ID, null);
        }
        if (m_partner == null) {
            int m_WindowNo = 0;
            int AD_Client_ID = ws.ctx.getAD_Client_ID();
            m_partner = MBPartner.getTemplate(ws.ctx, AD_Client_ID);
            boolean isSOTrx = ws.ctx.isSOTrx(m_WindowNo);
            m_partner.setIsCustomer(isSOTrx);
            m_partner.setIsVendor(!isSOTrx);
        }
        this.actionSave(request, m_partner);
        WebDoc doc = WebDoc.createWindow(Msg.getMsg(ws.ctx, NAME));
        doc.getBody().setOnLoad("updateParentBPartner('" + m_partner.getC_BPartner_ID() + "','" + m_partner.getName() + "');return false;");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    private WebDoc createBPartnerPage(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String bpartner_id = WebUtil.getParameter(request, "bpartnerID");
        boolean newRecord = StringUtils.isEmpty(bpartner_id);
        String columnName = WebUtil.getParameter(request, "columnName");
        int m_WindowNo = ws.mWindow.getWindowNo();
        boolean m_readOnly = !MRole.getDefault(wsc.ctx, false).canUpdate(ws.ctx.getAD_Client_ID(), ws.ctx.getAD_Org_ID(), 291, 0, false);
        int C_BPartner_ID = 0;
        if (!newRecord) {
            C_BPartner_ID = StringToIntConverter.StringToInt(bpartner_id);
        }
        WebDoc doc = WebDoc.createWindow(Msg.getMsg(ws.ctx, NAME));
        form myForm = new form(request.getRequestURI());
        myForm.setID("WBPartner");
        table myTable = new table();
        myTable.setAlign("CENTER");
        div divBody = (div)new div().setID("body");
        divBody.addElement((Element)myTable);
        String V_searchKey = "";
        String V_Greeting = "";
        String V_Name = "";
        String V_Name2 = "";
        String V_Contact = "";
        String V_GreetingC = "";
        String V_Title = "";
        String V_EMail = "";
        String V_C_Location_ID = "";
        String V_C_Location_Display = "";
        String V_Phone = "";
        String V_Phone2 = "";
        String V_Fax = "";
        if (C_BPartner_ID != 0) {
            MUser m_user;
            MBPartner m_partner = new MBPartner(ws.ctx, C_BPartner_ID, null);
            V_searchKey = m_partner.getValue();
            V_Greeting = String.valueOf(m_partner.getC_Greeting_ID());
            V_Name = m_partner.getName();
            V_Name2 = m_partner.getName2();
            MBPartnerLocation m_pLocation = m_partner.getLocation(ws.ctx.getContextAsInt(m_WindowNo, "C_BPartner_Location_ID"));
            if (m_pLocation != null) {
                int location = m_pLocation.getC_Location_ID();
                V_C_Location_ID = String.valueOf(new Integer(location));
                String tmp = m_pLocation.toString();
                V_C_Location_Display = m_pLocation.getLocation(true).toString();
                V_Phone = m_pLocation.getPhone();
                V_Phone2 = m_pLocation.getPhone2();
                V_Fax = m_pLocation.getFax();
            }
            if ((m_user = m_partner.getContact(ws.ctx.getContextAsInt(m_WindowNo, "AD_User_ID"))) != null) {
                V_GreetingC = String.valueOf(m_user.getC_Greeting_ID());
                V_Contact = m_user.getName();
                V_Title = m_user.getTitle();
                V_EMail = m_user.getEMail();
                V_Phone = m_user.getPhone();
                V_Phone2 = m_user.getPhone2();
                V_Fax = m_user.getFax();
            }
        }
        input hiddBpartnerId = new input("hidden", "C_BPartner_ID", C_BPartner_ID);
        hiddBpartnerId.setID("C_BPartner_ID");
        myForm.addElement((Element)hiddBpartnerId);
        tr myTr = new tr((Element)new td("&nbsp;").setColSpan(2));
        myTable.addElement((Element)this.getStringTr(request, "Value", "searchKey", V_searchKey));
        myTable.addElement((Element)this.getSelectTr(request, "Greeting", "Greeting", V_Greeting));
        myTable.addElement((Element)this.getStringTr(request, "Name", "Name", V_Name));
        myTable.addElement((Element)this.getStringTr(request, "Name2", "Name2", V_Name2));
        myTable.addElement((Element)this.getStringTr(request, "Contact", "Contact", V_Contact));
        myTable.addElement((Element)this.getSelectTr(request, "Greeting", "GreetingC", V_GreetingC));
        myTable.addElement((Element)this.getStringTr(request, "Title", "Title", V_Title));
        myTable.addElement((Element)this.getStringTr(request, "EMail", "EMail", V_EMail));
        boolean ro = m_readOnly;
        if (!ro) {
            boolean bl = ro = !MRole.getDefault(wsc.ctx, false).canUpdate(ws.ctx.getAD_Client_ID(), ws.ctx.getAD_Org_ID(), 293, 0, false);
        }
        if (!ro) {
            ro = !MRole.getDefault(wsc.ctx, false).canUpdate(ws.ctx.getAD_Client_ID(), ws.ctx.getAD_Org_ID(), 162, 0, false);
        }
        myTable.addElement((Element)this.getLocationField(request, "C_Location_ID", V_C_Location_Display, "C_Location_ID", V_C_Location_ID));
        myTable.addElement((Element)this.getStringTr(request, "Phone", "Phone", V_Phone));
        myTable.addElement((Element)this.getStringTr(request, "Phone2", "Phone2", V_Phone2));
        myTable.addElement((Element)this.getStringTr(request, "Fax", "Fax", V_Fax));
        div divButtonBox = (div)new div().setClass("button-box");
        img cancel = new img(WebEnv.getImageDirectory("Cancel32.png"), "Cancel");
        cancel.setOnClick("window.close(); return false;");
        divButtonBox.addElement((Element)cancel);
        cancel.setID("btn_cancel");
        input submit = new input("image", "btn_submit", "OK");
        submit.setSrc(WebEnv.getImageDirectory("Ok32.png"));
        submit.setID("btn_submit");
        submit.setOnClick("checkBPartner();return false;");
        divButtonBox.addElement((Element)submit);
        myTr = new tr();
        myTable.addElement((Element)myTr);
        myTr.addElement((Element)new td());
        td buttonTd = new td();
        buttonTd.setAlign("right");
        buttonTd.addElement((Element)divButtonBox);
        myTr.addElement((Element)buttonTd);
        myForm.addElement((Element)divBody);
        doc.getBody().addElement((Element)myForm);
        return doc;
    }

    public tr getStringTr(HttpServletRequest request, String lableName, String textName, String value) {
        WWindowStatus ws = WWindowStatus.get(request);
        tr myTr = new tr();
        myTr.addElement((Element)new td().addElement(Msg.translate(ws.ctx, lableName)));
        input inputbox = new input("text", textName, value);
        inputbox.setID(textName);
        inputbox.setSize(64);
        myTr.addElement((Element)new td().addElement((Element)inputbox));
        return myTr;
    }

    private tr getSelectTr(HttpServletRequest request, String labelName, String selName, String value) {
        WWindowStatus ws = WWindowStatus.get(request);
        tr myTr = new tr();
        String sql = "SELECT C_Greeting_ID, Name FROM C_Greeting WHERE IsActive='Y' ORDER BY 2";
        sql = MRole.getDefault(ws.ctx, true).addAccessSQL(sql, "C_Greeting", false, false);
        KeyNamePair[] list = DB.getKeyNamePairs(sql, true);
        option[] options = new option[list.length];
        int selectedIndex = -1;
        for (int i2 = 0; i2 < list.length; ++i2) {
            KeyNamePair p2 = list[i2];
            options[i2] = new option(String.valueOf(p2.getKey())).addElement(p2.getName());
            if (StringToIntConverter.StringToInt(value) != p2.getKey()) continue;
            options[i2].setSelected(true);
        }
        select sel = new select(selName, options);
        sel.setID(selName);
        myTr.addElement((Element)new td().addElement(Msg.translate(ws.ctx, labelName)));
        td selTd = new td().addElement((Element)sel).setAlign("left").setVAlign("top");
        selTd.setID(selName);
        myTr.addElement((Element)selTd);
        return myTr;
    }

    private tr getLocationField(HttpServletRequest request, String labelName, String dataDisplay, String m_columnName, String dataValue) {
        WWindowStatus ws = WWindowStatus.get(request);
        int m_windowNo = ws.mWindow.getWindowNo();
        tr myTr = new tr();
        myTr.addElement((Element)new td().addElement(Msg.translate(ws.ctx, labelName)));
        input hidden = new input("hidden", m_columnName, dataValue);
        hidden.setID(m_columnName + "D");
        input display = new input("text", m_columnName + "F", AmpiereUtil.maskHtmlCR(dataDisplay));
        display.setID(m_columnName + "F");
        int m_displayLength = 50;
        display.setSize(m_displayLength);
        display.setSize(60);
        img button2 = null;
        String gif = "Location16.gif";
        button2 = new img(WebEnv.getImageDirectory(gif), m_columnName);
        button2.setID(m_columnName + "B");
        button2.setClass("popupButton");
        String onClick = "";
        String AD_Column_ID = "0";
        String col = "dummy";
        if (StringUtils.isEmpty(dataValue)) {
            dataValue = "0";
        }
        onClick = "startLocation('" + m_columnName + "'," + m_windowNo + "," + dataValue + ",'" + col + "',null);";
        display.setReadOnly(true);
        button2.setOnClick(onClick + "return false;");
        td tdLocation = new td().addElement((Element)hidden).addElement((Element)display).addElement((Element)button2);
        myTr.addElement((Element)tdLocation);
        return myTr;
    }

    private boolean actionSave(HttpServletRequest request, MBPartner m_partner) {
        WWindowStatus ws = WWindowStatus.get(request);
        int m_WindowNo = ws.mWindow.getWindowNo();
        if (m_partner == null) {
            int AD_Client_ID = ws.ctx.getAD_Client_ID();
            m_partner = MBPartner.getTemplate(ws.ctx, AD_Client_ID);
            boolean isSOTrx = ws.ctx.isSOTrx(m_WindowNo);
            m_partner.setIsCustomer(isSOTrx);
            m_partner.setIsVendor(!isSOTrx);
        }
        String V_searchKey = WebUtil.getParameter(request, "searchKey");
        String V_Greeting = WebUtil.getParameter(request, "Greeting");
        String V_Name = WebUtil.getParameter(request, "Name");
        String V_Name2 = WebUtil.getParameter(request, "Name2");
        String V_Contact = WebUtil.getParameter(request, "Contact");
        String V_GreetingC = WebUtil.getParameter(request, "GreetingC");
        String V_Title = WebUtil.getParameter(request, "Title");
        String V_EMail = WebUtil.getParameter(request, "EMail");
        String V_C_Location_ID = WebUtil.getParameter(request, "C_Location_ID");
        String V_C_Location_Display = WebUtil.getParameter(request, "");
        String V_Phone = WebUtil.getParameter(request, "Phone");
        String V_Phone2 = WebUtil.getParameter(request, "Phone2");
        String V_Fax = WebUtil.getParameter(request, "Fax");
        String value = V_searchKey;
        if (value == null || value.length() == 0) {
            value = DB.getDocumentNo(ws.ctx.getAD_Client_ID(), "C_BPartner", null);
        }
        m_partner.setValue(value);
        m_partner.setName(V_Name);
        m_partner.setName2(V_Name2);
        m_partner.setC_Greeting_ID(StringToIntConverter.StringToInt(V_Greeting));
        m_partner.save();
        MBPartnerLocation m_pLocation = m_partner.getLocation(ws.ctx.getContextAsInt(m_WindowNo, "C_BPartner_Location_ID"));
        if (m_pLocation == null) {
            m_pLocation = new MBPartnerLocation(m_partner);
        }
        m_pLocation.setC_Location_ID(StringToIntConverter.StringToInt(V_C_Location_ID));
        m_pLocation.setPhone(V_Phone);
        m_pLocation.setPhone2(V_Phone2);
        m_pLocation.setFax(V_Fax);
        if (m_pLocation.save()) {
            this.log.fine("C_BPartner_Location_ID=" + m_pLocation.getC_BPartner_Location_ID());
        }
        String contact = V_Contact;
        String email = V_EMail;
        MUser m_user = m_partner.getContact(ws.ctx.getContextAsInt(m_WindowNo, "AD_User_ID"));
        if (m_user == null && (contact.length() > 0 || email.length() > 0)) {
            m_user = new MUser(m_partner);
        }
        if (m_user != null) {
            if (contact.length() == 0) {
                contact = V_Name;
            }
            m_user.setName(contact);
            m_user.setEMail(email);
            m_user.setTitle(V_Title);
            m_user.setC_Greeting_ID(StringToIntConverter.StringToInt(V_GreetingC));
            m_user.setPhone(V_Phone);
            m_user.setPhone2(V_Phone2);
            m_user.setFax(V_Fax);
            if (m_user.save()) {
                this.log.fine("AD_User_ID=" + m_user.getAD_User_ID());
            }
        }
        return true;
    }
}

