/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.FileUpload;
import com.ampiere.web.servlet.WWindowStatus;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.impexp.ImpFormat;
import org.compiere.impexp.ImpFormatRow;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Msg;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFileImport
extends HttpServlet {
    private static final long serialVersionUID = 7585292696988042858L;
    private static CLogger log = CLogger.getCLogger(WFileImport.class);
    public static final String M_DATA = "m_data";
    public static final String ACTION_TYPE = "actionType";
    public static final String B_FILE = "1";
    public static final String PICK_FORMAT = "2";
    public static final String B_NEXT = "3";
    public static final String B_PREV = "4";
    public static final String A_OK = "5";
    public static final String s_none = "----";
    public static final String M_RECORD = "m_record";
    public static final String M_LABELS = "m_labels";
    public static final String M_FIELDS = "m_fields";
    public static final String M_FORMAT = "m_format";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WAttachment.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        log.info("From " + request.getRemoteHost() + " - " + request.getRemoteAddr());
        WWindowStatus ws = WWindowStatus.get(request);
        String actionType = request.getParameter(ACTION_TYPE);
        if (B_FILE.equals(actionType)) {
            ArrayList<String> response_array = this.cmd_loadFile(request);
            Document responseDocument = WFileImport.generateContentXML(request, response_array);
            WFileImport.createAjaxResponse(response, responseDocument);
        } else if (PICK_FORMAT.equals(actionType)) {
            Document doc = this.cmd_loadFormat(request);
            WFileImport.createAjaxResponse(response, doc);
        } else if (B_NEXT.equals(actionType)) {
            Document doc = this.cmd_applyFormat(request, true);
            WFileImport.createAjaxResponse(response, doc);
        } else if (B_PREV.equals(actionType)) {
            Document doc = this.cmd_applyFormat(request, false);
            WFileImport.createAjaxResponse(response, doc);
        } else if (A_OK.equals(actionType)) {
            String msg = this.cmd_process(request);
            response.setContentType("text/html; charset=UTF-8");
            response.getOutputStream().print(msg);
        }
    }

    private ArrayList<String> cmd_loadFile(HttpServletRequest request) {
        ArrayList<String> m_data = new ArrayList<String>();
        FileUpload upload = null;
        upload = new FileUpload(request, 2000);
        String error = upload.getError();
        if (error != null) {
            log.warning("cmd_loadFile - " + error);
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(upload.getData()), "UTF-8"));
            String s = null;
            while ((s = in.readLine()) != null) {
                m_data.add(s);
            }
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        request.getSession().setAttribute(M_DATA, m_data);
        return m_data;
    }

    public static void setResponse(HttpServletResponse response, ArrayList<String> response_array) {
        response.addHeader("pragma", "no-store,no-cache");
        response.addHeader("cache-control", "no-cache, no-store,must-revalidate, max-age=-1");
        response.addHeader("expires", "-1");
        try {
            response.getOutputStream().print(WFileImport.generateResponseText(response_array));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String generateResponseText(ArrayList<String> arr) throws UnsupportedEncodingException {
        String resp_arr = "";
        String split_arr = "**";
        for (int i2 = 0; i2 < arr.size(); ++i2) {
            if (i2 != 0) {
                resp_arr = resp_arr + "</br>";
            }
            resp_arr = resp_arr + arr.get(i2);
        }
        return resp_arr;
    }

    public static Document generateContentXML(HttpServletRequest request, ArrayList<String> arr) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("lines");
            document.appendChild(elements);
            StringBuffer contentBuffer = new StringBuffer();
            for (int i2 = 0; i2 < arr.size(); ++i2) {
                if (i2 != 0) {
                    contentBuffer.append("\n");
                }
                contentBuffer.append(arr.get(i2));
            }
            Element element = document.createElement("line");
            String limitedContent = contentBuffer.toString();
            int responseLimit = 4000;
            if (limitedContent != null && limitedContent.length() > 4000) {
                limitedContent = limitedContent.substring(0, 4000);
            }
            element.appendChild(document.createTextNode(limitedContent));
            elements.appendChild(element);
            ArrayList m_data = (ArrayList)request.getSession().getAttribute(M_DATA);
            int index = 1;
            if (m_data.size() == 1) {
                index = 0;
            }
            int length = 0;
            if (m_data.size() > 0) {
                length = ((String)m_data.get(index)).toString().length();
            }
            Element msg = document.createElement("msg");
            WebSessionCtx wsc = WebSessionCtx.get(request);
            Ctx ctx = wsc.ctx;
            String msg_str = Msg.getMsg(ctx, "Records") + "=" + m_data.size() + ", " + Msg.getMsg(ctx, "Length") + "=" + length + "   ";
            msg.appendChild(document.createTextNode(msg_str));
            elements.appendChild(msg);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    public static void createAjaxResponse(HttpServletResponse response, Document document) throws IOException {
        response.setContentType("text/xml; charset=UTF-8");
        response.addHeader("pragma", "no-store,no-cache");
        response.addHeader("cache-control", "no-cache, no-store,must-revalidate, max-age=-1");
        response.addHeader("expires", "-1");
        PrintWriter out = null;
        out = response.getWriter();
        try {
            System.setProperty("javax.xml.transform.TransformerFactory", "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", PICK_FORMAT);
            transformer.transform(new DOMSource(document), new StreamResult(out));
            File outfile = new File("D:/test.xml");
            transformer.transform(new DOMSource(document), new StreamResult(outfile));
        }
        catch (Exception e) {
            log.warning("error---- createCalloutAjaxResponse");
        }
    }

    private Document cmd_loadFormat(HttpServletRequest request) {
        HttpSession session = request.getSession();
        String formatName = request.getParameter("impFormat");
        if (formatName.equals(s_none)) {
            return null;
        }
        ImpFormat m_format = ImpFormat.load(formatName);
        if (m_format == null) {
            return null;
        }
        int size = m_format.getRowCount();
        String[] m_labels = new String[size];
        String[] m_fields = new String[size];
        for (int i2 = 0; i2 < size; ++i2) {
            ImpFormatRow row = m_format.getRow(i2);
            m_labels[i2] = row.getColumnName();
            int length = row.getEndNo() - row.getStartNo();
            if (length <= 5) {
                length = 5;
            } else if (length > 20) {
                length = 20;
            }
            m_fields[i2] = "";
        }
        int m_record = -1;
        session.setAttribute(M_RECORD, (Object)m_record);
        session.setAttribute(M_LABELS, (Object)m_labels);
        session.setAttribute(M_FIELDS, (Object)m_fields);
        session.setAttribute(M_FORMAT, (Object)m_format);
        return WFileImport.generateFieldsXML(request, m_labels, m_fields, "-");
    }

    public static Document generateFormatXML(HttpServletRequest request, String[] m_labels, String[] m_fields) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("fields");
            document.appendChild(elements);
            StringBuffer contentBuffer = new StringBuffer();
            for (int i2 = 0; i2 < m_labels.length; ++i2) {
                Element element = document.createElement("field");
                Element label2 = document.createElement("key");
                label2.appendChild(document.createTextNode(m_labels[i2]));
                element.appendChild(label2);
                Element text = document.createElement("value");
                text.appendChild(document.createTextNode(m_fields[i2]));
                element.appendChild(text);
                elements.appendChild(element);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    public static Document generateFieldsXML(HttpServletRequest request, String[] m_labels, String[] m_fields, String recordNum) {
        td td2;
        int i2;
        table table2 = new table();
        tr first = new tr();
        tr second = new tr();
        for (i2 = 0; i2 < m_labels.length; ++i2) {
            td2 = new td();
            td2.addElement(m_labels[i2]);
            first.addElement((org.apache.ecs.Element)td2);
        }
        table2.addElement((org.apache.ecs.Element)first);
        for (i2 = 0; i2 < m_fields.length; ++i2) {
            td2 = new td();
            input text = new input("text", m_labels[i2], m_fields[i2]);
            td2.addElement((org.apache.ecs.Element)text);
            second.addElement((org.apache.ecs.Element)td2);
        }
        table2.addElement((org.apache.ecs.Element)second);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
            Element html = document.createElement("html");
            html.appendChild(document.createTextNode(table2.toString()));
            elements.appendChild(html);
            Element recordNumObj = document.createElement("recordNum");
            recordNumObj.appendChild(document.createTextNode(recordNum));
            elements.appendChild(recordNumObj);
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    private Document cmd_applyFormat(HttpServletRequest request, boolean next) {
        HttpSession session = request.getSession();
        ImpFormat m_format = (ImpFormat)session.getAttribute(M_FORMAT);
        int m_record = (Integer)session.getAttribute(M_RECORD);
        ArrayList m_data = (ArrayList)request.getSession().getAttribute(M_DATA);
        String[] m_labels = (String[])session.getAttribute(M_LABELS);
        String[] m_fields = (String[])session.getAttribute(M_FIELDS);
        if (m_format == null) {
            return null;
        }
        if (m_data == null) {
            return null;
        }
        m_record = next ? ++m_record : --m_record;
        if (m_record < 0) {
            m_record = 0;
        } else if (m_record >= m_data.size()) {
            m_record = m_data.size() - 1;
        }
        session.setAttribute(M_RECORD, (Object)m_record);
        String[] lInfo = m_format.parseLine(((String)m_data.get(m_record)).toString(), false, true, false);
        int size = m_format.getRowCount();
        if (lInfo.length != size) {
            log.log(Level.SEVERE, "FormatElements=" + size + " != Fields=" + lInfo.length);
        }
        for (int i2 = 0; i2 < size; ++i2) {
            m_fields[i2] = lInfo[i2];
        }
        return WFileImport.generateFieldsXML(request, m_labels, m_fields, String.valueOf(m_record));
    }

    private String cmd_process(HttpServletRequest request) {
        HttpSession session = request.getSession();
        ImpFormat m_format = (ImpFormat)session.getAttribute(M_FORMAT);
        ArrayList m_data = (ArrayList)request.getSession().getAttribute(M_DATA);
        if (m_format == null) {
            return null;
        }
        WebSessionCtx wsc = WebSessionCtx.get(request);
        Ctx ctx = wsc.ctx;
        int row = 0;
        int imported = 0;
        for (row = 0; row < m_data.size(); ++row) {
            if (!m_format.updateDB(ctx, ((String)m_data.get(row)).toString(), null)) continue;
            ++imported;
        }
        StringBuffer out = new StringBuffer();
        String AD_Message = "FileImportR/I";
        String msg = row + " / " + imported + "#";
        if (AD_Message != null && !AD_Message.equals("")) {
            out.append(Msg.getMsg(ctx, AD_Message));
        }
        if (msg != null && msg.length() > 0) {
            out.append("\n").append(msg);
        }
        return out.toString();
    }
}

