/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AdvancedRow;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WFind;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.servlet.WebField;
import com.jware.util.StringToIntConverter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.li;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.apache.ecs.xhtml.ul;
import org.compiere.framework.Lookup;
import org.compiere.framework.Query;
import org.compiere.model.GridField;
import org.compiere.model.MLocator;
import org.compiere.model.MRole;
import org.compiere.model.MUserQuery;
import org.compiere.model.MUserQueryLine;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WFindAdvanced
extends HttpServlet {
    private static final long serialVersionUID = 6617424544044122702L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String ERROR = " ERROR! ";
    private int TABNO = 99;
    private String QUERY_ENTRY_DIV = "queryEntryDiv";
    private String SAVED_QUERY_LOAD_ACTION = "1";
    private String SAVED_QUERY_DELETE_ACTION = "2";
    private String COLUMN_ACTION = "3";
    private String OPERATOR_ACTION = "4";
    private String DELETE_ROW_ACTION = "5";
    private String SAVE_ROW_ACTION = "6";
    private String REFRESH_ACTION = "7";
    private String OK_ACTION = "8";
    private String COLUMN_ID = "columnId";
    private String OPERATOR_ID = "operatorId";
    private String QUERY_VALUE_1 = "queryValue1";
    private String QUERY_VALUE_2 = "queryValue2";
    private String QUERY_VALUE_DISPLAY_1 = "queryValueDisplay1";
    private String QUERY_VALUE_DISPLAY_2 = "queryValueDisplay2";
    private String QUERY_DISPLAY_1 = "queryDisplay1";
    private String QUERY_DISPLAY_2 = "queryDisplay2";
    private String QUERY_ID = "queryId";
    private String QUERY_NAME = "queryName";
    private String QUERY_ENTRY_INDEX = "queryEntryIndex";
    private String DELETE_ROW_BUTTON = "deleteRowButton";
    private String SAVE_ROW_BUTTON = "saveRowButton";
    private String DELETE_QUERY_BUTTON = "delteQueryButton";
    private String ADVANCED_DATA = "advancedData";
    private int DEFAULT_DISPLAY_LENGTH = 160;
    private String RETURN_FALSE = "return false;";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WProcess.init");
        }
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WebDoc doc = this.createFindPage(request);
        session.setAttribute(this.ADVANCED_DATA, null);
        if (doc == null) {
            doc = WebDoc.createWindow("Error");
        }
        doc.getBody().setOnUnload("closeMyChildren();");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        Document xml_doc = this.processAction(request);
        AWebUtil.createCalloutAjaxResponse(response, xml_doc);
    }

    private WebDoc createFindPage(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        WebDoc doc = WebDoc.createWindow(ws.mWindow.getName() + " - " + ws.curTab.getName());
        AmpiereUtil.addProcessMsg(request, doc);
        this.addTabFind(request, doc);
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        doc.getHead().addElement((org.apache.ecs.Element)new script((org.apache.ecs.Element)null, WebEnv.getBaseDirectory("js/findAdvanced.js")));
        doc.getHead().addElement((org.apache.ecs.Element)new script((org.apache.ecs.Element)null, WebEnv.getBaseDirectory("js/search.js")));
        String actionName = request.getRequestURI();
        int pos = actionName.indexOf("Advanced");
        actionName = actionName.substring(0, pos);
        form myForm = new form(actionName);
        myForm.setName("findAdvancedForm");
        myForm.setID("findAdvancedForm");
        div divBody = (div)new div().setID("body");
        this.addSavedQueryTable(request, divBody);
        this.addAdvancedEntry(request, divBody);
        this.addValueEditor(request, divBody);
        this.addButtons(request, divBody);
        table myTable = new table();
        myTable.setAlign("CENTER");
        divBody.addElement((org.apache.ecs.Element)myTable);
        table historyTable = WFind.getHistoryTable(request);
        divBody.addElement((org.apache.ecs.Element)historyTable);
        myForm.addElement((org.apache.ecs.Element)divBody);
        doc.getBody().addElement((org.apache.ecs.Element)myForm);
        return doc;
    }

    private void addField(WebSessionCtx wsc, tr line, GridField field, Object oData, boolean hasDependents, boolean readOnly) {
        String columnName = field.getColumnName();
        Object data = oData;
        boolean error = field.isErrorValue();
        if (error) {
            this.log.log(Level.SEVERE, oData.toString());
            data = field.getErrorValue();
        }
        int dt = field.getDisplayType();
        boolean hasCallout = field.getCallout().length() > 0;
        int display_length = field.getDisplayLength();
        display_length = display_length > 500 ? 550 : 200;
        WebField wField = new WebField(field.getWindowNo(), wsc, columnName, field.getHeader(), field.getDescription(), dt, field.getFieldLength(), display_length, field.isLongField(), readOnly, field.isMandatory(false), error, hasDependents, hasCallout, field.getAD_Process_ID(), field.isEncryptedField());
        line.addElement((org.apache.ecs.Element)wField.getLabel());
        line.addElement((org.apache.ecs.Element)wField.getField(field.getLookup(), data, field.getAD_Column_ID()));
    }

    void addTabFind(HttpServletRequest request, WebDoc doc) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String msgFind = Msg.getMsg(wsc.ctx, "Find");
        String msgFindAdvanced = Msg.getMsg(wsc.ctx, "Advanced");
        div tabbar = (div)new div().setID("menu_tab");
        ul tabTable = new ul();
        boolean currentTab = false;
        for (int i2 = 0; i2 < 2; ++i2) {
            String tabMouseOver = "";
            String tabMouseOut = "";
            String tabLeftId = "tabLeftId_" + Integer.toString(i2);
            String tabRightId = "tabRightId_" + Integer.toString(i2);
            String tabLeftClass = "tabLeft";
            String tabRightClass = "tabRight";
            span big = i2 == 0 ? new span(msgFind) : new span(msgFindAdvanced);
            if (1 == i2) {
                big.setClass("tabSelected");
                tabLeftClass = tabLeftClass + "Sel";
                tabRightClass = tabRightClass + "Sel";
                currentTab = true;
            } else {
                big.setClass("tab");
                big.setOnClick("window.location.href = 'WFind?windowId=" + ws.getCurTab().getAD_Window_ID() + "&windowNo=" + ws.getCurTab().getWindowNo() + "'");
                tabMouseOver = "tabMouseOver('" + tabLeftId + "', '" + tabRightId + "');";
                tabMouseOut = "tabMouseOut('" + tabLeftId + "', '" + tabRightId + "');";
            }
            if (i2 != 1) {
                currentTab = false;
            }
            span tabTdLeft = new span(WebEnv.NBSP);
            tabTdLeft.setClass(tabLeftClass);
            li tabTdRight = (li)new li().setClass(tabRightClass);
            tabTdLeft.setID(tabLeftId);
            tabTdRight.setID(tabRightId);
            tabMouseOver = i2 == 0 ? tabMouseOver + "status='" + msgFind + "';return true;" : tabMouseOver + "status='" + msgFindAdvanced + "';return true;";
            if (tabMouseOver != null && !"".equals(tabMouseOver)) {
                big.setOnMouseOver(tabMouseOver);
            }
            if (tabMouseOut != null && !"".equals(tabMouseOut)) {
                tabMouseOut = tabMouseOut + "status='" + ws.curTab.getName() + "';return true;";
                big.setOnMouseOut(tabMouseOut);
            }
            tabTable.addElement((org.apache.ecs.Element)tabTdRight);
            tabTdRight.addElement((org.apache.ecs.Element)tabTdLeft);
            tabTdRight.addElement((org.apache.ecs.Element)big);
            tabTdRight.setStyle("");
        }
        tabbar.addElement((org.apache.ecs.Element)tabTable);
        doc.getBody().addElement((org.apache.ecs.Element)tabbar);
    }

    private ArrayList<ValueNamePair> getSavedQueryList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int m_AD_Tab_ID = ws.curTab.getAD_Tab_ID();
        int m_AD_Table_ID = ws.curTab.getAD_Table_ID();
        ArrayList<ValueNamePair> savedQueryList = new ArrayList<ValueNamePair>();
        ValueNamePair pp = new ValueNamePair("", "");
        savedQueryList.add(pp);
        MUserQuery[] queries = MUserQuery.get(wsc.ctx, m_AD_Tab_ID, m_AD_Table_ID);
        for (int i2 = 0; i2 < queries.length; ++i2) {
            MUserQuery query = queries[i2];
            pp = new ValueNamePair(query.getCode(), query.getName());
            savedQueryList.add(pp);
        }
        return savedQueryList;
    }

    private static option[] getSavedQueryOptions(HttpServletRequest request) {
        return WFindAdvanced.getSavedQueryOptions(request, null);
    }

    public static option[] getSavedQueryOptions(HttpServletRequest request, String msg) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int m_AD_Tab_ID = ws.curTab.getAD_Tab_ID();
        int m_AD_Table_ID = ws.curTab.getAD_Table_ID();
        MUserQuery[] queries = MUserQuery.get(wsc.ctx, m_AD_Tab_ID, m_AD_Table_ID);
        option[] options = new option[queries.length + 1];
        options[0] = !StringUtils.isEmpty(msg) ? new option("").addElement(msg) : new option("").addElement("");
        for (int i2 = 0; i2 < queries.length; ++i2) {
            MUserQuery query = queries[i2];
            options[i2 + 1] = new option(query.getCode()).addElement(query.getName());
        }
        return options;
    }

    void addSavedQueryTable(HttpServletRequest request, div divBody) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        table savedQueryTable = new table("0", "0", "5", "100%", null);
        divBody.addElement((org.apache.ecs.Element)savedQueryTable);
        td sqtd1 = (td)new td().setStyle("min-width:80px;");
        td sqtd2 = (td)new td().setStyle("min-width:80px;");
        td sqtd3 = (td)new td().setStyle("min-width:80px;");
        td sqtd4 = (td)new td().setStyle("min-width:80px;");
        sqtd1.addElement(Msg.getMsg(wsc.ctx, "GetSavedQuery"));
        select sel = new select(this.QUERY_ID, WFindAdvanced.getSavedQueryOptions(request));
        sel.setID(this.QUERY_ID);
        sel.setOnChange("processAction('" + this.SAVED_QUERY_LOAD_ACTION + "');" + this.RETURN_FALSE);
        sel.addAttribute("style", "width:" + this.DEFAULT_DISPLAY_LENGTH + "px;");
        sqtd2.addElement((org.apache.ecs.Element)sel);
        img deleteButton = new img(WebEnv.getImageDirectory("Delete16.png"), Msg.getMsg(wsc.ctx, "QueryDelete"));
        deleteButton.setID(this.DELETE_QUERY_BUTTON);
        deleteButton.setOnClick("processAction('" + this.SAVED_QUERY_DELETE_ACTION + "');" + this.RETURN_FALSE);
        sqtd2.addElement((org.apache.ecs.Element)deleteButton);
        sqtd3.addElement(WebEnv.NBSP + WebEnv.NBSP + Msg.getMsg(wsc.ctx, "QueryName"));
        sqtd3.setStyle("text-align:right;");
        input queryName = new input("text", this.QUERY_NAME, "");
        queryName.setID(this.QUERY_NAME);
        queryName.addAttribute("style", "width:" + this.DEFAULT_DISPLAY_LENGTH + "px;");
        sqtd4.addElement((org.apache.ecs.Element)queryName);
        tr sqtr = new tr();
        sqtr.addElement((org.apache.ecs.Element)sqtd1).addElement((org.apache.ecs.Element)sqtd2).addElement((org.apache.ecs.Element)sqtd3).addElement((org.apache.ecs.Element)sqtd4);
        savedQueryTable.addElement((org.apache.ecs.Element)sqtr);
    }

    void addAdvancedEntry(HttpServletRequest request, div divBody) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        div entryDiv = new div();
        entryDiv.setStyle("min-height:100px;");
        entryDiv.setID(this.QUERY_ENTRY_DIV);
        divBody.addElement((org.apache.ecs.Element)entryDiv);
        table entryTable = new table("1", "0", "5", "100%", null);
        entryTable.setStyle("margin-top: 50px;");
        entryTable.setBorderColor("#7F9DB9");
        entryDiv.addElement((org.apache.ecs.Element)entryTable);
        td sqtd1 = (td)new td().setStyle("min-width:80px;");
        td sqtd2 = (td)new td().setStyle("min-width:80px;");
        td sqtd3 = (td)new td().setStyle("min-width:80px;");
        td sqtd4 = (td)new td().setStyle("min-width:80px;");
        sqtd1.addElement(Msg.translate(wsc.ctx, "AD_Column_ID"));
        sqtd2.addElement(Msg.translate(wsc.ctx, "Operator"));
        sqtd3.addElement(Msg.translate(wsc.ctx, "QueryValue"));
        sqtd4.addElement(Msg.translate(wsc.ctx, "QueryValue2"));
        tr sqtr = new tr();
        sqtr.addElement((org.apache.ecs.Element)sqtd1).addElement((org.apache.ecs.Element)sqtd2).addElement((org.apache.ecs.Element)sqtd3).addElement((org.apache.ecs.Element)sqtd4);
        entryTable.addElement((org.apache.ecs.Element)sqtr);
    }

    void addValueEditor(HttpServletRequest request, div divBody) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        table entryTable = new table("0", "0", "5", "100%", null);
        entryTable.setStyle("margin-top: 20px;");
        divBody.addElement((org.apache.ecs.Element)entryTable);
        td sqtd1 = (td)new td().setStyle("min-width:80px;");
        td sqtd2 = (td)new td().setStyle("min-width:80px;");
        td sqtd3 = (td)new td().setStyle("min-width:80px;");
        td sqtd4 = (td)new td().setStyle("min-width:80px;");
        td sqtd5 = (td)new td().setStyle("min-width:80px;");
        sqtd1.addElement(Msg.translate(wsc.ctx, "AD_Column_ID"));
        sqtd2.addElement(Msg.translate(wsc.ctx, "Operator"));
        sqtd3.addElement(Msg.translate(wsc.ctx, "QueryValue"));
        sqtd4.addElement(Msg.translate(wsc.ctx, "QueryValue2"));
        img deleteButton = new img(WebEnv.getImageDirectory("Delete16.png"), Msg.getMsg(wsc.ctx, "QueryDeleteRow"));
        deleteButton.setID(this.DELETE_ROW_BUTTON);
        deleteButton.setOnClick("processAction('" + this.DELETE_ROW_ACTION + "');" + this.RETURN_FALSE);
        sqtd5.addElement((org.apache.ecs.Element)deleteButton);
        tr sqtr = new tr();
        sqtr.addElement((org.apache.ecs.Element)sqtd1).addElement((org.apache.ecs.Element)sqtd2).addElement((org.apache.ecs.Element)sqtd3).addElement((org.apache.ecs.Element)sqtd4).addElement((org.apache.ecs.Element)sqtd5);
        entryTable.addElement((org.apache.ecs.Element)sqtr);
        td qetd1 = (td)new td().setStyle("min-width:80px;");
        td qetd2 = (td)new td().setStyle("min-width:80px;");
        td qetd3 = (td)new td().setStyle("min-width:80px;");
        td qetd4 = (td)new td().setStyle("min-width:80px;");
        td qetd5 = (td)new td().setStyle("min-width:80px;");
        div columnDiv = (div)new div().setID("columnDiv");
        select selColumn = new select(this.COLUMN_ID, this.getcolumnOptions(request));
        selColumn.setID(this.COLUMN_ID);
        selColumn.setOnChange("processAction('" + this.COLUMN_ACTION + "');" + this.RETURN_FALSE);
        columnDiv.addElement((org.apache.ecs.Element)selColumn);
        qetd1.addElement((org.apache.ecs.Element)columnDiv);
        div operatorDiv = (div)new div().setID("operatorDiv");
        select selOperator = new select(this.OPERATOR_ID, new option[1]);
        selOperator.setID(this.OPERATOR_ID);
        selOperator.setOnChange("processAction('" + this.OPERATOR_ACTION + "');" + this.RETURN_FALSE);
        selOperator.setDisabled(true);
        operatorDiv.addElement((org.apache.ecs.Element)selOperator);
        qetd2.addElement((org.apache.ecs.Element)operatorDiv);
        div queryValueDiv1 = (div)new div().setID("queryValueDiv1");
        input queryValue1 = new input("text", this.QUERY_VALUE_1, "");
        queryValue1.setID(this.QUERY_VALUE_1);
        queryValue1.setReadOnly(true);
        queryValueDiv1.addElement((org.apache.ecs.Element)queryValue1);
        qetd3.addElement((org.apache.ecs.Element)queryValueDiv1);
        div queryValueDiv2 = (div)new div().setID("queryValueDiv2");
        input queryValue2 = new input("text", this.QUERY_VALUE_2, "");
        queryValue2.setID(this.QUERY_VALUE_2);
        queryValueDiv2.addElement((org.apache.ecs.Element)queryValue2);
        qetd4.addElement((org.apache.ecs.Element)queryValueDiv2);
        img saveButton = new img(WebEnv.getImageDirectory("Save16.png"), Msg.getMsg(wsc.ctx, "QuerySaveRow"));
        saveButton.setID(this.SAVE_ROW_BUTTON);
        saveButton.setOnClick("processAction('" + this.SAVE_ROW_ACTION + "');" + this.RETURN_FALSE);
        qetd5.addElement((org.apache.ecs.Element)saveButton);
        tr sqtr2 = new tr();
        sqtr2.addElement((org.apache.ecs.Element)qetd1).addElement((org.apache.ecs.Element)qetd2).addElement((org.apache.ecs.Element)qetd3).addElement((org.apache.ecs.Element)qetd4).addElement((org.apache.ecs.Element)qetd5);
        entryTable.addElement((org.apache.ecs.Element)sqtr2);
    }

    option[] getcolumnOptions(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        GridField[] m_findFields = GridField.createFields(wsc.ctx, ws.curTab.getWindowNo(), 0, ws.curTab.getAD_Tab_ID(), 0);
        ArrayList<ValueNamePair> items = new ArrayList<ValueNamePair>();
        for (int c = 0; c < m_findFields.length; ++c) {
            GridField field = m_findFields[c];
            if (field.isEncrypted()) continue;
            String columnName = field.getColumnName();
            String header = field.getHeader();
            if ((header == null || header.length() == 0) && ((header = Msg.getElement(wsc.ctx, columnName)) == null || header.length() == 0)) continue;
            if (field.isKey()) {
                header = header + " (ID)";
            }
            ValueNamePair pp = new ValueNamePair(columnName, header);
            items.add(pp);
        }
        option[] options = new option[items.size() + 1];
        options[0] = new option("").addElement("");
        for (int i2 = 0; i2 < items.size(); ++i2) {
            ValueNamePair tmp = (ValueNamePair)items.get(i2);
            options[i2 + 1] = new option(tmp.getValue()).addElement(tmp.getName());
        }
        return options;
    }

    void addButtons(HttpServletRequest request, div divBody) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        table bottomTable = new table("0", "0", "0", "100%", null);
        td tdRefresh = (td)new td().setClass("button-box");
        input refresh = AmpiereUtil.createImageButton(wsc.ctx, "Refresh", "");
        refresh.setOnClick("processAction('" + this.REFRESH_ACTION + "');" + this.RETURN_FALSE);
        tdRefresh.addElement((org.apache.ecs.Element)refresh);
        td tdButton = (td)new td().setClass("button-box");
        input cancel = AmpiereUtil.createImageButton(wsc.ctx, "Cancel", "window.close();" + this.RETURN_FALSE);
        tdButton.addElement((org.apache.ecs.Element)cancel);
        input ok = AmpiereUtil.createImageButton(wsc.ctx, "Ok", "");
        ok.setOnClick("processAction('" + this.OK_ACTION + "');" + this.RETURN_FALSE);
        tdButton.addElement((org.apache.ecs.Element)ok);
        tr lastTr = new tr();
        lastTr.addElement((org.apache.ecs.Element)tdRefresh);
        lastTr.addElement((org.apache.ecs.Element)tdButton);
        bottomTable.addElement((org.apache.ecs.Element)lastTr);
        divBody.addElement((org.apache.ecs.Element)bottomTable);
    }

    Document processAction(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        Document document = null;
        String actionType = request.getParameter("actionType");
        if (this.SAVED_QUERY_LOAD_ACTION.equals(actionType)) {
            document = this.cmd_savedQueryLoad(request);
        } else if (this.SAVED_QUERY_DELETE_ACTION.equals(actionType)) {
            document = this.cmd_savedQueryDelete(request);
        } else if (this.COLUMN_ACTION.equals(actionType)) {
            document = this.processColumnAction(request);
        } else if (this.OPERATOR_ACTION.equals(actionType)) {
            document = this.processOperatorAction(request);
        } else if (this.DELETE_ROW_ACTION.equals(actionType)) {
            document = this.cmd_deleteRow(request);
        } else if (this.SAVE_ROW_ACTION.equals(actionType)) {
            document = this.cmd_saveRow(request);
        } else if (this.REFRESH_ACTION.equals(actionType)) {
            document = this.cmd_refresh(request);
        } else if (this.OK_ACTION.equals(actionType)) {
            document = this.cmd_okAdvanced(request);
        }
        return document;
    }

    Document processColumnAction(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        List<Object> operatorList = new ArrayList();
        Object queryValue1Element = null;
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
            String columnName = WebUtil.getParameter(request, this.COLUMN_ID);
            if (columnName != null) {
                this.log.config("Column=" + columnName);
                operatorList = columnName.endsWith("_ID") || columnName.endsWith("_Acct") ? Arrays.asList(Query.OPERATORS_ID) : (columnName.startsWith("Is") ? Arrays.asList(Query.OPERATORS_YN) : Arrays.asList(Query.OPERATORS));
                document = this.getOperatorDoc(document, request, operatorList);
                GridField field = this.getTargetMField(request, columnName);
                document = this.getEditor(document, request, field, "queryValueDiv1", "queryValue1", this.QUERY_VALUE_DISPLAY_1, "0");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    public Document getOperatorDoc(Document document, HttpServletRequest request, List<ValueNamePair> operatorList) {
        Element element = document.createElement("element");
        document.getFirstChild().appendChild(element);
        Element elm_id = document.createElement("id");
        String objId = this.OPERATOR_ID;
        elm_id.appendChild(document.createTextNode(objId));
        element.appendChild(elm_id);
        Element elm_lookup = document.createElement("lookup");
        element.appendChild(elm_lookup);
        elm_lookup.appendChild(document.createTextNode("1"));
        Element elm_visibility = document.createElement("visibility");
        element.appendChild(elm_visibility);
        elm_visibility.appendChild(document.createTextNode("1"));
        Element elm_newValue = document.createElement("newValue");
        element.appendChild(elm_newValue);
        for (int p2 = 0; p2 < operatorList.size(); ++p2) {
            String key = "";
            String value = "";
            ValueNamePair onePair = operatorList.get(p2);
            key = onePair.getValue();
            value = onePair.getName();
            Element elm_item = document.createElement("item");
            elm_newValue.appendChild(elm_item);
            Element elm_key = document.createElement("key");
            elm_item.appendChild(elm_key);
            elm_key.appendChild(document.createTextNode(String.valueOf(key)));
            Element elm_value = document.createElement("value");
            elm_item.appendChild(elm_value);
            elm_value.appendChild(document.createTextNode(value));
        }
        Element elm_readonly = document.createElement("readonly");
        element.appendChild(elm_readonly);
        elm_readonly.appendChild(document.createTextNode("0"));
        Element elm_type = document.createElement("type");
        element.appendChild(elm_type);
        elm_type.appendChild(document.createTextNode("1"));
        return document;
    }

    public Document getEditor(Document document, HttpServletRequest request, GridField field, String queryDivId, String queryValueId, String queryValueDisplayId, String readOnly) {
        String columnName = "";
        if (field != null) {
            columnName = field.getColumnName();
            if (field.isKey()) {
                // empty if block
            }
        }
        document = this.getField(document, request, field, queryDivId, queryValueId, queryValueDisplayId, readOnly);
        return document;
    }

    public Document getField(Document document, HttpServletRequest request, GridField mField, String queryDivId, String queryValueId, String queryValueDisplayId, String readOnly) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        Lookup lookup = mField.getLookup();
        String data = "";
        int AD_Column_ID = mField.getAD_Column_ID();
        String onclick = "";
        Object tdRet = null;
        String dataValue = data == null ? "" : data.toString();
        int m_displayType = mField.getDisplayType();
        String elementHtml = "";
        String scriptSrc = "";
        if (m_displayType == 30 || m_displayType == 21 || m_displayType == 25 || m_displayType == 35) {
            String dataDisplay = "";
            if (lookup != null && data != null) {
                dataDisplay = lookup.getDisplay(data);
            }
            elementHtml = this.getPopupField(request, queryValueId, mField, dataDisplay, dataValue, AD_Column_ID, lookup, onclick);
        } else if (DisplayType.isLookup(m_displayType) || m_displayType == 31) {
            elementHtml = this.getSelectField(request, queryValueId, mField, lookup, dataValue, queryValueDisplayId);
        } else if (m_displayType == 20) {
            elementHtml = this.getCheckField(request, queryValueId, mField, dataValue);
        } else if (DisplayType.isDate(m_displayType)) {
            elementHtml = this.getDateField(request, queryValueId, mField, dataValue);
            scriptSrc = this.getLoadCalendarScript(request, queryValueId, mField, dataValue);
        } else {
            elementHtml = this.getStringField(request, queryValueId, mField, dataValue);
        }
        Element element = null;
        try {
            element = document.createElement("element");
            document.getFirstChild().appendChild(element);
            Element elm_id = document.createElement("id");
            String objId = queryDivId;
            elm_id.appendChild(document.createTextNode(objId));
            element.appendChild(elm_id);
            Element elm_lookup = document.createElement("lookup");
            element.appendChild(elm_lookup);
            elm_lookup.appendChild(document.createTextNode("2"));
            Element elm_visibility = document.createElement("visibility");
            element.appendChild(elm_visibility);
            elm_visibility.appendChild(document.createTextNode("1"));
            Element elm_newValue = document.createElement("newValue");
            element.appendChild(elm_newValue);
            elm_newValue.appendChild(document.createTextNode(elementHtml));
            Element elm_readonly = document.createElement("readonly");
            element.appendChild(elm_readonly);
            elm_readonly.appendChild(document.createTextNode(readOnly));
            Element elm_type = document.createElement("type");
            element.appendChild(elm_type);
            elm_type.appendChild(document.createTextNode("1"));
            if (!StringUtils.isEmpty(scriptSrc)) {
                Element elementScript = document.createElement("element");
                document.getFirstChild().appendChild(elementScript);
                Element elm_id_script = document.createElement("id");
                String objIdScript = queryDivId;
                elm_id_script.appendChild(document.createTextNode(objIdScript));
                elementScript.appendChild(elm_id_script);
                Element elm_lookup_script = document.createElement("lookup");
                elementScript.appendChild(elm_lookup_script);
                elm_lookup_script.appendChild(document.createTextNode("2"));
                Element elm_visibility_script = document.createElement("visibility");
                elementScript.appendChild(elm_visibility_script);
                elm_visibility_script.appendChild(document.createTextNode("1"));
                Element elm_newValue_script = document.createElement("newValue");
                elementScript.appendChild(elm_newValue_script);
                elm_newValue_script.appendChild(document.createTextNode(scriptSrc));
                Element elm_readonly_script = document.createElement("readonly");
                elementScript.appendChild(elm_readonly_script);
                elm_readonly_script.appendChild(document.createTextNode(readOnly));
                Element elm_type_script = document.createElement("type");
                elementScript.appendChild(elm_type_script);
                elm_type_script.appendChild(document.createTextNode("script"));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    private String getPopupField(HttpServletRequest request, String m_columnName, GridField mField, String dataDisplay, String dataValue, int AD_Column_ID, Lookup lookup, String onclick) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        input hidden = new input("hidden", m_columnName, dataValue);
        hidden.setID(m_columnName + "D");
        int m_displayLength = 160;
        int m_displayType = mField.getDisplayType();
        String m_description = mField.getDescription();
        input display = new input("text", m_columnName, AmpiereUtil.maskHtmlCR(dataDisplay));
        display.setID(m_columnName + "F");
        display.addAttribute("style", "width:" + m_displayLength + "px;");
        img button2 = null;
        String gif = "PickOpen16.gif";
        if (m_displayType == 21) {
            gif = "Location16.gif";
        } else if (m_displayType == 25) {
            gif = "Account16.gif";
        } else if (m_columnName.equals("C_BPartner_ID")) {
            gif = "BPartner16.png";
        } else if (m_columnName.equals("M_Product_ID")) {
            gif = "Product16.png";
        } else if (m_columnName.equals("M_AttributeSetInstance_ID")) {
            gif = "PAttribute16.png";
        }
        button2 = new img(WebEnv.getImageDirectory(gif), m_columnName);
        button2.setID(m_columnName + "B");
        button2.setClass("popupButton");
        String onClick = "";
        String col = lookup.getColumnName();
        if (col != null && col.indexOf(".") >= 0) {
            col = col.substring(col.indexOf(".") + 1);
        }
        if (m_displayType == 21) {
            onClick = "startLocation('" + m_columnName + "'," + ws.getCurTab().getWindowNo() + "," + AD_Column_ID + ",'" + col + "',null);";
            display.setReadOnly(true);
        } else {
            onClick = m_displayType == 25 ? "startAccount('" + m_columnName + "',null);" : (m_columnName.equals("M_AttributeSetInstance_ID") ? "startPopup('WAttributeSet');" : "startLookup('" + m_columnName + "'," + ws.getCurTab().getWindowNo() + "," + AD_Column_ID + ",'" + col + "', 'N',null);");
        }
        if (!StringUtils.isEmpty(onclick)) {
            onClick = onclick;
        }
        button2.setOnClick(onClick + "return false;");
        if (m_description != null) {
            button2.setTitle(Util.maskHTML(m_description));
        }
        display.setOnChange("startUpdate(this);");
        StringBuffer htmlBuff = new StringBuffer();
        htmlBuff.append(hidden.toString());
        htmlBuff.append(display.toString());
        htmlBuff.append(button2.toString());
        String html = htmlBuff.toString();
        return html;
    }

    private String getSelectField(HttpServletRequest request, String m_columnName, GridField mField, Lookup lookup, String dataValue, String queryValueDisplayId) {
        int m_displayLength = 160;
        select sel = new select(m_columnName, this.getOptions(mField, lookup, dataValue));
        sel.setID(m_columnName);
        sel.setOnChange("startUpdate(this);");
        sel.setOnChange("");
        sel.addAttribute("style", "width:" + m_displayLength + "px;");
        StringBuffer htmlBuff = new StringBuffer();
        htmlBuff.append(sel.toString());
        String html = htmlBuff.toString();
        return html;
    }

    private String getCheckField(HttpServletRequest request, String m_columnName, GridField mField, String data) {
        String m_name = mField.getColumnName();
        boolean check = data != null && (data.equals("true") || data.equals("Y"));
        input cb = new input("checkbox", m_columnName, "true").setChecked(check);
        label myLabel = new label(m_columnName + "F", null, Util.maskHTML(m_name));
        myLabel.setID(m_columnName + "L");
        cb.addElement((org.apache.ecs.Element)myLabel);
        cb.setID(m_columnName + "F");
        cb.setOnClick("startUpdate(this);");
        StringBuffer htmlBuff = new StringBuffer();
        htmlBuff.append(cb.toString());
        String html = htmlBuff.toString();
        return html;
    }

    private String getDateField(HttpServletRequest request, String m_columnName, GridField mField, String data) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int m_windowNo = ws.getCurTab().getWindowNo();
        int m_displayLength = 160;
        int m_displayType = mField.getDisplayType();
        int m_fieldLength = mField.getFieldLength();
        String m_description = mField.getDescription();
        String formattedData = "";
        input string = new input("text", m_columnName, formattedData);
        string.setID(m_columnName + "F");
        string.setSize(m_displayLength);
        if (m_fieldLength >= 10) {
            string.setMaxlength(m_fieldLength);
        }
        string.setDisabled(false);
        string.setReadOnly(false);
        string.addAttribute("style", "width:" + m_displayLength + "px;");
        div dateTimePickerScriptDiv = new div();
        img button2 = null;
        String gif = "Calendar16.png";
        button2 = new img(WebEnv.getImageDirectory(gif), m_columnName);
        button2.setID(m_columnName + "B");
        button2.setClass("popupButton");
        String onClick = "";
        String inputBoxId = m_columnName + "F";
        String buttonId = m_columnName + "B";
        if (m_displayType == 16) {
            AmpiereUtil.addDateTimePickerScript((org.apache.ecs.Element)dateTimePickerScriptDiv, inputBoxId, buttonId, wsc.language);
        } else {
            AmpiereUtil.addDatePickerScript((org.apache.ecs.Element)dateTimePickerScriptDiv, inputBoxId, buttonId, wsc.language);
        }
        if (m_description != null) {
            button2.setTitle(Util.maskHTML(m_description));
        }
        StringBuffer htmlBuff = new StringBuffer();
        htmlBuff.append(string.toString());
        htmlBuff.append(button2.toString());
        htmlBuff.append(dateTimePickerScriptDiv.toString());
        String html = htmlBuff.toString();
        return html;
    }

    private String getLoadCalendarScript(HttpServletRequest request, String m_columnName, GridField mField, String data) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        int m_displayType = mField.getDisplayType();
        String locadCalendarScript = "";
        div dateTimePickerScriptDiv = new div();
        String inputBoxId = m_columnName + "F";
        String buttonId = m_columnName + "B";
        locadCalendarScript = m_displayType == 16 ? AmpiereUtil.getLoadCalendarDateTimePickerScript((org.apache.ecs.Element)dateTimePickerScriptDiv, inputBoxId, buttonId, wsc.language) : AmpiereUtil.getLoadCalendarDatePickerScript((org.apache.ecs.Element)dateTimePickerScriptDiv, inputBoxId, buttonId, wsc.language);
        return locadCalendarScript;
    }

    private String getStringField(HttpServletRequest request, String m_columnName, GridField mField, String data) {
        int m_displayLength = 160;
        int m_displayType = mField.getDisplayType();
        int m_fieldLength = mField.getFieldLength();
        input string = new input("text", m_columnName, AmpiereUtil.maskHtmlCR(data));
        string.setID(m_columnName + "F");
        if (m_displayLength > 128) {
            string.setSize(128);
        } else {
            string.setSize(m_displayLength);
        }
        if (m_fieldLength > 0) {
            string.setMaxlength(m_fieldLength);
        }
        string.setDisabled(false);
        string.addAttribute("style", "width:" + m_displayLength + "px;");
        StringBuffer htmlBuff = new StringBuffer();
        htmlBuff.append(string.toString());
        String html = htmlBuff.toString();
        return html;
    }

    Document processOperatorAction(HttpServletRequest request) {
        GridField field;
        String columnName;
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
        }
        catch (Exception e) {
            // empty catch block
        }
        String op = WebUtil.getParameter(request, this.OPERATOR_ID);
        if (op != null) {
            this.log.config("Operator: " + op);
            if (" BETWEEN ".equals(op)) {
                columnName = WebUtil.getParameter(request, this.COLUMN_ID);
                field = this.getTargetMField(request, columnName);
                document = this.getEditor(document, request, field, "queryValueDiv2", "queryValue2", this.QUERY_VALUE_DISPLAY_2, "0");
            }
        } else {
            columnName = WebUtil.getParameter(request, this.COLUMN_ID);
            field = this.getTargetMField(request, columnName);
            document = this.getEditor(document, request, field, "queryValueDiv2", "queryValue2", this.QUERY_VALUE_DISPLAY_2, "1");
        }
        return document;
    }

    private Document cmd_refresh(HttpServletRequest request) {
        WWindowStatus ws = WWindowStatus.get(request);
        Document document = null;
        document = this.cmd_saveRow(request);
        Query query = this.getQueryAdvanced(request);
        String alert_msg = "";
        int m_total = this.getNoOfRecords(request, query, true);
        MRole role = MRole.getDefault(ws.ctx, false);
        if (m_total == 0) {
            alert_msg = AWebUtil.info(request, "FindZeroRecords", null);
        } else if (query != null && role.isQueryMax(m_total)) {
            alert_msg = AWebUtil.info(request, "FindOverMax", m_total + " > " + role.getMaxQueryRecords());
        } else {
            this.log.config("#" + m_total);
        }
        if (StringUtils.isEmpty(alert_msg)) {
            if (query != null && query.isActive()) {
                ws.curTab.setQuery(query);
            } else {
                ws.curTab.setQuery(null);
            }
            ws.curTab.query(0);
        }
        try {
            Element element = document.createElement("element");
            document.getFirstChild().appendChild(element);
            if (StringUtils.isEmpty(alert_msg)) {
                Element elm_id = document.createElement("id");
                String objId = this.QUERY_ENTRY_DIV;
                elm_id.appendChild(document.createTextNode(objId));
                element.appendChild(elm_id);
                Element elm_lookup = document.createElement("lookup");
                element.appendChild(elm_lookup);
                elm_lookup.appendChild(document.createTextNode("0"));
                Element elm_visibility = document.createElement("visibility");
                element.appendChild(elm_visibility);
                elm_visibility.appendChild(document.createTextNode("1"));
                Element elm_newValue = document.createElement("newValue");
                element.appendChild(elm_newValue);
                StringBuffer sb = new StringBuffer();
                sb.append("window.opener.onunload='';");
                sb.append("window.opener.document.WForm.PCommand.value='Refresh';");
                sb.append("window.opener.document.WForm.submit();");
                elm_newValue.appendChild(document.createTextNode(sb.toString()));
                Element elm_readonly = document.createElement("readonly");
                element.appendChild(elm_readonly);
                elm_readonly.appendChild(document.createTextNode("0"));
                Element elm_type = document.createElement("type");
                element.appendChild(elm_type);
                elm_type.appendChild(document.createTextNode("script"));
            } else {
                Element elm_id = document.createElement("id");
                String objId = this.QUERY_ENTRY_DIV;
                elm_id.appendChild(document.createTextNode(objId));
                element.appendChild(elm_id);
                Element elm_lookup = document.createElement("lookup");
                element.appendChild(elm_lookup);
                elm_lookup.appendChild(document.createTextNode("0"));
                Element elm_visibility = document.createElement("visibility");
                element.appendChild(elm_visibility);
                elm_visibility.appendChild(document.createTextNode("1"));
                Element elm_newValue = document.createElement("newValue");
                element.appendChild(elm_newValue);
                StringBuffer sb = new StringBuffer();
                sb.append("alert('" + alert_msg + "');");
                elm_newValue.appendChild(document.createTextNode(sb.toString()));
                Element elm_readonly = document.createElement("readonly");
                element.appendChild(elm_readonly);
                elm_readonly.appendChild(document.createTextNode("0"));
                Element elm_type = document.createElement("type");
                element.appendChild(elm_type);
                elm_type.appendChild(document.createTextNode("script"));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Document cmd_saveRow(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
        }
        catch (Exception e) {
            // empty catch block
        }
        String column = WebUtil.getParameter(request, this.COLUMN_ID);
        if (StringUtils.isEmpty(column)) {
            return document;
        }
        GridField field = this.getTargetMField(request, column);
        int m_displayType = field.getDisplayType();
        String op = WebUtil.getParameter(request, this.OPERATOR_ID);
        String value = WebUtil.getParameter(request, this.QUERY_VALUE_1);
        String valueDisplay = WebUtil.getParameter(request, this.QUERY_VALUE_1);
        if (DisplayType.isLookup(m_displayType) || m_displayType == 31) {
            valueDisplay = this.getValueDisplay(field, field.getLookup(), value);
        } else if (20 == m_displayType) {
            String string = value = "true".equals(value) ? "Y" : "N";
        }
        if (StringUtils.isEmpty(valueDisplay)) {
            valueDisplay = value;
        }
        ValueNamePair v = null;
        if (value == null || "-1".equals(value) && (DisplayType.isLookup(m_displayType) || m_displayType == 31)) {
            if (!"=".equals(op)) {
                if (!"!=".equals(op)) return document;
            }
            v = new ValueNamePair("NULLValue", "NULL");
        } else {
            v = new ValueNamePair(value.toString(), valueDisplay);
        }
        ValueNamePair v2 = null;
        if (" BETWEEN ".equals(op)) {
            String value2 = WebUtil.getParameter(request, this.QUERY_VALUE_2);
            String value2Display = WebUtil.getParameter(request, this.QUERY_VALUE_2);
            if (DisplayType.isLookup(m_displayType) || m_displayType == 31) {
                value2Display = this.getValueDisplay(field, field.getLookup(), value2);
                if (StringUtils.isEmpty(valueDisplay)) {
                    valueDisplay = value;
                }
            }
            if (value2 == null) {
                return document;
            }
            if ("-1".equals(value) && (DisplayType.isLookup(m_displayType) || m_displayType == 31)) {
                value2Display = this.getValueDisplay(field, field.getLookup(), value2);
            } else {
                v2 = new ValueNamePair(value2.toString(), value2Display);
            }
        }
        AdvancedRow row = new AdvancedRow(this.getColumnValueNamePair(request, column), this.getOperatorValueNamePair(op), v, v2);
        Vector<AdvancedRow> advancedData = (Vector<AdvancedRow>)session.getAttribute(this.ADVANCED_DATA);
        if (advancedData == null) {
            advancedData = new Vector<AdvancedRow>();
        }
        advancedData.add(row);
        session.setAttribute(this.ADVANCED_DATA, advancedData);
        try {
            return this.addAdvancedData(document, request);
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    private String getValueDisplay(GridField mField, Lookup lookup, String dataValue) {
        int m_displayType = mField.getDisplayType();
        String valueDisplay = "";
        if (lookup == null) {
            return valueDisplay;
        }
        Object[] list = lookup.getData(false, true, false, false).toArray();
        int size = list.length;
        if (size <= 0) {
            list = lookup.getData(false, true, true, true).toArray();
            size = list.length;
        }
        option[] options = new option[size];
        for (int i2 = 0; i2 < size; ++i2) {
            NamePair p2;
            String name;
            boolean isNumber = list[0] instanceof KeyNamePair;
            String key = null;
            if (m_displayType == 31 && !isNumber) {
                MLocator loc = (MLocator)list[i2];
                key = String.valueOf(loc.getM_Locator_ID());
                name = AmpiereUtil.maskHTML(loc.getValue());
                if (!dataValue.equals(key)) continue;
                valueDisplay = name;
                break;
            }
            if (isNumber) {
                p2 = (KeyNamePair)list[i2];
                key = String.valueOf(((KeyNamePair)p2).getKey());
                name = AmpiereUtil.maskHTML(p2.getName());
                if (!dataValue.equals(key)) continue;
                valueDisplay = name;
                break;
            }
            p2 = (ValueNamePair)list[i2];
            key = ((ValueNamePair)p2).getValue();
            if (key == null || key.length() == 0) {
                key = "";
            }
            if ((name = p2.getName()) == null || name.length() == 0) {
                name = " ";
            }
            name = AmpiereUtil.maskHTML(name);
            if (!dataValue.equals(key)) continue;
            valueDisplay = name;
            break;
        }
        return valueDisplay;
    }

    private Document addAdvancedData(Document document, HttpServletRequest request) {
        try {
            Element element = document.createElement("element");
            document.getFirstChild().appendChild(element);
            Element elm_id = document.createElement("id");
            String objId = this.QUERY_ENTRY_DIV;
            elm_id.appendChild(document.createTextNode(objId));
            element.appendChild(elm_id);
            Element elm_lookup = document.createElement("lookup");
            element.appendChild(elm_lookup);
            elm_lookup.appendChild(document.createTextNode("2"));
            Element elm_visibility = document.createElement("visibility");
            element.appendChild(elm_visibility);
            elm_visibility.appendChild(document.createTextNode("1"));
            Element elm_newValue = document.createElement("newValue");
            element.appendChild(elm_newValue);
            String advancedDateHtml = this.getAdvancedDateHtml(request);
            elm_newValue.appendChild(document.createTextNode(advancedDateHtml));
            Element elm_readonly = document.createElement("readonly");
            element.appendChild(elm_readonly);
            elm_readonly.appendChild(document.createTextNode("0"));
            Element elm_type = document.createElement("type");
            element.appendChild(elm_type);
            elm_type.appendChild(document.createTextNode("1"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return document;
    }

    private String getAdvancedDateHtml(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int m_displayLength = 160;
        Vector advancedData = (Vector)session.getAttribute(this.ADVANCED_DATA);
        if (advancedData == null || advancedData.size() == 0) {
            return "</br>";
        }
        table advancedDataTable = new table("1", "0", "5", "100%", null);
        advancedDataTable.setStyle("margin-top: 30px;");
        advancedDataTable.setBorderColor("#7F9DB9");
        td sqtd0 = (td)new td().setStyle("min-width:20px;");
        td sqtd1 = (td)new td().setStyle("min-width:80px;");
        td sqtd2 = (td)new td().setStyle("min-width:80px;");
        td sqtd3 = (td)new td().setStyle("min-width:80px;");
        td sqtd4 = (td)new td().setStyle("min-width:80px;");
        sqtd0.addElement("");
        sqtd1.addElement(Msg.translate(wsc.ctx, "AD_Column_ID"));
        sqtd2.addElement(Msg.translate(wsc.ctx, "Operator"));
        sqtd3.addElement(Msg.translate(wsc.ctx, "QueryValue"));
        sqtd4.addElement(Msg.translate(wsc.ctx, "QueryValue2"));
        tr sqtr = new tr();
        sqtr.addElement((org.apache.ecs.Element)sqtd0).addElement((org.apache.ecs.Element)sqtd1).addElement((org.apache.ecs.Element)sqtd2).addElement((org.apache.ecs.Element)sqtd3).addElement((org.apache.ecs.Element)sqtd4);
        advancedDataTable.addElement((org.apache.ecs.Element)sqtr);
        for (int i2 = 0; i2 < advancedData.size(); ++i2) {
            tr rowTr = new tr();
            advancedDataTable.addElement((org.apache.ecs.Element)rowTr);
            td td0 = (td)new td().setStyle("min-width:20px;");
            td td1 = (td)new td().setStyle("min-width:80px;");
            td td2 = (td)new td().setStyle("min-width:80px;");
            td td3 = (td)new td().setStyle("min-width:80px;");
            td td4 = (td)new td().setStyle("min-width:80px;");
            rowTr.addElement((org.apache.ecs.Element)td0).addElement((org.apache.ecs.Element)td1).addElement((org.apache.ecs.Element)td2).addElement((org.apache.ecs.Element)td3).addElement((org.apache.ecs.Element)td4);
            input rowIndex = new input("radio", this.QUERY_ENTRY_INDEX, i2);
            td0.addElement((org.apache.ecs.Element)rowIndex);
            AdvancedRow row = (AdvancedRow)advancedData.get(i2);
            String column = row.getColumn().getName();
            td1.addElement(column);
            rowTr.addElement((org.apache.ecs.Element)td1);
            String operator = row.getOperator().getName();
            td2.addElement(operator);
            rowTr.addElement((org.apache.ecs.Element)td2);
            String value = "NULLValue";
            if (row.getValue() != null) {
                value = row.getValue().getName();
            }
            td3.addElement(value);
            rowTr.addElement((org.apache.ecs.Element)td3);
            String value2 = "";
            if (row.getValue2() != null) {
                value2 = row.getValue2().getName();
            }
            td4.addElement(value2);
            rowTr.addElement((org.apache.ecs.Element)td4);
        }
        StringBuffer htmlBuff = new StringBuffer();
        htmlBuff.append(advancedDataTable.toString());
        String html = htmlBuff.toString();
        return html;
    }

    private ValueNamePair getOperatorValueNamePair(String value) {
        ValueNamePair[] operators = Query.OPERATORS;
        ValueNamePair operator = null;
        for (int i2 = 0; i2 < operators.length; ++i2) {
            if (!operators[i2].getValue().equals(value)) continue;
            operator = operators[i2];
            break;
        }
        return operator;
    }

    private ValueNamePair getColumnValueNamePair(HttpServletRequest request, String value) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        GridField[] m_findFields = GridField.createFields(wsc.ctx, ws.curTab.getWindowNo(), 0, ws.curTab.getAD_Tab_ID(), 0);
        ValueNamePair pair = null;
        for (int i2 = 0; i2 < m_findFields.length; ++i2) {
            GridField field = m_findFields[i2];
            if (!field.getColumnName().equals(value)) continue;
            pair = new ValueNamePair(value, field.getHeader());
            break;
        }
        return pair;
    }

    private Document cmd_deleteRow(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
        }
        catch (Exception e) {
            // empty catch block
        }
        int index = StringToIntConverter.StringToInt(WebUtil.getParameter(request, this.QUERY_ENTRY_INDEX));
        this.log.info("#" + index);
        if (index == -1) {
            return document;
        }
        Vector advancedData = (Vector)session.getAttribute(this.ADVANCED_DATA);
        if (advancedData != null) {
            advancedData.remove(index);
        }
        session.setAttribute(this.ADVANCED_DATA, (Object)advancedData);
        document = this.addAdvancedData(document, request);
        return document;
    }

    private Query getQueryAdvanced(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String m_tableName = ws.getCurTab().getTableName();
        Query query = new Query(m_tableName);
        Vector advancedData = (Vector)session.getAttribute(this.ADVANCED_DATA);
        if (advancedData == null) {
            return null;
        }
        for (int i2 = 0; i2 < advancedData.size(); ++i2) {
            AdvancedRow row = (AdvancedRow)advancedData.get(i2);
            ValueNamePair column = row.getColumn();
            String infoName = column.getName();
            String columnName = column.getValue();
            GridField field = this.getTargetMField(request, columnName);
            String columnSQL = field.getColumnSQL(false);
            String operator = row.getOperator().getValue();
            ValueNamePair value = row.getValue();
            Object parsedValue = this.parseValue(request, field, value);
            String infoDisplay = null;
            if (value == null) {
                if (" BETWEEN ".equals(operator)) continue;
                parsedValue = "NULLValue";
                infoDisplay = "NULL";
            } else {
                infoDisplay = value.getName();
            }
            if (" BETWEEN ".equals(operator)) {
                ValueNamePair value2 = row.getValue2();
                if (value2 == null) continue;
                Object parsedValue2 = this.parseValue(request, field, value2);
                String infoDisplay_to = value2.getName();
                if (parsedValue2 == null) continue;
                query.addRangeRestriction(columnSQL, parsedValue, parsedValue2, infoName, infoDisplay, infoDisplay_to);
                continue;
            }
            query.addRestriction(columnSQL, operator, parsedValue, infoName, infoDisplay);
        }
        return query;
    }

    private GridField getTargetMField(HttpServletRequest request, String columnName) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        GridField[] findFields = GridField.createFields(wsc.ctx, ws.curTab.getWindowNo(), 0, ws.curTab.getAD_Tab_ID(), 0);
        if (columnName == null) {
            return null;
        }
        for (int c = 0; c < findFields.length; ++c) {
            GridField field = findFields[c];
            if (!columnName.equals(field.getColumnName())) continue;
            return field;
        }
        return null;
    }

    private Object parseValue(HttpServletRequest request, GridField field, ValueNamePair pp) {
        String in;
        block9: {
            WebSessionCtx wsc = WebSessionCtx.get(request);
            if (pp == null) {
                return null;
            }
            int dt = field.getDisplayType();
            in = pp.getValue();
            if (in == null || in.equals("NULLValue")) {
                return null;
            }
            try {
                if (dt == 11 || DisplayType.isID(dt) && field.getColumnName().endsWith("_ID")) {
                    int i2 = Integer.parseInt(in);
                    return new Integer(i2);
                }
                if (DisplayType.isNumeric(dt)) {
                    return DisplayType.getNumberFormat(dt).parse(in);
                }
                if (!DisplayType.isDate(dt)) break block9;
                Timestamp ts = null;
                try {
                    Date d = null;
                    d = dt == 15 ? wsc.dateFormat.parse(in) : wsc.dateTimeFormat.parse(in);
                    ts = new Timestamp(d.getTime());
                }
                catch (Exception e) {
                    this.log.warning("Date: " + field.getColumnName() + "=" + in + ERROR);
                    return ERROR;
                }
                this.log.fine("Date: " + field.getColumnName() + "=" + in + " -> " + ts);
                return ts;
            }
            catch (Exception ex) {
                this.log.log(Level.WARNING, "Object=" + in, ex);
                String error = ex.getLocalizedMessage();
                if (error == null || error.length() == 0) {
                    error = ex.toString();
                }
                StringBuffer errMsg = new StringBuffer();
                errMsg.append(field.getColumnName()).append(" = ").append(in).append(" - ").append(error);
                return null;
            }
        }
        return in;
    }

    private Document cmd_savedQueryLoad(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
        }
        catch (Exception e) {
            // empty catch block
        }
        session.setAttribute(this.ADVANCED_DATA, null);
        MUserQuery uq = this.getSelectedQuery(request);
        if (uq == null) {
            this.addAdvancedData(document, request);
            this.addQueryName(document, request, "");
            return document;
        }
        this.log.info(uq.toStringX());
        Vector<AdvancedRow> advancedData = new Vector<AdvancedRow>();
        Vector<AdvancedRow> ad = this.reloadAdvancedRow(uq);
        if (ad != null) {
            for (int i2 = 0; i2 < ad.size(); ++i2) {
                AdvancedRow row = ad.get(i2);
                advancedData.add(row);
            }
        }
        session.setAttribute(this.ADVANCED_DATA, advancedData);
        try {
            this.addAdvancedData(document, request);
            this.addQueryName(document, request, uq.getName());
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    Vector<AdvancedRow> reloadAdvancedRow(MUserQuery query) {
        Vector<AdvancedRow> retValue = new Vector<AdvancedRow>();
        MUserQueryLine[] lines = query.getLines(true);
        for (int i2 = 0; i2 < lines.length; ++i2) {
            MUserQueryLine line = lines[i2];
            ValueNamePair column = new ValueNamePair(line.getKeyValue(), line.getKeyName());
            ValueNamePair operator = line.getOperatorPair();
            ValueNamePair value = new ValueNamePair(line.getValue1Value(), line.getValue1Name());
            ValueNamePair value2 = null;
            if (line.getValue2Value() != null) {
                value2 = new ValueNamePair(line.getValue2Value(), line.getValue2Name());
            }
            AdvancedRow row = new AdvancedRow(column, operator, value, value2);
            retValue.add(row);
        }
        return retValue;
    }

    private Document addQueryName(Document document, HttpServletRequest request, String queryName) {
        try {
            Element element = document.createElement("element");
            document.getFirstChild().appendChild(element);
            Element elm_id = document.createElement("id");
            String objId = this.QUERY_NAME;
            elm_id.appendChild(document.createTextNode(objId));
            element.appendChild(elm_id);
            Element elm_lookup = document.createElement("lookup");
            element.appendChild(elm_lookup);
            elm_lookup.appendChild(document.createTextNode("0"));
            Element elm_visibility = document.createElement("visibility");
            element.appendChild(elm_visibility);
            elm_visibility.appendChild(document.createTextNode("1"));
            Element elm_newValue = document.createElement("newValue");
            element.appendChild(elm_newValue);
            elm_newValue.appendChild(document.createTextNode(queryName));
            Element elm_readonly = document.createElement("readonly");
            element.appendChild(elm_readonly);
            elm_readonly.appendChild(document.createTextNode("0"));
            Element elm_type = document.createElement("type");
            element.appendChild(elm_type);
            elm_type.appendChild(document.createTextNode("1"));
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    private Document cmd_savedQueryDelete(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String result_msg = "";
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
        }
        catch (Exception e) {
            // empty catch block
        }
        MUserQuery uq = this.getSelectedQuery(request);
        if (uq == null) {
            return document;
        }
        this.log.info(uq.toStringX());
        String name = uq.getName();
        if (uq.delete(true)) {
            result_msg = AWebUtil.info(request, "Deleted", name);
            session.setAttribute(this.ADVANCED_DATA, null);
            this.addAdvancedData(document, request);
            this.addQueryName(document, request, "");
            this.addSavedQuery(document, request);
        } else {
            result_msg = AWebUtil.info(request, "DeleteError", null);
        }
        return document;
    }

    Document addResultMessage(Document document, HttpServletRequest request, String result_msg) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
            Element element = document.createElement("element");
            document.getFirstChild().appendChild(element);
            Element elm_id = document.createElement("id");
            String objId = this.QUERY_ENTRY_DIV;
            elm_id.appendChild(document.createTextNode(objId));
            element.appendChild(elm_id);
            Element elm_lookup = document.createElement("lookup");
            element.appendChild(elm_lookup);
            elm_lookup.appendChild(document.createTextNode("0"));
            Element elm_visibility = document.createElement("visibility");
            element.appendChild(elm_visibility);
            elm_visibility.appendChild(document.createTextNode("1"));
            Element elm_newValue = document.createElement("newValue");
            element.appendChild(elm_newValue);
            StringBuffer sb = new StringBuffer();
            if (!StringUtils.isEmpty(result_msg)) {
                sb.append("alert('" + result_msg + "');window.close();");
            }
            elm_newValue.appendChild(document.createTextNode(sb.toString()));
            Element elm_readonly = document.createElement("readonly");
            element.appendChild(elm_readonly);
            elm_readonly.appendChild(document.createTextNode("0"));
            Element elm_type = document.createElement("type");
            element.appendChild(elm_type);
            elm_type.appendChild(document.createTextNode("script"));
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    private Document addSavedQuery(Document document, HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        try {
            Element element = document.createElement("element");
            document.getFirstChild().appendChild(element);
            Element elm_id = document.createElement("id");
            String objId = this.QUERY_ID;
            elm_id.appendChild(document.createTextNode(objId));
            element.appendChild(elm_id);
            Element elm_lookup = document.createElement("lookup");
            element.appendChild(elm_lookup);
            elm_lookup.appendChild(document.createTextNode("1"));
            Element elm_visibility = document.createElement("visibility");
            element.appendChild(elm_visibility);
            elm_visibility.appendChild(document.createTextNode("1"));
            Element elm_newValue = document.createElement("newValue");
            element.appendChild(elm_newValue);
            MUserQuery[] queries = MUserQuery.get(wsc.ctx, ws.getCurTab().getAD_Tab_ID(), ws.getCurTab().getAD_Table_ID());
            String key = "";
            String value = "";
            Element elm_item = document.createElement("item");
            elm_newValue.appendChild(elm_item);
            Element elm_key = document.createElement("key");
            elm_item.appendChild(elm_key);
            elm_key.appendChild(document.createTextNode(String.valueOf(key)));
            Element elm_value = document.createElement("value");
            elm_item.appendChild(elm_value);
            elm_value.appendChild(document.createTextNode(value));
            for (int p2 = 0; p2 < queries.length; ++p2) {
                key = queries[p2].getCode();
                value = queries[p2].getName();
                elm_item = document.createElement("item");
                elm_newValue.appendChild(elm_item);
                elm_key = document.createElement("key");
                elm_item.appendChild(elm_key);
                elm_key.appendChild(document.createTextNode(String.valueOf(key)));
                elm_value = document.createElement("value");
                elm_item.appendChild(elm_value);
                elm_value.appendChild(document.createTextNode(value));
            }
            Element elm_readonly = document.createElement("readonly");
            element.appendChild(elm_readonly);
            elm_readonly.appendChild(document.createTextNode("0"));
            Element elm_type = document.createElement("type");
            element.appendChild(elm_type);
            elm_type.appendChild(document.createTextNode("1"));
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    MUserQuery getSelectedQuery(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String queryCode = WebUtil.getParameter(request, this.QUERY_ID);
        MUserQuery[] queries = MUserQuery.get(wsc.ctx, ws.getCurTab().getAD_Tab_ID(), ws.getCurTab().getAD_Table_ID());
        MUserQuery uq = null;
        for (int i2 = 0; i2 < queries.length; ++i2) {
            MUserQuery query = queries[i2];
            if (!query.getCode().equals(queryCode)) continue;
            uq = query;
            break;
        }
        return uq;
    }

    private Document cmd_okAdvanced(HttpServletRequest request) {
        WWindowStatus ws = WWindowStatus.get(request);
        Document document = null;
        String result_msg = this.cmd_saveAdvanced(request);
        Query query = this.getQueryAdvanced(request);
        if (query != null && query.isActive()) {
            ws.curTab.setQuery(query);
        } else {
            ws.curTab.setQuery(null);
        }
        ws.curTab.query(0);
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
            Element element = document.createElement("element");
            document.getFirstChild().appendChild(element);
            Element elm_id = document.createElement("id");
            String objId = this.QUERY_ENTRY_DIV;
            elm_id.appendChild(document.createTextNode(objId));
            element.appendChild(elm_id);
            Element elm_lookup = document.createElement("lookup");
            element.appendChild(elm_lookup);
            elm_lookup.appendChild(document.createTextNode("0"));
            Element elm_visibility = document.createElement("visibility");
            element.appendChild(elm_visibility);
            elm_visibility.appendChild(document.createTextNode("1"));
            Element elm_newValue = document.createElement("newValue");
            element.appendChild(elm_newValue);
            StringBuffer sb = new StringBuffer();
            sb.append("window.opener.onunload='';");
            sb.append("window.opener.document.WForm.PCommand.value='Refresh';");
            sb.append("window.opener.document.WForm.submit();");
            if (!StringUtils.isEmpty(result_msg)) {
                sb.append("alert('" + result_msg + "');window.close();");
            } else {
                sb.append("window.close();");
            }
            elm_newValue.appendChild(document.createTextNode(sb.toString()));
            Element elm_readonly = document.createElement("readonly");
            element.appendChild(elm_readonly);
            elm_readonly.appendChild(document.createTextNode("0"));
            Element elm_type = document.createElement("type");
            element.appendChild(elm_type);
            elm_type.appendChild(document.createTextNode("script"));
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }

    private String cmd_saveAdvanced(HttpServletRequest request) {
        MUserQuery uq;
        Vector<AdvancedRow> advancedData;
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        int m_AD_Tab_ID = ws.getCurTab().getAD_Tab_ID();
        int m_AD_Table_ID = ws.getCurTab().getAD_Table_ID();
        String msg = "";
        this.log.fine("");
        this.cmd_saveRow(request);
        Query m_query = this.getQueryAdvanced(request);
        if (m_query == null || m_query.getRestrictionCount() == 0) {
            return msg;
        }
        String where = m_query.getWhereClause();
        String name = WebUtil.getParameter(request, this.QUERY_NAME);
        if (name != null && name.length() == 0) {
            name = null;
        }
        if ((advancedData = (Vector<AdvancedRow>)session.getAttribute(this.ADVANCED_DATA)) == null) {
            advancedData = new Vector<AdvancedRow>();
        }
        if ((uq = this.getSelectedQuery(request)) != null) {
            if (name != null) {
                uq.setName(name);
            }
            uq.setCode(where);
            uq.setAD_Tab_ID(m_AD_Tab_ID);
            uq.setAD_Table_ID(m_AD_Table_ID);
            if (uq.save()) {
                AdvancedRow.store(uq, advancedData);
                msg = AWebUtil.info(request, "Updated", uq.getName());
            } else {
                msg = AWebUtil.info(request, "SaveError", uq.getName());
            }
        } else if (name != null) {
            uq = new MUserQuery(wsc.ctx, 0, null);
            uq.setName(name);
            uq.setCode(where);
            uq.setAD_Tab_ID(m_AD_Tab_ID);
            uq.setAD_Table_ID(m_AD_Table_ID);
            if (uq.save()) {
                AdvancedRow.store(uq, advancedData);
                msg = AWebUtil.info(request, "Saved", uq.getName());
            } else {
                msg = AWebUtil.info(request, "SaveError", uq.getName());
            }
        }
        return msg;
    }

    private int getNoOfRecords(HttpServletRequest request, Query query, boolean alertZeroRecords) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String m_tableName = ws.getCurTab().getTableName();
        int m_targetWindowNo = ws.getCurTab().getAD_Table_ID();
        this.log.config(query == null ? "" : query.toString());
        StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ");
        sql.append(m_tableName);
        boolean hasWhere = false;
        String m_whereExtended = "";
        if (m_whereExtended != null && m_whereExtended.length() > 0) {
            sql.append(" WHERE ").append(m_whereExtended);
            hasWhere = true;
        }
        if (query != null && query.isActive()) {
            if (hasWhere) {
                sql.append(" AND ");
            } else {
                sql.append(" WHERE ");
            }
            sql.append(query.getWhereClause());
        }
        String finalSQL = MRole.getDefault(wsc.ctx, false).addAccessSQL(sql.toString(), m_tableName, false, false);
        finalSQL = Env.parseContext(wsc.ctx, m_targetWindowNo, finalSQL, false);
        wsc.ctx.setContext(m_targetWindowNo, this.TABNO, "FindSQL", finalSQL);
        int m_total = 999999;
        try {
            Statement stmt = DB.createStatement();
            ResultSet rs = stmt.executeQuery(finalSQL);
            if (rs.next()) {
                m_total = rs.getInt(1);
            }
            rs.close();
            stmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, finalSQL, e);
        }
        return m_total;
    }

    private option[] getOptions(GridField mField, Lookup lookup, String dataValue) {
        int m_displayType = mField.getDisplayType();
        if (lookup == null) {
            return new option[0];
        }
        Object[] list = lookup.getData(false, true, false, false).toArray();
        int size = list.length;
        if (size <= 0) {
            list = lookup.getData(false, true, true, true).toArray();
            size = list.length;
        }
        option[] options = new option[size];
        for (int i2 = 0; i2 < size; ++i2) {
            NamePair p2;
            String name;
            boolean isNumber = list[0] instanceof KeyNamePair;
            String key = null;
            if (m_displayType == 31 && !isNumber) {
                MLocator loc = (MLocator)list[i2];
                key = String.valueOf(loc.getM_Locator_ID());
                name = AmpiereUtil.maskHTML(loc.getValue());
                options[i2] = new option(key).addElement(name);
            } else if (isNumber) {
                p2 = (KeyNamePair)list[i2];
                key = String.valueOf(((KeyNamePair)p2).getKey());
                name = AmpiereUtil.maskHTML(p2.getName());
                options[i2] = new option(key).addElement(name);
            } else {
                p2 = (ValueNamePair)list[i2];
                key = ((ValueNamePair)p2).getValue();
                if (key == null || key.length() == 0) {
                    key = "";
                }
                if ((name = p2.getName()) == null || name.length() == 0) {
                    name = " ";
                }
                name = AmpiereUtil.maskHTML(name);
                options[i2] = new option(key).addElement(name);
            }
            if (!dataValue.equals(key)) continue;
            options[i2].setSelected(true);
        }
        return options;
    }

    private String readReferenceName(HttpServletRequest request, int AD_Reference_ID, String value) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        String name = value;
        String SQL = Env.isBaseLanguage(wsc.ctx, "AD_Ref_List") ? "SELECT Name FROM AD_Ref_List WHERE AD_Reference_ID=? AND VALUE=?" : "SELECT t.Name FROM AD_Ref_List l, AD_Ref_List_Trl t WHERE l.AD_Ref_List_ID=t.AD_Ref_List_ID AND t.AD_Language='" + Env.getAD_Language(wsc.ctx) + "'" + " AND l.AD_Reference_ID=?" + " AND l.VALUE=?";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(SQL, null);
            pstmt.setInt(1, AD_Reference_ID);
            pstmt.setString(2, value);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                name = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            // empty catch block
        }
        return name;
    }

    Document getDoc(HttpServletRequest request) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
        }
        catch (Exception e) {
            // empty catch block
        }
        return document;
    }
}

