/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AWebUtil;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.swing.tree.TreeNode;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.base;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.li;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.apache.ecs.xhtml.ul;
import org.compiere.model.CTreeNode;
import org.compiere.model.MClient;
import org.compiere.model.MForm;
import org.compiere.model.MOrg;
import org.compiere.model.MRole;
import org.compiere.model.MTree;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.model.X_AD_Menu;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Login;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WMenu
extends HttpServlet {
    private static final long serialVersionUID = 69175041285196528L;
    protected CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WMenu.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Menu";
    }

    public void destroy() {
        this.log.fine("destroy");
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.fine("doGet - Process Menu Request");
        if (WebUtil.getParameter(request, "Exit") != null) {
            WebUtil.createLoginPage(request, response, this, null, "Exit");
            return;
        }
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc.ctx == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int AD_Window_ID = WebUtil.getParameterAsInt(request, "AD_Window_ID");
        if (AD_Window_ID != 0) {
            this.log.fine("doGet - AD_Window_ID=" + AD_Window_ID);
            String url = WebEnv.getBaseDirectory("WWindow?AD_Window_ID=" + AD_Window_ID);
            this.log.fine("doGet - Forward to=" + url);
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(url);
            rd.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        WebUtil.createErrorPage(request, response, this, "NotImplemented");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.fine("doPost - Create Menu");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String role = WebUtil.getParameter(request, "AD_Role_ID");
        String client = WebUtil.getParameter(request, "AD_Client_ID");
        String org = WebUtil.getParameter(request, "AD_Org_ID");
        String wh = WebUtil.getParameter(request, "M_Warehouse_ID");
        Timestamp date = WebUtil.getParameterAsDate(request, "Date", wsc.language);
        if (wh == null) {
            wh = "";
        }
        if (role == null || client == null || org == null) {
            WebUtil.createTimeoutPage(request, response, this, Msg.getMsg(wsc.ctx, "ParameterMissing"));
            return;
        }
        int AD_User_ID = wsc.ctx.getAD_User_ID();
        int AD_Role_ID = wsc.ctx.getAD_Role_ID();
        int AD_Client_ID = wsc.ctx.getAD_Client_ID();
        int AD_Org_ID = -1;
        int M_Warehouse_ID = -1;
        try {
            int req_role = Integer.parseInt(role);
            if (req_role != AD_Role_ID) {
                this.log.fine("doPost - AD_Role_ID - changed from " + AD_Role_ID);
                AD_Role_ID = req_role;
                wsc.ctx.setContext("#AD_Role_ID", AD_Role_ID);
            }
            this.log.fine("doPost - AD_Role_ID = " + AD_Role_ID);
            int req_client = Integer.parseInt(client);
            if (req_client != AD_Client_ID) {
                this.log.fine("doPost - AD_Client_ID - changed from " + AD_Client_ID);
                AD_Client_ID = req_client;
                wsc.ctx.setContext("#AD_Client_ID", AD_Client_ID);
            }
            this.log.fine("doPost - AD_Client_ID = " + AD_Client_ID);
            AD_Org_ID = Integer.parseInt(org);
            this.log.fine("doPost - AD_Org_ID = " + AD_Org_ID);
            if (wh.length() > 0) {
                M_Warehouse_ID = Integer.parseInt(wh);
                this.log.fine("doPost - M_Warehouse_ID = " + M_Warehouse_ID);
            }
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "doPost - Parameter", e);
            WebUtil.createTimeoutPage(request, response, this, Msg.getMsg(wsc.ctx, "ParameterMissing"));
            return;
        }
        wsc.loginInfo = this.checkLogin(wsc.ctx, AD_User_ID, AD_Role_ID, AD_Client_ID, AD_Org_ID, M_Warehouse_ID, date);
        if (wsc.loginInfo == null) {
            WebUtil.createErrorPage(request, response, this, Msg.getMsg(wsc.ctx, "RoleInconsistent"));
            return;
        }
        Properties cProp = AWebUtil.getCookieProprties(request);
        cProp.setProperty("AD_Role_ID", String.valueOf(AD_Role_ID));
        cProp.setProperty("AD_Client_ID", String.valueOf(AD_Client_ID));
        cProp.setProperty("AD_Org_ID", String.valueOf(AD_Org_ID));
        if (M_Warehouse_ID == -1) {
            cProp.setProperty("M_Warehouse_ID", "");
        } else {
            cProp.setProperty("M_Warehouse_ID", String.valueOf(M_Warehouse_ID));
        }
        if (!cProp.getProperty("SaveCookie", "N").equals("Y")) {
            cProp.clear();
        }
        WebDoc doc = this.createPage(request, wsc, AD_Role_ID);
        WebUtil.createResponse(request, response, this, cProp, doc, false);
    }

    private String checkLogin(Ctx ctx, int AD_User_ID, int AD_Role_ID, int AD_Client_ID, int AD_Org_ID, int M_Warehouse_ID, Timestamp date) {
        String loginInfo = null;
        String sql = "SELECT u.Name || '@' || c.Name || '.' || o.Name AS Text FROM AD_User u, AD_Client c, AD_Org o, AD_User_Roles ur WHERE u.AD_User_ID=? AND c.AD_Client_ID=? AND o.AD_Org_ID=? AND ur.AD_Role_ID=? AND ur.AD_User_ID=u.AD_User_ID AND (o.AD_Client_ID = 0 OR o.AD_Client_ID=c.AD_Client_ID) AND c.AD_Client_ID IN (SELECT AD_Client_ID FROM AD_Role_OrgAccess ca WHERE ca.AD_Role_ID=ur.AD_Role_ID) AND o.AD_Org_ID IN (SELECT AD_Org_ID FROM AD_Role_OrgAccess ca WHERE ca.AD_Role_ID=ur.AD_Role_ID)";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_User_ID);
            pstmt.setInt(2, AD_Client_ID);
            pstmt.setInt(3, AD_Org_ID);
            pstmt.setInt(4, AD_Role_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                loginInfo = rs.getString(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        if (loginInfo == null) {
            return null;
        }
        MUser user = new MUser(ctx, AD_User_ID, null);
        MRole role = new MRole(ctx, AD_Role_ID, null);
        ctx.setContext("#AD_Role_Name", role.getName());
        MClient client = MClient.get(ctx, AD_Client_ID);
        ctx.setContext("#AD_Client_Name", client.getName());
        MOrg org = MOrg.get(ctx, AD_Org_ID);
        KeyNamePair orgPair = new KeyNamePair(AD_Org_ID, org.getName());
        KeyNamePair wh = null;
        if (M_Warehouse_ID > 0) {
            MWarehouse warehouse = MWarehouse.get(ctx, M_Warehouse_ID);
            wh = new KeyNamePair(M_Warehouse_ID, warehouse.getName());
        }
        Login login = new Login(ctx);
        login.getRoles(user.getName(), user.getPassword());
        login.loadPreferences(orgPair, wh, date, null);
        KeyNamePair[] userOrgs = login.getOrgs(client.getKeyNamePair());
        String orgs = "";
        for (int i2 = 0; i2 < userOrgs.length; ++i2) {
            if (i2 > 0) {
                orgs = orgs + ",";
            }
            orgs = orgs + userOrgs[i2].getKey();
        }
        ctx.setContext("#User_Org", orgs);
        return loginInfo;
    }

    private WebDoc createPage(HttpServletRequest request, WebSessionCtx wsc, int AD_Role_ID) {
        String ch;
        String windowTitle = Msg.getMsg(wsc.ctx, "Menu");
        if (windowTitle.indexOf(ch = "(") > 0) {
            windowTitle = windowTitle.substring(0, windowTitle.indexOf(ch));
        }
        request.setAttribute("BODY_ID", (Object)"menu");
        request.setAttribute("LOGIN_INFO", (Object)wsc.loginInfo);
        WebDoc doc = WebDoc.create(windowTitle, request);
        head head2 = doc.getHead();
        head2.addElement((Element)new base().setTarget("WWindow"));
        head2.addElement((Element)new link(WebEnv.getBaseDirectory("css/import_menu.css"), "stylesheet", "text/css"));
        head2.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory("js/menu.js")));
        String statusMessage = Msg.getMsg(wsc.ctx, "SelectMenuItem");
        String scriptTxt = "top.document.title='" + windowTitle + " - " + wsc.loginInfo + "'; " + "var defaultStatus='" + statusMessage + "';";
        head2.addElement((Element)new script(scriptTxt));
        body body2 = doc.getBody();
        body2.setTitle(statusMessage);
        body2.addElement((Element)WebUtil.getClearFrame("WWindow"));
        table table2 = doc.getTable();
        int AD_Tree_ID = DB.getSQLValue(null, "SELECT COALESCE(r.AD_Tree_Menu_ID, ci.AD_Tree_Menu_ID)FROM AD_ClientInfo ci INNER JOIN AD_Role r ON (ci.AD_Client_ID=r.AD_Client_ID) WHERE AD_Role_ID=?", AD_Role_ID);
        if (AD_Tree_ID <= 0) {
            AD_Tree_ID = 10;
        }
        this.log.fine("doPost - AD_Tree_ID=" + AD_Tree_ID + " - " + Env.getAD_Language(wsc.ctx));
        MTree tree = new MTree(wsc.ctx, AD_Tree_ID, false, false, null);
        CTreeNode root = tree.getRoot();
        Enumeration<TreeNode> en = root.preorderEnumeration();
        while (en.hasMoreElements()) {
            CTreeNode nd = (CTreeNode)en.nextElement();
            if (!nd.isTask() && !nd.isWorkbench() && !nd.isWorkFlow() && nd.getNode_ID() != 383) continue;
            CTreeNode parent = (CTreeNode)nd.getParent();
            parent.remove(nd);
        }
        tree.trimTree();
        StringBuffer buf = new StringBuffer();
        StringBuffer bar = new StringBuffer();
        bar.append("<div id =\"shotMenu\" style=\"margin-left:30px;display:none\"><ul id=\"shotMenuList\">\n");
        en = root.preorderEnumeration();
        int oldLevel = 0;
        while (en.hasMoreElements()) {
            CTreeNode nd = (CTreeNode)en.nextElement();
            int level = nd.getLevel();
            if (level == 0) continue;
            while (oldLevel < level) {
                if (level == 1) {
                    buf.append("<ul id=\"menuList\">\n");
                } else {
                    buf.append("<ul style=\"display:none\">\n");
                }
                ++oldLevel;
            }
            while (oldLevel > level) {
                if (--oldLevel == 1) {
                    buf.append("</ul>\n");
                    continue;
                }
                buf.append("</ul></li>\n");
            }
            buf.append(this.printNode(nd, wsc.ctx));
            if (!nd.isOnBar()) continue;
            bar.append(this.printNode(nd, wsc.ctx));
        }
        bar.append("</ul></div>\n");
        while (oldLevel > 0) {
            if (--oldLevel == 1) {
                buf.append("</ul>\n");
                continue;
            }
            buf.append("</ul></li>\n");
        }
        td td2 = new td().setColSpan(2).setNoWrap(true);
        td2.setClass("menuCenter");
        div divBody = (div)new div().setID("body");
        td2.addElement((Element)divBody);
        divBody.addElement(bar.toString());
        divBody.addElement(buf.toString());
        table2.addElement((Element)new tr().addElement((Element)td2));
        input t = new input("hidden", "MenuOnOff", "MenuOn");
        t.setID("MenuOnOff");
        div divInput = new div();
        divInput.addElement((Element)t);
        divBody.addElement((Element)divInput);
        div divBottomMenuLeft = (div)new div().setClass("bottomMenuLeft");
        divBody.addElement((Element)divBottomMenuLeft);
        td tdMenuFooter = (td)new td().setClass("menuFooter");
        ul notificationBar = new ul();
        notificationBar.setStyle("margin:0 0 0 20");
        divBottomMenuLeft.addElement((Element)new hr());
        divBottomMenuLeft.addElement((Element)new b((Element)notificationBar));
        a aPerformance = new a("WPerformanceMeter", Msg.translate(wsc.ctx, "Performance"));
        notificationBar.addElement((Element)new li().addElement((Element)aPerformance));
        this.addRequestAndNote(notificationBar, wsc);
        a aExit = new a().setHref("WMenu?Exit=true");
        img imgExit = new img(WebEnv.getImageDirectory("Exit32.png")).setAlt(Msg.getMsg(wsc.ctx, "Exit"));
        span spanExit = new span(Msg.getMsg(wsc.ctx, "LogOff"));
        divBottomMenuLeft.addElement((Element)new table().addElement((Element)new tr().addElement((Element)tdMenuFooter)));
        tdMenuFooter.addElement((Element)aExit);
        aExit.addElement((Element)imgExit);
        aExit.addElement((Element)spanExit);
        return doc;
    }

    private StringBuffer printNode(CTreeNode node, Ctx ctx) {
        StringBuffer sb = new StringBuffer();
        if (!node.isSummary()) {
            MForm form2;
            String cssClassName = "";
            String servletName = "";
            if (node.isWindow()) {
                cssClassName = "menuWindow";
                servletName = "WWindow";
            } else if (node.isForm()) {
                cssClassName = "menuWindow";
                servletName = "WFormWindow";
            } else if (node.isReport()) {
                cssClassName = "menuReport";
                servletName = "WProcess";
            } else if (node.isProcess()) {
                cssClassName = "menuProcess";
                servletName = "WProcess";
            } else if (node.isWorkFlow()) {
                cssClassName = "menuWorkflow";
                servletName = "WWorkflow";
            } else if (node.isTask()) {
                cssClassName = "menuProcess";
                servletName = "WTask";
            } else {
                servletName = "WError";
            }
            String name = node.getName().replace('\'', ' ').replace('\"', ' ');
            String description = node.getDescription().replace('\'', ' ').replace('\"', ' ').replace('\n', ' ').replace('\r', ' ');
            sb.append("<li class=\"" + cssClassName + "\" id=\"" + node.getNode_ID() + "\"><a href=\"");
            boolean standardURL = true;
            if (node.isForm() && (form2 = new MForm(ctx, new X_AD_Menu(ctx, node.getNode_ID(), null).getAD_Form_ID(), null)).getJSPURL() != null && form2.getJSPURL().length() > 0) {
                sb.append(form2.getJSPURL());
                standardURL = false;
            }
            if (standardURL) {
                sb.append(WebEnv.getBaseDirectory(servletName));
            }
            sb.append("?AD_Menu_ID=");
            sb.append(node.getNode_ID());
            sb.append("\" onMouseOver=\"status='" + description + "';\" onClick=\"showLoadingWindow('" + WebEnv.getBaseDirectory("") + "')\">").append(name).append("</a></li>\n");
        } else {
            String name = node.getName().replace('\'', ' ').replace('\"', ' ');
            sb.append("\n<li class=\"menuSummary\" id=\"" + node.getNode_ID() + "\" onClick=\"changeMenu(event);\">").append(name).append("\n");
        }
        return sb;
    }

    private int getRequests(WebSessionCtx wsc) {
        String m_requestSQL = null;
        int m_AD_User_ID = wsc.ctx.getAD_User_ID();
        int m_AD_Role_ID = wsc.ctx.getAD_Role_ID();
        int retValue = 0;
        if (m_requestSQL == null) {
            m_requestSQL = MRole.getDefault(wsc.ctx, false).addAccessSQL("SELECT COUNT(*) FROM R_Request WHERE (SalesRep_ID=? OR AD_Role_ID=?) AND Processed='N' AND (DateNextAction IS NULL OR TRUNC(DateNextAction, 'DD') <= TRUNC(SysDate, 'DD')) AND (R_Status_ID IS NULL OR R_Status_ID IN (SELECT R_Status_ID FROM R_Status WHERE IsClosed='N'))", "R_Request", false, true);
        }
        try {
            CPreparedStatement pstmt = DB.prepareStatement(m_requestSQL, null);
            pstmt.setInt(1, m_AD_User_ID);
            pstmt.setInt(2, m_AD_Role_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, m_requestSQL, e);
        }
        return retValue;
    }

    private String getOpenRequestUrl() {
        int m_WINDOW_ID = 201;
        String requestUrl = "WWindow?windowId=" + String.valueOf(m_WINDOW_ID);
        return requestUrl;
    }

    private String getNotesUrl() {
        int m_note_Window_ID = 0;
        if (m_note_Window_ID == 0) {
            m_note_Window_ID = DB.getSQLValue(null, "SELECT m.AD_WINDOW_ID FROM AD_Menu m INNER JOIN AD_TABLE t ON (t.AD_Window_ID=m.AD_Window_ID) WHERE t.AD_Table_ID=?", 389);
        }
        if (m_note_Window_ID == 0) {
            m_note_Window_ID = 193;
        }
        String noteUrl = "WWindow?windowId=" + String.valueOf(m_note_Window_ID);
        return noteUrl;
    }

    private int getNotes(WebSessionCtx wsc) {
        int m_AD_Client_ID = wsc.ctx.getAD_Client_ID();
        int m_AD_User_ID = wsc.ctx.getAD_User_ID();
        int retValue = 0;
        String sql = "SELECT COUNT(*) FROM AD_Note WHERE AD_Client_ID=? AND AD_User_ID IN (0,?) AND Processed='N'";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, m_AD_Client_ID);
            pstmt.setInt(2, m_AD_User_ID);
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getInt(1);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return retValue;
    }

    private void addRequestAndNote(ul notificationBar, WebSessionCtx wsc) {
        int requests = this.getRequests(wsc);
        String requestInfo = Msg.translate(wsc.ctx, "R_Request_ID") + ": " + requests;
        String requestUrl = this.getOpenRequestUrl();
        a a_request = new a(requestUrl, requestInfo);
        a_request.setTarget("_BLANK");
        if (requests > 0) {
            notificationBar.addElement((Element)new li().addElement((Element)a_request));
        }
        int notes = this.getNotes(wsc);
        String noteInfo = Msg.translate(wsc.ctx, "AD_Note_ID") + ": " + notes;
        String noteUrl = this.getNotesUrl();
        a a_note = new a(noteUrl, noteInfo);
        a_note.setTarget("_BLANK");
        if (notes > 0) {
            notificationBar.addElement((Element)new li().addElement((Element)a_note));
        }
    }
}

