/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.BarGraph;
import com.ampiere.util.BarGraphColumn;
import com.ampiere.util.GraphUtil;
import com.ampiere.web.servlet.WWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.area;
import org.apache.ecs.xhtml.b;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.map;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.framework.Query;
import org.compiere.framework.ZoomTarget;
import org.compiere.model.MAchievement;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MProjectType;
import org.compiere.model.MRequestType;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WPerformanceBar
extends HttpServlet {
    private static final long serialVersionUID = -8472078781140462598L;
    protected static CLogger log = CLogger.getCLogger(WPerformanceBar.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WPerformanceBar.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Window";
    }

    public void destroy() {
        log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info(((Object)((Object)this)).getClass().getName() + ".doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int goalId = WebUtil.getParameterAsInt(request, "GOAL_ID");
        MGoal[] goals = MGoal.getUserGoals(wsc.ctx, wsc.ctx.getAD_Role_ID(), wsc.ctx.getAD_User_ID());
        for (int i2 = 0; i2 < goals.length; ++i2) {
            if (goalId != goals[i2].get_ID()) continue;
            WebDoc doc = WebDoc.createWindow(goals[i2].getName(), request);
            doc.getTable().addElement((Element)new tr().addElement((Element)new td(null, "left", "top", true, (Element)WWindow.createMenuDiv(wsc, null))));
            doc.getHead().addElement((Element)new script(WWindow.makeMenuItemScript(wsc, null)));
            doc.getBody().setOnLoad("displayMenu();");
            body bdy = doc.getBody();
            bdy.addElement("<br>");
            img performance = new img("/compiere/ampiere/WPerformanceImage?IMAGE_TYPE_NAME=IMAGE_TYPE_BAR&GOAL_ID=" + goals[i2].get_ID());
            performance.setUseMap("#map" + goals[i2].get_ID());
            bdy.addElement((Element)performance);
            map goalMap = new map();
            goalMap.setName("map" + goals[i2].get_ID());
            Dimension size = new Dimension(600, 400);
            BarGraph barGraph = new BarGraph(goals[i2]);
            Font font2 = barGraph.getFont();
            FontMetrics fm = barGraph.getFontMetrics(font2);
            int fontHeight = fm.getHeight();
            int yAxis_X = fontHeight + 10;
            int xAxis_Y = size.height - fontHeight - 10;
            Point point0_0 = new Point(yAxis_X, xAxis_Y);
            double maxValue = 0.0;
            Component[] data = barGraph.getComponents();
            for (int j = 0; j < data.length; ++j) {
                BarGraphColumn column = (BarGraphColumn)data[j];
                maxValue = Math.max(maxValue, column.getValue());
            }
            double graphHeight = size.height - (size.height - point0_0.y) - 2;
            double graphWidth = size.width - point0_0.x - 2;
            double columnWidth = (graphWidth - (double)(2 * data.length)) / (double)data.length;
            columnWidth = Math.min(30.0, columnWidth);
            columnWidth = Math.max((double)fontHeight, columnWidth);
            int x = point0_0.x + 4;
            for (int j = 0; j < data.length; ++j) {
                BarGraphColumn column = (BarGraphColumn)data[j];
                double multiplier = column.getValue() / maxValue;
                double height = graphHeight * multiplier;
                column.setColHeight(height);
                column.setColWidth(columnWidth);
                Dimension ps = column.getPreferredSize();
                column.setBackground(GraphUtil.getBackground(j));
                int y = point0_0.y - ps.height - 1;
                column.setLocation(x, y);
                column.setBounds(x, y, ps.width, ps.height);
                BarGraphColumn bgc = column;
                Query query = null;
                if (bgc.getAchievement() != null) {
                    MAchievement a2 = bgc.getAchievement();
                    query = Query.getEqualQuery("PA_Measure_ID", a2.getPA_Measure_ID());
                } else if (bgc.getGoal() != null) {
                    MGoal goal = bgc.getGoal();
                    query = Query.getEqualQuery("PA_Measure_ID", goal.getPA_Measure_ID());
                } else if (bgc.getMeasureCalc() != null) {
                    MMeasureCalc mc = bgc.getMeasureCalc();
                    query = mc.getQuery(goals[i2].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), MRole.getDefault(wsc.ctx, false));
                } else if (bgc.getProjectType() != null) {
                    MProjectType pt = bgc.getProjectType();
                    query = pt.getQuery(goals[i2].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(), MRole.getDefault(wsc.ctx, false));
                } else if (bgc.getRequestType() != null) {
                    MRequestType rt = bgc.getRequestType();
                    query = rt.getQuery(goals[i2].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(), MRole.getDefault(wsc.ctx, false));
                }
                String TableName = query.getTableName();
                int AD_Window_ID = 0;
                int PO_Window_ID = 0;
                String sql = "SELECT AD_Window_ID, PO_Window_ID FROM AD_Table WHERE TableName=?";
                try {
                    CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                    pstmt.setString(1, TableName);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_Window_ID = rs.getInt(1);
                        PO_Window_ID = rs.getInt(2);
                    }
                    rs.close();
                    pstmt.close();
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, e);
                }
                boolean isSOTrx = true;
                if (PO_Window_ID != 0) {
                    AD_Window_ID = ZoomTarget.getZoomAD_Window_ID(TableName, 0, query.getWhereClause(), isSOTrx);
                }
                Rectangle bounds = column.getBounds();
                String bound = bounds.x + "," + bounds.y + "," + (bounds.x + bounds.width) + "," + (bounds.y + bounds.height);
                String url = "/compiere/ampiere/WWindow?AD_Window_ID=" + AD_Window_ID + "&" + "GOAL_ID" + "=" + goals[i2].get_ID() + "&" + "GOAL_COLUMN_INDEX" + "=" + j;
                area columnArea = new area("rect", bound, url);
                columnArea.setAlt(column.getName());
                columnArea.setTitle(column.getName());
                goalMap.addElement((Element)columnArea);
                x += ps.width + 2;
            }
            data = null;
            barGraph = null;
            bdy.addElement((Element)goalMap);
            bdy.addElement((Element)new br("both"));
            bdy.addElement((Element)new br("both"));
            bdy.addElement((Element)new span("&nbsp;&nbsp;&nbsp;&nbsp;"));
            a aPerformance = new a().setHref("WPerformanceMeter");
            aPerformance.addElement((Element)new b((Element)new span(Msg.translate(wsc.ctx, "Performance"))));
            bdy.addElement((Element)aPerformance);
            WebUtil.createResponse(request, response, this, null, doc, false);
        }
        log.fine("Fini");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.fine("doPost");
    }
}

