/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.web.servlet.WWindow;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.body;
import org.apache.ecs.xhtml.br;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.model.MGoal;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WPerformanceMeter
extends HttpServlet {
    private static final long serialVersionUID = -8472078781140462598L;
    protected static CLogger log = CLogger.getCLogger(WPerformanceMeter.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WPerformanceImage.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Window";
    }

    public void destroy() {
        log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.info(((Object)((Object)this)).getClass().getName() + ".doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        String windowTitle = Msg.translate(wsc.ctx, "Performance");
        WebDoc doc = WebDoc.createWindow(windowTitle, request);
        doc.getTable().addElement((Element)new tr().addElement((Element)new td(null, "left", "top", true, (Element)WWindow.createMenuDiv(wsc, null))));
        doc.getHead().addElement((Element)new script(WWindow.makeMenuItemScript(wsc, null)));
        doc.getBody().setOnLoad("displayMenu();");
        body bdy = doc.getBody();
        bdy.addElement("<br>");
        MGoal[] goals = MGoal.getUserGoals(wsc.ctx, wsc.ctx.getAD_Role_ID(), wsc.ctx.getAD_User_ID());
        for (int i2 = 0; i2 < goals.length; ++i2) {
            img performance = new img("/compiere/ampiere/WPerformanceImage?IMAGE_TYPE_NAME=IMAGE_TYPE_METER&GOAL_ID=" + goals[i2].get_ID());
            performance.setBorder(0);
            DecimalFormat s_format = DisplayType.getNumberFormat(11);
            StringBuilder text = new StringBuilder();
            if (goals[i2].getDescription() != null) {
                text.append(goals[i2].getDescription());
            } else {
                text.append(goals[i2].getName());
            }
            text.append(": ");
            text.append(s_format.format(goals[i2].getMeasureActual()));
            if (goals[i2].isTarget()) {
                text.append(" / ").append(s_format.format(goals[i2].getMeasureTarget()));
            }
            performance.setTitle(text.toString());
            performance.setOnClick("top.frames['WWindow'].location.href='/compiere/ampiere/WPerformanceBar?GOAL_ID=" + goals[i2].get_ID() + "';");
            bdy.addElement((Element)performance);
            if (i2 <= 0 || (i2 + 1) % 2 != 0) continue;
            bdy.addElement((Element)new br("both"));
        }
        log.fine("Fini");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        log.fine("doPost");
    }
}

