/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WWindowStatus;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.label;
import org.apache.ecs.xhtml.option;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.select;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.compiere.framework.PrintInfo;
import org.compiere.framework.Query;
import org.compiere.model.MPInstance;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.model.MProcess;
import org.compiere.model.MRole;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;

public class WPrint
extends HttpServlet {
    private static final long serialVersionUID = -66341541642842506L;
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    public static final String PRINT_FORMAT = "PrintFormat";
    public static final String FILE_FORMAT = "FileFormat";
    public static final String FILE_FORMAT_PDF = "pdf";
    public static final String FILE_FORMAT_PS = "ps";
    public static final String FILE_FORMAT_XML = "xml";
    public static final String FILE_FORMAT_HTML = "html";
    public static final String FILE_FORMAT_TXT = "txt";
    public static final String FILE_FORMAT_SSV = "ssv";
    public static final String FILE_FORMAT_CSV = "csv";
    public static final String FILE_FORMAT_SAVE = "SaveFile";

    public final void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WPrint.init");
        }
    }

    public final String getServletInfo() {
        return "Ampiere Web Print Window";
    }

    public final void destroy() {
        this.log.info("destroy");
        super.destroy();
    }

    public final void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doGet");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        WWindowStatus ws = WWindowStatus.get(request);
        int processId = wsc.ctx.getContextAsInt("AD_Process_ID");
        int pInstanceId = wsc.ctx.getContextAsInt("AD_PInstance_ID");
        MProcess process = MProcess.get(wsc.ctx, processId);
        MPInstance pInstance = new MPInstance(wsc.ctx, pInstanceId, null);
        ProcessInfo processInfo = new ProcessInfo(process.getName(), process.getAD_Process_ID());
        processInfo.setAD_User_ID(wsc.ctx.getAD_User_ID());
        processInfo.setAD_Client_ID(wsc.ctx.getAD_Client_ID());
        processInfo.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
        processInfo.setRecord_ID(pInstance.getRecord_ID());
        if (ws != null) {
            processInfo.setRecord_ID(ws.curTab.getRecord_ID());
        }
        ReportEngine re = null;
        if (processInfo.getAD_Process_ID() == 110) {
            re = ReportEngine.get(wsc.ctx, 0, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 116) {
            re = ReportEngine.get(wsc.ctx, 2, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 117) {
            re = ReportEngine.get(wsc.ctx, 1, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 217) {
            re = ReportEngine.get(wsc.ctx, 3, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 276) {
            re = ReportEngine.get(wsc.ctx, 4, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 313) {
            int paySelectionCheckId = 0;
            MPaySelectionCheck psc = MPaySelectionCheck.getOfPayment(wsc.ctx, processInfo.getRecord_ID(), null);
            if (psc != null) {
                paySelectionCheckId = psc.getC_PaySelectionCheck_ID();
            } else {
                psc = MPaySelectionCheck.createForPayment(wsc.ctx, processInfo.getRecord_ID(), null);
                if (psc != null) {
                    paySelectionCheckId = psc.getC_PaySelectionCheck_ID();
                }
            }
            re = ReportEngine.get(wsc.ctx, 6, paySelectionCheckId);
        } else if (processInfo.getAD_Process_ID() == 159) {
            re = ReportEngine.get(wsc.ctx, 7, processInfo.getRecord_ID());
        } else if (processInfo.getAD_Process_ID() == 202 || processInfo.getAD_Process_ID() == 204) {
            String tableName = processInfo.getAD_Process_ID() == 202 ? "T_Report" : "T_ReportStatement";
            Query query = Query.get(wsc.ctx, processInfo.getAD_PInstance_ID(), tableName);
            MPrintFormat format = (MPrintFormat)processInfo.getTransientObject();
            if (format == null) {
                format = (MPrintFormat)processInfo.getSerializableObject();
            }
            if (format == null) {
                this.log.log(Level.SEVERE, "startFinReport - No PrintFormat");
                return;
            }
            PrintInfo info = new PrintInfo(processInfo);
            re = new ReportEngine(wsc.ctx, format, query, info);
        } else {
            re = ReportEngine.get(wsc.ctx, processInfo);
        }
        int tableId = re.getPrintFormat().getAD_Table_ID();
        String title = "";
        try {
            title = ws.curTab.getName() + " : ";
        }
        catch (Exception e) {
            // empty catch block
        }
        title = title + Msg.getMsg(wsc.ctx, "Report");
        WebDoc doc = WebDoc.createWindow(title);
        doc.getBody().addElement((Element)new script("top.document.title='" + title + "';"));
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        td center = doc.addWindowCenter(false);
        form myForm = new form("WPrint").setName("WPrint");
        table myTable = new table("0", "0", "5", "100%", null);
        myTable.setID("WPrint");
        myTable.setStyle("border-collapse:separate;border-spacing:20px;");
        tr line = new tr();
        line.addElement((Element)new td().addElement(Msg.translate(wsc.ctx, "AD_PrintFormat_ID")).setAlign("right"));
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> names = new ArrayList<String>();
        String sql = MRole.getDefault(wsc.ctx, false).addAccessSQL("SELECT AD_PrintFormat_ID, Name, AD_Client_ID FROM AD_PrintFormat WHERE AD_Table_ID=? AND ISACTIVE='Y' ORDER BY AD_Client_ID DESC, IsDefault DESC, Name", "AD_PrintFormat", false, false);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, tableId);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                ids.add(rs.getString(1));
                names.add(rs.getString(2));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        option[] options = new option[ids.size()];
        for (int i2 = 0; i2 < ids.size(); ++i2) {
            options[i2] = new option((String)ids.get(i2)).addElement((String)names.get(i2));
            if (re.getPrintFormat().getAD_PrintFormat_ID() != Integer.valueOf((String)ids.get(i2)).intValue()) continue;
            options[i2].setSelected(true);
        }
        line.addElement((Element)new td().addElement(new select(PRINT_FORMAT, options).setID(PRINT_FORMAT)));
        myTable.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td().addElement(Msg.translate(wsc.ctx, "Export")).setAlign("right"));
        options = new option[]{new option(FILE_FORMAT_PDF).addElement(Msg.getMsg(wsc.ctx, "FilePDF")), new option(FILE_FORMAT_PS).addElement(Msg.getMsg(wsc.ctx, "FilePS")), new option(FILE_FORMAT_XML).addElement(Msg.getMsg(wsc.ctx, "FileXML")), new option(FILE_FORMAT_HTML).addElement(Msg.getMsg(wsc.ctx, "FileHTML")), new option(FILE_FORMAT_TXT).addElement(Msg.getMsg(wsc.ctx, "FileTXT")), new option(FILE_FORMAT_SSV).addElement(Msg.getMsg(wsc.ctx, "FileSSV")), new option(FILE_FORMAT_CSV).addElement(Msg.getMsg(wsc.ctx, "FileCSV"))};
        options[0].setSelected(true);
        line.addElement((Element)new td(new select(FILE_FORMAT, options).setID(FILE_FORMAT)));
        myTable.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td());
        input checkBox = new input("checkbox", FILE_FORMAT_SAVE, "false");
        checkBox.setID(FILE_FORMAT_SAVE);
        checkBox.setChecked(false);
        label checkBoxLabel = new label(FILE_FORMAT_SAVE, null, Util.maskHTML(Msg.getMsg(wsc.ctx, FILE_FORMAT_SAVE, true)));
        checkBox.addElement((Element)checkBoxLabel);
        line.addElement((Element)new td((Element)checkBox));
        myTable.addElement((Element)line);
        line = new tr();
        line.addElement((Element)new td(WebEnv.NBSP).setColSpan(2));
        myTable.addElement((Element)line);
        line = new tr();
        input bt = new input("button", "Export", Msg.translate(wsc.ctx, "Start"));
        StringBuffer sb = new StringBuffer();
        sb.append("openPrintWindow('/compiere/ampiere/WPrintReport");
        sb.append("?PrintFormat='+document.WPrint.PrintFormat.value+");
        sb.append("'&FileFormat='+document.WPrint.FileFormat.value+");
        sb.append("'&SaveFile='+document.WPrint.SaveFile.checked");
        sb.append(",'' );");
        bt.setOnClick(sb.toString());
        line.addElement((Element)new td(null, "center", "middle", false, (Element)bt).setColSpan(2));
        myTable.addElement((Element)line);
        myForm.addElement((Element)myTable);
        center.addElement((Element)myForm);
        doc.getBody().setOnUnload("closeMyChildren();");
        WebUtil.createResponse(request, response, this, null, doc, false);
    }

    public final void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.log.info("doPost");
    }
}

