/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.servlet;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.util.BarGraph;
import com.ampiere.util.BarGraphColumn;
import com.ampiere.util.ProcessCtl;
import com.ampiere.util.WRequest;
import com.ampiere.util.WZoomAcross;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.servlet.WebField;
import com.jware.util.StringToIntConverter;
import java.awt.Component;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.xhtml.a;
import org.apache.ecs.xhtml.div;
import org.apache.ecs.xhtml.form;
import org.apache.ecs.xhtml.hr;
import org.apache.ecs.xhtml.img;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.li;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.th;
import org.apache.ecs.xhtml.thead;
import org.apache.ecs.xhtml.tr;
import org.apache.ecs.xhtml.ul;
import org.compiere.framework.Query;
import org.compiere.framework.ZoomTarget;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridWindowVO;
import org.compiere.model.MAchievement;
import org.compiere.model.MCurrency;
import org.compiere.model.MGoal;
import org.compiere.model.MMeasureCalc;
import org.compiere.model.MPInstance;
import org.compiere.model.MProjectType;
import org.compiere.model.MRequestType;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebDoc;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WWindow
extends HttpServlet
implements DataStatusListener {
    private static final long serialVersionUID = 5764325063392615769L;
    protected static CLogger log = CLogger.getCLogger(WWindow.class);
    private static int s_WindowNo = 1;
    protected static final String FORM_NAME = "WForm";
    private static final String P_Command = "PCommand";
    private static final String P_Tab = "PTab";
    private static final String P_MR_RowNo = "PMRRowNo";
    private static final String P_ChangedColumn = "ChangedColumn";
    private static final String P_Reserve1 = "Reserve1";
    private static final String P_Reserve2 = "Reserve2";
    private static final String P_Reserve3 = "Reserve3";
    private static final String Change_Flag = "ChangeFlag";
    private static final int MAX_LINES = 20;
    private static final String ERROR = " ERROR! ";
    private HttpServletRequest m_request = null;
    private StringBuffer m_popupAlert = null;
    private String m_popupLookup = null;
    private String m_oldFieldGroup = null;
    private static String IS_ZOOM_WINDOW = "IS_ZOOM_WINDOW";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        if (!WebEnv.initWeb(config)) {
            throw new ServletException("WWindow.init");
        }
    }

    public String getServletInfo() {
        return "Compiere Web Window";
    }

    public void destroy() {
        log.fine("destroy");
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ArrayList<KeyNamePair> zoomList;
        Query query;
        String queryStr;
        boolean isWorkFlowQuery;
        GridWindowVO mWindowVO;
        this.m_popupAlert = null;
        this.m_popupLookup = null;
        this.m_request = request;
        request.getSession().setAttribute("SAVE_ERROR", (Object)"0");
        HttpSession sess = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            WebUtil.createTimeoutPage(request, response, this, null);
            return;
        }
        int AD_Window_ID = WebUtil.getParameterAsInt(request, "AD_Window_ID");
        int AD_Menu_ID = WebUtil.getParameterAsInt(request, "AD_Menu_ID");
        log.info("AD_Window_ID=" + AD_Window_ID + "; AD_Menu_ID=" + AD_Menu_ID);
        WWindowStatus ws = WWindowStatus.get(request);
        boolean isZoomWindow = false;
        String window_target = null;
        if (request.getParameter("windowId") != null) {
            AD_Window_ID = StringToIntConverter.StringToInt(request.getParameter("windowId"));
            window_target = "_self";
            isZoomWindow = true;
            request.setAttribute(IS_ZOOM_WINDOW, (Object)true);
        } else {
            request.setAttribute(IS_ZOOM_WINDOW, null);
        }
        if (ws != null) {
            int WindowNo = ws.mWindow.getWindowNo();
            log.fine("Disposing - WindowNo=" + WindowNo + ", ID=" + ws.mWindow.getAD_Window_ID());
            try {
                ws.mWindow.dispose();
            }
            catch (Exception e) {
                return;
            }
            Env.clearWinContext(wsc.ctx, WindowNo);
        }
        if ((mWindowVO = GridWindowVO.create(wsc.ctx, s_WindowNo++, AD_Window_ID, AD_Menu_ID)) == null) {
            String msg = AWebUtil.info(request, "AccessTableNoView", "(No Window Model Info)");
            WebUtil.createErrorPage(request, response, this, msg);
            sess.setAttribute("WWindowStatus", null);
            return;
        }
        ws = new WWindowStatus(mWindowVO);
        WWindowStatus.set(request, ws.curTab.getAD_Window_ID(), ws);
        ws.setTarget(window_target);
        this.initWindow(ws);
        boolean isZoomAcross = false;
        String keyColumnName = request.getParameter("columnName");
        String refrenceValue = request.getParameter("value");
        if (!StringUtils.isEmpty(keyColumnName)) {
            Query zoomQuery = new Query();
            if (keyColumnName != null && keyColumnName.length() != 0) {
                zoomQuery.addRestriction(keyColumnName, "=", refrenceValue);
            }
            isZoomAcross = true;
            ws.curTab.setQuery(zoomQuery);
        }
        if (isWorkFlowQuery = "1".equals(request.getParameter("WorkFlowQuery"))) {
            String AD_Table_ID = request.getParameter("AD_Table_ID");
            String Record_ID = request.getParameter("Record_ID");
            Query query2 = null;
            query2 = new Query("AD_WF_Process");
            query2.addRestriction("AD_Table_ID", "=", AD_Table_ID);
            query2.addRestriction("Record_ID", "=", Record_ID);
            ws.curTab.setQuery(query2);
        }
        if (!StringUtils.isEmpty(queryStr = request.getParameter("Query"))) {
            query = new Query();
            query.addRestriction(queryStr);
            ws.curTab.setQuery(query);
        }
        if (isZoomAcross) {
            ws.curTab.query(0);
        } else {
            query = null;
            int goalId = WebUtil.getParameterAsInt(request, "GOAL_ID");
            if (goalId > 0) {
                int columnIndex = WebUtil.getParameterAsInt(request, "GOAL_COLUMN_INDEX");
                MGoal[] goals = MGoal.getUserGoals(wsc.ctx, wsc.ctx.getAD_Role_ID(), wsc.ctx.getAD_User_ID());
                for (int i2 = 0; i2 < goals.length; ++i2) {
                    if (goalId != goals[i2].get_ID()) continue;
                    BarGraph barGraph = new BarGraph(goals[i2]);
                    Component[] data = barGraph.getComponents();
                    if (columnIndex >= data.length) break;
                    BarGraphColumn bgc = (BarGraphColumn)data[columnIndex];
                    if (bgc.getAchievement() != null) {
                        MAchievement a2 = bgc.getAchievement();
                        query = Query.getEqualQuery("PA_Measure_ID", a2.getPA_Measure_ID());
                        break;
                    }
                    if (bgc.getGoal() != null) {
                        MGoal goal = bgc.getGoal();
                        query = Query.getEqualQuery("PA_Measure_ID", goal.getPA_Measure_ID());
                        break;
                    }
                    if (bgc.getMeasureCalc() != null) {
                        MMeasureCalc mc = bgc.getMeasureCalc();
                        query = mc.getQuery(goals[i2].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), MRole.getDefault(wsc.ctx, false));
                        break;
                    }
                    if (bgc.getProjectType() != null) {
                        MProjectType pt = bgc.getProjectType();
                        query = pt.getQuery(goals[i2].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(), MRole.getDefault(wsc.ctx, false));
                        break;
                    }
                    if (bgc.getRequestType() == null) break;
                    MRequestType rt = bgc.getRequestType();
                    query = rt.getQuery(goals[i2].getRestrictions(false), bgc.getMeasureDisplay(), bgc.getDate(), bgc.getID(), MRole.getDefault(wsc.ctx, false));
                    break;
                }
            }
            if (query != null) {
                ws.curTab.setQuery(query);
                ws.curTab.query(0);
            } else {
                ws.curTab.query(ws.mWindow.isTransaction() ? 2 : 0);
            }
        }
        ws.curTab.navigate(0);
        this.resetAmountformat(wsc, ws);
        sess.setAttribute("WebSessionCtx", (Object)wsc);
        sess.setAttribute("FieldLookup", null);
        ws.curTab.addDataStatusListener(this);
        WebDoc doc = null;
        doc = ws.curTab.isSingleRow() ? ((zoomList = WZoomAcross.cmd_zoomAcross(ws)) != null && zoomList.size() > 0 ? this.getSR_Form(request, wsc, ws, zoomList) : this.getSR_Form(request, wsc, ws)) : this.getMR_Form(request, wsc, ws);
        if ("1".equals(request.getParameter("CreateNew"))) {
            String referenceStr = request.getParameter("Reference");
            doc.getBody().setOnLoad("parent.document.getElementById('Reserve1').value='" + referenceStr + "';document.WForm.PCommand.value='New';WForm.submit();");
        }
        log.fine("Fini");
        WebUtil.createResponse(request, response, this, null, doc, false);
        log.fine("Closed");
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.m_popupAlert = null;
        this.m_popupLookup = null;
        this.m_request = request;
        String actionType = request.getParameter("actionType");
        if ("4".equals(actionType)) {
            String p_cmd = WebUtil.getParameter(request, P_Command);
            String change_tab = WebUtil.getParameter(request, "ChangeTab");
            if (StringUtils.isEmpty(p_cmd) && StringUtils.isEmpty(change_tab)) {
                int windowId = StringToIntConverter.StringToInt(request.getParameter("windowId"));
                int windowNo = StringToIntConverter.StringToInt(request.getParameter("windowNo"));
                WWindowStatus.clean(request, windowId, windowNo);
                return;
            }
            return;
        }
        if ("3".equals(actionType)) {
            String saveError = request.getSession().getAttribute("SAVE_ERROR") == null ? "0" : (String)request.getSession().getAttribute("SAVE_ERROR");
            AWebUtil.createSaveErrorResponse(response, saveError);
            return;
        }
        WebEnv.dump(request);
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null || ws == null) {
            if (wsc == null) {
                WebUtil.createTimeoutPage(request, response, this, "No Context");
            } else {
                this.doGet(request, response);
            }
            return;
        }
        String p_cmd = WebUtil.getParameter(request, P_Command);
        String column = WebUtil.getParameter(request, P_ChangedColumn);
        log.info("Cmd=" + p_cmd + " - ChangedColumn=" + column);
        ws.curTab.addDataStatusListener(this);
        if (column != null && column.length() > 0) {
            if (p_cmd != null && "ButtonCommand".equalsIgnoreCase(p_cmd)) {
                int processId = WebUtil.getParameterAsInt(request, P_Reserve1);
                boolean batch = "true".equalsIgnoreCase(WebUtil.getParameter(request, P_Reserve2));
                String value = WebUtil.getParameter(request, P_Reserve3);
                request.setAttribute(P_Command, (Object)"");
                request.setAttribute(P_ChangedColumn, (Object)"");
                request.setAttribute(P_Reserve1, (Object)"");
                request.setAttribute(P_Reserve2, (Object)"");
                request.setAttribute(P_Reserve3, (Object)"");
                int currentRow = ws.curTab.getCurrentRow();
                int keyId = ws.curTab.getKeyID(currentRow);
                this.actionButton(ws, wsc, column, processId, batch, value);
                ws.curTab.query(ws.curTab.getOnlyCurrentDays());
                for (int ii = 0; ii < ws.curTab.getRowCount(); ++ii) {
                    if (keyId != ws.curTab.getKeyID(ii)) continue;
                    ws.curTab.navigate(ii);
                    break;
                }
            } else {
                try {
                    if (ws.curTab.getField(column) != null && ws.curTab.getField(column).getLookup() != null) {
                        ws.curTab.getField(column).getLookup().refresh();
                    }
                    this.updateFields(request, wsc, ws);
                }
                catch (Exception e) {}
            }
        } else {
            if (p_cmd.equals("Exit")) {
                MSession cSession = MSession.get(wsc.ctx, false);
                if (cSession != null) {
                    cSession.logout();
                }
                WebUtil.createLoginPage(request, response, this, ws.ctx, "Exit");
                return;
            }
            this.executeCommand(request, p_cmd, wsc, ws);
        }
        HttpSession sess = request.getSession();
        sess.setAttribute("FieldLookup", null);
        this.resetAmountformat(wsc, ws);
        sess.setAttribute("WebSessionCtx", (Object)wsc);
        WebDoc doc = null;
        if (ws.curTab.isSingleRow()) {
            if (!"1".equals(actionType)) {
                ArrayList<KeyNamePair> zoomList = WZoomAcross.cmd_zoomAcross(ws);
                doc = zoomList != null && zoomList.size() > 0 ? this.getSR_Form(request, wsc, ws, zoomList) : this.getSR_Form(request, wsc, ws);
            }
            request.getSession().setAttribute("SAVE_ERROR", (Object)"0");
        } else {
            doc = this.getMR_Form(request, wsc, ws);
        }
        if (!"1".equals(actionType)) {
            if (this.m_popupAlert != null && this.m_popupAlert.length() > 0) {
                doc.getBody().setOnLoad("alert('" + this.m_popupAlert.toString() + "');");
            }
            if (this.m_popupLookup != null && this.m_popupLookup.length() > 0) {
                doc.getBody().setOnLoad(this.m_popupLookup);
            }
            log.fine("Fini");
            WebUtil.createResponse(request, response, this, null, doc, false);
        } else {
            Document xml_doc = this.get_Ajax_SR_Form(request, wsc, ws);
            AWebUtil.createCalloutAjaxResponse(response, xml_doc);
        }
        log.fine("Closed");
    }

    private void executeCommand(HttpServletRequest request, String p_cmd, WebSessionCtx wsc, WWindowStatus ws) {
        String p_tab = WebUtil.getParameter(request, P_Tab);
        String p_row = WebUtil.getParameter(request, P_MR_RowNo);
        log.config(p_cmd + " - Tab=" + p_tab + " - Row=" + p_row);
        wsc.ctx.setContext(ws.curTab.getWindowNo(), "NeedSave", 0);
        if (p_row != null && p_row.length() > 0) {
            try {
                int newRowNo = Integer.parseInt(p_row);
                ws.curTab.navigate(newRowNo);
                if ("Edit".equals(p_cmd)) {
                    ws.curTab.setSingleRow(true);
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Parse RowNo=" + p_row, e);
            }
        } else if (p_tab != null && p_tab.length() > 0) {
            int newTabNo = 0;
            try {
                newTabNo = Integer.parseInt(p_tab);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Parse TabNo=" + p_tab, e);
            }
            if (newTabNo > ws.curTab.getTabNo()) {
                ws.curTab = ws.mWindow.getTab(newTabNo);
                ws.curTab.query(0);
                ws.curTab.navigate(0);
            } else if (newTabNo < ws.curTab.getTabNo()) {
                ws.curTab = ws.mWindow.getTab(newTabNo);
                ws.curTab.dataRefresh();
            }
        } else if (p_cmd.equals("Multi")) {
            boolean single = ws.curTab.isSingleRow();
            ws.curTab.setSingleRow(!single);
        } else if (p_cmd.equals("First")) {
            ws.curTab.navigate(0);
        } else if (p_cmd.equals("Next")) {
            if (ws.curTab.isSingleRow()) {
                if (ws.curTab.getCurrentRow() < ws.curTab.getRowCount()) {
                    ws.curTab.navigateRelative(1);
                }
            } else if (ws.curTab.getCurrentRow() < ws.curTab.getRowCount()) {
                ws.curTab.navigateRelative(1);
            }
        } else if (p_cmd.equals("Previous")) {
            if (ws.curTab.isSingleRow()) {
                if (ws.curTab.getCurrentRow() > 0) {
                    ws.curTab.navigateRelative(-1);
                }
            } else if (ws.curTab.getCurrentRow() > 0) {
                ws.curTab.navigateRelative(-1);
            }
        } else if (p_cmd.equals("Last")) {
            ws.curTab.navigateRelative(999999);
        } else if (!p_cmd.equals("Find")) {
            if (p_cmd.equals("Refresh")) {
                ws.curTab.dataRefreshAll();
            } else if (!p_cmd.equals("Attachment")) {
                if (p_cmd.equals("History")) {
                    if (ws.mWindow.isTransaction() && ws.curTab.getWindowNo() == 0) {
                        ws.curTab.query(ws.curTab.getOnlyCurrentDays());
                        ws.curTab.navigate(0);
                    }
                } else if (p_cmd.equals("Report")) {
                    wsc.ctx.setContext(ws.curTab.getWindowNo(), "IsReportStart", true);
                } else if (p_cmd.equals("Print")) {
                    wsc.ctx.setContext(ws.curTab.getWindowNo(), "IsPrintStart", true);
                } else if (p_cmd.equals("New")) {
                    ws.curTab.setSingleRow(true);
                    if (!ws.curTab.dataNew(false)) {
                        ws.curTab.dataIgnore();
                    }
                    this.addReferenceField(request, wsc, ws);
                    wsc.ctx.setContext(ws.curTab.getWindowNo(), "NeedSave", 1);
                } else if (p_cmd.equals("Ignore")) {
                    ws.curTab.dataIgnore();
                    ws.curTab.navigate(0);
                } else if (p_cmd.equals("Delete")) {
                    ws.curTab.dataDelete();
                } else if (p_cmd.equals("Save")) {
                    this.executeSave(request, wsc, ws);
                }
            }
        }
    }

    private void addReferenceField(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws) {
        if (ws.curTab.getAD_Window_ID() == 232) {
            int m_AD_Table_ID = 0;
            int m_Record_ID = 0;
            int m_C_BPartner_ID = 0;
            String para = request.getParameter(P_Reserve1);
            if (!StringUtils.isEmpty(para)) {
                String[] params = para.split(",");
                for (int i2 = 0; i2 < params.length; ++i2) {
                    String[] paramValue = params[i2].split(":");
                    if ("m_AD_Table_ID".equals(paramValue[0])) {
                        m_AD_Table_ID = StringToIntConverter.StringToInt(paramValue[1]);
                        continue;
                    }
                    if ("m_Record_ID".equals(paramValue[0])) {
                        m_Record_ID = StringToIntConverter.StringToInt(paramValue[1]);
                        continue;
                    }
                    if (!"m_C_BPartner_ID".equals(paramValue[0])) continue;
                    m_C_BPartner_ID = StringToIntConverter.StringToInt(paramValue[1]);
                }
                ws.curTab.dataNew(false);
                ws.curTab.setValue("AD_Table_ID", (Object)new Integer(m_AD_Table_ID));
                ws.curTab.setValue("Record_ID", (Object)new Integer(m_Record_ID));
                if (m_C_BPartner_ID != 0) {
                    ws.curTab.setValue("C_BPartner_ID", (Object)new Integer(m_C_BPartner_ID));
                }
                if (m_AD_Table_ID == 291) {
                    ws.curTab.setValue("C_BPartner_ID", (Object)new Integer(m_Record_ID));
                } else if (m_AD_Table_ID == 114) {
                    ws.curTab.setValue("AD_User_ID", (Object)new Integer(m_Record_ID));
                } else if (m_AD_Table_ID == 203) {
                    ws.curTab.setValue("C_Project_ID", (Object)new Integer(m_Record_ID));
                } else if (m_AD_Table_ID == 539) {
                    ws.curTab.setValue("A_Asset_ID", (Object)new Integer(m_Record_ID));
                } else if (m_AD_Table_ID == 259) {
                    ws.curTab.setValue("C_Order_ID", (Object)new Integer(m_Record_ID));
                } else if (m_AD_Table_ID == 318) {
                    ws.curTab.setValue("C_Invoice_ID", (Object)new Integer(m_Record_ID));
                } else if (m_AD_Table_ID == 208) {
                    ws.curTab.setValue("M_Product_ID", (Object)new Integer(m_Record_ID));
                } else if (m_AD_Table_ID == 335) {
                    ws.curTab.setValue("C_Payment_ID", (Object)new Integer(m_Record_ID));
                } else if (m_AD_Table_ID == 319) {
                    ws.curTab.setValue("M_InOut_ID", (Object)new Integer(m_Record_ID));
                } else if (m_AD_Table_ID == 274) {
                    ws.curTab.setValue("C_Campaign_ID", (Object)new Integer(m_Record_ID));
                }
            }
        }
    }

    private void executeSave(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws) {
        log.info("");
        boolean error = this.updateFields(request, wsc, ws);
        request.getSession().setAttribute("SAVE_ERROR", (Object)"0");
        log.fine("Mandatory check");
        int size = ws.curTab.getFieldCount();
        for (int i2 = 0; i2 < size; ++i2) {
            GridField field = ws.curTab.getField(i2);
            if (!field.isMandatory(true)) continue;
            Object value = field.getValue();
            if (value == null || value.toString().length() == 0) {
                field.setInserting(true);
                field.setError(true);
                field.setErrorValue(value == null ? null : value.toString());
                if (!error) {
                    error = true;
                }
                log.info("Mandatory Error: " + field.getColumnName());
                continue;
            }
            field.setError(false);
        }
        if (error) {
            request.getSession().setAttribute("SAVE_ERROR", (Object)"1");
            return;
        }
        if (!ws.curTab.dataSave(true)) {
            ws.curTab.dataIgnore();
        }
        wsc.ctx.setContext(ws.curTab.getWindowNo(), "NeedSave", 0);
        log.fine("done");
    }

    private boolean updateFields(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws) {
        String value;
        Object newValue;
        GridField mField;
        boolean error = false;
        try {
            String enc = request.getCharacterEncoding();
            if (enc == null) {
                request.setCharacterEncoding("UTF-8");
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Set CharacterEndocung=UTF-8", e);
        }
        Enumeration en = request.getParameterNames();
        while (en.hasMoreElements()) {
            GridField mField2;
            String key = (String)en.nextElement();
            if (key == null || key.equals(P_Command) || key.equals(P_ChangedColumn) || key.equals(P_MR_RowNo) || key.equals(P_Tab) || key.equals(P_Reserve1) || key.equals(P_Reserve2) || key.equals(P_Reserve3) || (mField2 = ws.curTab.getField(key)) == null || !mField2.isEditable(true)) continue;
            String value2 = WebUtil.getParameter(request, key);
            Object dbValue = mField2.getValue();
            boolean fieldError = false;
            String columnName = mField2.getColumnName();
            log.finest(columnName + ": " + (dbValue == null ? "null" : dbValue.toString()) + " -> " + (value2 == null ? "null" : value2.toString()));
            if (dbValue == null && value2 == null) continue;
            if (dbValue != null && value2 == null) {
                this.setFieldNewValue(wsc, ws, mField2, null);
            } else if (dbValue == null && value2 != null) {
                fieldError = !this.setFieldValue(wsc, ws, mField2, value2);
            } else {
                if (dbValue.equals(value2)) continue;
                boolean bl = fieldError = !this.setFieldValue(wsc, ws, mField2, value2);
            }
            if (error || !fieldError) continue;
            log.info("Error: " + mField2.getColumnName());
            error = true;
        }
        int fileds = ws.curTab.getFieldCount();
        for (int i2 = 0; i2 < fileds; ++i2) {
            String key;
            mField = ws.curTab.getField(i2);
            if (mField == null || !mField.isEditable(true) || mField.getDisplayType() != 20 || (key = mField.getColumnName()).equals("IsActive")) continue;
            String value3 = WebUtil.getParameter(request, key);
            Object dbValue = mField.getValue();
            if (dbValue == null || value3 != null) continue;
            this.setFieldNewValue(wsc, ws, mField, false);
        }
        String columnName = WebUtil.getParameter(request, P_ChangedColumn);
        if (columnName != null && columnName.length() > 0 && (mField = ws.curTab.getField(columnName)) != null && !ERROR.equals(newValue = this.getFieldValue(wsc, mField, value = WebUtil.getParameter(request, columnName)))) {
            if (newValue == null && mField.getDisplayType() == 20) {
                newValue = "N";
            }
            log.fine("ChangedColumn: " + columnName + "=" + newValue);
            this.setFieldNewValue(wsc, ws, mField, newValue);
        }
        wsc.ctx.setContext(ws.curTab.getWindowNo(), "NeedSave", 1);
        return error;
    }

    private boolean setFieldValue(WebSessionCtx wsc, WWindowStatus ws, GridField mField, String value) {
        Object newValue = this.getFieldValue(wsc, mField, value);
        if (ERROR.equals(newValue)) {
            mField.setErrorValue(value);
            return false;
        }
        Object dbValue = mField.getValue();
        if (newValue == null && dbValue != null || newValue != null && !newValue.equals(dbValue)) {
            this.setFieldNewValue(wsc, ws, mField, newValue);
        }
        return true;
    }

    private Object getFieldValue(WebSessionCtx wsc, GridField mField, String value) {
        if (value == null || value.length() == 0) {
            return null;
        }
        int dt = mField.getDisplayType();
        String columnName = mField.getColumnName();
        if (DisplayType.isNumeric(dt)) {
            BigDecimal bd = null;
            try {
                Number nn = null;
                nn = dt == 12 ? (Number)wsc.amountFormat.parse(value) : (Number)(dt == 29 ? (Number)wsc.quantityFormat.parse(value) : (Number)wsc.numberFormat.parse(value));
                bd = nn instanceof BigDecimal ? (BigDecimal)nn : new BigDecimal(nn.toString());
            }
            catch (Exception e) {
                log.warning("BigDecimal: " + columnName + "=" + value + ERROR);
                return ERROR;
            }
            log.fine("BigDecimal: " + columnName + "=" + value + " -> " + bd);
            return bd;
        }
        if (DisplayType.isID(dt) && !columnName.equals("AD_Language")) {
            Integer ii = null;
            try {
                ii = new Integer(value);
            }
            catch (Exception e) {
                log.log(Level.WARNING, "ID: " + columnName + "=" + value, e);
                ii = null;
            }
            if (ii != null && ii == -1) {
                ii = null;
            }
            log.fine("ID: " + columnName + "=" + value + " -> " + ii);
            return ii;
        }
        if (DisplayType.isDate(dt)) {
            Timestamp ts = null;
            try {
                Date d = null;
                d = dt == 15 ? wsc.dateFormat.parse(value) : wsc.dateTimeFormat.parse(value);
                ts = new Timestamp(d.getTime());
            }
            catch (Exception e) {
                log.warning("Date: " + columnName + "=" + value + ERROR);
                return ERROR;
            }
            log.fine("Date: " + columnName + "=" + value + " -> " + ts);
            return ts;
        }
        if (dt == 20) {
            Boolean retValue = Boolean.FALSE;
            if (value.equals("true")) {
                retValue = Boolean.TRUE;
            }
            log.fine("YesNo: " + columnName + "=" + value + " -> " + retValue);
            return retValue;
        }
        log.fine(columnName + "=" + value);
        return value;
    }

    private Document get_Ajax_SR_Form(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
            if (ws.curTab.isDisplayed(false)) {
                wsc.ctx.setContext(ws.curTab.getWindowNo(), "Record_ID", ws.curTab.getRecord_ID());
                int currentRow = ws.curTab.getCurrentRow();
                int noFields = ws.curTab.getFieldCount();
                for (int i2 = 0; i2 < noFields; ++i2) {
                    Element lbl_readonly;
                    Element lbl_type;
                    Element lbl_newValue;
                    Element lbl_visibility;
                    Element lbl_lookup;
                    Element lbl_id;
                    Element elementLabel;
                    Element elm_type;
                    String realOnlyFlag;
                    Element elm_readonly;
                    Element elm_newValue;
                    Element elm_visibility;
                    Element elm_lookup;
                    Element elm_id;
                    Element element;
                    GridField field = ws.curTab.getSRField(i2);
                    String columnName = field.getColumnName();
                    Object newValue = "";
                    String objId = "";
                    String newValue_str = "";
                    if (DisplayType.isLookup(field.getDisplayType()) && field.getDisplayType() != 30) {
                        boolean readOnly = currentRow == -1 || !field.isEditable(true);
                        Object[] list = field.getLookup().getData(true, true, !readOnly, false).toArray();
                        Element element2 = document.createElement("element");
                        elements.appendChild(element2);
                        Element elm_id2 = document.createElement("id");
                        objId = this.getHtmlObjectName(field);
                        elm_id2.appendChild(document.createTextNode(objId));
                        element2.appendChild(elm_id2);
                        Element elm_lookup2 = document.createElement("lookup");
                        element2.appendChild(elm_lookup2);
                        elm_lookup2.appendChild(document.createTextNode("1"));
                        Element elm_visibility2 = document.createElement("visibility");
                        element2.appendChild(elm_visibility2);
                        elm_visibility2.appendChild(document.createTextNode("1"));
                        Element elm_newValue2 = document.createElement("newValue");
                        element2.appendChild(elm_newValue2);
                        for (int p2 = 0; p2 < list.length; ++p2) {
                            NamePair onePair;
                            boolean isNumber;
                            String key = "";
                            String value = "";
                            if (p2 == 0) {
                                Element elm_item = document.createElement("item");
                                elm_newValue2.appendChild(elm_item);
                                Element elm_key = document.createElement("key");
                                elm_item.appendChild(elm_key);
                                elm_key.appendChild(document.createTextNode(String.valueOf(key)));
                                Element elm_value = document.createElement("value");
                                elm_item.appendChild(elm_value);
                                elm_value.appendChild(document.createTextNode(value));
                            }
                            if (isNumber = list[0] instanceof KeyNamePair) {
                                onePair = (KeyNamePair)list[p2];
                                key = String.valueOf(((KeyNamePair)onePair).getKey());
                                value = onePair.getName();
                            } else {
                                onePair = (ValueNamePair)list[p2];
                                key = ((ValueNamePair)onePair).getValue();
                                value = onePair.getName();
                            }
                            Element elm_item = document.createElement("item");
                            elm_newValue2.appendChild(elm_item);
                            Element elm_key = document.createElement("key");
                            elm_item.appendChild(elm_key);
                            elm_key.appendChild(document.createTextNode(String.valueOf(key)));
                            Element elm_value = document.createElement("value");
                            elm_item.appendChild(elm_value);
                            elm_value.appendChild(document.createTextNode(value));
                        }
                        Element elm_readonly2 = document.createElement("readonly");
                        element2.appendChild(elm_readonly2);
                        elm_readonly2.appendChild(document.createTextNode("0"));
                        Element elm_type2 = document.createElement("type");
                        element2.appendChild(elm_type2);
                        elm_type2.appendChild(document.createTextNode("1"));
                    }
                    if (field.isDisplayed(true)) {
                        newValue = field.getValue();
                        element = document.createElement("element");
                        elements.appendChild(element);
                        elm_id = document.createElement("id");
                        element.appendChild(elm_id);
                        objId = this.getHtmlObjectName(field);
                        elm_id.appendChild(document.createTextNode(objId));
                        elm_lookup = document.createElement("lookup");
                        element.appendChild(elm_lookup);
                        elm_lookup.appendChild(document.createTextNode("0"));
                        elm_visibility = document.createElement("visibility");
                        element.appendChild(elm_visibility);
                        elm_visibility.appendChild(document.createTextNode("1"));
                        elm_newValue = document.createElement("newValue");
                        element.appendChild(elm_newValue);
                        newValue_str = AWebUtil.toString(newValue, wsc, field.getDisplayType(), columnName, field);
                        elm_newValue.appendChild(document.createTextNode(newValue_str));
                        elm_readonly = document.createElement("readonly");
                        element.appendChild(elm_readonly);
                        String string = realOnlyFlag = !field.isEditable(true) ? "1" : "0";
                        if (columnName.indexOf("PaymentRule") >= 0) {
                            realOnlyFlag = "1";
                        }
                        elm_readonly.appendChild(document.createTextNode(realOnlyFlag));
                        elm_type = document.createElement("type");
                        element.appendChild(elm_type);
                        if (field.getDisplayType() == 20) {
                            elm_type.appendChild(document.createTextNode("0"));
                        } else {
                            elm_type.appendChild(document.createTextNode("1"));
                        }
                        if (field.getDisplayType() == 30 || field.getDisplayType() == 21 || field.getDisplayType() == 25) {
                            objId = field.getColumnName() + "F";
                            AWebUtil.createDisplayElement(document, elements, objId, field, realOnlyFlag, true);
                            objId = field.getColumnName() + "B";
                            AWebUtil.createDisplayElement(document, elements, objId, field, realOnlyFlag, true);
                        }
                        if (field.getDisplayType() == 28) continue;
                        elementLabel = document.createElement("element");
                        elements.appendChild(elementLabel);
                        lbl_id = document.createElement("id");
                        elementLabel.appendChild(lbl_id);
                        objId = this.getHtmlObjectLabelName(field);
                        lbl_id.appendChild(document.createTextNode(objId));
                        lbl_lookup = document.createElement("lookup");
                        elementLabel.appendChild(lbl_lookup);
                        lbl_lookup.appendChild(document.createTextNode("0"));
                        lbl_visibility = document.createElement("visibility");
                        elementLabel.appendChild(lbl_visibility);
                        lbl_visibility.appendChild(document.createTextNode("1"));
                        lbl_newValue = document.createElement("newValue");
                        elementLabel.appendChild(lbl_newValue);
                        lbl_newValue.appendChild(document.createTextNode(""));
                        lbl_type = document.createElement("type");
                        elementLabel.appendChild(lbl_type);
                        lbl_type.appendChild(document.createTextNode("0"));
                        lbl_readonly = document.createElement("readonly");
                        elementLabel.appendChild(lbl_readonly);
                        lbl_readonly.appendChild(document.createTextNode(!field.isEditable(true) ? "1" : "0"));
                        continue;
                    }
                    newValue = field.getValue();
                    element = document.createElement("element");
                    elements.appendChild(element);
                    elm_id = document.createElement("id");
                    element.appendChild(elm_id);
                    objId = this.getHtmlObjectName(field);
                    elm_id.appendChild(document.createTextNode(objId));
                    elm_lookup = document.createElement("lookup");
                    element.appendChild(elm_lookup);
                    elm_lookup.appendChild(document.createTextNode("0"));
                    elm_visibility = document.createElement("visibility");
                    element.appendChild(elm_visibility);
                    elm_visibility.appendChild(document.createTextNode("0"));
                    elm_newValue = document.createElement("newValue");
                    element.appendChild(elm_newValue);
                    elm_newValue.appendChild(document.createTextNode(AWebUtil.toString(newValue, wsc, field.getDisplayType(), columnName, field)));
                    elm_readonly = document.createElement("readonly");
                    element.appendChild(elm_readonly);
                    String string = realOnlyFlag = !field.isEditable(true) ? "1" : "0";
                    if (columnName.indexOf("PaymentRule") >= 0) {
                        realOnlyFlag = "1";
                    }
                    elm_readonly.appendChild(document.createTextNode(realOnlyFlag));
                    elm_type = document.createElement("type");
                    element.appendChild(elm_type);
                    if (field.getDisplayType() == 20 || field.getDisplayType() == 28) {
                        elm_type.appendChild(document.createTextNode("0"));
                    } else {
                        elm_type.appendChild(document.createTextNode("1"));
                    }
                    if (field.getDisplayType() != 28) {
                        elementLabel = document.createElement("element");
                        elements.appendChild(elementLabel);
                        lbl_id = document.createElement("id");
                        elementLabel.appendChild(lbl_id);
                        objId = this.getHtmlObjectLabelName(field);
                        lbl_id.appendChild(document.createTextNode(objId));
                        lbl_lookup = document.createElement("lookup");
                        elementLabel.appendChild(lbl_lookup);
                        lbl_lookup.appendChild(document.createTextNode("0"));
                        lbl_visibility = document.createElement("visibility");
                        elementLabel.appendChild(lbl_visibility);
                        lbl_visibility.appendChild(document.createTextNode("0"));
                        lbl_newValue = document.createElement("newValue");
                        elementLabel.appendChild(lbl_newValue);
                        lbl_newValue.appendChild(document.createTextNode(""));
                        lbl_type = document.createElement("type");
                        elementLabel.appendChild(lbl_type);
                        lbl_type.appendChild(document.createTextNode("0"));
                        lbl_readonly = document.createElement("readonly");
                        elementLabel.appendChild(lbl_readonly);
                        lbl_readonly.appendChild(document.createTextNode(!field.isEditable(true) ? "1" : "0"));
                    }
                    if (field.getDisplayType() != 30 && field.getDisplayType() != 21 && field.getDisplayType() != 25) continue;
                    objId = field.getColumnName() + "F";
                    AWebUtil.createDisplayElement(document, elements, objId, field, realOnlyFlag, false);
                    objId = field.getColumnName() + "B";
                    AWebUtil.createDisplayElement(document, elements, objId, field, realOnlyFlag, false);
                }
            }
            if (this.m_popupAlert != null && this.m_popupAlert.length() > 0) {
                String alertScript = "alert('" + this.m_popupAlert.toString() + "');";
                Element element = document.createElement("script");
                elements.appendChild(element);
                Element elm = document.createElement("item");
                elm.appendChild(document.createTextNode(alertScript));
                element.appendChild(elm);
            }
            if (this.m_popupLookup != null && this.m_popupLookup.length() > 0) {
                Element element = document.createElement("script");
                elements.appendChild(element);
                Element elm = document.createElement("item");
                elm.appendChild(document.createTextNode(this.m_popupLookup));
                element.appendChild(elm);
            }
        }
        catch (Exception e) {
            log.warning("get_Ajax_SR_Form error");
        }
        return document;
    }

    private WebDoc getMR_Form(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws) {
        log.fine("Tab=" + ws.curTab.getTabNo());
        int oldRow = ws.curTab.getCurrentRow();
        int initRowNo = oldRow / 20 * 20;
        table table2 = new table().setAlign("center");
        table2.setClass("displaytag");
        table2.setBorder(0);
        table2.setCellSpacing(0);
        tr line = new tr();
        line.addElement((org.apache.ecs.Element)new th().addElement(WebEnv.NBSP));
        if (!ws.curTab.isDisplayed(false)) {
            return WWindow.createLayout(request, table2, wsc, ws, "", "-");
        }
        int noFields = ws.curTab.getFieldCount();
        for (int colNo = 0; colNo < noFields; ++colNo) {
            GridField field = ws.curTab.getField(colNo);
            if (!field.isDisplayed(false)) continue;
            th th2 = new th();
            th2.addElement(new span(field.getHeader()).setStyle("white-space: nowrap;"));
            th2.setAbbr(field.getDescription());
            line.addElement((org.apache.ecs.Element)th2);
        }
        table2.addElement((org.apache.ecs.Element)new thead().addElement((org.apache.ecs.Element)line));
        int lastRow = initRowNo + 20;
        lastRow = Math.min(lastRow, ws.curTab.getRowCount());
        String[] lineClass = new String[]{"odd", "even", "current"};
        for (int lineNo = initRowNo; lineNo < lastRow; ++lineNo) {
            ws.curTab.navigate(lineNo);
            line = new tr();
            if (oldRow == ws.curTab.getCurrentRow()) {
                line.setClass(lineClass[2]);
            } else {
                line.setClass(lineClass[lineNo >= 0 ? lineNo % 2 : 1]);
            }
            td tmp = new td();
            String href = "document.WForm.PMRRowNo.value='" + lineNo + "'; " + FORM_NAME + ".submit();";
            img selector = new img(WebEnv.getImageDirectory("Go.gif"));
            selector.setClass("cursorPointer");
            selector.setOnClick(href);
            tmp.addElement((org.apache.ecs.Element)selector);
            href = "document.WForm.PCommand.value='Edit';document.WForm.PMRRowNo.value='" + lineNo + "'; " + FORM_NAME + ".submit();";
            selector = new img(WebEnv.getImageDirectory("Editor16.png"));
            selector.setClass("cursorPointer");
            selector.setOnClick(href);
            tmp.addElement((org.apache.ecs.Element)selector);
            line.addElement((org.apache.ecs.Element)tmp);
            for (int colNo = 0; colNo < noFields; ++colNo) {
                td td2 = new td();
                GridField field = ws.curTab.getField(colNo);
                if (!field.isDisplayed(false)) continue;
                Object data = ws.curTab.getValue(field.getColumnName());
                String info = null;
                if (data == null) {
                    info = "";
                } else {
                    int dt = field.getDisplayType();
                    switch (dt) {
                        case 15: {
                            info = wsc.dateFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 16: {
                            info = wsc.dateTimeFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 12: {
                            info = wsc.amountFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 22: {
                            info = wsc.numberFormat.format(data);
                            td2.setAlign("right");
                        }
                        case 29: {
                            info = wsc.quantityFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 11: {
                            info = wsc.integerFormat.format(data);
                            td2.setAlign("right");
                            break;
                        }
                        case 20: {
                            info = Msg.getMsg(ws.ctx, data.toString());
                            break;
                        }
                        default: {
                            info = DisplayType.isLookup(dt) ? field.getLookup().getDisplay(data) : data.toString();
                        }
                    }
                }
                if (info == null || info.length() == 0 || info.trim().length() == 0) {
                    info = WebEnv.NBSP;
                }
                td2.addElement(new span(info).setStyle("white-space: nowrap;"));
                line.addElement((org.apache.ecs.Element)td2);
            }
            table2.addElement((org.apache.ecs.Element)line);
        }
        ws.curTab.navigate(oldRow);
        String statusDB = String.valueOf(initRowNo + 1) + "-" + String.valueOf(lastRow) + " # " + ws.curTab.getRowCount();
        return WWindow.createLayout(request, table2, wsc, ws, "", statusDB);
    }

    private static WebDoc createLayout(HttpServletRequest request, table contentTable, WebSessionCtx wsc, WWindowStatus ws, String statusInfo, String statusDB) {
        return WWindow.createLayout(request, contentTable, wsc, ws, statusInfo, statusDB, null);
    }

    private static WebDoc createLayout(HttpServletRequest request, table contentTable, WebSessionCtx wsc, WWindowStatus ws, String statusInfo, String statusDB, ArrayList<KeyNamePair> zoomList) {
        img img2;
        boolean insertRecord;
        String action = request.getRequestURI();
        div bodyDiv = (div)new div().setID("body");
        form myForm = null;
        myForm = new form(action);
        if (ws.getTarget() == null) {
            myForm.setTarget("WWindow");
        } else {
            myForm.setTarget(ws.getTarget());
        }
        myForm.setID("WWindow" + ws.mWindow.getAD_Window_ID());
        String AD_Language = Env.getAD_Language(ws.ctx);
        myForm.setName(FORM_NAME);
        div hiddenDiv = new div();
        myForm.addElement((org.apache.ecs.Element)hiddenDiv);
        hiddenDiv.addElement((org.apache.ecs.Element)new input("hidden", P_Command, ""));
        hiddenDiv.addElement((org.apache.ecs.Element)new input("hidden", P_MR_RowNo, ""));
        hiddenDiv.addElement(new input("hidden", P_Reserve1, "").setID(P_Reserve1));
        hiddenDiv.addElement(new input("hidden", P_Reserve2, "").setID(P_Reserve2));
        hiddenDiv.addElement(new input("hidden", P_Reserve3, "").setID(P_Reserve3));
        hiddenDiv.addElement(new input("hidden", "windowId", ws.mWindow.getAD_Window_ID()).setID("windowId"));
        hiddenDiv.addElement(new input("hidden", "windowNo", ws.mWindow.getWindowNo()).setID("windowNo"));
        hiddenDiv.addElement((org.apache.ecs.Element)new input("hidden", "ChangeTab", ""));
        boolean isZoomWindow = false;
        String zoomWindowStr = "0";
        if (request.getAttribute(IS_ZOOM_WINDOW) != null || "1".equals(request.getParameter(IS_ZOOM_WINDOW))) {
            isZoomWindow = true;
            zoomWindowStr = "1";
        }
        hiddenDiv.addElement((org.apache.ecs.Element)new input("hidden", IS_ZOOM_WINDOW, zoomWindowStr));
        hiddenDiv.addElement(new input("hidden", P_ChangedColumn, "").addAttribute("id", P_ChangedColumn));
        hiddenDiv.addElement(new input("hidden", Change_Flag, "").setID(Change_Flag));
        String title = ws.mWindow.getName() + " - " + wsc.loginInfo;
        hiddenDiv.addElement((org.apache.ecs.Element)new script("top.document.title='" + title + "';"));
        td toolbarTd = new td(null, "left", "middle", true);
        div toolbarDiv = (div)new div().setID("menu_icon");
        ul toolbar = new ul();
        toolbarTd.addElement((org.apache.ecs.Element)toolbarDiv);
        bodyDiv.addElement((org.apache.ecs.Element)new li((org.apache.ecs.Element)WWindow.createMenuDiv(wsc, ws)));
        ul infobar = new ul();
        infobar.setStyle("margin-bottom:10px");
        toolbarDiv.addElement((org.apache.ecs.Element)infobar);
        toolbarDiv.addElement((org.apache.ecs.Element)toolbar);
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "MenuOnOff", "MenuOnOff", "menuSwitch();", true, false)));
        boolean needSave = wsc.ctx.getContextAsInt(ws.curTab.getWindowNo(), "NeedSave") != 0;
        boolean bl = insertRecord = !ws.curTab.isReadOnly();
        if (insertRecord) {
            insertRecord = ws.curTab.isInsertRecord();
        }
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Ignore", "Ignore", null, needSave, false)));
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Help", "Help", "startPopup('WHelp?AD_Window_ID=" + ws.mWindow.getAD_Window_ID() + "');", true, false)));
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "New", "New", null, !needSave && insertRecord, false)));
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Delete", "Delete", "if (confirm(deleteText)) WForm.submit();", !needSave && insertRecord, false)));
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Save", "Save", "beforeSave(document.WForm);", needSave, false)));
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Refresh", "Refresh", null, !needSave, false)));
        boolean findPressed = ws.curTab.isQueryActive() || ws.curTab.getOnlyCurrentDays() > 0;
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Find", "Find", "openFindWindow('/compiere/ampiere/WFind', '" + ws.curTab.getTableName() + "' );", true, false, findPressed)));
        boolean canHaveAttachment = ws.curTab.canHaveAttachment();
        if (ws.curTab.canHaveAttachment() && ws.curTab.getRecord_ID() == -1) {
            canHaveAttachment = false;
        }
        boolean hasAttachment = false;
        try {
            hasAttachment = ws.curTab.getAD_AttachmentID() != 0;
        }
        catch (Exception e) {
            // empty catch block
        }
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Attachment", "Attachment", "startPopup('WAttachment');", ws.curTab.getCurrentRow() != -1 && canHaveAttachment, false, hasAttachment)));
        boolean canHaveChat = ws.curTab.hasChat();
        if (ws.curTab.hasChat() && ws.curTab.getRecord_ID() == -1) {
            canHaveChat = false;
        }
        boolean hasChat = false;
        try {
            hasChat = ws.curTab.getCM_ChatID() != 0;
        }
        catch (Exception e) {
            // empty catch block
        }
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Chat", "Chat", "startPopupWH('Chat.do','600','700');", ws.curTab.getCurrentRow() != -1, false, hasChat)));
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Multi", "Multi", null, true, !ws.curTab.isSingleRow())));
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Report", "Report")));
        boolean isPrint = false;
        isPrint = ws.curTab.getAD_Process_ID() != 0;
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Print", "Print", null, isPrint, false)));
        String sql = MRole.getDefault(wsc.ctx, false).addAccessSQL("SELECT COUNT(*) FROM AD_JasperFormat WHERE IsActive='Y' AND AD_Table_ID=" + ws.curTab.getAD_Table_ID(), null, false, false);
        int no = DB.getSQLValue(null, sql);
        boolean enable = false;
        if (no > 0) {
            enable = true;
        }
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "JasperReport", "JasperReport", "openReportWindow('/compiere/ampiere/WJasperPrint', '" + ws.curTab.getTableName() + "' );", enable, false)));
        boolean isFirst = ws.curTab.getCurrentRow() < 1;
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "First", "First", null, !isFirst, false)));
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Previous", "Previous", null, !isFirst, false)));
        boolean isLast = ws.curTab.getCurrentRow() + 1 == ws.curTab.getRowCount();
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Next", "Next", null, !isLast, false)));
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Last", "Last", null, !isLast, false)));
        if (zoomList != null) {
            img2 = WWindow.createImage(AD_Language, "ZoomAcross", "ZoomAcross", null, ws.curTab.isSingleRow(), false);
            toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WebField.getZoomAcross(img2, zoomList, ws)));
        } else {
            toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "ZoomAcross", "ZoomAcross", null, false, false)));
        }
        if (ws.curTab.isSingleRow()) {
            img2 = WWindow.createImage(AD_Language, "WorkFlow", "WorkFlow", null, ws.curTab.isSingleRow(), false);
            toolbar.addElement((org.apache.ecs.Element)WebField.getWorkFlow(img2, ws));
        }
        ArrayList<ValueNamePair> requestList = WRequest.getRequests(request, ws);
        img img3 = WWindow.createImage(AD_Language, "Request", "Request", null, ws.curTab.isSingleRow(), false);
        toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WebField.getRequestLi(img3, requestList, ws)));
        if (isZoomWindow) {
            toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Exit", "Exit", "window.close();", true, false)));
        } else {
            toolbar.addElement((org.apache.ecs.Element)new li().addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Exit", "Exit")));
        }
        div tabbar = (div)new div().setID("menu_tab");
        tabbar.addElement((org.apache.ecs.Element)new input("hidden", P_Tab, ""));
        ul tabTable = new ul();
        boolean currentTab = false;
        for (int i2 = 0; i2 < ws.mWindow.getTabCount(); ++i2) {
            GridTab tab = ws.mWindow.getTab(i2);
            if (tab.isSortTab()) continue;
            String tabMouseOver = "";
            String tabMouseOut = "";
            String tabLeftId = "tabLeftId_" + Integer.toString(i2);
            String tabRightId = "tabRightId_" + Integer.toString(i2);
            String tabLeftClass = "tabLeft";
            String tabRightClass = "tabRight";
            span big = new span(tab.getName());
            if (ws.curTab.getTabNo() == i2) {
                big.setClass("tabSelected");
                tabLeftClass = tabLeftClass + "Sel";
                tabRightClass = tabRightClass + "Sel";
                currentTab = true;
            } else if (tab.getTabLevel() <= ws.curTab.getTabLevel() || currentTab && tab.getTabLevel() == ws.curTab.getTabLevel() + 1) {
                big.setClass("tab");
                big.setOnClick("beforeChangeTab('" + i2 + "');");
                tabMouseOver = "tabMouseOver('" + tabLeftId + "', '" + tabRightId + "');";
                tabMouseOut = "tabMouseOut('" + tabLeftId + "', '" + tabRightId + "');";
            } else {
                big.setClass("tabDisabled");
                tabLeftClass = tabLeftClass + "Dis";
                tabRightClass = tabRightClass + "Dis";
            }
            if (ws.curTab.getTabNo() != i2 && currentTab && tab.getTabLevel() <= ws.curTab.getTabLevel()) {
                currentTab = false;
            }
            span tabTdLeft = new span(WebEnv.NBSP);
            tabTdLeft.setClass(tabLeftClass);
            li tabTdRight = (li)new li().setClass(tabRightClass);
            tabTdLeft.setID(tabLeftId);
            tabTdRight.setID(tabRightId);
            if (tab.getDescription().length() > 0) {
                tabMouseOver = tabMouseOver + "status='" + tab.getDescription() + "';return true;";
            }
            if (tabMouseOver != null && !"".equals(tabMouseOver)) {
                big.setOnMouseOver(tabMouseOver);
            }
            if (tabMouseOut != null && !"".equals(tabMouseOut)) {
                tabMouseOut = tabMouseOut + "status='" + ws.curTab.getName() + "';return true;";
                big.setOnMouseOut(tabMouseOut);
            }
            tabTable.addElement((org.apache.ecs.Element)tabTdRight);
            tabTdRight.addElement((org.apache.ecs.Element)tabTdLeft);
            tabTdRight.addElement((org.apache.ecs.Element)big);
            tabTdRight.setStyle("");
        }
        tabbar.addElement((org.apache.ecs.Element)tabTable);
        table topTable = (table)new table("0", "0", "0", "100%", null).setStyle("margin:0 0 0 0;");
        topTable.setID("WWindow.topTable");
        topTable.addElement((org.apache.ecs.Element)new tr((org.apache.ecs.Element)toolbarTd));
        myForm.addElement((org.apache.ecs.Element)topTable);
        myForm.addElement((org.apache.ecs.Element)tabbar);
        myForm.addElement((org.apache.ecs.Element)contentTable);
        table statusTable = new table();
        tr statusLine = new tr();
        div statusdiv = (div)new div().setClass("bottomMenuRight");
        td statusTd = new td();
        statusTd.addElement((org.apache.ecs.Element)new span().addElement(statusDB));
        statusTd.addElement((org.apache.ecs.Element)WWindow.createImage(AD_Language, "Save", "Save2", "beforeSave(document.WForm);", needSave, false).setHeight("24"));
        statusTd.addElement("&nbsp;&nbsp;&nbsp");
        statusLine.addElement((org.apache.ecs.Element)statusTd);
        statusTable.addElement((org.apache.ecs.Element)statusLine);
        statusdiv.addElement((org.apache.ecs.Element)statusTable);
        WebDoc doc = WWindow.createPage(ws, wsc);
        doc.getBody().setOnUnload("closeMyChildren();");
        doc.getHead().addElement((org.apache.ecs.Element)new script(WWindow.makeMenuItemScript(wsc, ws)));
        doc.getBody().setOnLoad("displayMenu();");
        bodyDiv.addElement((org.apache.ecs.Element)myForm);
        bodyDiv.addElement((org.apache.ecs.Element)statusdiv);
        doc.getTable().addElement((org.apache.ecs.Element)new tr().addElement((org.apache.ecs.Element)new td(null, "left", "top", true, (org.apache.ecs.Element)bodyDiv)));
        return doc;
    }

    private static WebDoc createPage(WWindowStatus ws, WebSessionCtx wsc) {
        WebDoc doc = WebDoc.createWindow(ws.mWindow.getName());
        doc.getHead().addElement((org.apache.ecs.Element)new link("css/displaytagWithFixedWidth.css", "stylesheet", "text/css"));
        AmpiereUtil.addDatePicker(doc.getHead(), wsc);
        if ("Y".equals(ws.ctx.getContext(ws.mWindow.getWindowNo(), "IsPrintStart"))) {
            wsc.ctx.setContext(ws.curTab.getWindowNo(), "IsPrintStart", false);
            MPInstance pInstance = new MPInstance(ws.ctx, ws.curTab.getAD_Process_ID(), ws.curTab.getRecord_ID());
            if (!pInstance.save()) {
                log.log(Level.SEVERE, "Instance run error.");
            }
            wsc.ctx.setContext("AD_Process_ID", ws.curTab.getAD_Process_ID());
            wsc.ctx.setContext("AD_PInstance_ID", pInstance.getAD_PInstance_ID());
            StringBuffer sb = new StringBuffer();
            sb.append("openReportWindow(").append("\"/compiere/ampiere/WPrint\",").append("\"WPrint\" );");
            doc.getHead().addElement((org.apache.ecs.Element)new script(sb.toString()));
        } else if ("Y".equals(ws.ctx.getContext(ws.curTab.getWindowNo(), "IsReportStart"))) {
            wsc.ctx.setContext(ws.curTab.getWindowNo(), "IsReportStart", false);
            StringBuffer sb = new StringBuffer();
            sb.append("openReportWindow(").append("\"/compiere/ampiere/WReport\",").append("\"WReport\" );");
            doc.getHead().addElement((org.apache.ecs.Element)new script(sb.toString()));
        }
        doc.getBody().addElement((org.apache.ecs.Element)new script("deleteText='" + Msg.getMsg(ws.ctx, "DeleteRecord?") + "';")).addElement((org.apache.ecs.Element)new script("saveErrorText='" + Msg.getMsg(ws.ctx, "SaveError") + "';"));
        return doc;
    }

    private static img createImage(String AD_Language, String name, String id, String js_command, boolean enabled, boolean pressed) {
        return WWindow.createImage(AD_Language, name, id, js_command, enabled, pressed, false);
    }

    private static img createImage(String AD_Language, String name, String id, String js_command, boolean enabled, boolean pressed, boolean hasData) {
        StringBuffer imgName = new StringBuffer();
        imgName.append(name);
        if (hasData) {
            imgName.append("X");
        }
        imgName.append("32.png");
        img img2 = new img(WebEnv.getImageDirectory(imgName.toString()), name);
        if (enabled) {
            img2.setAlt(Msg.getMsg(AD_Language, name));
            img2.setTitle(Msg.getMsg(AD_Language, name));
        }
        if (enabled) {
            if (!pressed) {
                img2.setClass("imgButton");
            } else {
                img2.setClass("imgButtonPressed");
            }
            img2.setOnMouseOver("btnMouseOver('" + id + "');");
            img2.setOnMouseOut("btnMouseOut('" + id + "');");
        } else {
            img2.setClass("imgButtonD");
        }
        img2.setID(id);
        img2.setStyle("");
        if (js_command == null) {
            js_command = "WForm.submit();";
        }
        if (js_command.length() > 0 && enabled) {
            img2.setOnClick("document.WForm.PCommand.value='" + name + "';" + js_command);
        }
        return img2;
    }

    private static img createImage(String AD_Language, String name, String id) {
        return WWindow.createImage(AD_Language, name, id, null, true, false);
    }

    private void addField(WebSessionCtx wsc, tr line, GridField field, Object oData, boolean hasDependents, boolean readOnly, WWindowStatus ws) {
        String columnName = field.getColumnName();
        boolean error = field.isErrorValue();
        if (error) {
            oData = field.getErrorValue();
        }
        int dt = field.getDisplayType();
        boolean hasCallout = field.getCallout().length() > 0;
        int display_length = field.getDisplayLength();
        display_length = display_length > 40 ? 48 : 20;
        WebField wField = new WebField(field.getWindowNo(), wsc, columnName, field.getHeader(), field.getDescription(), dt, field.getFieldLength(), display_length * 12, field.isLongField(), readOnly, field.isMandatory(false), error, hasDependents, hasCallout, field.getAD_Process_ID(), field.isEncryptedField());
        th labelTD = new th();
        if (field.getVO().lookupInfo != null) {
            if (field.getDisplayType() != 17 || field.getDisplayType() == 17 && wsc.ctx.getAD_Role_ID() == 0) {
                String oDataValue = "";
                if (oData != null) {
                    oDataValue = oData.toString();
                }
                int m_WindowNo = ws.mWindow.getWindowNo();
                boolean isSOTrx = ws.ctx.isSOTrx(m_WindowNo);
                String queryString = "";
                try {
                    queryString = field.getLookup().getZoomQuery().getWhereClause();
                }
                catch (Exception e) {
                    // empty catch block
                }
                int zoomWindowId = ZoomTarget.getZoomAD_Window_ID(field.getVO().lookupInfo.TableName, ws.getCurTab().getAD_Window_ID(), queryString, isSOTrx);
                labelTD = wField.getZoomLabel(zoomWindowId, field.getVO().ColumnName, oDataValue, ws);
            } else {
                labelTD = wField.getLabel();
            }
        } else {
            labelTD = wField.getLabel();
        }
        line.addElement((org.apache.ecs.Element)labelTD).addElement((org.apache.ecs.Element)wField.getField(field.getLookupRefresh(), oData, field.getAD_Column_ID()));
    }

    private boolean isNewGroup(String fieldGroup) {
        boolean isnewgroup = false;
        if (this.m_oldFieldGroup == null) {
            this.m_oldFieldGroup = "";
        } else if (fieldGroup == null || fieldGroup.length() == 0 || fieldGroup.equals(this.m_oldFieldGroup)) {
            isnewgroup = false;
        } else if (!fieldGroup.equals(this.m_oldFieldGroup)) {
            this.m_oldFieldGroup = fieldGroup;
            isnewgroup = true;
        }
        return isnewgroup;
    }

    private void actionButton(WWindowStatus ws, WebSessionCtx wsc, String columnName, int processId, boolean batch, String value) {
        log.info("Process button : " + columnName + "  ProcessID : " + processId + "  Value : " + value);
        if (ws.curTab.needSave(true, false) && !ws.curTab.dataSave(true)) {
            ws.curTab.dataIgnore();
            log.log(Level.INFO, "Data save has been ignored.");
            return;
        }
        int table_ID = ws.curTab.getAD_Table_ID();
        int record_ID = ws.curTab.getRecord_ID();
        if (record_ID == -1 && ws.curTab.getKeyColumnName().equals("AD_Language")) {
            record_ID = wsc.ctx.getContextAsInt(ws.mWindow.getWindowNo(), "AD_Language_ID");
        }
        if (record_ID == -1 && (processId == 306 || processId == 307)) {
            Integer id = (Integer)ws.curTab.getValue("AD_ChangeLog_ID");
            record_ID = id;
        }
        if (record_ID == -1 && ws.curTab.getKeyColumnName().endsWith("_ID")) {
            log.log(Level.SEVERE, "SaveErrorRowNotFound");
            return;
        }
        log.config("Process_ID=" + processId + ", Record_ID=" + record_ID);
        if (processId == 0) {
            return;
        }
        if ("DocAction".equalsIgnoreCase(columnName)) {
            log.config("DocAction=" + value);
            Object orgValue = ws.curTab.getValue("DocAction");
            if (!value.equals(orgValue)) {
                ws.curTab.setValue("DocAction", (Object)value);
                if (ws.curTab.needSave(true, false)) {
                    ws.curTab.dataSave(false);
                }
            }
        }
        String title = columnName;
        ProcessInfo pi = new ProcessInfo(title, processId, table_ID, record_ID);
        pi.setAD_User_ID(wsc.ctx.getAD_User_ID());
        pi.setAD_Client_ID(wsc.ctx.getAD_Client_ID());
        pi.setIsBatch(batch);
        ProcessCtl processCtrl = ProcessCtl.getProcessInstance(ws.mWindow.getWindowNo(), pi, null, wsc.ctx);
        processCtrl.run();
        String summary = pi.getSummary();
        if (summary != null && summary.indexOf("@") != -1) {
            summary = Msg.parseTranslation(wsc.ctx, summary);
        }
        if (pi.isError()) {
            this.m_popupAlert = new StringBuffer();
            this.m_popupAlert.append(summary);
        }
    }

    @Override
    public void dataStatusChanged(DataStatusEvent e) {
        if (this.m_request == null) {
            return;
        }
        if ((e.isError() || e.isWarning()) && !e.isConfirmed()) {
            WebSessionCtx wsc = WebSessionCtx.get(this.m_request);
            StringBuffer sb = new StringBuffer();
            String msg = null;
            if (e.getAD_Message() != null || e.getInfo() != null) {
                int pos;
                String info;
                msg = Msg.translate(wsc.ctx, e.getAD_Message());
                if (msg != null) {
                    sb.append(msg);
                }
                if ((info = e.getInfo()) != null && info.length() > 0) {
                    if (sb.length() > 0 && !sb.toString().trim().endsWith(":")) {
                        sb.append(": ");
                    }
                    sb.append(info);
                }
                if (sb.length() > 0 && (pos = sb.indexOf("\n")) != -1) {
                    sb.replace(pos, pos + 1, " - ");
                }
            }
            if (sb.length() > 0) {
                if (this.m_popupAlert != null) {
                    if (msg != null && this.m_popupAlert.indexOf(msg) == -1) {
                        this.m_popupAlert.append("\\n" + sb.toString());
                    }
                } else {
                    this.m_popupAlert = new StringBuffer();
                    this.m_popupAlert.append(sb.toString());
                }
            }
            e.setConfirmed(true);
        }
    }

    private void setFieldNewValue(WebSessionCtx wsc, WWindowStatus ws, GridField mField, Object newValue) {
        if (mField.getDisplayType() == 30) {
            boolean popup = true;
            String columnName = mField.getColumnName();
            String[] values = this.m_request.getParameterValues(columnName);
            if (values != null && values.length == 2 && values[1].length() > 0) {
                ResultSet rs;
                String text;
                NamePair np = null;
                if (values[0] != null && values[0].length() > 0) {
                    try {
                        int key = Integer.parseInt(values[0]);
                        np = mField.getLookup().get(new Integer(key));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                String name = text = values[1].toUpperCase();
                log.config(columnName + " - " + text);
                CPreparedStatement pstmt = null;
                String finalSQL = Msg.parseTranslation(wsc.ctx, AmpiereUtil.getDirectAccessSQL(wsc.ctx, mField.getLookup(), columnName, text));
                int id = -3;
                try {
                    pstmt = DB.prepareStatement(finalSQL, null);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        id = rs.getInt(1);
                        if (rs.next()) {
                            id = -1;
                        }
                    }
                    rs.close();
                    pstmt.close();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, finalSQL, e);
                    id = -2;
                }
                if (id == -3 && !text.endsWith("%")) {
                    text = text + "%";
                    finalSQL = Msg.parseTranslation(wsc.ctx, AmpiereUtil.getDirectAccessSQL(wsc.ctx, mField.getLookup(), columnName, text));
                    try {
                        pstmt = DB.prepareStatement(finalSQL, null);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            id = rs.getInt(1);
                            if (rs.next()) {
                                id = -1;
                            }
                        }
                        rs.close();
                        pstmt.close();
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, finalSQL, e);
                        id = -2;
                    }
                }
                try {
                    if (pstmt != null) {
                        pstmt.close();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (id <= 0 && np != null && np.getName().equalsIgnoreCase(name)) {
                    id = Integer.parseInt(np.getID());
                }
                if (id <= 0) {
                    if (id == -3) {
                        log.fine(columnName + " - Not Found - " + finalSQL);
                    } else {
                        log.fine(columnName + " - Not Unique - " + finalSQL);
                    }
                } else {
                    log.fine(columnName + " - Unique ID=" + id);
                    ws.curTab.setValue(mField, (Object)new Integer(id));
                    popup = false;
                }
                if (popup) {
                    String col = mField.getLookup().getColumnName();
                    if (col != null && col.indexOf(".") >= 0) {
                        col = col.substring(col.indexOf(".") + 1);
                    }
                    String s = "startLookup('" + columnName + "'," + mField.getWindowNo() + "," + mField.getAD_Column_ID() + ",'" + col + "', 'N','" + values[1] + "');";
                    this.m_popupLookup = s + "return false;";
                }
            } else if (values != null && values.length == 2 && "".equals(values[0]) && "".equals(values[1])) {
                ws.curTab.setValue(mField, newValue);
            }
        } else {
            ws.curTab.setValue(mField, newValue);
        }
    }

    private void resetAmountformat(WebSessionCtx wsc, WWindowStatus ws) {
        MCurrency mCurrency;
        GridField[] fields = ws.mWindow.getTab(0).getFields();
        int currencyId = 0;
        for (int i2 = 0; i2 < fields.length; ++i2) {
            String fieldName = fields[i2].getColumnName();
            if (!fieldName.equals("C_Currency_ID")) continue;
            if (fields[i2].getValue() == null) break;
            currencyId = new Integer(fields[i2].getValue().toString());
            break;
        }
        if (currencyId == 0) {
            currencyId = wsc.ctx.getContextAsInt("$C_Currency_ID");
        }
        if ((mCurrency = new MCurrency(wsc.ctx, currencyId, null)) != null) {
            wsc.amountFormat.setMinimumFractionDigits(mCurrency.getStdPrecision());
        }
    }

    private WebDoc getSR_Form(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws) {
        return this.getSR_Form(request, wsc, ws, null);
    }

    private WebDoc getSR_Form(HttpServletRequest request, WebSessionCtx wsc, WWindowStatus ws, ArrayList<KeyNamePair> zoomList) {
        log.fine("Tab=" + ws.curTab.getTabNo());
        table table2 = new table().setAlign("center");
        StringBuffer scriptSrc = new StringBuffer();
        StringBuffer scriptSrcHidden = new StringBuffer();
        tr line = new tr();
        if (ws.curTab.isDisplayed(false)) {
            wsc.ctx.setContext(ws.curTab.getWindowNo(), "Record_ID", ws.curTab.getRecord_ID());
            int currentRow = ws.curTab.getCurrentRow();
            int noFields = ws.curTab.getFieldCount();
            for (int i2 = 0; i2 < noFields; ++i2) {
                GridField field = ws.curTab.getSRField(i2);
                String columnName = field.getColumnName();
                Object oData = ws.curTab.getValue(field);
                if (!field.isSameLine()) {
                    line = new tr();
                }
                if (field.isDisplayed(true)) {
                    if (this.isNewGroup(field.getFieldGroup())) {
                        line = new tr();
                        line.addElement((org.apache.ecs.Element)new td().setColSpan(4).addElement(field.getFieldGroup()));
                        table2.addElement((org.apache.ecs.Element)line);
                        line = new tr();
                        line.addElement((org.apache.ecs.Element)new td().setColSpan(4).addElement((org.apache.ecs.Element)new hr()));
                        table2.addElement((org.apache.ecs.Element)line);
                        line = new tr();
                    }
                    boolean hasDependents = ws.curTab.hasDependants(columnName);
                    boolean readOnly = currentRow == -1 || !field.isEditable(true);
                    this.addField(wsc, line, field, oData, hasDependents, readOnly, ws);
                    table2.addElement((org.apache.ecs.Element)line);
                    String dispLogic = field.getDisplayLogic();
                    if (dispLogic == null || dispLogic.length() <= 0) continue;
                    dispLogic = dispLogic.replace('\'', '\"');
                    dispLogic = dispLogic.replaceAll("\n", "");
                    scriptSrc.append("document.").append(FORM_NAME).append(".").append(columnName).append(".displayLogic='").append(dispLogic).append("';\n");
                    continue;
                }
                String dispLogic = field.getDisplayLogic();
                if (dispLogic == null || dispLogic.length() <= 0) continue;
                boolean hasDependents = ws.curTab.hasDependants(columnName);
                boolean readOnly = currentRow == -1 || !field.isEditable(true);
                this.addField(wsc, line, field, oData, hasDependents, readOnly, ws);
                table2.addElement((org.apache.ecs.Element)line);
                dispLogic = dispLogic.replace('\'', '\"');
                dispLogic = dispLogic.replaceAll("\n", "");
                scriptSrc.append("document.").append(FORM_NAME).append(".").append(columnName).append(".displayLogic='").append(dispLogic).append("';\n");
                int m_displayType = field.getDisplayType();
                String m_columnName = field.getColumnName();
                String htmlObjId = "";
                if (m_displayType == 30 || m_displayType == 21 || m_displayType == 25) {
                    htmlObjId = m_columnName + "D";
                    scriptSrcHidden.append("Element.hide('").append(field.getColumnName() + "F").append("');\n");
                    scriptSrcHidden.append("Element.hide('").append(field.getColumnName() + "B").append("');\n");
                } else {
                    htmlObjId = DisplayType.isLookup(m_displayType) || m_displayType == 31 ? m_columnName : (m_displayType == 20 ? m_columnName + "F" : (m_displayType == 28 ? m_columnName : (DisplayType.isDate(m_displayType) ? m_columnName + "F" : (DisplayType.isNumeric(m_displayType) ? m_columnName + "F" : (m_displayType == 14 ? m_columnName + "F" : (m_displayType == 36 ? m_columnName + "F" : (m_displayType == 34 ? m_columnName + "F" : m_columnName + "F")))))));
                }
                scriptSrcHidden.append("Element.hide('").append(htmlObjId).append("');\n");
                scriptSrcHidden.append("Element.hide('").append(field.getColumnName() + "L").append("');\n");
            }
        }
        if (scriptSrc.length() > 0) {
            table2.addElement((org.apache.ecs.Element)new script(scriptSrcHidden.toString()));
        }
        table2.addElement((org.apache.ecs.Element)new script(scriptSrc.toString()));
        int rowNo = ws.curTab.getCurrentRow();
        String statusDB = String.valueOf(rowNo + 1) + " # " + ws.curTab.getRowCount();
        if (zoomList != null) {
            return WWindow.createLayout(request, table2, wsc, ws, "", statusDB, zoomList);
        }
        return WWindow.createLayout(request, table2, wsc, ws, "", statusDB);
    }

    private String getHtmlObjectName(GridField field) {
        int m_displayType = field.getDisplayType();
        String m_columnName = field.getColumnName();
        String htmlObjId = "";
        htmlObjId = m_displayType == 30 || m_displayType == 21 || m_displayType == 25 || m_displayType == 35 ? m_columnName + "D" : (DisplayType.isLookup(m_displayType) || m_displayType == 31 ? m_columnName : (m_displayType == 20 ? m_columnName + "F" : (m_displayType == 28 ? m_columnName : (DisplayType.isDate(m_displayType) ? m_columnName + "F" : (DisplayType.isNumeric(m_displayType) ? m_columnName + "F" : (m_displayType == 14 ? m_columnName + "F" : (m_displayType == 36 ? m_columnName + "F" : (m_displayType == 34 ? m_columnName + "F" : m_columnName + "F"))))))));
        return htmlObjId;
    }

    private String getHtmlObjectLabelName(GridField field) {
        String m_columnName = field.getColumnName();
        String htmlObjId = "";
        htmlObjId = m_columnName + "L";
        return htmlObjId;
    }

    private void InsertAttributeSetHiddenObject(Document document, Element elements, String objId, String newValue_str) {
        objId = objId + "D";
        Element element = document.createElement("element");
        elements.appendChild(element);
        Element elm_id = document.createElement("id");
        element.appendChild(elm_id);
        elm_id.appendChild(document.createTextNode(objId));
        Element elm_lookup = document.createElement("lookup");
        element.appendChild(elm_lookup);
        elm_lookup.appendChild(document.createTextNode("0"));
        Element elm_visibility = document.createElement("visibility");
        element.appendChild(elm_visibility);
        elm_visibility.appendChild(document.createTextNode("0"));
        Element elm_newValue = document.createElement("newValue");
        element.appendChild(elm_newValue);
        elm_newValue.appendChild(document.createTextNode(newValue_str));
        Element elm_readonly = document.createElement("readonly");
        element.appendChild(elm_readonly);
        String realOnlyFlag = "0";
        elm_readonly.appendChild(document.createTextNode(realOnlyFlag));
        Element elm_type = document.createElement("type");
        element.appendChild(elm_type);
        elm_type.appendChild(document.createTextNode("1"));
    }

    private void initWindow(WWindowStatus ws) {
        for (int tab = 0; tab < ws.mWindow.getTabCount(); ++tab) {
            MRole role = MRole.getDefault(ws.ctx, false);
            if (!role.isDisplayClient()) {
                ws.mWindow.getTab(tab).getField("AD_Client_ID").setDisplayed(false);
            }
            if (role.isDisplayOrg()) continue;
            ws.mWindow.getTab(tab).getField("AD_Org_ID").setDisplayed(false);
        }
    }

    public static String makeMenuItemScript(WebSessionCtx wsc, WWindowStatus ws) {
        boolean needSave = false;
        try {
            needSave = wsc.ctx.getContextAsInt(ws.curTab.getWindowNo(), "NeedSave") != 0;
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean insertRecord = false;
        try {
            boolean bl = insertRecord = !ws.curTab.isReadOnly();
            if (insertRecord) {
                insertRecord = ws.curTab.isInsertRecord();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String LN = "\r\n";
        StringBuffer sb = new StringBuffer();
        sb.append("function displayMenu() {" + LN);
        sb.append("var oMenuBar = new YAHOO.widget.MenuBar(\"menuBar\", {" + LN);
        sb.append("   autosubmenudisplay : true," + LN);
        sb.append("   hidedelay : 750," + LN);
        sb.append("   lazyload : true" + LN);
        sb.append("});" + LN);
        sb.append("var aSubmenuData = [ {" + LN);
        sb.append("   id : \"File\"," + LN);
        sb.append("   itemdata : [ [" + LN);
        if (ws != null) {
            sb.append("   {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("Report") + Msg.translate(wsc.ctx, "Report") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='Report';WForm.submit();\"" + LN);
            sb.append("   }, {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("Print") + Msg.translate(wsc.ctx, "Print") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='Print';WForm.submit();\"" + LN);
            sb.append("   }, {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("JasperReport") + Msg.translate(wsc.ctx, "JasperReport") + "\"," + LN);
            sb.append("      url : \"javascript:openReportWindow('/compiere/ampiere/WJasperPrint', '" + ws.curTab.getTableName() + "' );\"" + LN);
            sb.append("   }], [" + LN);
        }
        sb.append("   {" + LN);
        sb.append("      text : \"" + WWindow.getImage16("Exit") + Msg.translate(wsc.ctx, "Exit") + "\"," + LN);
        sb.append("      url : \"/compiere/ampiere/WMenu?Exit=true\"" + LN);
        sb.append("   } ]]" + LN);
        if (ws != null) {
            sb.append("}, {" + LN);
            sb.append("   id : \"Edit\"," + LN);
            sb.append("   itemdata : [[{" + LN);
            if (!needSave && insertRecord) {
                sb.append("      text : \"" + WWindow.getImage16("New") + Msg.translate(wsc.ctx, "New") + "\"," + LN);
                sb.append("      url : \"javascript:document.WForm.PCommand.value='New';WForm.submit();\"" + LN);
                sb.append("   }, {" + LN);
            }
            sb.append("      text : \"" + WWindow.getImage16("Copy") + Msg.translate(wsc.ctx, "Copy") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='Copy';WForm.submit();\"" + LN);
            sb.append("   }, {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("Delete") + Msg.translate(wsc.ctx, "Delete") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='Delete';WForm.submit();\"" + LN);
            sb.append("   }, {" + LN);
            if (needSave) {
                sb.append("      text : \"" + WWindow.getImage16("Save") + Msg.translate(wsc.ctx, "Save") + "\"," + LN);
                sb.append("      url : \"javascript:document.WForm.PCommand.value='Save';WForm.submit();\"" + LN);
                sb.append("   }], [{" + LN);
                sb.append("      text : \"" + WWindow.getImage16("Ignore") + Msg.translate(wsc.ctx, "Ignore") + "\"," + LN);
                sb.append("      url : \"javascript:document.WForm.PCommand.value='Ignore';WForm.submit();\"" + LN);
                sb.append("   }, {" + LN);
            }
            sb.append("      text : \"" + WWindow.getImage16("Refresh") + Msg.translate(wsc.ctx, "Refresh") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='Refresh';WForm.submit();\"" + LN);
            sb.append("   }], [{" + LN);
            sb.append("      text : \"" + WWindow.getImage16("Find") + Msg.translate(wsc.ctx, "Find") + "\"," + LN);
            sb.append("      url : \"javascript:openFindWindow('/compiere/ampiere/WFind', '" + ws.curTab.getTableName() + "' );\"" + LN);
            if (MRole.getDefault(wsc.ctx, false).isPersonalLock()) {
                sb.append("   }, {" + LN);
                sb.append("      text : \"" + WWindow.getImage16("Lock") + Msg.translate(wsc.ctx, "Lock") + "\"," + LN);
                sb.append("      url : \"javascript:document.WForm.PCommand.value='Lock';WForm.submit();\"" + LN);
            }
            sb.append("   } ]]" + LN);
        }
        sb.append("}, {" + LN);
        sb.append("   id : \"View\"," + LN);
        sb.append("   itemdata : [ [{" + LN);
        sb.append("      text : \"" + WWindow.getImage16("InfoProduct") + Msg.translate(wsc.ctx, "InfoProduct") + "\"," + LN);
        sb.append("      url : \"javascript:startLookup('M_Product_ID',null,null,'M_Product_ID', 'N',null);\"" + LN);
        sb.append("   }, {" + LN);
        sb.append("      text : \"" + WWindow.getImage16("InfoBPartner") + Msg.translate(wsc.ctx, "InfoBPartner") + "\"," + LN);
        sb.append("      url : \"javascript:startLookup('C_BPartner_ID',null,null,'C_BPartner_ID', 'N',null);\"" + LN);
        if (MRole.getDefault(wsc.ctx, false).isShowAcct()) {
            sb.append("   }, {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("InfoAccount") + Msg.translate(wsc.ctx, "InfoAccount") + "\"," + LN);
            sb.append("      url : \"javascript:startPopupWH('AcctViewer.do','900','600');\"" + LN);
        }
        sb.append("   }, {" + LN);
        sb.append("      text : \"" + WWindow.getImage16("InfoSchedule") + Msg.translate(wsc.ctx, "InfoSchedule") + "\"," + LN);
        sb.append("      url : \"javascript:startPopupWH('InfoSchedule.do','900','600');\"" + LN);
        sb.append("   }], [{" + LN);
        sb.append("      text : \"" + WWindow.getImage16("Info") + Msg.translate(wsc.ctx, "InfoOrder") + "\"," + LN);
        sb.append("      url : \"javascript:startLookup('C_Order_ID_info',null,null,'C_Order_ID_info', 'N',null);\"" + LN);
        sb.append("   }, {" + LN);
        sb.append("      text : \"" + WWindow.getImage16("Info") + Msg.translate(wsc.ctx, "InfoInvoice") + "\"," + LN);
        sb.append("      url : \"javascript:startLookup('C_Order_ID',null,null,'C_Order_ID_Invoice', 'N',null);\"" + LN);
        sb.append("   }, {" + LN);
        sb.append("      text : \"" + WWindow.getImage16("Info") + Msg.translate(wsc.ctx, "InfoInOut") + "\"," + LN);
        sb.append("      url : \"javascript:startLookup('C_Order_ID',null,null,'C_Order_ID_InfoInOut', 'N',null);\"" + LN);
        sb.append("   }, {" + LN);
        sb.append("      text : \"" + WWindow.getImage16("Info") + Msg.translate(wsc.ctx, "InfoPayment") + "\"," + LN);
        sb.append("      url : \"javascript:startLookup('C_Order_ID',null,null,'C_Order_ID_InfoPayment', 'N',null);\"" + LN);
        sb.append("   }, {" + LN);
        sb.append("      text : \"" + WWindow.getImage16("Info") + Msg.translate(wsc.ctx, "InfoCashLine") + "\"," + LN);
        sb.append("      url : \"javascript:startLookup('C_CashLine_ID',null,null,'C_CashLine_ID', 'N',null);\"" + LN);
        sb.append("   }, {" + LN);
        sb.append("      text : \"" + WWindow.getImage16("Info") + Msg.translate(wsc.ctx, "InfoAssignment") + "\"," + LN);
        sb.append("      url : \"javascript:startLookup('S_ResourceAssignment_ID',null,null,'S_ResourceAssignment_ID', 'N',null);\"" + LN);
        sb.append("   }, {" + LN);
        sb.append("      text : \"" + WWindow.getImage16("Info") + Msg.translate(wsc.ctx, "InfoAsset") + "\"," + LN);
        sb.append("      url : \"javascript:startLookup('A_Asset_ID',null,null,' A_Asset_ID', 'N',null);\"" + LN);
        sb.append("   }]" + LN);
        if (ws != null) {
            sb.append("   ,[ {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("Attachment") + Msg.translate(wsc.ctx, "Attachment") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='Attachment';startPopup('WAttachment');\"" + LN);
            sb.append("   }, {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("Chat") + Msg.translate(wsc.ctx, "Chat") + "\"," + LN);
            if (ws.getCurTab().getRecord_ID() != -1) {
                sb.append("      url : \"javascript:startPopupWH('Chat.do','600','700');\"" + LN);
            } else {
                sb.append("      url : \"#\"" + LN);
            }
            sb.append("   }], [{" + LN);
            sb.append("      text : \"" + WWindow.getImage16("Multi") + Msg.translate(wsc.ctx, "Multi") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='Multi';WForm.submit();\"" + LN);
            sb.append("   } ]");
        }
        sb.append("   ]" + LN);
        if (ws != null) {
            sb.append("}, {" + LN);
            sb.append("   id : \"Go\"," + LN);
            sb.append("   itemdata : [[{" + LN);
            sb.append("      text : \"" + WWindow.getImage16("First") + Msg.translate(wsc.ctx, "First") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='First';WForm.submit();\"" + LN);
            sb.append("   }, {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("Previous") + Msg.translate(wsc.ctx, "Previous") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='Previous';WForm.submit();\"" + LN);
            sb.append("   }, {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("Next") + Msg.translate(wsc.ctx, "Next") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='Next';WForm.submit();\"" + LN);
            sb.append("   }, {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("Last") + Msg.translate(wsc.ctx, "Last") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='Last';WForm.submit();\"" + LN);
            sb.append("   }], [{" + LN);
            sb.append("      text : \"" + WWindow.getImage16("ZoomAcross") + Msg.translate(wsc.ctx, "ZoomAcross") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='ZoomAcross';WForm.submit();\"" + LN);
            sb.append("   }, {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("Request") + Msg.translate(wsc.ctx, "Request") + "\"," + LN);
            sb.append("      url : \"javascript:mopen('rl_C_Order_ID');\"" + LN);
            sb.append("   } ]]");
        }
        sb.append("}, {" + LN);
        sb.append("   id : \"Tools\"," + LN);
        sb.append("   itemdata : [");
        sb.append("   [{" + LN);
        sb.append("      text : \"" + WWindow.getImage16("Calculator") + Msg.translate(wsc.ctx, "Calculator") + "\"," + LN);
        sb.append("      url : \"javascript:TCR.TCRPopup('');\"" + LN);
        sb.append("   }, {" + LN);
        sb.append("      text : \"" + WWindow.getImage16("Calendar") + Msg.translate(wsc.ctx, "Calendar") + "\"," + LN);
        sb.append("      url : \"javascript:openCalendar();\"" + LN);
        if (AmpiereUtil.isWorkflowProcess(wsc.ctx)) {
            int tableId = 0;
            int recordId = 0;
            if (ws != null) {
                tableId = ws.curTab.getAD_Table_ID();
                recordId = ws.curTab.getRecord_ID();
            }
            String url = "WWindow?windowId=297&WorkFlowQuery=1&AD_Table_ID=" + tableId + "&Record_ID=" + recordId;
            sb.append("   }, {" + LN);
            sb.append("      text : \"" + WWindow.getImage16("WorkFlow") + Msg.translate(wsc.ctx, "WorkFlow") + "\"," + LN);
            sb.append("      url : \"javascript:startPopup('" + url + "');\"" + LN);
        }
        if (MRole.getDefault(wsc.ctx, false).isShowPreference()) {
            sb.append("   }], [{" + LN);
            StringBuffer parameter = new StringBuffer();
            parameter.append("channelmode=no,");
            parameter.append("directories=no,");
            parameter.append("fullscreen=no,");
            parameter.append("location=no,");
            parameter.append("menubar=no,");
            parameter.append("resizable=no,");
            parameter.append("scrollbars=no,");
            parameter.append("status=no,");
            parameter.append("titlebar=no,");
            parameter.append("toolbar=no");
            sb.append("      text : \"" + WWindow.getImage16("Preference") + Msg.translate(wsc.ctx, "Preference") + "\"," + LN);
            sb.append("      url : \"javascript:openWindow('WToolsPreference','" + Msg.translate(wsc.ctx, "Preference") + "','" + parameter.toString() + "'," + 680 + "," + 520 + ");\"" + LN);
        }
        sb.append("   } ]");
        sb.append("   ]" + LN);
        sb.append("}, {" + LN);
        sb.append("   id : \"Helps\"," + LN);
        sb.append("   itemdata : [ {" + LN);
        if (ws != null) {
            sb.append("      text : \"" + WWindow.getImage16("Help") + Msg.translate(wsc.ctx, "Help") + "\"," + LN);
            sb.append("      url : \"javascript:document.WForm.PCommand.value='Help';startPopup('WHelp?AD_Window_ID=" + ws.mWindow.getAD_Window_ID() + "');\"" + LN);
            sb.append("   }, {" + LN);
        }
        sb.append("      text : \"" + WWindow.getImage16("Online") + Msg.translate(wsc.ctx, "Online") + "\"," + LN);
        sb.append("      url : \"http://www.compiere-japan.com/\"," + LN);
        sb.append("      target: \"_blank\"" + LN);
        sb.append("   }, {" + LN);
        StringBuffer parameter = new StringBuffer();
        parameter.append("channelmode=no,");
        parameter.append("directories=no,");
        parameter.append("fullscreen=no,");
        parameter.append("location=no,");
        parameter.append("menubar=no,");
        parameter.append("resizable=no,");
        parameter.append("scrollbars=no,");
        parameter.append("status=no,");
        parameter.append("titlebar=no,");
        parameter.append("toolbar=no");
        sb.append("      text : \"" + WWindow.getImage16("EMailSupport") + Msg.translate(wsc.ctx, "EMailSupport") + "\"," + LN);
        sb.append("      url : \"javascript:openWindow('WEMail?emailType=emailTypeSupport','" + Msg.translate(wsc.ctx, "EMailSupport") + "','" + parameter.toString() + "'," + 600 + "," + 500 + ");\"" + LN);
        sb.append("   }, {" + LN);
        parameter = new StringBuffer();
        parameter.append("channelmode=no,");
        parameter.append("directories=no,");
        parameter.append("fullscreen=no,");
        parameter.append("location=no,");
        parameter.append("menubar=no,");
        parameter.append("resizable=no,");
        parameter.append("scrollbars=no,");
        parameter.append("status=no,");
        parameter.append("titlebar=no,");
        parameter.append("toolbar=no");
        sb.append("      text : \"" + WWindow.getImage16("About") + Msg.translate(wsc.ctx, "About") + "\"," + LN);
        sb.append("      url : \"javascript:openWindow('WAbout','" + Msg.translate(wsc.ctx, "About") + "','" + parameter.toString() + "'," + 420 + "," + 580 + ");\"" + LN);
        sb.append("   } ]" + LN);
        sb.append("} ];" + LN);
        sb.append("oMenuBar.subscribe(\"beforeRender\", function() {" + LN);
        sb.append("   if (this.getRoot() == this) {" + LN);
        sb.append("      this.getItem(0).cfg.setProperty(\"submenu\", aSubmenuData[0]);" + LN);
        sb.append("      this.getItem(1).cfg.setProperty(\"submenu\", aSubmenuData[1]);" + LN);
        sb.append("      this.getItem(2).cfg.setProperty(\"submenu\", aSubmenuData[2]);" + LN);
        sb.append("      this.getItem(3).cfg.setProperty(\"submenu\", aSubmenuData[3]);" + LN);
        if (ws != null) {
            sb.append("      this.getItem(4).cfg.setProperty(\"submenu\", aSubmenuData[4]);" + LN);
            sb.append("      this.getItem(5).cfg.setProperty(\"submenu\", aSubmenuData[5]);" + LN);
        }
        sb.append("   }" + LN);
        sb.append("});" + LN);
        sb.append("oMenuBar.render();" + LN);
        sb.append("}" + LN);
        return sb.toString();
    }

    private static String getImage16(String name) {
        return "<img src='" + WebEnv.getImageDirectory(name + "16.png") + "'> ";
    }

    public static div createMenuDiv(WebSessionCtx wsc, WWindowStatus ws) {
        div menuFrameDiv = new div();
        menuFrameDiv.setID("menuFrame");
        menuFrameDiv.setClass("yui-skin-sam");
        div menuDiv = new div();
        menuDiv.setID("menuBar");
        menuDiv.setClass("yuimenubar yuimenubarnav");
        menuFrameDiv.addElement((org.apache.ecs.Element)menuDiv);
        div bdDiv = new div();
        bdDiv.setClass("bd");
        menuDiv.addElement((org.apache.ecs.Element)bdDiv);
        ul menuBarUl = new ul();
        menuBarUl.setClass("first-of-type");
        bdDiv.addElement((org.apache.ecs.Element)menuBarUl);
        li menuItem = new li();
        menuItem.setClass("yuimenubaritem first-of-type");
        menuItem.addElement((org.apache.ecs.Element)((a)new a("#", Msg.translate(wsc.ctx, "File")).setClass("yuimenubaritemlabel")));
        menuBarUl.addElement((org.apache.ecs.Element)menuItem);
        if (ws != null) {
            menuItem = new li();
            menuItem.setClass("yuimenubaritem");
            menuItem.addElement((org.apache.ecs.Element)((a)new a("#", Msg.translate(wsc.ctx, "Edit")).setClass("yuimenubaritemlabel")));
            menuBarUl.addElement((org.apache.ecs.Element)menuItem);
        }
        menuItem = new li();
        menuItem.setClass("yuimenubaritem");
        menuItem.addElement((org.apache.ecs.Element)((a)new a("#", Msg.translate(wsc.ctx, "View")).setClass("yuimenubaritemlabel")));
        menuBarUl.addElement((org.apache.ecs.Element)menuItem);
        if (ws != null) {
            menuItem = new li();
            menuItem.setClass("yuimenubaritem");
            menuItem.addElement((org.apache.ecs.Element)((a)new a("#", Msg.translate(wsc.ctx, "Go")).setClass("yuimenubaritemlabel")));
            menuBarUl.addElement((org.apache.ecs.Element)menuItem);
        }
        menuItem = new li();
        menuItem.setClass("yuimenubaritem");
        menuItem.addElement((org.apache.ecs.Element)((a)new a("#", Msg.translate(wsc.ctx, "Tools")).setClass("yuimenubaritemlabel")));
        menuBarUl.addElement((org.apache.ecs.Element)menuItem);
        menuItem = new li();
        menuItem.setClass("yuimenubaritem");
        menuItem.addElement((org.apache.ecs.Element)((a)new a("#", Msg.translate(wsc.ctx, "Help")).setClass("yuimenubaritemlabel")));
        menuBarUl.addElement((org.apache.ecs.Element)menuItem);
        return menuFrameDiv;
    }
}

