/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.AllocationForm;
import com.jware.util.StringToIntConverter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.framework.Lookup;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrderLine;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.NamePair;
import org.compiere.util.TimeUtil;
import org.compiere.util.Trx;
import org.compiere.util.WebSessionCtx;

public class AllocationAction
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String MATCHING_LIST = "matchinglist";
    private static final String ACTION_FORM = "MatchingForm";
    private static final String ERROR_FORWARD = "error";
    private static final int MATCH_INVOICE = 0;
    private static final int MATCH_SHIPMENT = 1;
    private static final int MATCH_ORDER = 2;
    private static final String CALCULATE_ACTION = "1";
    private static final String MATCH_FROM_DATA_LIST = "MATCH_FROM_DATA_LIST";
    private static final String MATCH_TO_DATA_LIST = "MATCH_TO_DATA_LIST";
    private static final String ALLOCATE_DATE = "ALLOCATE_DATE";
    private StringBuffer m_sql = null;
    private String m_dateColumn = "";
    private String m_qtyColumn = "";
    private String m_groupBy = "";

    public final ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        ActionForward actionForward = mapping.findForward(MATCHING_LIST);
        AllocationForm myForm = (AllocationForm)form2;
        String actionType = request.getParameter("actionType");
        if (CALCULATE_ACTION.equals(actionType)) {
            String[] response_array = new String[8];
            String column = myForm.getChangedColumn();
            if (column.indexOf("payment") >= 0) {
                int index = StringToIntConverter.StringToInt(column.replace("payment", ""));
                AllocationAction.selectUnselectPayment(request, myForm, index, response_array);
            } else if (column.indexOf("invoice") >= 0) {
                int index = StringToIntConverter.StringToInt(column.replace("invoice", ""));
                AllocationAction.selectUnselectInvoice(request, myForm, index, response_array);
            } else if (column.indexOf("invoice") >= 0) {
                boolean index = true;
            }
            this.calculate(myForm, request, response, response_array);
            AllocationAction.setResponse(response, response_array);
            return null;
        }
        String column = myForm.getChangedColumn();
        if (column.equals("currency")) {
            this.search(wsc, myForm);
            this.searchTo(wsc, myForm);
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("businessPartnerName")) {
            MLookup lookup = null;
            try {
                lookup = MLookupFactory.get(wsc.ctx, 0, 3499, 19, wsc.language, "C_BPartner_ID", 0, false, "UPPER(NAME) LIKE '" + myForm.getBusinessPartnerName().toUpperCase() + "%' ");
                Iterator<NamePair> keyNames = ((Lookup)lookup).getData(true, false, true, false).iterator();
                if (keyNames.hasNext()) {
                    KeyNamePair keyName = (KeyNamePair)keyNames.next();
                    myForm.setBusinessPartnerId(keyName.getKey());
                    myForm.setBusinessPartnerName(keyName.getName());
                } else {
                    myForm.setBusinessPartnerId(999999999);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "MLookupFactory.get AD_Column_ID=3499", e);
            }
            this.search(wsc, myForm);
            this.searchTo(wsc, myForm);
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("search")) {
            myForm.setMatchFromCurrentId(0);
            myForm.setMatchToIdList(null);
            myForm.setMatchFromCurrentBusinessPartnerId(-1);
            this.search(wsc, myForm);
            this.searchTo(wsc, myForm);
            actionForward = mapping.findForward(MATCHING_LIST);
        } else if (column.equals("process")) {
            this.saveData(request, myForm);
            this.search(wsc, myForm);
            this.searchTo(wsc, myForm);
            actionForward = mapping.findForward(MATCHING_LIST);
        } else {
            this.search(wsc, myForm);
            this.searchTo(wsc, myForm);
        }
        myForm.setChangedColumn(null);
        myForm.setMatchFromIdList(null);
        myForm.setMatchToIdList(null);
        myForm.setMatchDifferenceCount("0.0");
        request.setAttribute(ACTION_FORM, (Object)myForm);
        session.setAttribute(MATCH_FROM_DATA_LIST, (Object)myForm.getMatchFromDataList());
        session.setAttribute(MATCH_TO_DATA_LIST, (Object)myForm.getMatchToDataList());
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return actionForward;
    }

    private void search(WebSessionCtx wsc, AllocationForm form2) {
        int m_C_Currency_ID = StringToIntConverter.StringToInt(form2.getCurrency());
        int m_C_BPartner_ID = form2.getBusinessPartnerId();
        int AD_Role_ID = wsc.ctx.getAD_Role_ID();
        int AD_User_ID = wsc.ctx.getAD_User_ID();
        MRole role = MRole.get(wsc.ctx, AD_Role_ID, AD_User_ID, false);
        boolean isMultiCurrencySelected = "on".equals(form2.getMultiCurrency());
        int index = 1;
        ArrayList dataList = new ArrayList();
        HashMap<String, Object> data = new HashMap<String, Object>();
        int count = 0;
        StringBuffer sql = new StringBuffer("SELECT p.DateTrx,p.DocumentNo,p.C_Payment_ID,c.ISO_Code,p.PayAmt,currencyConvert(p.PayAmt,p.C_Currency_ID," + m_C_Currency_ID + ",p.DateTrx,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID)," + "currencyConvert(paymentAvailable(C_Payment_ID),p.C_Currency_ID," + m_C_Currency_ID + ",p.DateTrx,p.C_ConversionType_ID,p.AD_Client_ID,p.AD_Org_ID)," + "p.MultiplierAP " + "FROM C_Payment_v p" + " INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID) " + "WHERE p.IsAllocated='N' AND p.Processed='Y'" + " AND p.C_Charge_ID IS NULL" + " AND p.C_BPartner_ID=?");
        if (!isMultiCurrencySelected) {
            sql.append(" AND p.C_Currency_ID=?");
        }
        sql.append(" ORDER BY p.DateTrx,p.DocumentNo");
        sql = new StringBuffer(role.addAccessSQL(sql.toString(), "p", true, false));
        this.log.fine("PaySQL=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, m_C_BPartner_ID);
            if (!isMultiCurrencySelected) {
                pstmt.setInt(2, m_C_Currency_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (++count != 1 || form2.getMatchFromCurrentId() <= 0) {
                    // empty if block
                }
                data = new HashMap();
                if (count % 2 == 0) {
                    data.put("RowType", "even");
                } else {
                    data.put("RowType", "odd");
                }
                data.put("ID", index);
                ++index;
                data.put("Date", wsc.dateFormat.format(rs.getTimestamp(1)));
                data.put("DocumentNo", rs.getString(2));
                data.put("PaymentID", rs.getString(3));
                if (isMultiCurrencySelected) {
                    data.put("TrxCurrency", rs.getString(4));
                    data.put("Amount", rs.getBigDecimal(5));
                }
                data.put("ConvertedAmount", rs.getBigDecimal(6));
                BigDecimal available = rs.getBigDecimal(7);
                if (available == null || available.signum() == 0) continue;
                data.put("OpenAmt", available);
                data.put("AppliedAmt", Env.ZERO);
                dataList.add(data);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        form2.setMatchFromDataList(dataList);
    }

    private void searchTo(WebSessionCtx wsc, AllocationForm form2) {
        int m_C_Currency_ID = StringToIntConverter.StringToInt(form2.getCurrency());
        int m_C_BPartner_ID = form2.getBusinessPartnerId();
        int AD_Role_ID = wsc.ctx.getAD_Role_ID();
        int AD_User_ID = wsc.ctx.getAD_User_ID();
        MRole role = MRole.get(wsc.ctx, AD_Role_ID, AD_User_ID, false);
        boolean isMultiCurrencySelected = "on".equals(form2.getMultiCurrency());
        int index = 1;
        ArrayList dataList = new ArrayList();
        HashMap<String, Object> data = new HashMap<String, Object>();
        int count = 0;
        Timestamp date = null;
        if (!StringUtils.isEmpty(form2.getDate())) {
            try {
                try {
                    date = new Timestamp(wsc.dateFormat.parse(form2.getDate()).getTime());
                }
                catch (Exception e) {
                    date = null;
                }
            }
            catch (Exception e) {}
        } else {
            date = new Timestamp(new Date().getTime());
        }
        StringBuffer sql = new StringBuffer("SELECT i.DateInvoiced,i.DocumentNo,i.C_Invoice_ID,c.ISO_Code,i.GrandTotal*i.MultiplierAP, currencyConvert(i.GrandTotal*i.MultiplierAP,i.C_Currency_ID," + m_C_Currency_ID + ",i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID), " + "currencyConvert(invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),i.C_Currency_ID," + m_C_Currency_ID + ",i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.MultiplierAP, " + "currencyConvert(invoiceDiscount" + "(i.C_Invoice_ID," + DB.TO_DATE(date) + ",C_InvoicePaySchedule_ID),i.C_Currency_ID," + m_C_Currency_ID + ",i.DateInvoiced,i.C_ConversionType_ID,i.AD_Client_ID,i.AD_Org_ID)*i.Multiplier*i.MultiplierAP," + "i.MultiplierAP " + "FROM C_Invoice_v i" + " INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID) " + "WHERE i.IsPaid='N' AND i.Processed='Y'" + " AND i.C_BPartner_ID=?");
        if (!isMultiCurrencySelected) {
            sql.append(" AND i.C_Currency_ID=?");
        }
        sql.append(" ORDER BY i.DateInvoiced, i.DocumentNo");
        sql = new StringBuffer(role.addAccessSQL(sql.toString(), "i", true, false));
        this.log.fine("InvSQL=" + sql.toString());
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setInt(1, m_C_BPartner_ID);
            if (!isMultiCurrencySelected) {
                pstmt.setInt(2, m_C_Currency_ID);
            }
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                data = new HashMap();
                if (++count % 2 == 0) {
                    data.put("RowType", "even");
                } else {
                    data.put("RowType", "odd");
                }
                data.put("ID", index);
                ++index;
                data.put("Date", rs.getTimestamp(1));
                data.put("DocumentNo", rs.getString(2));
                data.put("InvoiceID", rs.getString(3));
                if (isMultiCurrencySelected) {
                    data.put("TrxCurrency", rs.getString(4));
                    data.put("Amount", rs.getBigDecimal(5));
                }
                data.put("ConvertedAmount", rs.getBigDecimal(6));
                BigDecimal open = rs.getBigDecimal(7);
                if (open == null) {
                    open = Env.ZERO;
                }
                data.put("OpenAmt", open);
                BigDecimal discount = rs.getBigDecimal(8);
                if (discount == null) {
                    discount = Env.ZERO;
                }
                data.put("Discount", discount);
                data.put("WriteOff", Env.ZERO);
                data.put("AppliedAmt", Env.ZERO);
                if (Env.ZERO.compareTo(open) == 0) continue;
                dataList.add(data);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        form2.setMatchToDataList(dataList);
    }

    private boolean createMatchRecord(WebSessionCtx wsc, boolean invoice, int M_InOutLine_ID, int Line_ID, BigDecimal qty) {
        if (qty.compareTo(Env.ZERO) == 0) {
            return true;
        }
        this.log.fine("IsInvoice=" + invoice + ", M_InOutLine_ID=" + M_InOutLine_ID + ", Line_ID=" + Line_ID + ", Qty=" + qty);
        boolean success = false;
        MInOutLine sLine = new MInOutLine(wsc.ctx, M_InOutLine_ID, null);
        if (invoice) {
            MInvoiceLine iLine = new MInvoiceLine(wsc.ctx, Line_ID, null);
            iLine.setM_InOutLine_ID(M_InOutLine_ID);
            if (sLine.getC_OrderLine_ID() != 0) {
                iLine.setC_OrderLine_ID(sLine.getC_OrderLine_ID());
            }
            iLine.save();
            if (iLine.getM_Product_ID() != 0) {
                MMatchInv match = new MMatchInv(iLine, null, qty);
                match.setM_InOutLine_ID(M_InOutLine_ID);
                if (match.save()) {
                    success = true;
                } else {
                    this.log.log(Level.SEVERE, "Inv Match not created: " + match);
                }
            } else {
                success = true;
            }
            if (iLine.getC_OrderLine_ID() != 0 && iLine.getM_Product_ID() != 0) {
                MMatchPO matchPO = MMatchPO.create(iLine, sLine, null, qty);
                matchPO.setC_InvoiceLine_ID(iLine);
                matchPO.setM_InOutLine_ID(M_InOutLine_ID);
                if (!matchPO.save()) {
                    this.log.log(Level.SEVERE, "PO(Inv) Match not created: " + matchPO);
                }
            }
        } else {
            sLine.setC_OrderLine_ID(Line_ID);
            sLine.save();
            MOrderLine oLine = new MOrderLine(wsc.ctx, Line_ID, null);
            if (oLine.get_ID() != 0) {
                oLine.setQtyReserved(oLine.getQtyReserved().subtract(qty));
                if (!oLine.save()) {
                    this.log.severe("QtyReserved not updated - C_OrderLine_ID=" + Line_ID);
                }
            }
            if (sLine.getM_Product_ID() != 0) {
                MMatchPO match = new MMatchPO(sLine, null, qty);
                if (!match.save()) {
                    this.log.log(Level.SEVERE, "PO Match not created: " + match);
                } else {
                    success = true;
                    if (sLine.getProduct() != null && sLine.getProduct().isStocked()) {
                        success = MStorage.add(wsc.ctx, sLine.getM_Warehouse_ID(), sLine.getM_Locator_ID(), sLine.getM_Product_ID(), sLine.getM_AttributeSetInstance_ID(), oLine.getM_AttributeSetInstance_ID(), null, null, qty.negate(), null);
                    }
                }
            } else {
                success = true;
            }
        }
        return success;
    }

    private void calculate(AllocationForm myForm, HttpServletRequest request, HttpServletResponse response, String[] response_array) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        DecimalFormat format = DisplayType.getNumberFormat(12);
        Timestamp allocDate = null;
        ArrayList paymentList = (ArrayList)session.getAttribute(MATCH_FROM_DATA_LIST);
        ArrayList invoiceList = (ArrayList)session.getAttribute(MATCH_TO_DATA_LIST);
        String[] selectedPaymentIds = myForm.getMatchFromIdList();
        String[] selectedInvoiceIds = myForm.getMatchToIdList();
        HashMap currentPayment = (HashMap)paymentList.get(0);
        HashMap currentInvoice = (HashMap)invoiceList.get(0);
        boolean multiCurrency = false;
        if ("on".equals(myForm.getMultiCurrency())) {
            multiCurrency = true;
        }
        BigDecimal totalPay = new BigDecimal(0.0);
        int rows = 0;
        if (myForm.getMatchFromIdList() != null) {
            rows = myForm.getMatchFromIdList().length;
        }
        int m_noPayments = 0;
        for (int i2 = 0; i2 < rows; ++i2) {
            String index = selectedPaymentIds[i2];
            currentPayment = (HashMap)paymentList.get(StringToIntConverter.StringToInt(index));
            Timestamp ts = null;
            try {
                ts = new Timestamp(wsc.dateFormat.parse(currentPayment.get("Date").toString()).getTime());
            }
            catch (Exception e) {
                // empty catch block
            }
            allocDate = TimeUtil.max(allocDate, ts);
            BigDecimal bd = BigDecimal.valueOf(0L);
            bd = (BigDecimal)currentPayment.get("OpenAmt");
            totalPay = totalPay.add(bd);
            ++m_noPayments;
        }
        BigDecimal totalInv = new BigDecimal(0.0);
        rows = 0;
        if (myForm.getMatchToIdList() != null) {
            rows = myForm.getMatchToIdList().length;
        }
        int m_noInvoices = 0;
        for (int i3 = 0; i3 < rows; ++i3) {
            String index = selectedInvoiceIds[i3];
            currentInvoice = (HashMap)invoiceList.get(StringToIntConverter.StringToInt(index));
            Timestamp ts = null;
            try {
                ts = new Timestamp(wsc.dateFormat.parse(currentPayment.get("Date").toString()).getTime());
            }
            catch (Exception e) {
                // empty catch block
            }
            allocDate = TimeUtil.max(allocDate, ts);
            BigDecimal bd = (BigDecimal)currentInvoice.get("OpenAmt");
            totalInv = totalInv.add(bd);
            ++m_noInvoices;
        }
        if (allocDate != null) {
            session.setAttribute(ALLOCATE_DATE, (Object)allocDate);
        }
        BigDecimal difference = totalPay.subtract(totalInv);
        String enableAllocateButton = "";
        enableAllocateButton = difference.compareTo(new BigDecimal(0.0)) == 0 ? CALCULATE_ACTION : "0";
        if (selectedPaymentIds == null && selectedInvoiceIds == null) {
            enableAllocateButton = "0";
        }
        response_array[0] = enableAllocateButton;
        response_array[1] = difference.toString();
        response_array[2] = String.valueOf(m_noPayments) + " - " + Msg.getMsg(wsc.ctx, "Sum") + "  " + format.format(totalPay) + " ";
        response_array[3] = String.valueOf(m_noInvoices) + " - " + Msg.getMsg(wsc.ctx, "Sum") + "  " + format.format(totalInv) + " ";
    }

    private void saveData(HttpServletRequest request, AllocationForm myForm) {
        int C_Invoice_ID;
        HashMap currentInvoice;
        String index;
        int i2;
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        ArrayList paymentListAll = (ArrayList)session.getAttribute(MATCH_FROM_DATA_LIST);
        ArrayList invoiceListAll = (ArrayList)session.getAttribute(MATCH_TO_DATA_LIST);
        String[] selectedPaymentIds = myForm.getMatchFromIdList();
        String[] selectedInvoiceIds = myForm.getMatchToIdList();
        int m_noPayments = 0;
        int m_noInvoices = 0;
        if (selectedPaymentIds != null) {
            m_noPayments += selectedPaymentIds.length;
        }
        if (selectedInvoiceIds != null) {
            m_noInvoices += selectedInvoiceIds.length;
        }
        int AD_Client_ID = wsc.ctx.getAD_Client_ID();
        int AD_Org_ID = wsc.ctx.getAD_Org_ID();
        int C_BPartner_ID = myForm.getBusinessPartnerId();
        int C_Order_ID = 0;
        int C_CashLine_ID = 0;
        Timestamp DateTrx = (Timestamp)session.getAttribute(ALLOCATE_DATE);
        int C_Currency_ID = StringToIntConverter.StringToInt(myForm.getCurrency());
        if (AD_Org_ID == 0) {
            Ctx ctx = wsc.ctx;
            StringBuffer out = new StringBuffer();
            String AD_Message = "Org0NotAllowed";
            if (AD_Message != null && !AD_Message.equals("")) {
                out.append(Msg.getMsg(ctx, AD_Message));
            }
            request.setAttribute("warningInfo", (Object)out.toString());
            return;
        }
        this.log.config("Client=" + AD_Client_ID + ", Org=" + AD_Org_ID + ", BPartner=" + C_BPartner_ID + ", Date=" + DateTrx);
        Trx trx = Trx.get(Trx.createTrxName("AL"), true);
        ArrayList<Integer> paymentList = new ArrayList<Integer>(m_noPayments);
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(m_noPayments);
        BigDecimal paymentAppliedAmt = Env.ZERO;
        for (int i3 = 0; i3 < m_noPayments; ++i3) {
            String index2 = selectedPaymentIds[i3];
            HashMap currentPayment = (HashMap)paymentListAll.get(StringToIntConverter.StringToInt(index2));
            Integer C_Payment_ID = StringToIntConverter.StringToInt((String)currentPayment.get("PaymentID"));
            paymentList.add(C_Payment_ID);
            BigDecimal PaymentAmt = (BigDecimal)currentPayment.get("AppliedAmt");
            amountList.add(PaymentAmt);
            paymentAppliedAmt = paymentAppliedAmt.add(PaymentAmt);
            this.log.fine("C_Payment_ID=" + C_Payment_ID + " - PaymentAmt=" + PaymentAmt);
        }
        int iRows = selectedInvoiceIds.length;
        BigDecimal totalAppliedAmt = Env.ZERO;
        MAllocationHdr alloc = new MAllocationHdr(wsc.ctx, true, DateTrx, C_Currency_ID, wsc.ctx.getContext("#AD_User_Name"), trx.getTrxName());
        alloc.setAD_Org_ID(AD_Org_ID);
        int invoiceLines = 0;
        for (i2 = 0; i2 < iRows; ++i2) {
            index = selectedInvoiceIds[i2];
            currentInvoice = (HashMap)invoiceListAll.get(StringToIntConverter.StringToInt(index));
            ++invoiceLines;
            C_Invoice_ID = StringToIntConverter.StringToInt((String)currentInvoice.get("InvoiceID"));
            BigDecimal AppliedAmt = (BigDecimal)currentInvoice.get("AppliedAmt");
            BigDecimal DiscountAmt = (BigDecimal)currentInvoice.get("Discount");
            BigDecimal WriteOffAmt = (BigDecimal)currentInvoice.get("WriteOff");
            BigDecimal OverUnderAmt = ((BigDecimal)currentInvoice.get("OpenAmt")).subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
            this.log.config("Invoice #" + i2 + " - AppliedAmt=" + AppliedAmt);
            int noPayments = 0;
            for (int j = 0; j < paymentList.size() && AppliedAmt.signum() != 0; ++j) {
                int C_Payment_ID = (Integer)paymentList.get(j);
                BigDecimal PaymentAmt = (BigDecimal)amountList.get(j);
                if (PaymentAmt.signum() == 0) continue;
                this.log.config(".. with payment #" + j + ", Amt=" + PaymentAmt);
                ++noPayments;
                BigDecimal amount = AppliedAmt;
                this.log.fine("C_Payment_ID=" + C_Payment_ID + ", C_Invoice_ID=" + C_Invoice_ID + ", Amount=" + amount + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt);
                if (alloc.get_ID() == 0 && !alloc.save()) {
                    this.log.log(Level.SEVERE, "Allocation not created");
                    return;
                }
                MAllocationLine aLine = new MAllocationLine(alloc, amount, DiscountAmt, WriteOffAmt, OverUnderAmt);
                aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                if (!aLine.save()) {
                    this.log.log(Level.SEVERE, "Allocation Line not written - Invoice=" + C_Invoice_ID);
                }
                DiscountAmt = Env.ZERO;
                WriteOffAmt = Env.ZERO;
                AppliedAmt = AppliedAmt.subtract(amount);
                PaymentAmt = PaymentAmt.subtract(amount);
                this.log.fine("Allocation Amount=" + amount + " - Remaining  Applied=" + AppliedAmt + ", Payment=" + PaymentAmt);
                amountList.set(j, PaymentAmt);
            }
            if (noPayments == 0 && paymentList.size() == 0) {
                int C_Payment_ID = 0;
                this.log.config(" ... no payment - TotalApplied=" + totalAppliedAmt);
                this.log.fine("C_Payment_ID=" + C_Payment_ID + ", C_Invoice_ID=" + C_Invoice_ID + ", Amount=" + AppliedAmt + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt);
                if (alloc.get_ID() == 0 && !alloc.save()) {
                    this.log.log(Level.SEVERE, "Allocation not created");
                    return;
                }
                MAllocationLine aLine = new MAllocationLine(alloc, AppliedAmt, DiscountAmt, WriteOffAmt, OverUnderAmt);
                aLine.setDocInfo(C_BPartner_ID, C_Order_ID, C_Invoice_ID);
                aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                if (!aLine.save(trx.getTrxName())) {
                    this.log.log(Level.SEVERE, "Allocation Line not written - Invoice=" + C_Invoice_ID);
                }
                this.log.fine("Allocation Amount=" + AppliedAmt);
            }
            totalAppliedAmt = totalAppliedAmt.add(AppliedAmt);
            this.log.config("TotalRemaining=" + totalAppliedAmt);
        }
        if (invoiceLines == 0 && paymentList.size() > 0 && paymentAppliedAmt.signum() == 0) {
            for (i2 = 0; i2 < paymentList.size(); ++i2) {
                int C_Payment_ID = (Integer)paymentList.get(i2);
                BigDecimal PaymentAmt = (BigDecimal)amountList.get(i2);
                this.log.fine("Payment=" + C_Payment_ID + ", Amount=" + PaymentAmt);
                if (alloc.get_ID() == 0 && !alloc.save()) {
                    this.log.log(Level.SEVERE, "Allocation not created");
                    return;
                }
                MAllocationLine aLine = new MAllocationLine(alloc, PaymentAmt, Env.ZERO, Env.ZERO, Env.ZERO);
                aLine.setDocInfo(C_BPartner_ID, 0, 0);
                aLine.setPaymentInfo(C_Payment_ID, 0);
                if (aLine.save(trx.getTrxName())) continue;
                this.log.log(Level.SEVERE, "Allocation Line not saved - Payment=" + C_Payment_ID);
            }
        }
        if (totalAppliedAmt.signum() != 0) {
            this.log.log(Level.SEVERE, "Remaining TotalAppliedAmt=" + totalAppliedAmt);
        }
        if (alloc.get_ID() != 0) {
            alloc.processIt("CO");
            alloc.save();
        }
        for (i2 = 0; i2 < iRows; ++i2) {
            index = selectedInvoiceIds[i2];
            currentInvoice = (HashMap)invoiceListAll.get(StringToIntConverter.StringToInt(index));
            ++invoiceLines;
            C_Invoice_ID = StringToIntConverter.StringToInt((String)currentInvoice.get("InvoiceID"));
            String sql = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
            BigDecimal open = DB.getSQLValueBD(trx.getTrxName(), sql, C_Invoice_ID);
            if (open != null && open.signum() == 0) {
                sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
                int no = DB.executeUpdate(sql, trx.getTrxName());
                this.log.config("Invoice #" + i2 + " is paid");
                continue;
            }
            this.log.config("Invoice #" + i2 + " is not paid - " + open);
        }
        for (i2 = 0; i2 < paymentList.size(); ++i2) {
            int C_Payment_ID = (Integer)paymentList.get(i2);
            MPayment pay = new MPayment(wsc.ctx, C_Payment_ID, trx.getTrxName());
            if (pay.testAllocation()) {
                pay.save();
            }
            this.log.config("Payment #" + i2 + (pay.isAllocated() ? " not" : " is") + " fully allocated");
        }
        paymentList.clear();
        amountList.clear();
        trx.commit();
        trx.close();
    }

    public static void setResponse(HttpServletResponse response, String[] response_array) {
        response.addHeader("pragma", "no-store,no-cache");
        response.addHeader("cache-control", "no-cache, no-store,must-revalidate, max-age=-1");
        response.addHeader("expires", "-1");
        try {
            response.getOutputStream().print(AllocationAction.generateResponseText(response_array));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String generateResponseText(String[] arr) throws UnsupportedEncodingException {
        String resp_arr = "";
        String split_arr = "**";
        for (int i2 = 0; i2 < arr.length; ++i2) {
            if (i2 != 0) {
                resp_arr = resp_arr + "**";
            }
            if (StringUtils.isEmpty(arr[i2])) continue;
            resp_arr = resp_arr + arr[i2];
        }
        return URLEncoder.encode(resp_arr, "UTF-8");
    }

    public static void selectUnselectPayment(HttpServletRequest request, AllocationForm myForm, int index, String[] response_array) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        ArrayList paymentListAll = (ArrayList)session.getAttribute(MATCH_FROM_DATA_LIST);
        String[] selectedPaymentIds = myForm.getMatchFromIdList();
        HashMap currentPayment = (HashMap)paymentListAll.get(index);
        boolean isSelected = false;
        if (selectedPaymentIds != null) {
            for (int i2 = 0; i2 < selectedPaymentIds.length; ++i2) {
                if (!String.valueOf(index).equals(selectedPaymentIds[i2])) continue;
                isSelected = true;
                break;
            }
        }
        if (isSelected) {
            BigDecimal amount = (BigDecimal)currentPayment.get("OpenAmt");
            currentPayment.put("AppliedAmt", amount);
        } else {
            currentPayment.put("AppliedAmt", Env.ZERO);
        }
        response_array[4] = "paymentAppliedAmt" + index + "," + (BigDecimal)currentPayment.get("AppliedAmt");
    }

    public static void selectUnselectInvoice(HttpServletRequest request, AllocationForm myForm, int index, String[] response_array) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        ArrayList invoiceListAll = (ArrayList)session.getAttribute(MATCH_TO_DATA_LIST);
        String[] selectedInvoiceIds = myForm.getMatchToIdList();
        HashMap currentInvoice = (HashMap)invoiceListAll.get(index);
        boolean isSelected = false;
        if (selectedInvoiceIds != null) {
            for (int i2 = 0; i2 < selectedInvoiceIds.length; ++i2) {
                if (!String.valueOf(index).equals(selectedInvoiceIds[i2])) continue;
                isSelected = true;
                break;
            }
        }
        if (isSelected) {
            BigDecimal amount = (BigDecimal)currentInvoice.get("OpenAmt");
            amount = amount.subtract((BigDecimal)currentInvoice.get("Discount"));
            currentInvoice.put("WriteOff", Env.ZERO);
            currentInvoice.put("AppliedAmt", amount);
        } else {
            currentInvoice.put("WriteOff", Env.ZERO);
            currentInvoice.put("AppliedAmt", Env.ZERO);
        }
        response_array[5] = "invoiceDiscount" + index + "," + (BigDecimal)currentInvoice.get("Discount");
        response_array[6] = "invoiceWriteOff" + index + "," + (BigDecimal)currentInvoice.get("WriteOff");
        response_array[7] = "invoiceAppliedAmt" + index + "," + (BigDecimal)currentInvoice.get("AppliedAmt");
    }

    public static void autoWriteOff(HttpServletRequest request, AllocationForm myForm, int index, String[] response_array) {
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        ArrayList invoiceListAll = (ArrayList)session.getAttribute(MATCH_TO_DATA_LIST);
        String[] selectedInvoiceIds = myForm.getMatchToIdList();
        HashMap currentInvoice = (HashMap)invoiceListAll.get(index);
        boolean isSelected = false;
        if (selectedInvoiceIds != null) {
            for (int i2 = 0; i2 < selectedInvoiceIds.length; ++i2) {
                if (!String.valueOf(index).equals(selectedInvoiceIds[i2])) continue;
                isSelected = true;
                break;
            }
        }
        response_array[5] = "invoiceDiscount" + index + "," + (BigDecimal)currentInvoice.get("Discount");
        response_array[6] = "invoiceWriteOff" + index + "," + (BigDecimal)currentInvoice.get("WriteOff");
        response_array[7] = "invoiceAppliedAmt" + index + "," + (BigDecimal)currentInvoice.get("AppliedAmt");
    }
}

