/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.struts.form.ArchiveViewForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveView
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String SUCCESS = "success";
    private static final String ACTION_FORM = "ArchiveViewForm";
    private static final String ERROR_FORWARD = "error";
    private static final int FORM_ID = 118;

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        String doQurey = "0";
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        MForm form2 = this.getForm(wsc.ctx, 118);
        wsc.ctx.setContext("FormName", form2.getName());
        ArchiveViewForm archiveViewForm = (ArchiveViewForm)request.getAttribute(ACTION_FORM);
        if (archiveViewForm == null && (archiveViewForm = (ArchiveViewForm)actionForm) == null) {
            archiveViewForm = new ArchiveViewForm();
        }
        archiveViewForm.statInit(wsc.ctx);
        archiveViewForm.setTitle(Msg.getMsg(wsc.ctx, "Archive"));
        List<KeyNamePair> processList = this.getProcessList(request);
        List<KeyNamePair> tableList = this.getTableList(request);
        List<KeyNamePair> userList = this.getUserList(request);
        session.setAttribute("processList", processList);
        session.setAttribute("tableList", tableList);
        session.setAttribute("userList", userList);
        session.setAttribute(ACTION_FORM, (Object)archiveViewForm);
        return mapping.findForward(SUCCESS);
    }

    private MForm getForm(Ctx ctx, int formId) {
        boolean trl;
        MForm form2 = new MForm(ctx, formId, null);
        boolean bl = trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form2.setName(rs.getString(1));
                        form2.setDescription(rs.getString(2));
                        form2.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        return form2;
    }

    private List<KeyNamePair> getProcessList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        ArrayList<KeyNamePair> keynameList = new ArrayList();
        int AD_Role_ID = wsc.ctx.getAD_Role_ID();
        String sql = "SELECT DISTINCT p.AD_Process_ID, p.Name FROM AD_Process p INNER JOIN AD_Process_Access pa ON (p.AD_Process_ID=pa.AD_Process_ID) WHERE pa.AD_Role_ID=" + AD_Role_ID + " AND p.IsReport='Y' AND p.IsActive='Y' AND pa.IsActive='Y' " + "ORDER BY 2";
        KeyNamePair[] keynameArray = DB.getKeyNamePairs(sql, true);
        keynameList = Arrays.asList(keynameArray);
        return keynameList;
    }

    private List<KeyNamePair> getTableList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        int AD_Role_ID = wsc.ctx.getAD_Role_ID();
        ArrayList<KeyNamePair> tableList = new ArrayList();
        String sql = "SELECT DISTINCT t.AD_Table_ID, t.Name FROM AD_Table t INNER JOIN AD_Tab tab ON (tab.AD_Table_ID=t.AD_Table_ID) INNER JOIN AD_Window_Access wa ON (tab.AD_Window_ID=wa.AD_Window_ID) WHERE wa.AD_Role_ID=" + AD_Role_ID + " AND t.IsActive='Y' AND tab.IsActive='Y' " + "ORDER BY 2";
        KeyNamePair[] keynameArray = DB.getKeyNamePairs(sql, true);
        tableList = Arrays.asList(keynameArray);
        return tableList;
    }

    private List<KeyNamePair> getUserList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        int AD_Role_ID = wsc.ctx.getAD_Role_ID();
        ArrayList<KeyNamePair> userList = new ArrayList();
        String sql = "SELECT AD_User_ID, Name FROM AD_User u WHERE EXISTS (SELECT * FROM AD_User_Roles ur WHERE u.AD_User_ID=ur.AD_User_ID) ORDER BY 2";
        KeyNamePair[] keynameArray = DB.getKeyNamePairs(sql, true);
        userList = Arrays.asList(keynameArray);
        return userList;
    }
}

