/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.struts.form.AttributeGridForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MAttribute;
import org.compiere.model.MForm;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeGrid
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String SUCCESS = "success";
    private static final String ACTION_FORM = "AttributeGridForm";
    private static final String ERROR_FORWARD = "error";
    private static final int FORM_ID = 120;

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        String doQurey = "0";
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        MForm form2 = this.getForm(wsc.ctx, 120);
        wsc.ctx.setContext("FormName", form2.getName());
        AttributeGridForm attributeGridForm = (AttributeGridForm)request.getAttribute(ACTION_FORM);
        if (attributeGridForm == null && (attributeGridForm = (AttributeGridForm)actionForm) == null) {
            attributeGridForm = new AttributeGridForm();
        }
        attributeGridForm.statInit(wsc.ctx);
        ArrayList<KeyNamePair> attributeList = this.getAttributeList(request);
        session.setAttribute("attributeList", attributeList);
        ArrayList<KeyNamePair> pricelistList = this.getPricelistList(request);
        session.setAttribute("pricelistList", pricelistList);
        ArrayList<KeyNamePair> warehouseList = this.getWarehouseList(request);
        session.setAttribute("warehouseList", warehouseList);
        attributeGridForm.setTitle(Msg.getMsg(wsc.ctx, "AttributeGrid"));
        session.setAttribute("attributeGridForm", (Object)attributeGridForm);
        return mapping.findForward(SUCCESS);
    }

    private MForm getForm(Ctx ctx, int formId) {
        boolean trl;
        MForm form2 = new MForm(ctx, formId, null);
        boolean bl = trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form2.setName(rs.getString(1));
                        form2.setDescription(rs.getString(2));
                        form2.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        return form2;
    }

    private ArrayList<KeyNamePair> getAttributeList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        MAttribute[] m_attributes = MAttribute.getOfClient(wsc.ctx, true, true);
        ArrayList<KeyNamePair> attributeList = new ArrayList<KeyNamePair>();
        attributeList.add(new KeyNamePair(0, ""));
        for (int i2 = 0; i2 < m_attributes.length; ++i2) {
            attributeList.add(m_attributes[i2].getKeyNamePair());
        }
        return attributeList;
    }

    private ArrayList<KeyNamePair> getPricelistList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        ArrayList<KeyNamePair> priceList = new ArrayList<KeyNamePair>();
        String sql = "SELECT M_PriceList_Version.M_PriceList_Version_ID, M_PriceList_Version.Name || ' (' || c.Iso_Code || ')' AS ValueName FROM M_PriceList_Version, M_PriceList pl, C_Currency c WHERE M_PriceList_Version.M_PriceList_ID=pl.M_PriceList_ID AND pl.C_Currency_ID=c.C_Currency_ID AND M_PriceList_Version.IsActive='Y' AND pl.IsActive='Y'";
        sql = MRole.getDefault(wsc.ctx, false).addAccessSQL(sql, "M_PriceList_Version", true, false) + " ORDER BY M_PriceList_Version.Name";
        try {
            priceList.add(new KeyNamePair(0, ""));
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                KeyNamePair kn = new KeyNamePair(rs.getInt(1), rs.getString(2));
                priceList.add(kn);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return priceList;
    }

    private ArrayList<KeyNamePair> getWarehouseList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        ArrayList<KeyNamePair> warehouseList = new ArrayList<KeyNamePair>();
        String sql = "SELECT M_Warehouse_ID, Value || ' - ' || Name AS ValueName FROM M_Warehouse WHERE IsActive='Y'";
        sql = MRole.getDefault(wsc.ctx, false).addAccessSQL(sql, "M_Warehouse", false, false) + " ORDER BY Value";
        try {
            warehouseList.add(new KeyNamePair(0, ""));
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                KeyNamePair kn = new KeyNamePair(rs.getInt("M_Warehouse_ID"), rs.getString("ValueName"));
                warehouseList.add(kn);
            }
            rs.close();
            pstmt.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return warehouseList;
    }
}

