/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.AttributeGridForm;
import com.jware.util.StringToIntConverter;
import java.awt.Color;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.swing.BorderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRole;
import org.compiere.model.MStorage;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class AttributeGridAction
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String ACTION_FORM = "AttributeGridForm";
    private static final String ERROR_FORWARD = "error";
    private static final int FORM_ID = 120;
    private DecimalFormat m_price = DisplayType.getNumberFormat(37);
    private DecimalFormat m_qty = DisplayType.getNumberFormat(29);

    public final ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        AttributeGridForm attributeGridForm = (AttributeGridForm)form2;
        List attributeGridRowList = this.createGrid(request, attributeGridForm);
        attributeGridForm.setAttributeRowList(attributeGridRowList);
        attributeGridForm.setTitle(Msg.getMsg(wsc.ctx, "AttributeGrid"));
        request.setAttribute(ACTION_FORM, (Object)attributeGridForm);
        return mapping.findForward("success");
    }

    private List createGrid(HttpServletRequest request, AttributeGridForm attributeGridForm) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        ArrayList<AttributeGridForm.AttributeGridRow> attributeRowList = new ArrayList<AttributeGridForm.AttributeGridRow>();
        if (StringUtils.isEmpty(attributeGridForm.getAttribute1()) || attributeGridForm.getAttribute1().equals(attributeGridForm.getAttribute2())) {
            return null;
        }
        int m_M_PriceList_Version_ID = StringToIntConverter.StringToInt(attributeGridForm.getPricelist());
        int m_M_Warehouse_ID = StringToIntConverter.StringToInt(attributeGridForm.getWarehouse());
        MAttribute[] m_attributes = MAttribute.getOfClient(wsc.ctx, true, true);
        int cols = 2;
        MAttribute mAttribute1 = this.getMAttribute(m_attributes, attributeGridForm.getAttribute1());
        MAttributeValue[] xValues = mAttribute1.getMAttributeValues();
        if (xValues != null) {
            cols = xValues.length;
            this.log.info("X - " + mAttribute1.getName() + " #" + xValues.length);
        }
        int rows = 2;
        MAttribute mAttribute2 = this.getMAttribute(m_attributes, attributeGridForm.getAttribute2());
        MAttributeValue[] yValues = mAttribute2.getMAttributeValues();
        if (yValues != null) {
            rows = yValues.length;
            this.log.info("Y - " + mAttribute2.getName() + " #" + yValues.length);
        }
        this.log.info("Rows=" + rows + " - Cols=" + cols);
        for (int row = 0; row < rows; ++row) {
            AttributeGridForm.AttributeGridRow oneRow = new AttributeGridForm.AttributeGridRow(attributeGridForm);
            for (int col = 0; col < cols; ++col) {
                MAttributeValue xValue = null;
                if (xValues != null) {
                    xValue = xValues[col];
                }
                MAttributeValue yValue = null;
                if (yValues != null) {
                    yValue = yValues[row];
                }
                AttributeGridForm.GridValue gridValue = new AttributeGridForm.GridValue(attributeGridForm);
                if (row == 0 && col == 0) {
                    if (xValues != null) {
                        gridValue.getValueList().add("       " + mAttribute1.getName());
                    }
                    if (yValues != null) {
                        gridValue.getValueList().add(mAttribute2.getName());
                    }
                } else if (row == 0) {
                    if (xValue != null) {
                        gridValue.getValueList().add(xValue.getName());
                    } else {
                        gridValue.getValueList().add("");
                    }
                } else if (col == 0) {
                    if (yValue != null) {
                        gridValue.getValueList().add(yValue.getName());
                    } else {
                        gridValue.getValueList().add("");
                    }
                } else {
                    gridValue = this.getGridElement(xValue, yValue, request, attributeGridForm);
                }
                oneRow.getColumnList().add(gridValue);
            }
            if (attributeRowList == null) {
                attributeRowList = new ArrayList();
            }
            attributeRowList.add(oneRow);
        }
        return attributeRowList;
    }

    private AttributeGridForm.GridValue getGridElement(MAttributeValue xValue, MAttributeValue yValue, HttpServletRequest request, AttributeGridForm attributeGridForm) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        AttributeGridForm.GridValue gridValue = new AttributeGridForm.GridValue(attributeGridForm);
        String sql = "SELECT * FROM M_Product WHERE IsActive='Y'";
        if (xValue != null) {
            sql = sql + " AND M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE M_Attribute_ID=" + xValue.getM_Attribute_ID() + " AND M_AttributeValue_ID=" + xValue.getM_AttributeValue_ID() + ")";
        }
        if (yValue != null) {
            sql = sql + " AND M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE M_Attribute_ID=" + yValue.getM_Attribute_ID() + " AND M_AttributeValue_ID=" + yValue.getM_AttributeValue_ID() + ")";
        }
        sql = MRole.getDefault(wsc.ctx, false).addAccessSQL(sql, "M_Product", false, false);
        CPreparedStatement pstmt = null;
        int noProducts = 0;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MProduct product = new MProduct(wsc.ctx, rs, null);
                this.addProduct(gridValue, product, request, attributeGridForm);
                ++noProducts;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return gridValue;
    }

    private void addProduct(AttributeGridForm.GridValue gridValue, MProduct product, HttpServletRequest request, AttributeGridForm attributeGridForm) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        StringBuffer gridValueBuffer = new StringBuffer();
        Insets ii = new Insets(2, 4, 2, 4);
        int M_Product_ID = product.getM_Product_ID();
        CPanel pe = new CPanel();
        pe.setBorder(BorderFactory.createLineBorder(Color.BLUE, 1));
        pe.setLayout(new GridBagLayout());
        int m_M_PriceList_Version_ID = StringToIntConverter.StringToInt(attributeGridForm.getPricelist());
        int m_M_Warehouse_ID = StringToIntConverter.StringToInt(attributeGridForm.getWarehouse());
        gridValueBuffer.append(product.getValue());
        String formatted = "";
        if (m_M_PriceList_Version_ID != 0) {
            MProductPrice pp = MProductPrice.get(wsc.ctx, m_M_PriceList_Version_ID, M_Product_ID, null);
            if (pp != null) {
                BigDecimal price = pp.getPriceStd();
                formatted = this.m_price.format(price);
            } else {
                formatted = "-";
            }
        }
        gridValueBuffer.append(formatted);
        gridValue.getValueList().add(gridValueBuffer.toString());
        gridValueBuffer = new StringBuffer();
        gridValueBuffer.append(product.getName());
        formatted = "";
        if (m_M_Warehouse_ID != 0) {
            BigDecimal qty = MStorage.getQtyAvailable(m_M_Warehouse_ID, M_Product_ID, 0, null);
            formatted = qty == null ? "-" : this.m_qty.format(qty);
        }
        gridValueBuffer.append(formatted);
        gridValue.getValueList().add(gridValueBuffer.toString());
    }

    private MAttribute getMAttribute(MAttribute[] m_attributes, String key) {
        MAttribute mAttribute = null;
        for (int i2 = 0; i2 < m_attributes.length; ++i2) {
            if (StringToIntConverter.StringToInt(key) != m_attributes[i2].getKeyNamePair().getKey()) continue;
            mAttribute = m_attributes[i2];
            break;
        }
        return mAttribute;
    }
}

