/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.PaymentSelectionForm;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MForm;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class PaymentSelection
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String PAYMENT_LIST = "paymentlist";
    private static final String ACTION_FORM = "PaymentSelectionForm";
    private static final String ERROR_FORWARD = "error";
    private static final int FORM_ID = 107;

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HashMap<String, Object> data;
        ResultSet rs;
        CPreparedStatement pstmt;
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        wsc.ctx.setContext(0, "IsSOTrx", "Y");
        MForm form2 = this.getForm(wsc.ctx, 107);
        wsc.ctx.setContext("FormName", form2.getName());
        PaymentSelectionForm myForm = (PaymentSelectionForm)request.getAttribute(ACTION_FORM);
        if (myForm == null && (myForm = (PaymentSelectionForm)actionForm) == null) {
            myForm = new PaymentSelectionForm();
        }
        myForm.setMainWindowTitle(form2.getName() + " - " + wsc.loginInfo);
        myForm.setPageTitle(form2.getName());
        myForm.setBankAccountLabel(Msg.translate(wsc.ctx, "C_BankAccount_ID"));
        myForm.setCurrentBalanceLabel(Msg.translate(wsc.ctx, "CurrentBalance"));
        ArrayList dataList = new ArrayList();
        String sql = MRole.getDefault(wsc.ctx, false).addAccessSQL("SELECT ba.C_BankAccount_ID,b.Name || ' ' || ba.AccountNo AS Name,ba.C_Currency_ID, c.ISO_Code,ba.CurrentBalance FROM C_Bank b, C_BankAccount ba, C_Currency c WHERE b.C_Bank_ID=ba.C_Bank_ID AND ba.C_Currency_ID=c.C_Currency_ID  AND EXISTS (SELECT * FROM C_BankAccountDoc d WHERE d.C_BankAccount_ID=ba.C_BankAccount_ID) ORDER BY 2", "b", true, true);
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                data = new HashMap<String, Object>();
                String value = rs.getString(1) + "|" + rs.getString(3) + "|" + rs.getString(4) + "|" + rs.getString(5);
                data.put("key", value);
                data.put("value", rs.getString(2));
                dataList.add(data);
                if (count == 0 && myForm.getBankAccount() == null) {
                    myForm.setBankAccount(value);
                    myForm.setCurrentBalance(wsc.amountFormat.format(rs.getBigDecimal(5)));
                    myForm.setCurrentCurrency(rs.getString(4));
                }
                ++count;
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        if (myForm.getBankAccount() != null) {
            String[] bankInfo = myForm.getBankAccount().split("\\|");
            myForm.setCurrentBalance(wsc.amountFormat.format(new BigDecimal(bankInfo[3])));
            myForm.setCurrentCurrency(bankInfo[2]);
        }
        myForm.setBankAccountList(dataList);
        if (dataList.size() == 0) {
            myForm.setResultInfo(Msg.translate(wsc.ctx, "VPaySelectNoBank"));
        }
        myForm.setBusinessPartnerLabel(Msg.translate(wsc.ctx, "C_BPartner_ID"));
        dataList = new ArrayList();
        data = new HashMap();
        data.put("0", "");
        dataList.add(data);
        sql = MRole.getDefault(wsc.ctx, false).addAccessSQL("SELECT bp.C_BPartner_ID, bp.Name FROM C_BPartner bp", "bp", true, false) + " AND EXISTS (SELECT * FROM C_Invoice i WHERE bp.C_BPartner_ID=i.C_BPartner_ID" + " AND i.IsSOTrx='N' AND i.IsPaid<>'Y') " + "ORDER BY 2";
        try {
            pstmt = DB.prepareStatement(sql, null);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                data = new HashMap();
                data.put("key", rs.getInt(1));
                data.put("value", rs.getString(2));
                dataList.add(data);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        myForm.setBusinessPartnerList(dataList);
        myForm.setOnlyDueInvoicesLabel(Msg.getMsg(wsc.ctx, "OnlyDue"));
        if (myForm.getOnlyDueInvoices() == null) {
            myForm.setOnlyDueInvoices("off");
        }
        myForm.setPaymentDateLabel(Msg.translate(wsc.ctx, "PayDate"));
        if (myForm.getPaymentDate() == null) {
            myForm.setPaymentDate(wsc.dateFormat.format(wsc.ctx.getContextAsTime("Date")));
        }
        myForm.setPaymentRuleLabel(Msg.translate(wsc.ctx, "PaymentRule"));
        dataList = new ArrayList();
        int referenceId = 195;
        Language language = Env.getLanguage(wsc.ctx);
        MLookupInfo info = MLookupFactory.getLookup_List(language, referenceId);
        sql = info.Query.substring(0, info.Query.indexOf(" ORDER BY")) + " AND " + info.KeyColumn + " IN (SELECT PaymentRule FROM C_BankAccountDoc WHERE C_BankAccount_ID=?) " + info.Query.substring(info.Query.indexOf(" ORDER BY"));
        String[] bankInfo = myForm.getBankAccount().split("\\|");
        try {
            CPreparedStatement pstmt2 = DB.prepareStatement(sql, null);
            pstmt2.setInt(1, Integer.valueOf(bankInfo[0]));
            ResultSet rs2 = pstmt2.executeQuery();
            while (rs2.next()) {
                data = new HashMap();
                data.put("key", rs2.getString(2));
                data.put("value", rs2.getString(3));
                dataList.add(data);
            }
            rs2.close();
            pstmt2.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        myForm.setPaymentRuleList(dataList);
        myForm.setInvoiceList(this.getInvoiceList(wsc, myForm));
        request.setAttribute(ACTION_FORM, (Object)myForm);
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return mapping.findForward(PAYMENT_LIST);
    }

    private MForm getForm(Ctx ctx, int formId) {
        boolean trl;
        MForm form2 = new MForm(ctx, formId, null);
        boolean bl = trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form2.setName(rs.getString(1));
                        form2.setDescription(rs.getString(2));
                        form2.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        return form2;
    }

    private ArrayList getInvoiceList(WebSessionCtx wsc, PaymentSelectionForm form2) {
        ArrayList dataList = new ArrayList();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("RowType", "title");
        data.put("C_Invoice_ID", "");
        data.put("DateDue", Msg.translate(wsc.ctx, "DateDue"));
        data.put("BPartner", Msg.translate(wsc.ctx, "C_BPartner_ID"));
        data.put("DocumentNo", Msg.translate(wsc.ctx, "DocumentNo"));
        data.put("Currency", Msg.translate(wsc.ctx, "C_Currency_ID"));
        data.put("GrandTotal", Msg.translate(wsc.ctx, "GrandTotal"));
        data.put("DiscountAmt", Msg.translate(wsc.ctx, "DiscountAmt"));
        data.put("DiscountDate", Msg.getMsg(wsc.ctx, "DiscountDate"));
        data.put("AmountDue", Msg.getMsg(wsc.ctx, "AmountDue"));
        data.put("AmountPay", Msg.getMsg(wsc.ctx, "AmountPay"));
        dataList.add(data);
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT  i.C_Invoice_ID,");
        sql.append("        i.DateInvoiced+p.NetDays AS DateDue,");
        sql.append("        bp.Name,");
        sql.append("        i.C_BPartner_ID,");
        sql.append("        i.DocumentNo,");
        sql.append("        c.ISO_Code,");
        sql.append("        i.C_Currency_ID,");
        sql.append("        i.GrandTotal,");
        sql.append("        paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?),");
        sql.append("        SysDate-paymentTermDueDays(i.C_PaymentTerm_ID,i.DateInvoiced,SysDate),");
        sql.append("        currencyConvert(invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID),i.C_Currency_ID, ?,?,i.C_ConversionType_ID, i.AD_Client_ID,i.AD_Org_ID),");
        sql.append("        currencyConvert(invoiceOpen(i.C_Invoice_ID,i.C_InvoicePaySchedule_ID)-paymentTermDiscount(i.GrandTotal,i.C_Currency_ID,i.C_PaymentTerm_ID,i.DateInvoiced, ?),i.C_Currency_ID, ?,?,i.C_ConversionType_ID, i.AD_Client_ID,i.AD_Org_ID)");
        sql.append("FROM C_Invoice_v i");
        sql.append(" INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID)");
        sql.append(" INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID)");
        sql.append(" INNER JOIN C_PaymentTerm p ON (i.C_PaymentTerm_ID=p.C_PaymentTerm_ID)");
        sql.append("WHERE i.IsSOTrx='N'");
        sql.append("  AND IsPaid='N'");
        sql.append("  AND NOT EXISTS (  SELECT *");
        sql.append("                    FROM C_PaySelectionLine psl");
        sql.append("                    WHERE i.C_Invoice_ID=psl.C_Invoice_ID");
        sql.append("                      AND psl.C_PaySelectionCheck_ID IS NOT NULL)");
        sql.append("  AND i.DocStatus IN ('CO','CL')");
        sql.append("  AND i.AD_Client_ID=?");
        if (form2.getOnlyDueInvoices().equals("on")) {
            sql.append("  AND i.DateInvoiced+p.NetDays <= ?");
        }
        if (form2.getBusinessPartner() > 0) {
            sql.append("  AND i.C_BPartner_ID=?");
        }
        sql.append("ORDER BY 2,3");
        Date payDate = wsc.dateFormat.parse(form2.getPaymentDate(), new ParsePosition(0));
        String[] bankInfo = form2.getBankAccount().split("\\|");
        int currencyId = Integer.valueOf(bankInfo[1]);
        int businessPartner = form2.getBusinessPartner();
        int clientId = wsc.ctx.getAD_Client_ID();
        try {
            int index = 1;
            CPreparedStatement pstmt = DB.prepareStatement(sql.toString(), null);
            pstmt.setTimestamp(index++, new Timestamp(payDate.getTime()));
            pstmt.setInt(index++, currencyId);
            pstmt.setTimestamp(index++, new Timestamp(payDate.getTime()));
            pstmt.setTimestamp(index++, new Timestamp(payDate.getTime()));
            pstmt.setInt(index++, currencyId);
            pstmt.setTimestamp(index++, new Timestamp(payDate.getTime()));
            pstmt.setInt(index++, clientId);
            if (form2.getOnlyDueInvoices().equals("on")) {
                pstmt.setTimestamp(index++, new Timestamp(payDate.getTime()));
            }
            if (businessPartner > 0) {
                pstmt.setInt(index++, businessPartner);
            }
            ResultSet rs = pstmt.executeQuery();
            int count = 0;
            while (rs.next()) {
                data = new HashMap();
                if (++count % 2 == 0) {
                    data.put("RowType", "even");
                } else {
                    data.put("RowType", "odd");
                }
                String invoiceId = rs.getString(1) + "|" + rs.getString(11) + "|" + rs.getString(12);
                data.put("C_Invoice_ID", invoiceId);
                data.put("DateDue", wsc.dateFormat.format(rs.getDate(2)));
                data.put("BPartner", rs.getString(3));
                data.put("DocumentNo", rs.getString(5));
                data.put("Currency", rs.getString(6));
                data.put("GrandTotal", wsc.amountFormat.format(rs.getBigDecimal(8)));
                data.put("DiscountAmt", wsc.amountFormat.format(rs.getBigDecimal(9)));
                data.put("DiscountDate", wsc.dateFormat.format(rs.getDate(10)));
                data.put("AmountDue", wsc.amountFormat.format(rs.getBigDecimal(11)));
                data.put("AmountPay", wsc.amountFormat.format(rs.getBigDecimal(12)));
                dataList.add(data);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql.toString(), e);
        }
        return dataList;
    }
}

