/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.util.AWebUtil;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.struts.form.WorkFlowActivityForm;
import com.jware.util.StringToIntConverter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MColumn;
import org.compiere.model.MForm;
import org.compiere.model.MRefList;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;
import org.compiere.util.WebSessionCtx;
import org.compiere.util.WebUtil;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkFlowActivity
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String SUCCESS = "success";
    private static final String ACTION_FORM = "WorkFlowActivityForm";
    private static final String ERROR_FORWARD = "error";
    private static final int FORM_ID = 117;
    private static final String PREV_ACTION = "1";
    private static final String NEXT_ACTION = "2";
    private static final String APPROVE_ACTION = "3";

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        String doQurey = "0";
        HttpSession session = request.getSession();
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        MForm form2 = this.getForm(wsc.ctx, 117);
        wsc.ctx.setContext("FormName", form2.getName());
        WorkFlowActivityForm workFlowActivityForm = (WorkFlowActivityForm)request.getAttribute(ACTION_FORM);
        if (workFlowActivityForm == null && (workFlowActivityForm = (WorkFlowActivityForm)actionForm) == null) {
            workFlowActivityForm = new WorkFlowActivityForm();
        }
        workFlowActivityForm.statInit(wsc.ctx);
        workFlowActivityForm.setTitle(form2.getName());
        String actionType = request.getParameter("actionType");
        if (PREV_ACTION.equals(actionType)) {
            MWFActivity currentWorkflow;
            Document xml_doc = null;
            if (xml_doc == null && (currentWorkflow = this.getPrevWfActivity(request)) != null) {
                xml_doc = this.setWorkFlowActivityAjax(request, currentWorkflow);
            }
            AWebUtil.createCalloutAjaxResponse(response, xml_doc);
            return null;
        }
        if (NEXT_ACTION.equals(actionType)) {
            MWFActivity currentWorkflow;
            Document xml_doc = null;
            if (xml_doc == null && (currentWorkflow = this.getNextWfActivity(request)) != null) {
                xml_doc = this.setWorkFlowActivityAjax(request, currentWorkflow);
            }
            AWebUtil.createCalloutAjaxResponse(response, xml_doc);
            return null;
        }
        if (APPROVE_ACTION.equals(actionType)) {
            Document xml_doc = this.cmd_OK(request, workFlowActivityForm);
            if (xml_doc == null) {
                MWFActivity currentWorkflow = this.getCurrentWfActivity(request);
                if (currentWorkflow != null) {
                    xml_doc = this.setWorkFlowActivityAjax(request, currentWorkflow);
                } else {
                    ArrayList<MWFActivity> workFlowList = this.loadActivities(request);
                    if (workFlowList != null && workFlowList.size() > 0) {
                        int m_index = 0;
                        currentWorkflow = workFlowList.get(m_index);
                        this.setWorkFlowActivityForm(workFlowActivityForm, currentWorkflow);
                        workFlowActivityForm.setWfActivityId(String.valueOf(currentWorkflow.getAD_WF_Activity_ID()));
                        workFlowActivityForm.setWfActivitySeqNo("0");
                        workFlowActivityForm.setWorkflowNum(workFlowList.size());
                    } else {
                        workFlowActivityForm.setWorkflowNum(0);
                    }
                    ArrayList<ValueNamePair> answerList = this.getAnswerList(request);
                    session.setAttribute("answerList", answerList);
                    workFlowActivityForm.setTitle(Msg.getMsg(wsc.ctx, "WFActivity"));
                    session.setAttribute(ACTION_FORM, (Object)workFlowActivityForm);
                    return mapping.findForward(SUCCESS);
                }
            }
            AWebUtil.createCalloutAjaxResponse(response, xml_doc);
            return null;
        }
        MWFActivity currentWorkflow = null;
        ArrayList<MWFActivity> workFlowList = this.loadActivities(request);
        if (workFlowList != null && workFlowList.size() > 0) {
            int m_index = 0;
            currentWorkflow = workFlowList.get(m_index);
            this.setWorkFlowActivityForm(workFlowActivityForm, currentWorkflow);
            workFlowActivityForm.setWfActivityId(String.valueOf(currentWorkflow.getAD_WF_Activity_ID()));
            workFlowActivityForm.setWfActivitySeqNo("0");
            workFlowActivityForm.setWorkflowNum(workFlowList.size());
        } else {
            workFlowActivityForm.setWorkflowNum(0);
        }
        ArrayList<ValueNamePair> answerList = this.getAnswerList(request);
        session.setAttribute("answerList", answerList);
        workFlowActivityForm.setTitle(Msg.getMsg(wsc.ctx, "WFActivity"));
        session.setAttribute(ACTION_FORM, (Object)workFlowActivityForm);
        return mapping.findForward(SUCCESS);
    }

    private MForm getForm(Ctx ctx, int formId) {
        boolean trl;
        MForm form2 = new MForm(ctx, formId, null);
        boolean bl = trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            String sql = "SELECT t.Name, t.Description, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                if (trl) {
                    pstmt.setString(1, Env.getAD_Language(ctx));
                    pstmt.setInt(2, formId);
                    ResultSet rs = pstmt.executeQuery();
                    if (rs.next()) {
                        form2.setName(rs.getString(1));
                        form2.setDescription(rs.getString(2));
                        form2.setHelp(rs.getString(3));
                    }
                    rs.close();
                    pstmt.close();
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        return form2;
    }

    private ArrayList<ValueNamePair> getAnswerList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        ValueNamePair[] values = MRefList.getList(319, false);
        ArrayList<ValueNamePair> answerList = new ArrayList<ValueNamePair>(Arrays.asList(values));
        return answerList;
    }

    public ArrayList<MWFActivity> loadActivities(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        long start = System.currentTimeMillis();
        ArrayList<MWFActivity> list = new ArrayList<MWFActivity>();
        String sql = "SELECT * FROM AD_WF_Activity a WHERE a.Processed='N' AND a.WFState='OS' AND ( a.AD_User_ID=? OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND COALESCE(r.AD_User_ID,0)=0 AND (a.AD_User_ID=? OR a.AD_User_ID IS NULL)) OR EXISTS (SELECT * FROM AD_WF_Responsible r WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND r.AD_User_ID=?) OR EXISTS (SELECT * FROM AD_WF_Responsible r INNER JOIN AD_User_Roles ur ON (r.AD_Role_ID=ur.AD_Role_ID) WHERE a.AD_WF_Responsible_ID=r.AD_WF_Responsible_ID AND ur.AD_User_ID=?)) ORDER BY a.Priority DESC, Created";
        int AD_User_ID = wsc.ctx.getAD_User_ID();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, AD_User_ID);
            pstmt.setInt(2, AD_User_ID);
            pstmt.setInt(3, AD_User_ID);
            pstmt.setInt(4, AD_User_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MWFActivity(wsc.ctx, rs, null));
                if (list.size() <= 200) continue;
                this.log.warning("More then 200 Activities - ignored");
                break;
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        return list;
    }

    private MWFActivity getWfActivity(HttpServletRequest request, int wfActivityId) {
        ArrayList<MWFActivity> workFlowList = this.loadActivities(request);
        MWFActivity m_activity = null;
        for (int i2 = 0; i2 < workFlowList.size(); ++i2) {
            MWFActivity tmpActivity = workFlowList.get(i2);
            if (tmpActivity.getAD_WF_Activity_ID() != wfActivityId) continue;
            m_activity = tmpActivity;
            break;
        }
        return m_activity;
    }

    private MWFActivity getCurrentWfActivity(HttpServletRequest request) {
        ArrayList<MWFActivity> workFlowList = this.loadActivities(request);
        int wfActivitySeqNo = StringToIntConverter.StringToInt(WebUtil.getParameter(request, "wfActivitySeqNo"));
        MWFActivity m_activity = null;
        if (workFlowList != null && workFlowList.size() > 0) {
            if (wfActivitySeqNo < workFlowList.size()) {
                m_activity = workFlowList.get(wfActivitySeqNo);
                request.setAttribute("wfActivitySeqNo", (Object)wfActivitySeqNo);
            } else {
                m_activity = workFlowList.get(0);
                request.setAttribute("wfActivitySeqNo", (Object)0);
            }
        }
        return m_activity;
    }

    private MWFActivity getNextWfActivity(HttpServletRequest request) {
        ArrayList<MWFActivity> workFlowList = this.loadActivities(request);
        int wfActivitySeqNo = StringToIntConverter.StringToInt(WebUtil.getParameter(request, "wfActivitySeqNo"));
        ++wfActivitySeqNo;
        MWFActivity m_activity = null;
        if (workFlowList != null && workFlowList.size() > 0) {
            if (wfActivitySeqNo < workFlowList.size()) {
                m_activity = workFlowList.get(wfActivitySeqNo);
                request.setAttribute("wfActivitySeqNo", (Object)wfActivitySeqNo);
            } else {
                m_activity = workFlowList.get(workFlowList.size() - 1);
                request.setAttribute("wfActivitySeqNo", (Object)(workFlowList.size() - 1));
            }
        }
        return m_activity;
    }

    private MWFActivity getPrevWfActivity(HttpServletRequest request) {
        ArrayList<MWFActivity> workFlowList = this.loadActivities(request);
        int wfActivitySeqNo = StringToIntConverter.StringToInt(WebUtil.getParameter(request, "wfActivitySeqNo"));
        if (--wfActivitySeqNo < 1) {
            wfActivitySeqNo = 0;
        }
        MWFActivity m_activity = null;
        if (workFlowList != null && workFlowList.size() > 0) {
            if (wfActivitySeqNo < workFlowList.size()) {
                m_activity = workFlowList.get(wfActivitySeqNo);
                request.setAttribute("wfActivitySeqNo", (Object)wfActivitySeqNo);
            } else {
                m_activity = workFlowList.get(0);
                request.setAttribute("wfActivitySeqNo", (Object)0);
            }
        }
        return m_activity;
    }

    private void setWorkFlowActivityForm(WorkFlowActivityForm workFlowActivityForm, MWFActivity workflow) {
        workFlowActivityForm.setNode(workflow.getNodeName());
        workFlowActivityForm.setDescription(workflow.getNodeDescription());
        workFlowActivityForm.setHelp(workflow.getNodeHelp());
        workFlowActivityForm.setHistory(workflow.getHistoryHTML());
        workFlowActivityForm.setTextMsg(workflow.getTextMsg());
    }

    private Document setWorkFlowActivityAjax(HttpServletRequest request, MWFActivity workflow) {
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.newDocument();
            Element elements = document.createElement("elements");
            document.appendChild(elements);
            Element element = document.createElement("element");
            elements.appendChild(element);
            this.addElement(document, element, "wfActivityId", String.valueOf(workflow.getAD_WF_Activity_ID()));
            this.addElement(document, element, "wfActivitySeqNo", String.valueOf(request.getAttribute("wfActivitySeqNo")));
            this.addElement(document, element, "wfNode", workflow.getNodeName());
            this.addElement(document, element, "wfDescription", workflow.getNodeDescription());
            this.addElement(document, element, "wfHelp", workflow.getNodeDescription());
            this.addElement(document, element, "wfHistory", workflow.getHistoryHTML());
            this.addElement(document, element, "wfTextMsg", workflow.getTextMsg());
            this.addElement(document, element, "wfPreviousButton", PREV_ACTION);
            this.addElement(document, element, "wfNextButton", PREV_ACTION);
            this.addElement(document, element, "wfApproveButton", PREV_ACTION);
            ArrayList<MWFActivity> workFlowList = this.loadActivities(request);
            this.addElement(document, element, "wfNum", String.valueOf(workFlowList.size()));
        }
        catch (Exception e) {
            this.log.warning("Error occured in function setWorkFlowActivityAjax\n");
        }
        return document;
    }

    private void addElement(Document document, Element element, String tagName, String tagValue) {
        Element newElement = document.createElement(tagName);
        if (tagValue == null) {
            tagValue = "";
        }
        newElement.appendChild(document.createTextNode(tagValue));
        element.appendChild(newElement);
    }

    private Document cmd_OK(HttpServletRequest request, WorkFlowActivityForm workFlowActivityForm) {
        block12: {
            WebSessionCtx wsc = WebSessionCtx.get(request);
            int wfActivityId = StringToIntConverter.StringToInt(WebUtil.getParameter(request, "wfActivityId"));
            MWFActivity m_activity = this.getWfActivity(request, wfActivityId);
            if (m_activity == null) {
                return null;
            }
            Document document = null;
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.newDocument();
                int AD_User_ID = wsc.ctx.getAD_User_ID();
                String textMsg = workFlowActivityForm.getTextMsg();
                MWFNode node = m_activity.getNode();
                String forward = workFlowActivityForm.getForwardId();
                if (!StringUtils.isEmpty(forward)) {
                    this.log.config("Forward to " + forward);
                    int fw = StringToIntConverter.StringToInt(forward);
                    if (fw == AD_User_ID || fw == 0) {
                        this.log.log(Level.SEVERE, "Forward User=" + fw);
                        return document;
                    }
                    if (!m_activity.forwardTo(fw, textMsg)) {
                        Element element = document.createElement("script");
                        document.appendChild(element);
                        String message = Msg.getMsg(wsc.ctx, "CannotForward");
                        element.appendChild(document.createTextNode(message));
                        return document;
                    }
                    break block12;
                }
                if ("C".equals(node.getAction())) {
                    MColumn m_column = node.getColumn();
                    int dt = m_column.getAD_Reference_ID();
                    String value = workFlowActivityForm.getAnswer();
                    if (value == null || value.length() == 0) {
                        Element element = document.createElement("script");
                        document.appendChild(element);
                        String message = Msg.getMsg(wsc.ctx, "FillMandatory") + "\n" + Msg.getMsg(wsc.ctx, "Answer");
                        element.appendChild(document.createTextNode(message));
                        return document;
                    }
                    this.log.config("Answer=" + value + " - " + textMsg);
                    try {
                        m_activity.setUserChoice(AD_User_ID, value, dt, textMsg);
                        break block12;
                    }
                    catch (Exception e) {
                        Element element = document.createElement("script");
                        document.appendChild(element);
                        String message = Msg.getMsg(wsc.ctx, "Error") + "\n" + e.toString();
                        element.appendChild(document.createTextNode(message));
                        return document;
                    }
                }
                this.log.config("Action=" + node.getAction() + " - " + textMsg);
                try {
                    m_activity.setUserConfirmation(AD_User_ID, textMsg);
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, node.getName(), e);
                    Element element = document.createElement("script");
                    document.appendChild(element);
                    String message = Msg.getMsg(wsc.ctx, "Error") + "\n" + e.toString();
                    element.appendChild(document.createTextNode(message));
                    return document;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }
}

