/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.search;

import com.ampiere.util.AWebUtil;
import com.ampiere.util.AmpiereUtil;
import com.ampiere.web.servlet.WWindowStatus;
import com.ampiere.web.struts.search.InfoScheduleForm;
import com.ampiere.web.struts.search.VSchedule;
import com.ampiere.web.struts.search.VSchedulePanel;
import com.jware.util.DateUtils;
import com.jware.util.StringToIntConverter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.swing.table.DefaultTableModel;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.xhtml.table;
import org.apache.ecs.xhtml.td;
import org.apache.ecs.xhtml.tr;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MAssignmentSlot;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MRole;
import org.compiere.model.ScheduleUtil;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.WebSessionCtx;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoSchedule
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String SUCCESS = "success";
    private static final String ACTION_FORM = "InfoScheduleForm";
    private static final String ERROR_FORWARD = "error";
    private String M_MASSIGNMENT = "m_mAssignment";
    String RESOURCE_TYPE = "RESOURE_TYPE";
    String RESOURCE = "RESOURE";
    String ACTION_RESOURE_TYPE = "1";
    String ACTION_RESOURE = "2";
    String ACTION_PREV = "3";
    String ACTION_NEXT = "4";
    String ACTION_TAB = "5";
    String ACTION_DATE = "6";
    String DAY = "day";
    String WEEK = "week";
    String MONTH = "month";
    String TAB_INDEX = "tabIndex";
    String TAB_DAY = "0";
    String TAB_WEEK = "1";
    String TAB_MONTH = "2";

    public final ActionForward execute(ActionMapping mapping, ActionForm actionForm, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get(request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        HttpSession session = request.getSession();
        String doQurey = "0";
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        InfoScheduleForm infoScheduleForm = (InfoScheduleForm)request.getAttribute(ACTION_FORM);
        if (infoScheduleForm == null && infoScheduleForm == null) {
            infoScheduleForm = new InfoScheduleForm();
        }
        infoScheduleForm.statInit(wsc.ctx);
        MResourceAssignment m_mAssignment = new MResourceAssignment(wsc.ctx, 0, null);
        session.setAttribute(this.M_MASSIGNMENT, (Object)m_mAssignment);
        String actionType = request.getParameter("actionType");
        if (this.ACTION_RESOURE_TYPE.equals(actionType)) {
            request.setAttribute(this.RESOURCE_TYPE, (Object)request.getParameter("resourceType"));
            List<KeyNamePair> resourceList = this.getResourceList(request);
            this.setResourceIdAttribute(request, resourceList);
            Document xml_doc = this.getCalendarXml(request);
            xml_doc = this.addResourceList(request, xml_doc, resourceList);
            AWebUtil.createCalloutAjaxResponse(response, xml_doc);
            return null;
        }
        if (this.ACTION_RESOURE.equals(actionType)) {
            Document xml_doc = this.getCalendarXml(request);
            AWebUtil.createCalloutAjaxResponse(response, xml_doc);
            return null;
        }
        if (this.ACTION_PREV.equals(actionType)) {
            return null;
        }
        if (this.ACTION_NEXT.equals(actionType)) {
            return null;
        }
        if (this.ACTION_TAB.equals(actionType)) {
            Document xml_doc = this.getCalendarXml(request);
            AWebUtil.createCalloutAjaxResponse(response, xml_doc);
            return null;
        }
        List<KeyNamePair> resourceTypeList = this.getResourceTypeList(request);
        request.setAttribute("resourceTypeList", resourceTypeList);
        List<KeyNamePair> resourceList = this.getResourceList(request);
        request.setAttribute("resourceList", resourceList);
        table resultTable = this.getCalendarTable(request);
        String html = resultTable.toString();
        infoScheduleForm.setScheduleHtml(html);
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date today = calendar.getTime();
        Timestamp date = new Timestamp(today.getTime());
        infoScheduleForm.setDate(wsc.dateFormat.format(date));
        request.setAttribute(ACTION_FORM, (Object)infoScheduleForm);
        return mapping.findForward(SUCCESS);
    }

    private List<KeyNamePair> getResourceTypeList(HttpServletRequest request) {
        String sql;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        HttpSession session = request.getSession();
        MResourceAssignment m_mAssignment = (MResourceAssignment)session.getAttribute(this.M_MASSIGNMENT);
        ArrayList<KeyNamePair> resourceTypeList = new ArrayList<KeyNamePair>();
        int S_ResourceType_ID = 0;
        if (m_mAssignment != null && m_mAssignment.getS_Resource_ID() != 0) {
            sql = "SELECT S_ResourceType_ID FROM S_Resource WHERE S_Resource_ID=?";
            try {
                CPreparedStatement pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, m_mAssignment.getS_Resource_ID());
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    S_ResourceType_ID = rs.getInt(1);
                }
                rs.close();
                pstmt.close();
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, e);
            }
        }
        sql = MRole.getDefault(wsc.ctx, true).addAccessSQL("SELECT S_ResourceType_ID, Name FROM S_ResourceType WHERE IsActive='Y' ORDER BY 2", "S_ResourceType", false, false);
        KeyNamePair defaultValue = null;
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                if (S_ResourceType_ID == pp.getKey()) {
                    defaultValue = pp;
                }
                resourceTypeList.add(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return resourceTypeList;
    }

    private List<KeyNamePair> getResourceList(HttpServletRequest request) {
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        HttpSession session = request.getSession();
        ArrayList<KeyNamePair> resourceList = new ArrayList<KeyNamePair>();
        int S_ResourceType_ID = this.getResourceTypeId(request);
        Object defaultValue = null;
        String sql = "SELECT S_Resource_ID, Name FROM S_Resource WHERE S_ResourceType_ID=? ORDER BY 2";
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, S_ResourceType_ID);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                KeyNamePair pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                resourceList.add(pp);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        return resourceList;
    }

    private Document getCalendarXml(HttpServletRequest request) {
        Document document = AmpiereUtil.CreateNewDocument(request);
        table calendarTable = this.getCalendarTable(request);
        String resultHtml = calendarTable.toString();
        ArrayList<String> resultList = new ArrayList<String>();
        int unit = 2000;
        int beginIndex = 0;
        int endIndex = 0;
        String tempStr = "";
        while (resultHtml.length() > 0) {
            if (resultHtml.length() + tempStr.length() < unit) {
                resultList.add(tempStr + resultHtml);
                break;
            }
            endIndex = resultHtml.indexOf("<tr>") + "<tr>".length();
            String str1 = resultHtml.substring(beginIndex, endIndex);
            String str2 = resultHtml.substring(endIndex, resultHtml.length());
            if ((tempStr = tempStr + str1).length() > unit) {
                resultList.add(tempStr);
                tempStr = "";
            }
            resultHtml = str2;
        }
        try {
            for (int i2 = 0; i2 < resultList.size(); ++i2) {
                Element element = document.createElement("element");
                document.getFirstChild().appendChild(element);
                Element elm_id = document.createElement("id");
                String objId = "dummy";
                elm_id.appendChild(document.createTextNode(objId));
                element.appendChild(elm_id);
                Element elm_lookup = document.createElement("lookup");
                element.appendChild(elm_lookup);
                elm_lookup.appendChild(document.createTextNode("0"));
                Element elm_visibility = document.createElement("visibility");
                element.appendChild(elm_visibility);
                elm_visibility.appendChild(document.createTextNode("1"));
                Element elm_newValue = document.createElement("newValue");
                element.appendChild(elm_newValue);
                elm_newValue.appendChild(document.createTextNode((String)resultList.get(i2)));
                Element elm_readonly = document.createElement("readonly");
                element.appendChild(elm_readonly);
                elm_readonly.appendChild(document.createTextNode("0"));
                Element elm_type = document.createElement("type");
                element.appendChild(elm_type);
                elm_type.appendChild(document.createTextNode("html"));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        document = this.addTabIndex(request, document);
        return document;
    }

    private Document addTabIndex(HttpServletRequest request, Document document) {
        String tabIndex = request.getParameter(this.TAB_INDEX);
        Element element = document.createElement("element");
        document.getFirstChild().appendChild(element);
        Element elm_id = document.createElement("id");
        String objId = "dummy";
        elm_id.appendChild(document.createTextNode(objId));
        element.appendChild(elm_id);
        Element elm_lookup = document.createElement("lookup");
        element.appendChild(elm_lookup);
        elm_lookup.appendChild(document.createTextNode("0"));
        Element elm_visibility = document.createElement("visibility");
        element.appendChild(elm_visibility);
        elm_visibility.appendChild(document.createTextNode("1"));
        Element elm_newValue = document.createElement("newValue");
        element.appendChild(elm_newValue);
        elm_newValue.appendChild(document.createTextNode(tabIndex));
        Element elm_readonly = document.createElement("readonly");
        element.appendChild(elm_readonly);
        elm_readonly.appendChild(document.createTextNode("0"));
        Element elm_type = document.createElement("type");
        element.appendChild(elm_type);
        elm_type.appendChild(document.createTextNode("tab"));
        return document;
    }

    private table getCalendarTable(HttpServletRequest request) {
        tr oneTr;
        int i2;
        WebSessionCtx wsc = WebSessionCtx.get(request);
        WWindowStatus ws = WWindowStatus.get(request);
        HttpSession session = request.getSession();
        int S_Resource_ID = this.getResourceId(request);
        if (S_Resource_ID == 0) {
            table resultTable = new table("1", "0", "5", "auto", null);
            tr header = new tr();
            resultTable.addElement((org.apache.ecs.Element)header);
            return resultTable;
        }
        MResourceAssignment m_mAssignment = new MResourceAssignment(wsc.ctx, 0, null);
        m_mAssignment.setS_Resource_ID(S_Resource_ID);
        session.setAttribute(this.M_MASSIGNMENT, (Object)m_mAssignment);
        Timestamp date = null;
        String DateFrom = request.getParameter("date");
        if (!StringUtils.isEmpty(DateFrom)) {
            try {
                try {
                    date = new Timestamp(wsc.dateFormat.parse(DateFrom).getTime());
                }
                catch (Exception e) {
                    date = null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (date == null) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            Date today = calendar.getTime();
            date = new Timestamp(today.getTime());
        }
        VSchedule.Period m_numDays = this.getPeriodType(request);
        ScheduleUtil m_model = new ScheduleUtil(wsc.ctx);
        Calendar s_calendar = Calendar.getInstance(Language.getLoginLanguage().getLocale());
        s_calendar.setTime(date);
        s_calendar.set(10, 0);
        s_calendar.set(12, 0);
        s_calendar.set(13, 0);
        s_calendar.set(14, 0);
        if (m_numDays == VSchedule.Period.WEEK) {
            s_calendar.set(7, s_calendar.getFirstDayOfWeek());
        } else if (m_numDays == VSchedule.Period.MONTH) {
            s_calendar.set(5, 1);
        }
        Timestamp m_startDate = new Timestamp(s_calendar.getTimeInMillis());
        s_calendar.add(m_numDays.type(), 1);
        Timestamp m_endDate = new Timestamp(s_calendar.getTimeInMillis());
        this.log.config("(" + (Object)((Object)m_numDays) + ") Resource_ID=" + S_Resource_ID + ": " + m_startDate + "->" + m_endDate);
        MAssignmentSlot[] mas = m_model.getAssignmentSlots(S_Resource_ID, m_startDate, m_endDate, null, true, null);
        MAssignmentSlot[] mts = m_model.getDayTimeSlots();
        VSchedulePanel schedulePanel = new VSchedulePanel();
        schedulePanel.setAssignmentSlots(mas, mts, S_Resource_ID, m_startDate, m_numDays);
        DefaultTableModel model = (DefaultTableModel)schedulePanel.getModel();
        Vector<Vector> dataVector = model.getDataVector();
        table resultTable = new table("1", "0", "5", "auto", null);
        tr header = new tr();
        resultTable.addElement((org.apache.ecs.Element)header);
        header.addElement((org.apache.ecs.Element)new td());
        Vector head_columns = dataVector.get(0);
        for (int x = 0; x < head_columns.size(); ++x) {
            td headTd = new td();
            header.addElement((org.apache.ecs.Element)headTd);
            Timestamp t = (Timestamp)head_columns.get(x);
            headTd.addElement(wsc.dateFormat.format(t));
        }
        for (i2 = 0; i2 < dataVector.size(); ++i2) {
            oneTr = new tr();
            resultTable.addElement((org.apache.ecs.Element)oneTr);
            Vector columns = dataVector.get(i2);
            for (int j = 0; j < columns.size(); ++j) {
                Timestamp t = (Timestamp)columns.get(j);
                if (j == 0) {
                    td hourTd = new td();
                    oneTr.addElement((org.apache.ecs.Element)hourTd);
                    hourTd.addElement(DateUtils.getHours(t) + ":" + DateUtils.getMinutes(t));
                }
                td oneTd = new td();
                oneTr.addElement((org.apache.ecs.Element)oneTd);
                oneTd.addElement(this.getAssignmentText(mas, t));
            }
        }
        for (i2 = 0; i2 < mts.length; ++i2) {
            oneTr = new tr();
            MAssignmentSlot onSlot = mts[i2];
            String name = onSlot.getName();
        }
        return resultTable;
    }

    String getAssignmentText(MAssignmentSlot[] mts, Timestamp t) {
        String ret = "";
        for (int i2 = 0; i2 < mts.length; ++i2) {
            MAssignmentSlot assignment = mts[i2];
            if (t.compareTo(assignment.getStartTime()) < 0 || t.compareTo(assignment.getEndTime()) >= 0) continue;
            ret = assignment.getName();
            break;
        }
        return ret;
    }

    private Document addResourceList(HttpServletRequest request, Document document, List<KeyNamePair> resourceList) {
        Element element = document.createElement("element");
        document.getFirstChild().appendChild(element);
        Element elm_id = document.createElement("id");
        elm_id.appendChild(document.createTextNode("resource"));
        element.appendChild(elm_id);
        Element elm_lookup = document.createElement("lookup");
        element.appendChild(elm_lookup);
        elm_lookup.appendChild(document.createTextNode("1"));
        Element elm_visibility = document.createElement("visibility");
        element.appendChild(elm_visibility);
        elm_visibility.appendChild(document.createTextNode("1"));
        Element elm_newValue = document.createElement("newValue");
        element.appendChild(elm_newValue);
        for (int p2 = 0; p2 < resourceList.size(); ++p2) {
            KeyNamePair pair = resourceList.get(p2);
            String key = String.valueOf(pair.getKey());
            String value = pair.getName();
            Element elm_item = document.createElement("item");
            elm_newValue.appendChild(elm_item);
            Element elm_key = document.createElement("key");
            elm_item.appendChild(elm_key);
            elm_key.appendChild(document.createTextNode(String.valueOf(key)));
            Element elm_value = document.createElement("value");
            elm_item.appendChild(elm_value);
            elm_value.appendChild(document.createTextNode(value));
        }
        Element elm_readonly = document.createElement("readonly");
        element.appendChild(elm_readonly);
        elm_readonly.appendChild(document.createTextNode("0"));
        Element elm_type = document.createElement("type");
        element.appendChild(elm_type);
        elm_type.appendChild(document.createTextNode("1"));
        return document;
    }

    VSchedule.Period getPeriodType(HttpServletRequest request) {
        VSchedule.Period Type2 = VSchedule.Period.DAY;
        String tab_str = request.getParameter(this.TAB_INDEX);
        if (this.TAB_WEEK.equals(tab_str)) {
            Type2 = VSchedule.Period.WEEK;
        } else if (this.TAB_MONTH.equals(tab_str)) {
            Type2 = VSchedule.Period.MONTH;
        }
        return Type2;
    }

    int getResourceTypeId(HttpServletRequest request) {
        List resourceTypeList;
        int S_ResourceType_ID = 0;
        S_ResourceType_ID = StringToIntConverter.StringToInt(request.getParameter("resourceType"));
        if (S_ResourceType_ID == 0) {
            String rt_attr = (String)request.getAttribute(this.RESOURCE_TYPE);
            S_ResourceType_ID = StringToIntConverter.StringToInt(rt_attr);
        }
        if (S_ResourceType_ID == 0 && S_ResourceType_ID == 0 && (resourceTypeList = (List)request.getAttribute("resourceTypeList")) != null && resourceTypeList.size() > 0) {
            S_ResourceType_ID = ((KeyNamePair)resourceTypeList.get(0)).getKey();
        }
        return S_ResourceType_ID;
    }

    int getResourceId(HttpServletRequest request) {
        List resourceList;
        int S_Resource_ID = 0;
        if (S_Resource_ID == 0) {
            String re_attr = (String)request.getAttribute(this.RESOURCE);
            S_Resource_ID = StringToIntConverter.StringToInt(re_attr);
        }
        if (S_Resource_ID == 0) {
            S_Resource_ID = StringToIntConverter.StringToInt(request.getParameter("resource"));
        }
        if (S_Resource_ID == 0 && (resourceList = (List)request.getAttribute("resourceList")) != null && resourceList.size() > 0) {
            S_Resource_ID = ((KeyNamePair)resourceList.get(0)).getKey();
        }
        return S_Resource_ID;
    }

    void setResourceIdAttribute(HttpServletRequest request, List<KeyNamePair> resourceList) {
        if (resourceList != null && resourceList.size() > 0) {
            int S_Resource_ID = resourceList.get(0).getKey();
            request.setAttribute(this.RESOURCE, (Object)String.valueOf(S_Resource_ID));
        }
    }

    table getNullTable() {
        table resultTable = new table("1", "0", "5", "auto", null);
        tr header = new tr();
        resultTable.addElement((org.apache.ecs.Element)header.addElement((org.apache.ecs.Element)new td()));
        return resultTable;
    }
}

