/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.search;

import com.ampiere.web.struts.search.InfoSchedule;
import com.ampiere.web.struts.search.VSchedule;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.CellRendererPane;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.compiere.model.MAssignmentSlot;
import org.compiere.model.MResourceAssignment;
import org.compiere.swing.CTable;
import org.compiere.util.Env;
import org.compiere.util.Language;

public class VSchedulePanel
extends CTable {
    private static final Calendar s_calendar = Calendar.getInstance(Language.getLoginLanguage().getLocale());
    private static final Composite s_composite = AlphaComposite.getInstance(3, 0.6f);
    private static Calendar s_compareCalendar = Calendar.getInstance(Language.getLoginLanguage().getLocale());
    private TreeMap<MAssignmentSlot, Rectangle> m_assignments = new TreeMap();
    private MAssignmentSlot[] m_timeSlots = null;
    private Timestamp m_startDate = null;
    private boolean m_createNew = false;
    private VSchedule.Period m_period;
    private int m_S_Resource_ID = 0;
    private InfoSchedule m_infoSchedule = null;
    private StringBuilder m_tempBuilder = new StringBuilder();
    private CellRendererPane m_rendererPane = new CellRendererPane();
    private DefaultTableCellRenderer m_renderer = new DefaultTableCellRenderer();
    private DateFormat m_dateFormat = DateFormat.getDateInstance(0, Language.getLoginLanguage().getLocale());
    private DateFormat m_timeFormat = DateFormat.getTimeInstance(3, Language.getLoginLanguage().getLocale());

    public VSchedulePanel() {
        this.setRowHeight(this.getRowHeight() * 2);
        this.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                return super.getTableCellRendererComponent(table2, null, false, false, row, column);
            }
        });
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){
            private Dimension size;
            private StringBuilder buffer = new StringBuilder();
            private Rectangle rect = new Rectangle();
            private boolean drawTop;

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.buffer.setLength(0);
                value = VSchedulePanel.this.m_timeFormat.format(VSchedulePanel.this.m_timeSlots[index].getStartTime());
                this.buffer.append(value).append(" ");
                this.drawTop = index == 0;
                Component comp = super.getListCellRendererComponent((JList<?>)list, this.buffer, index, false, false);
                this.setBackground(list.getBackground());
                this.setHorizontalAlignment(4);
                if (this.size == null) {
                    this.size = this.getPreferredSize();
                    this.size.width = (int)((double)this.size.width + (double)this.size.width * 0.3);
                }
                this.size.height = VSchedulePanel.this.getRowHeight(index);
                this.setPreferredSize(this.size);
                return comp;
            }

            public void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(VSchedulePanel.this.getGridColor());
                this.getBounds(this.rect);
                if (this.drawTop) {
                    g.drawLine(this.rect.x, 0, this.rect.width, 0);
                }
                this.rect.x = -1;
                this.rect.y = -1;
                ((Graphics2D)g).draw(this.rect);
            }
        };
        this.getRowHeader().setCellRenderer(renderer);
        this.m_renderer.setOpaque(false);
        this.getTableHeader().setReorderingAllowed(false);
        this.setDefaultEditor(Object.class, new TimeEditor());
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
    }

    private Rectangle calcTimeSlotRect(MAssignmentSlot slot) {
        s_calendar.setTime(this.m_startDate);
        int dayToColAdjust = this.m_period == VSchedule.Period.WEEK ? 1 : s_calendar.get(6);
        s_calendar.setTime(slot.getStartTime());
        int col = 0;
        if (this.m_period == VSchedule.Period.WEEK) {
            col = s_calendar.get(7) - dayToColAdjust;
        } else if (this.m_period == VSchedule.Period.MONTH) {
            col = s_calendar.get(6) - dayToColAdjust;
        }
        int minStart = s_calendar.get(12);
        s_calendar.set(12, 0);
        int rowStart = 0;
        int compare = 0;
        do {
            if (rowStart >= this.getRowCount()) continue;
            s_compareCalendar.setTime((Date)this.getValueAt(rowStart, col));
            compare = s_calendar.compareTo(s_compareCalendar);
            rowStart += compare > 0 ? 1 : 0;
        } while (compare > 0 && rowStart < this.getRowCount());
        s_calendar.setTime(slot.getEndTime());
        int minEnd = s_calendar.get(12);
        int rowEnd = rowStart;
        do {
            if (rowEnd + 1 >= this.getRowCount()) continue;
            s_compareCalendar.setTime((Date)this.getValueAt(rowEnd + 1, col));
            compare = s_calendar.compareTo(s_compareCalendar);
            rowEnd += compare > 0 ? 1 : 0;
        } while (compare > 0 && rowEnd + 1 < this.getRowCount());
        Rectangle rectStart = this.getCellRect(rowStart, col, false);
        rectStart.y += Math.round((float)minStart / 60.0f * (float)rectStart.height);
        Rectangle rectEnd = this.getCellRect(rowEnd, col, false);
        rectEnd.height -= Math.round((float)minEnd / 60.0f * (float)rectEnd.height);
        return rectStart.union(rectEnd);
    }

    public void dispose() {
    }

    public MAssignmentSlot[] getAssignmentSlots() {
        return this.m_assignments.keySet().toArray(new MAssignmentSlot[this.m_assignments.size()]);
    }

    public boolean isCreateNewsAssignments() {
        return this.m_createNew;
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        for (MAssignmentSlot slot : this.m_assignments.keySet()) {
            this.m_renderer.setForeground(slot.getColor(false));
            this.m_renderer.setVerticalAlignment(1);
            this.m_tempBuilder.setLength(0);
            this.m_tempBuilder.append(slot.getName());
            String desc = slot.getDescription();
            if (desc != null && !"".equals(desc)) {
                this.m_tempBuilder.append(" (").append(desc).append(")");
            }
            this.m_renderer.setText(this.m_tempBuilder.toString());
            Rectangle rect = this.m_assignments.get(slot);
            if (rect == null) {
                rect = this.calcTimeSlotRect(slot);
                this.m_assignments.put(slot, rect);
            }
            Graphics2D g2d = (Graphics2D)g;
            Composite composite = g2d.getComposite();
            g2d.setComposite(s_composite);
            Color color = g.getColor();
            g.setColor(slot.getColor(true));
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            g2d.setComposite(composite);
            g.setColor(color);
            this.m_rendererPane.paintComponent(g, this.m_renderer, this, rect);
        }
    }

    public void setAssignmentSlots(MAssignmentSlot[] assignments, MAssignmentSlot[] timeSlots, int s_Resource_ID, Timestamp startDate, VSchedule.Period period) {
        this.m_startDate = startDate;
        this.m_S_Resource_ID = s_Resource_ID;
        this.m_period = period;
        this.m_assignments.clear();
        for (MAssignmentSlot slot : assignments) {
            this.m_assignments.put(slot, null);
        }
        this.m_timeSlots = (MAssignmentSlot[])timeSlots.clone();
        Arrays.sort(this.m_timeSlots);
        Vector timeSlotList = new Vector();
        for (int i2 = 0; i2 < this.m_timeSlots.length; ++i2) {
            Vector timeslot = new Vector();
            timeSlotList.add(timeslot);
        }
        Vector<String> columnNames = new Vector<String>();
        Calendar slotTime = Calendar.getInstance(Language.getLoginLanguage().getLocale());
        s_calendar.setTime(this.m_startDate);
        int days = 1;
        if (this.m_period == VSchedule.Period.WEEK) {
            days = s_calendar.getActualMaximum(7);
        } else if (this.m_period == VSchedule.Period.MONTH) {
            days = s_calendar.getActualMaximum(5);
        }
        for (int i3 = 0; i3 < days; ++i3) {
            columnNames.add(this.m_dateFormat.format(s_calendar.getTime()));
            for (int j = 0; j < timeSlotList.size(); ++j) {
                Vector timeSlot = (Vector)timeSlotList.get(j);
                slotTime.setTime(this.m_timeSlots[j].getStartTime());
                slotTime.set(s_calendar.get(1), s_calendar.get(2), s_calendar.get(5));
                timeSlot.add(new Timestamp(slotTime.getTimeInMillis()));
            }
            s_calendar.add(6, 1);
        }
        DefaultTableModel model = new DefaultTableModel(timeSlotList, columnNames);
        this.setModel(model);
        Enumeration<TableColumn> e = this.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            TableColumn tc = e.nextElement();
            tc.setPreferredWidth(tc.getPreferredWidth() * 3);
        }
    }

    public void setCreatesNewAssignments(boolean createNew) {
        this.m_createNew = createNew;
    }

    public void setInfoSchedule(InfoSchedule is) {
        this.m_infoSchedule = is;
    }

    public void setTimeSlots(MAssignmentSlot[] timeSlots) {
        this.m_timeSlots = (MAssignmentSlot[])timeSlots.clone();
    }

    private class TimeEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JPanel m_editorComp = new JPanel();
        private MAssignmentSlot m_lastSlot;

        public TimeEditor() {
            this.m_editorComp.setOpaque(false);
        }

        public boolean isCellEditable(EventObject eo) {
            boolean editable = VSchedulePanel.this.m_createNew && super.isCellEditable(eo);
            this.m_lastSlot = null;
            if (eo instanceof MouseEvent) {
                MouseEvent me = (MouseEvent)eo;
                for (MAssignmentSlot slot : VSchedulePanel.this.m_assignments.keySet()) {
                    if (!((Rectangle)VSchedulePanel.this.m_assignments.get(slot)).contains(me.getX(), me.getY())) continue;
                    this.m_lastSlot = slot;
                    editable = slot.isAssignment();
                    break;
                }
            }
            return editable;
        }

        public Object getCellEditorValue() {
            return null;
        }

        public Component getTableCellEditorComponent(JTable table2, Object value, boolean isSelected, int row, int column) {
            MResourceAssignment ma = null;
            if (this.m_lastSlot != null) {
                ma = this.m_lastSlot.getMAssignment();
            } else {
                ma = new MResourceAssignment(Env.getCtx(), 0, null);
                ma.setS_Resource_ID(VSchedulePanel.this.m_S_Resource_ID);
                Timestamp ts = (Timestamp)VSchedulePanel.this.getValueAt(row, column);
                ma.setAssignDateFrom(ts);
                ma.setQty(new BigDecimal(1));
            }
            JFrame frame = Env.getFrame(VSchedulePanel.this);
            return this.m_editorComp;
        }
    }
}

