/*
 * Decompiled with CFR 0.152.
 */
package com.jware.apps.scheduler.jobs;

import com.jware.apps.scheduler.jobs.DumbRecoveryJob;
import com.jware.apps.scheduler.jobs.DumbRecoveryStatefulJob;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerFactory;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class ClusterTest {
    public static void clusterTest(SchedulerFactory sf, boolean clearJobs, boolean scheduleJobs) throws Exception {
        Log lg = LogFactory.getLog(ClusterTest.class);
        lg.info((Object)"------- Initializing -------------------");
        Scheduler sched = sf.getScheduler();
        if (clearJobs) {
            int j;
            String[] names;
            int i2;
            lg.warn((Object)"      *** Deleting existing jobs/triggers ***");
            String[] groups = sched.getTriggerGroupNames();
            for (i2 = 0; i2 < groups.length; ++i2) {
                names = sched.getTriggerNames(groups[i2]);
                for (j = 0; j < names.length; ++j) {
                    sched.unscheduleJob(names[j], groups[i2]);
                }
            }
            groups = sched.getJobGroupNames();
            for (i2 = 0; i2 < groups.length; ++i2) {
                names = sched.getJobNames(groups[i2]);
                for (j = 0; j < names.length; ++j) {
                    sched.deleteJob(names[j], groups[i2]);
                }
            }
        }
        lg.info((Object)"------- Initialization Complete -----------");
        if (scheduleJobs) {
            lg.info((Object)"------- Scheduling Jobs -----------");
            String schedId = sched.getSchedulerInstanceId();
            int count = 1;
            JobDetail job = new JobDetail("job_" + count, schedId, DumbRecoveryJob.class);
            job.setRequestsRecovery(true);
            SimpleTrigger trigger = new SimpleTrigger("trig_" + count, schedId, 20, 5000L);
            trigger.setStartTime(new Date(System.currentTimeMillis() + 1000L));
            lg.info((Object)(job.getFullName() + " will run at: " + trigger.getNextFireTime() + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
            sched.scheduleJob(job, (Trigger)trigger);
            job = new JobDetail("job_" + ++count, schedId, DumbRecoveryJob.class);
            job.setRequestsRecovery(true);
            trigger = new SimpleTrigger("trig_" + count, schedId, 20, 5000L);
            trigger.setStartTime(new Date(System.currentTimeMillis() + 2000L));
            lg.info((Object)(job.getFullName() + " will run at: " + trigger.getNextFireTime() + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
            sched.scheduleJob(job, (Trigger)trigger);
            job = new JobDetail("job_" + ++count, schedId, DumbRecoveryStatefulJob.class);
            job.setRequestsRecovery(true);
            trigger = new SimpleTrigger("trig_" + count, schedId, 20, 3000L);
            trigger.setStartTime(new Date(System.currentTimeMillis() + 1000L));
            lg.info((Object)(job.getFullName() + " will run at: " + trigger.getNextFireTime() + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
            sched.scheduleJob(job, (Trigger)trigger);
            job = new JobDetail("job_" + ++count, schedId, DumbRecoveryJob.class);
            job.setRequestsRecovery(true);
            trigger = new SimpleTrigger("trig_" + count, schedId, 20, 4000L);
            trigger.setStartTime(new Date(System.currentTimeMillis() + 1000L));
            lg.info((Object)(job.getFullName() + " will run at: " + trigger.getNextFireTime() + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
            sched.scheduleJob(job, (Trigger)trigger);
            job = new JobDetail("job_" + ++count, schedId, DumbRecoveryJob.class);
            job.setRequestsRecovery(true);
            trigger = new SimpleTrigger("trig_" + count, schedId, 20, 4500L);
            trigger.setStartTime(new Date(System.currentTimeMillis() + 1000L));
            lg.info((Object)(job.getFullName() + " will run at: " + trigger.getNextFireTime() + " & repeat: " + trigger.getRepeatCount() + "/" + trigger.getRepeatInterval()));
            sched.scheduleJob(job, (Trigger)trigger);
        }
        lg.info((Object)"------- Starting Scheduler ----------------");
        sched.start();
        lg.info((Object)"------- Started Scheduler -----------------");
        lg.info((Object)"------- Waiting... -----------------------");
        try {
            Thread.sleep(3600000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        lg.info((Object)"------- Shutting Down ---------------------");
        sched.shutdown();
        lg.info((Object)"------- Shutdown Complete -----------------");
    }

    public static void main(String[] args) throws Exception {
        try {
            boolean clearJobs = false;
            boolean scheduleJobs = true;
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].equals("clearJobs")) {
                    clearJobs = true;
                }
                if (!args[i2].equals("dontScheduleJobs")) continue;
                scheduleJobs = false;
            }
            ClusterTest.clusterTest((SchedulerFactory)new StdSchedulerFactory(), clearJobs, scheduleJobs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

