/*
 * Decompiled with CFR 0.152.
 */
package com.jware.common.charts;

import com.jware.common.charts.AxisCharts;
import java.awt.Paint;
import org.jCharts.Chart;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.chartData.interfaces.IDataSeries;
import org.jCharts.properties.AreaChartProperties;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.ChartType;

public class AreaCharts
extends AxisCharts {
    String xAxisTitle = "Years";
    String yAxisTitle = "Problems";
    String title = "Micro$oft at Work";
    String[] xAxisLabels = new String[]{"1998", "1999", "2000", "2001", "2002", "2003", "2004"};
    String[] legendLabels = new String[]{"Bugs", "Security Holes", "Backdoors"};
    double[][] data = TestDataGenerator.getRandomNumbers((int)3, (int)7, (double)0.0, (double)5000.0);

    public void set_xAxisTitle(String xAxisTitle) {
        this.xAxisTitle = xAxisTitle;
    }

    public String get_xAxisTitle() {
        return this.xAxisTitle;
    }

    public void set_yAxisTitle(String yAxisTitle) {
        this.yAxisTitle = yAxisTitle;
    }

    public String get_yAxisTitle() {
        return this.yAxisTitle;
    }

    public void set_Title(String Title) {
        this.title = Title;
    }

    public String get_Title() {
        return this.title;
    }

    public void set_xAxisLabels(String[] xAxisLabels) {
        this.xAxisLabels = xAxisLabels;
    }

    public String[] get_xAxisLabels() {
        return this.xAxisLabels;
    }

    public void set_legendLabels(String[] legendLabels) {
        this.legendLabels = legendLabels;
    }

    public String[] get_legendLabels() {
        return this.legendLabels;
    }

    public void set_Data(double[][] data) {
        this.data = data;
    }

    public double[][] get_Data() {
        return this.data;
    }

    private AxisChart getAreaCharts(ChartType chartType, AreaChartProperties areaChartProperties) throws ChartDataException {
        DataSeries dataSeries = new DataSeries(this.xAxisLabels, this.xAxisTitle, this.yAxisTitle, this.title);
        Paint[] paints = TestDataGenerator.getRandomPaints((int)this.legendLabels.length);
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(this.data, this.legendLabels, paints, chartType, (ChartTypeProperties)areaChartProperties);
        dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)axisChartDataSet);
        ChartProperties chartProperties = new ChartProperties();
        AxisProperties axisProperties = new AxisProperties();
        double maxvalue = 0.0;
        double minvalue = 0.0;
        for (int i2 = 0; i2 < this.data.length; ++i2) {
            for (int j = 0; j < this.data[0].length; ++j) {
                if (this.data[i2][j] > maxvalue) {
                    maxvalue = this.data[i2][j];
                }
                if (!(this.data[i2][j] < minvalue)) continue;
                minvalue = this.data[i2][j];
            }
        }
        if (minvalue < 0.0) {
            maxvalue -= minvalue;
        }
        int poweroftem = 0;
        poweroftem = maxvalue < 10.0 ? 0 : (maxvalue < 100.0 ? 1 : (maxvalue < 1000.0 ? 2 : (maxvalue < 10000.0 ? 3 : (maxvalue < 100000.0 ? 4 : (maxvalue < 1000000.0 ? 5 : (maxvalue < 1.0E7 ? 6 : (maxvalue < 1.0E8 ? 7 : 8)))))));
        axisProperties.setYAxisRoundValuesToNearest(poweroftem);
        LegendProperties legendProperties = new LegendProperties();
        AxisChart axisChart = new AxisChart((IDataSeries)dataSeries, chartProperties, axisProperties, legendProperties, 500, 300);
        return axisChart;
    }

    public void areaCharts(String filename) throws ChartDataException {
        AreaChartProperties areaChartProperties = new AreaChartProperties();
        AxisChart axisChart = this.getAreaCharts(ChartType.AREA, areaChartProperties);
        super.exportImage((Chart)axisChart, filename);
    }

    public void stackedAreas(String filename) throws ChartDataException {
        AreaChartProperties areaChartProperties = new AreaChartProperties();
        AxisChart axisChart = this.getAreaCharts(ChartType.AREA_STACKED, areaChartProperties);
        super.exportImage((Chart)axisChart, filename);
    }
}

