/*
 * Decompiled with CFR 0.152.
 */
package com.jware.common.charts;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jCharts.Chart;
import org.jCharts.encoders.JPEGEncoder13;
import org.jCharts.encoders.PNGEncoder;
import org.jCharts.encoders.SVGEncoder;

abstract class BaseChart {
    private String chart_file_type = "png";

    BaseChart() {
    }

    public void set_chart_file_type(String chart_file_type) {
        this.chart_file_type = chart_file_type;
    }

    public String get_chart_file_type() {
        return this.chart_file_type;
    }

    void exportImage(Chart chart, String fileName) {
        if (this.chart_file_type == null || this.chart_file_type.compareToIgnoreCase("jpg") == 0) {
            this.exportImageJPEG(chart, fileName);
        } else if (this.chart_file_type.compareToIgnoreCase("png") == 0) {
            this.exportImagePNG(chart, fileName);
        } else if (this.chart_file_type.compareToIgnoreCase("svg") == 0) {
            this.exportImageSVG(chart, fileName);
        } else {
            this.exportImageJPEG(chart, fileName);
        }
    }

    void exportImagePNG(Chart chart, String fileName) {
        String extension = ".png";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileName + extension);
            PNGEncoder.encode((Chart)chart, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    void exportImageJPEG(Chart chart, String fileName) {
        String extension = ".jpg";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileName + extension);
            JPEGEncoder13.encode((Chart)chart, (float)1.0f, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    void exportImageSVG(Chart chart, String fileName) {
        String extension = ".svg";
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(fileName + extension);
            SVGEncoder.encode((Chart)chart, (OutputStream)fileOutputStream);
            fileOutputStream.flush();
            fileOutputStream.close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }
}

